/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TENEListUtils {
    private static final String EVENT_SOURCE_FILE = "res" + File.separator + "stringresource_" + TENEListUtils.getLanguage() + ".ini";
    public static final String ALARM_SOURCE_FILE = "res" + File.separator + "alarmsource_" + TENEListUtils.getLanguage() + ".ini";
    public static final int SLOTCONSTATNS = 100;
    private static int logicNEID = 1;
    private static List cpTypeList = new ArrayList();

    private TENEListUtils() {
    }

    public static List getCPTypeList() {
        return cpTypeList;
    }

    public static String getLanguage() {
        return TESysManagerBean.getInstance().getlanguage();
    }

    public static String getString(String key) {
        TEResourceUtil res = TEResourceUtil.getInstance(EVENT_SOURCE_FILE);
        return res.getString(key);
    }

    public static String getString(String key, String sourceStr) {
        TEResourceUtil res = TEResourceUtil.getInstance(sourceStr);
        return res.getString(key);
    }

    public static String replaceString(String sourceString) {
        if (sourceString == null || "".equalsIgnoreCase(sourceString)) {
            return "NULL";
        }
        StringBuffer toStr = new StringBuffer();
        int len2 = sourceString.length();
        for (int j = 0; j < len2; ++j) {
            char ch = sourceString.charAt(j);
            if (ch == ',' || ch == '[' || ch == ']') continue;
            toStr.append(ch);
        }
        return toStr.toString();
    }

    public static ArrayList getPortArr(String port_no_list, ArrayList portList) {
        if (null == port_no_list || "".equals(port_no_list.trim())) {
            return portList;
        }
        String[] portlistStr = port_no_list.substring(1, port_no_list.length() - 1).split(",");
        String portStr = null;
        int minportno = -1;
        int maxportno = -1;
        for (int i = portlistStr.length - 1; i >= 0; --i) {
            portStr = portlistStr[i];
            if (portStr == null || portStr.equals("")) continue;
            if ((portStr = portStr.trim()).indexOf("-") > 0) {
                minportno = Integer.decode(portStr.split("-")[0]);
                maxportno = Integer.decode(portStr.split("-")[1]);
                for (int portno = minportno; portno <= maxportno; ++portno) {
                    portList.add(portno);
                }
                continue;
            }
            portList.add(Integer.decode(portStr));
        }
        return portList;
    }

    public static ArrayList getIncrementPortArr(String port_no_list) {
        ArrayList<Integer> idList = new ArrayList<Integer>();
        if (null == port_no_list || "".equals(port_no_list.trim())) {
            return idList;
        }
        String[] portlistStr = port_no_list.substring(1, port_no_list.length() - 1).split(",");
        String portStr = null;
        int minportno = -1;
        int maxportno = -1;
        for (int i = portlistStr.length - 1; i >= 0; --i) {
            portStr = portlistStr[i];
            if (portStr == null || portStr.equals("")) continue;
            if ((portStr = portStr.trim()).indexOf("-") > 0) {
                minportno = Integer.decode(portStr.split("-")[0]);
                maxportno = Integer.decode(portStr.split("-")[1]);
                for (int portno = minportno; portno <= maxportno; ++portno) {
                    idList.add(portno);
                }
                continue;
            }
            idList.add(Integer.decode(portStr));
        }
        return idList;
    }

    public static ArrayList getNumList(String numStr, ArrayList numList) {
        if (null == numStr || "".equalsIgnoreCase(numStr.trim())) {
            return numList;
        }
        for (String numberStr : numStr.split(",")) {
            int j;
            int end;
            int start;
            String[] numSplitStr;
            int indexSplit;
            int index = numberStr.indexOf("[");
            int indexLast = numberStr.lastIndexOf("]");
            if (index >= 0 && indexLast < 0) {
                indexSplit = (numberStr = numberStr.substring(index + 1)).indexOf("-");
                if (indexSplit >= 0) {
                    numSplitStr = numberStr.split("-");
                    start = 0;
                    end = 0;
                    start = Integer.decode(numSplitStr[0]);
                    end = Integer.decode(numSplitStr[1]);
                    for (j = start; j <= end; ++j) {
                        numList.add(j);
                    }
                    continue;
                }
                numList.add(Integer.decode(numberStr));
                continue;
            }
            if (indexLast >= 0 && index < 0) {
                indexSplit = (numberStr = numberStr.substring(0, indexLast)).indexOf("-");
                if (indexSplit >= 0) {
                    numSplitStr = numberStr.split("-");
                    start = 0;
                    end = 0;
                    start = Integer.decode(numSplitStr[0]);
                    end = Integer.decode(numSplitStr[1]);
                    for (j = start; j <= end; ++j) {
                        numList.add(j);
                    }
                    continue;
                }
                numList.add(Integer.decode(numberStr));
                continue;
            }
            if (index >= 0 && indexLast >= 0) {
                indexSplit = (numberStr = numberStr.substring(index + 1, indexLast)).indexOf("-");
                if (indexSplit >= 0) {
                    numSplitStr = numberStr.split("-");
                    start = 0;
                    end = 0;
                    start = Integer.decode(numSplitStr[0]);
                    end = Integer.decode(numSplitStr[1]);
                    for (j = start; j <= end; ++j) {
                        numList.add(j);
                    }
                    continue;
                }
                numList.add(Integer.decode(numberStr));
                continue;
            }
            indexSplit = numberStr.indexOf("-");
            if (indexSplit >= 0) {
                numSplitStr = numberStr.split("-");
                start = 0;
                end = 0;
                start = Integer.decode(numSplitStr[0]);
                end = Integer.decode(numSplitStr[1]);
                for (j = start; j <= end; ++j) {
                    numList.add(j);
                }
                continue;
            }
            numList.add(Integer.decode(numberStr));
        }
        return numList;
    }

    public static void stringToStrList(String strValue, ArrayList levelStrList) {
        StringBuffer levelStr = new StringBuffer();
        int len2 = strValue.length();
        for (int j = 0; j < len2; ++j) {
            char ch = strValue.charAt(j);
            if (ch != ',' && ch != '[' && ch != ']') {
                levelStr.append(ch);
                continue;
            }
            if (levelStr.length() == 0) continue;
            levelStrList.add(levelStr.toString());
            levelStr = new StringBuffer();
        }
    }

    public static int sendVerify(int neID) throws Exception {
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation("NSCMD_CFG_VERIFY");
        operList.add(oper.clone());
        OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, 10);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tempOper = (Operation)operList.get(0);
        Output output = tempOper.getOutput()[0];
        Fault fault = output.getFault()[0];
        return Integer.parseInt(fault.getCode());
    }

    public static int sendInitNE(int neID) throws Exception {
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_INIT_ALL");
        operList.add(oper.clone());
        OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, 180);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tempOper = (Operation)operList.get(0);
        Output output = tempOper.getOutput()[0];
        Fault fault = output.getFault()[0];
        return Integer.parseInt(fault.getCode());
    }

    public static int sendInitStart(int neID) throws Exception {
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_QX_CFG_START");
        operList.add(oper.clone());
        OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, 15);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tempOper = (Operation)operList.get(0);
        Output output = tempOper.getOutput()[0];
        Fault fault = output.getFault()[0];
        return Integer.parseInt(fault.getCode());
    }

    public static int sendInitEnd(int neID) throws Exception {
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_QX_CFG_END");
        operList.add(oper.clone());
        OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, 15);
        if (result.retCode != 0) {
            return result.retCode;
        }
        Operation tempOper = (Operation)operList.get(0);
        Output output = tempOper.getOutput()[0];
        Fault fault = output.getFault()[0];
        return Integer.parseInt(fault.getCode());
    }

    public static int sendModifyPhyID(int logicNeId, int newPhyId) {
        try {
            ArrayList<Object> operList = new ArrayList<Object>();
            Operation oper = TECreateObjectFactory.getOperation(logicNeId, "NSCMD_CM_SET_NEID");
            int eid = TENEListUtils.getExtendID(newPhyId);
            int baseid = TENEListUtils.getBaseID(newPhyId);
            oper.getInput().getPart("eid").setValue(String.valueOf(eid));
            oper.getInput().getPart("baseid").setValue(String.valueOf(baseid));
            operList.add(oper.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(logicNeId, operList, 15);
            if (result.retCode != 0) {
                return result.retCode;
            }
            Operation tempOper = (Operation)operList.get(0);
            Output output = tempOper.getOutput()[0];
            Fault fault = output.getFault()[0];
            if (Integer.parseInt(fault.getCode()) == 0) {
                TENE ne = TENEListMgr.getInstance().getNE(logicNeId);
                ne.setRealNEID(newPhyId);
                TENECommMgr.getInstance().deleteNEID((long)logicNeId);
                TENECommMgr.getInstance().putLogicNEID((long)newPhyId, (long)logicNeId);
            }
            return Integer.parseInt(fault.getCode());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENEListUtils.sendModifyPhyID() fail!", (Throwable)e);
            return 2;
        }
    }

    public static int[] sendQueryNeState(int neID) {
        int[] ret = new int[2];
        try {
            ArrayList<Object> operList = new ArrayList<Object>();
            Operation oper = TECreateObjectFactory.getOperation("NSCMD_CFG_GET_NE_STATE");
            operList.add(oper.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, 10);
            if (result.retCode != 0) {
                ret[0] = result.retCode;
                return ret;
            }
            Operation tempOper = (Operation)operList.get(0);
            Output output = tempOper.getOutput()[0];
            Fault fault = output.getFault()[0];
            int neState = -1;
            if (fault.getCode().equals("0")) {
                neState = Integer.parseInt(output.getPart("neState").getValue());
            }
            ret[0] = Integer.parseInt(fault.getCode());
            ret[1] = neState;
            return ret;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENEListUtils.sendQueryNeState() fail!", (Throwable)e);
            ret[0] = 2;
            return ret;
        }
    }

    public static int[] sendQueryTimeDivision(int neID) {
        int[] ret = new int[2];
        try {
            ArrayList<Object> operList = new ArrayList<Object>();
            Operation oper = TECreateObjectFactory.getOperation("NSCMD_CFG_GET_TIMEDIVISION");
            if (oper == null) {
                ret[0] = 2;
                return ret;
            }
            operList.add(oper.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, 10);
            if (result.retCode != 0) {
                ret[0] = result.retCode;
                return ret;
            }
            Operation tempOper = (Operation)operList.get(0);
            Output output = tempOper.getOutput()[0];
            Fault fault = output.getFault()[0];
            int iTimeDivison = -1;
            if (fault.getCode().equals("0")) {
                iTimeDivison = Integer.parseInt(output.getPart("timeDivison").getValue());
            }
            ret[0] = Integer.parseInt(fault.getCode());
            ret[1] = iTimeDivison;
            return ret;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENEListUtils.sendQueryNeState() fail!", (Throwable)e);
            ret[0] = 2;
            return ret;
        }
    }

    public static HashMap<TEPort, String> getPortMap(int neID, int slotID, int boardType) {
        HashMap<TEPort, String> portMap = new HashMap<TEPort, String>();
        try {
            ArrayList<Operation> operList = new ArrayList<Operation>();
            Operation oper = null;
            oper = TESpecialAttrMgr.getInstance().isNESupport(neID, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_PORTNAME_DBYTE") ? TECreateObjectFactory.getOperation(neID, "NSCMD_PTN_PORT_GET_NAME_EX") : TECreateObjectFactory.getOperation(neID, "NSCMD_CFG_GET_PORT_NAME");
            if (null == oper) {
                return portMap;
            }
            Input input = oper.getInput();
            input.setPartValue("slotid", String.valueOf(slotID));
            input.setPartValue("port", String.valueOf(0));
            operList.add(oper);
            OperationResult result = TENECommMgr.getInstance().sendCommand(neID, operList, 10);
            if (result.retCode != 0) {
                return portMap;
            }
            Operation tmpOper = (Operation)operList.get(0);
            Output[] outputArr = tmpOper.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                Part[] partArr = outputArr[i].getPart();
                String portName = "";
                int portID = 0;
                for (Part part : partArr) {
                    String name = part.getName();
                    String value = part.getValue();
                    if (("W32PORT_ATTR_NAME".equalsIgnoreCase(name) || "portName".equalsIgnoreCase(name)) && null != value) {
                        portName = IOStreamConvertor.replaceSpecialStr(value);
                    }
                    if (!"port".equalsIgnoreCase(name) || null == value || "".equalsIgnoreCase(value)) continue;
                    portID = Integer.parseInt(value);
                }
                TEPort port = new TEPort(neID, slotID, boardType, portID);
                portMap.put(port, portName);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENEListUtils.getPortMap() fail!", (Throwable)e);
        }
        return portMap;
    }

    public static int slotIDNEToNM(int slotID) {
        int slot = slotID & 0x1F;
        int shelfID = slotID & 0xE0;
        return slot += (shelfID >>>= 5) * 100;
    }

    public static int slotIDNMToNE(int slotID) {
        int shelfID = slotID / 100;
        int slot = slotID % 100;
        slot = (shelfID <<= 5) + slot;
        return slot;
    }

    public static int getNEID(int baseID, int extendID) {
        return extendID * 65536 + baseID;
    }

    public static int getExtendID(int neID) {
        return (neID - neID % 65536) / 65536;
    }

    public static int getBaseID(int neID) {
        return neID % 65536;
    }

    public static synchronized int getLogicNEID() {
        return logicNEID++;
    }

    public static int getNEType(int neID) {
        int neVer = TENECommMgr.getInstance().getNeVersion((long)neID);
        int neType = (neVer & 0xFF0000) >> 16;
        return neType;
    }

    public static int getNEVer(int neID) {
        int neVer = TENECommMgr.getInstance().getNeVersion((long)neID);
        return neVer;
    }

    public static String getStrNEVer(int neID) {
        int neVer = TENECommMgr.getInstance().getNeVersion((long)neID);
        int ver_1 = neVer & 0xFF;
        int ver_2 = (neVer & 0xFF00) >> 8;
        String ver_2Str = "";
        ver_2Str = ver_2 / 10 <= 0 ? "0" + String.valueOf(ver_2) : String.valueOf(ver_2);
        int ver_3 = (neVer & 0xFF0000) >> 16;
        int ver_4 = (neVer & 0xFF000000) >> 24;
        String neVerStr = String.valueOf(ver_4) + "." + String.valueOf(ver_3) + "." + ver_2Str + "." + String.valueOf(ver_1);
        return String.valueOf(neVerStr);
    }

    public static TENE getNEObj(int logicID) {
        TENE ne = TENEListMgr.getInstance().getNE(logicID);
        return ne;
    }

    static {
        int[] unmodifiedCPType = new int[]{913, 955, 956, 957, 958, 959, 969, 970, 971, 972, 973};
        int size = unmodifiedCPType.length;
        for (int i = 0; i < size; ++i) {
            Integer unmodifiedCP = unmodifiedCPType[i];
            if (cpTypeList.contains(unmodifiedCP)) continue;
            cpTypeList.add(unmodifiedCP);
        }
    }
}

