/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.network.qasn.m_q_inventory_ne.QAsnGetNEInfoReq;
import com.huawei.network.qasn.m_q_inventory_ne.QAsnGetNEInfoRsp;
import com.huawei.network.qasn.m_q_inventory_ne.QAsnNEInfo;
import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.event.Event;
import com.huawei.nglct.core.event.EventHandler;
import com.huawei.nglct.core.event.EventManager;
import com.huawei.nglct.core.startup.TEWNEMgrJniDllLoader;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.jni.TEJNINeCfgChgNtf;
import com.huawei.nglct.jni.nelist.TEJNIGetNEFromQ;
import com.huawei.nglct.nelist.NECommuStateNoticeReceiver;
import com.huawei.nglct.nelist.NECommuStateReceiverQxOnI;
import com.huawei.nglct.nelist.NECommuStateReceiverTL1OnI;
import com.huawei.nglct.nelist.TEIProcessOnReceiveNeMsg;
import com.huawei.nglct.nelist.TEJNIModifyNEIDNameObj;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENELdDevPkgNoticeReceiver;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TENEStatusMgr;
import com.huawei.nglct.nelist.handler.TENEHandlerMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.tl1.nemanager.TETL1NEBuildFactory;
import com.huawei.nglct.tl1.nemanager.TETL1NEStateNoticeReceiver;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEEventCenter;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEEventMsg;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.NENMIDHandle;
import com.huawei.uflight.qxprotocol.NEStateNoticeHandle;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import gnu.trove.TIntArrayList;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class TENEListMgr {
    private static final int MAX_LOGIN_NUM = 32;
    private Map<Integer, TENE> neMap = new Hashtable<Integer, TENE>();
    public static final String NELIST_PATH = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, "conf" + File.separator + "nelistinfo.xml");
    private Object sendNMIDObject = new Object();
    private static Logger embededWnemgrlog = TELogFactory.getembededWnemgrLogger();
    protected static final int TEEVENT_CFG_MODIFY_PHYNEID = 71;
    protected static final int TEEVENT_CFG_NEATTR_CHANGED = 6;
    private static final int TL1NEID_MASK = 0x4000000;
    private static final int OPERATION_UPLOAD = 3;
    private static TENEListMgr instance;

    void initIntegrationData() {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            EventManager.getInstance().registerEventHandler(71, (EventHandler)new TEJNIModifyNEIDHandler());
            EventManager.getInstance().registerEventHandler(6, (EventHandler)new TEJNIModifyNENameHandler());
            EventManager.getInstance().registerEventHandler(514, (EventHandler)new TEJNINeUploadEndHandler());
        }
    }

    private TENEListMgr() {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        TENE ne = null;
        int realNEID = -1;
        int neGWType = -1;
        String neGWAddress = null;
        String port = null;
        String bautRate = null;
        int isQXOrTL1 = 0;
        int neType = -1;
        String neVersion = "";
        String userName = "";
        String showNEVersion = "";
        String neName = "";
        InputStream in = null;
        ArrayList nelistinfo = null;
        int ini = 0;
        try {
            File nelistFileObj = new File(NELIST_PATH);
            in = nelistFileObj.toURI().toURL().openStream();
            ini = in.available();
        }
        catch (MalformedURLException ex) {
            TELogFactory.getNormalLogger().error(NELIST_PATH + " toURL() fail", (Throwable)ex);
        }
        catch (IOException ex) {
            TELogFactory.getNormalLogger().error(NELIST_PATH + " openStream() fail", (Throwable)ex);
        }
        if (null != in && ini > 0) {
            nelistinfo = TEResourceManager.getNeListInfo(NELIST_PATH);
        } else {
            try {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(NELIST_PATH), "utf-8"));
                writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.write("<nelist></nelist>");
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                TELogFactory.getNormalLogger().error("Create nelist.xml fail", (Throwable)e);
            }
        }
        if (null == nelistinfo || nelistinfo.isEmpty()) {
            return;
        }
        int size = nelistinfo.size();
        for (int i = 0; i < size; ++i) {
            HashMap htneinfo = (HashMap)nelistinfo.get(i);
            int neID = TENEListUtils.getLogicNEID();
            realNEID = Integer.parseInt((String)htneinfo.get("realNEID"));
            neType = Integer.parseInt((String)htneinfo.get("neType"));
            neVersion = (String)htneinfo.get("neVersion");
            neGWType = Integer.parseInt((String)htneinfo.get("neGWType"));
            neGWAddress = (String)htneinfo.get("neGWAddress");
            port = (String)htneinfo.get("port");
            bautRate = (String)htneinfo.get("baudRate");
            if (htneinfo.containsKey("neConnectType")) {
                isQXOrTL1 = Integer.parseInt((String)htneinfo.get("neConnectType"));
            }
            if (isQXOrTL1 == 0) {
                ne = new TENE(neID, neGWType, neGWAddress, port, bautRate);
                ne.setRealNEID(realNEID);
                ne.setNEType(neType);
                ne.setDeviceType(TEEquipmentDescription.getInstance().getDeviceTypeName(neType));
                ne.setHostVersion(neVersion);
                ne.setIsTL1OrQX(0);
                TENECommMgr.getInstance().putLogicNEID((long)realNEID, (long)neID);
            } else {
                neName = (String)htneinfo.get("neName");
                userName = (String)htneinfo.get("loginName");
                showNEVersion = (String)htneinfo.get("showNEVersion");
                ne = TETL1NEBuildFactory.bulidNE(neType);
                ne.setNEID(neID);
                ne.setNEName(neName);
                ne.setNEGWType(neGWType);
                ne.setDeviceType(TEEquipmentDescription.getInstance().getDeviceTypeName(neType));
                ne.setNEGWAddress(neGWAddress);
                ne.setPort(port);
                ne.setHostVersion(neVersion);
                ne.setBaudRate(bautRate);
                ne.setNEType(neType);
                ne.setCurUser(userName);
                ne.setShowNEVersion(showNEVersion);
                ne.setIsTL1OrQX(1);
                TETL1NECommMgr.getInstance().putLogicNEIDName((long)neID, neName);
            }
            this.addNEToNEListOnly(ne);
            if (isQXOrTL1 != 0) continue;
            TENEStatusMgr.getInstance().registerNe(ne);
        }
    }

    private void startConnectionNeThread() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                TIntArrayList neids = TENEListMgr.this.getNEIDList();
                for (int i = 0; i < neids.size(); ++i) {
                    TENE tmpNE = TENEListMgr.this.getNE(neids.get(i));
                    if (null == tmpNE) continue;
                    int tmpNEID = tmpNE.getNEID();
                    int tmpPort = Integer.parseInt(tmpNE.getPort());
                    int neConnectType = tmpNE.getIsTL1OrQX();
                    String tmpNEGWAddress = tmpNE.getNEGWAddress();
                    int tmpNEGWType = tmpNE.getNEGWType();
                    String baudrate = tmpNE.getBaudRate();
                    TELogFactory.getInterfaceLogger().info("NE:" + tmpNE.toString() + ",begin to connect" + "/n");
                    int result = -1;
                    if (tmpNEGWType == 5) {
                        tmpNEGWType = 3;
                    }
                    if (tmpNEGWType != 3) {
                        baudrate = null;
                    }
                    if (neConnectType == 0) {
                        TENECommMgr.getInstance().registerNEStateListener(tmpNEID, (NEStateNoticeHandle)new NECommuStateNoticeReceiver());
                        TELogFactory.getNormalLogger().info("create connect qx NEStateListener,ne: " + tmpNE.toString());
                        result = TENECommMgr.getInstance().createConect((long)tmpNEID, tmpPort, tmpNEGWAddress, tmpNEGWType, baudrate);
                    } else {
                        TETL1NECommMgr.getInstance().registerNEStateListener((long)tmpNEID, (com.huawei.uflight.tl1.NEStateNoticeHandle)new TETL1NEStateNoticeReceiver());
                        TELogFactory.getNormalLogger().info("create connect TL1 NEStateListener,NE: " + tmpNE.toString());
                        result = TETL1NECommMgr.getInstance().createConect((long)tmpNEID, tmpPort, tmpNEGWAddress, tmpNEGWType, baudrate);
                    }
                    if (result == 0) {
                        TELogFactory.getInterfaceLogger().info("NE:" + tmpNE.toString() + "connect successed" + "/n");
                        tmpNE.setComStatus(1);
                        continue;
                    }
                    TELogFactory.getInterfaceLogger().info("NE:" + tmpNE.toString() + "connect failed" + "/n");
                    tmpNE.setComStatus(0);
                }
            }
        }).start();
    }

    public static synchronized TENEListMgr getInstance() {
        if (instance == null) {
            instance = new TENEListMgr();
            if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                instance.startConnectionNeThread();
            }
        }
        return instance;
    }

    public String getNEListLogInfo() {
        StringBuilder nelistStr = new StringBuilder("nelsit->");
        Set<Map.Entry<Integer, TENE>> entrySet = this.neMap.entrySet();
        for (Map.Entry<Integer, TENE> entry : entrySet) {
            nelistStr.append(entry.getValue().toString());
            nelistStr.append(",");
        }
        return nelistStr.toString();
    }

    public TIntArrayList getNEIDList() {
        TIntArrayList neIDList = new TIntArrayList();
        Set<Integer> kets = this.neMap.keySet();
        Iterator<Integer> it = kets.iterator();
        while (it.hasNext()) {
            neIDList.add(it.next().intValue());
        }
        if (neIDList.isEmpty()) {
            TELogFactory.getNormalLogger().info("ne id list is empty");
        }
        neIDList.sort(0, neIDList.size());
        return neIDList;
    }

    public TENE getGateWayNEByIP(String ip) {
        Collection<TENE> teneCollections = this.neMap.values();
        for (TENE ne : teneCollections) {
            if (!ne.getNEGWAddress().equalsIgnoreCase(ip) || ne.getNEGateWay() != 1) continue;
            return ne;
        }
        TELogFactory.getNormalLogger().info("get gateway ne by ip failed. neip->" + ip);
        return null;
    }

    public TENE getNE(int neID) {
        TENE returnNE = null;
        if (this.neMap.containsKey(neID)) {
            returnNE = this.neMap.get(neID);
        }
        if (null == returnNE) {
            TELogFactory.getNormalLogger().info("get ne failed. neid->" + neID);
            TELogFactory.getNormalLogger().info(this.getNEListLogInfo());
        }
        return returnNE;
    }

    public TENE getInterNE(int neID) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (ne != null) {
            return ne;
        }
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return null;
        }
        QAsnGetNEInfoReq req = new QAsnGetNEInfoReq();
        QAsnGetNEInfoRsp rsp = new QAsnGetNEInfoRsp();
        req.neList.add((Object)neID);
        int retCode = TEJNIGetNEFromQ.getNE(neID, req, rsp);
        if (0 == retCode && 0 == rsp.result.result && !rsp.neInfoList.isEmpty()) {
            QAsnNEInfo asnNE = (QAsnNEInfo)rsp.neInfoList.get(0);
            TENE teNE = new TENE();
            teNE.setONEID(asnNE.oneID);
            teNE.setNEID(asnNE.neID);
            teNE.setRealNEID(asnNE.phyID);
            teNE.setNEType(TEGetNEDomainVersion.getInstance().getNeType(asnNE.neType));
            teNE.setShelfType(asnNE.shelfType);
            teNE.setNEName(new String(asnNE.name));
            teNE.setShowNEVersion(new String(asnNE.version));
            teNE.setNeIp(new String(asnNE.address));
            return teNE;
        }
        TELogFactory.getNormalLogger().error("get ne from Q fail! neID->" + neID);
        return null;
    }

    public TENE getNE(String nodeID) {
        Collection<TENE> allNe = this.neMap.values();
        Iterator<TENE> it = allNe.iterator();
        TENE returnNE = null;
        while (it.hasNext()) {
            TENE ne = it.next();
            if (ne.getNodeID() == null || !ne.getNodeID().equalsIgnoreCase(nodeID)) continue;
            returnNE = ne;
            break;
        }
        if (null == returnNE) {
            TELogFactory.getNormalLogger().info("get ne failed. nodeID->" + nodeID);
        }
        return returnNE;
    }

    public TENE getPhyNE(int realNEID) {
        Collection<TENE> allNe = this.neMap.values();
        Iterator<TENE> it = allNe.iterator();
        TENE returnNE = null;
        while (it.hasNext()) {
            TENE ne = it.next();
            if (ne.getRealNEID() != realNEID) continue;
            returnNE = ne;
            break;
        }
        if (null == returnNE) {
            TELogFactory.getNormalLogger().info("get ne failed. realNEID->" + realNEID);
        }
        return returnNE;
    }

    public void replaceNEAfterNEGetRealType(TENE oldNE, TENE newNE) {
        TENEListMgr.getInstance().delNEFromNEListOnly(oldNE);
        TENEListMgr.getInstance().addNEToNEListOnly(newNE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNE(TENE ne) {
        int neGWType = ne.getNEGWType();
        String neGWAddress = ne.getNEGWAddress();
        String port = ne.getPort();
        int neConnectType = ne.getIsTL1OrQX();
        boolean gneok = false;
        Collection<TENE> allNe = this.neMap.values();
        for (TENE tmpNE : allNe) {
            if (tmpNE.getNEGWAddress().equalsIgnoreCase(ne.getNEGWAddress())) {
                gneok = true;
            }
            if (!(neConnectType == 0 ? tmpNE.getNEID() == ne.getNEID() || tmpNE.getRealNEID() == ne.getRealNEID() && ne.getRealNEID() != 0 : tmpNE.getNEID() == ne.getNEID() || tmpNE.getNEName().equals(ne.getNEName()))) continue;
            return 1090781210;
        }
        this.addNEToNEListOnly(ne);
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            TEResourceManager.addNeListInfoNENode(NELIST_PATH, ne, true);
            this.registerNEStateListener(ne);
        }
        if (gneok || TESysManagerConstants.isSerialPort(neGWType)) {
            int result = this.createConectWithNe(ne, Integer.parseInt(port), neGWAddress);
            if (result != 0) {
                ne.setComStatus(0);
            } else {
                ne.setComStatus(1);
            }
        } else {
            Object object = this.sendNMIDObject;
            synchronized (object) {
                TENECommMgr.getInstance().registerNENMIDListener(ne.neID, (NENMIDHandle)new NENENMIDNoticeReceiver());
                int result = -1;
                result = this.createConectWithNe(ne, Integer.parseInt(port), neGWAddress);
                if (result != 0) {
                    ne.setComStatus(0);
                } else {
                    ne.setComStatus(1);
                    try {
                        this.sendNMIDObject.wait(20L);
                    }
                    catch (InterruptedException ex) {
                        TELogFactory.getNormalLogger().info("wait lock sendNMIDObject exception!", (Throwable)ex);
                    }
                }
            }
        }
        if (!TESysManagerBean.getInstance().isIntegratedStatus() && neConnectType == 0) {
            TENEStatusMgr.getInstance().registerNe(ne);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addNE(TENE ne, String sbiAddress, String sbiPort) {
        int neGWType = ne.getNEGWType();
        Collection<TENE> allNe = this.neMap.values();
        for (TENE tmpNE : allNe) {
            if (tmpNE.getNEID() != ne.getNEID() || tmpNE.getRealNEID() != ne.getRealNEID() || ne.getRealNEID() == 0) continue;
            return 0;
        }
        this.addNEToNEListOnly(ne);
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            this.registerNEStateListener(ne);
        }
        int result = 0;
        if (TESysManagerConstants.isSerialPort(neGWType)) {
            result = this.createConectWithNe(ne, Integer.parseInt(sbiPort), sbiAddress);
            if (result != 0) {
                TELogFactory.getNormalLogger().debug("Connect NE Fail!");
                ne.setComStatus(0);
            } else {
                TELogFactory.getNormalLogger().debug("Connect NE Success!");
                ne.setComStatus(1);
            }
        } else {
            Object object = this.sendNMIDObject;
            synchronized (object) {
                TENECommMgr.getInstance().registerNENMIDListener(0, (NENMIDHandle)new NENENMIDNoticeReceiver());
                TELogFactory.getNormalLogger().debug("The SBI address = " + sbiAddress + "  port = " + sbiPort);
                result = this.createConectWithNe(ne, Integer.parseInt(sbiPort), sbiAddress);
                if (result != 0) {
                    TELogFactory.getNormalLogger().debug("Connect NE Fail!");
                    ne.setComStatus(0);
                } else {
                    TELogFactory.getNormalLogger().debug("Connect NE Success!");
                    ne.setComStatus(1);
                    try {
                        this.sendNMIDObject.wait(30L);
                    }
                    catch (InterruptedException ex) {
                        TELogFactory.getNormalLogger().info("wait lock sendNMIDObject exception!" + ex);
                    }
                }
            }
        }
        return 0;
    }

    public int createConectWithNe(TENE neobj, int port, String ipAddress) {
        int result = 0;
        if (neobj == null) {
            return -1;
        }
        TELogFactory.getNormalLogger().info("Begin to connect ne: " + neobj.toString() + ", time:" + System.currentTimeMillis());
        long neID = neobj.getNEID();
        int isTL1OrQX = neobj.getIsTL1OrQX();
        int neGWType = neobj.getNEGWType();
        if (isTL1OrQX == 1) {
            if (null == TETL1NECommMgr.getInstance().getTL1NEName(neID)) {
                TETL1NECommMgr.getInstance().putLogicNEIDName(neID, neobj.getNEName());
            }
        } else if (-1 == TENECommMgr.getInstance().getNEID(neID)) {
            TENECommMgr.getInstance().putLogicNEID((long)neobj.getRealNEID(), neID);
        }
        if (neGWType == 5) {
            neGWType = 3;
        }
        if (neGWType == 3) {
            String baudRate = neobj.getBaudRate();
            result = isTL1OrQX == 1 ? TETL1NECommMgr.getInstance().createConect(neID, port, ipAddress, neGWType, baudRate) : TENECommMgr.getInstance().createConect(neID, port, ipAddress, neGWType, baudRate);
        } else {
            result = isTL1OrQX == 1 ? TETL1NECommMgr.getInstance().createConect(neID, port, ipAddress, neGWType) : TENECommMgr.getInstance().createConect(neID, port, ipAddress, neGWType);
        }
        TELogFactory.getNormalLogger().info("End to connect ne: " + neobj.toString() + ", time:" + System.currentTimeMillis());
        return result;
    }

    public int createConectWithNe(long neID, String neName, int isTL1OrQX, int port, String ipAddress, int neGWType, String baudRate) {
        int result = 0;
        TELogFactory.getNormalLogger().info("Begin to connect ne: (neid:" + neID + ",NeName: " + neName + ")");
        if (neGWType == 5) {
            neGWType = 3;
        }
        result = neGWType == 3 ? (isTL1OrQX == 1 ? TETL1NECommMgr.getInstance().createConect(neID, port, ipAddress, neGWType, baudRate) : TENECommMgr.getInstance().createConect(neID, port, ipAddress, neGWType, baudRate)) : (isTL1OrQX == 1 ? TETL1NECommMgr.getInstance().createConect(neID, port, ipAddress, neGWType) : TENECommMgr.getInstance().createConect(neID, port, ipAddress, neGWType));
        TELogFactory.getNormalLogger().info("End to connect ne: (neid:" + neID + ",NeName: " + neName + ")");
        return result;
    }

    public void registerNEStateListener(long neID, String neName, int isTL1OrQX) {
        if (isTL1OrQX == 1) {
            TETL1NECommMgr.getInstance().registerNEStateListener(neID, (com.huawei.uflight.tl1.NEStateNoticeHandle)new TETL1NEStateNoticeReceiver());
            TELogFactory.getNormalLogger().info("register add TL1NE NEStateListener,NE:(neid:" + neID + ",NeName: " + neName + ")");
        } else {
            int neIDInt = (int)neID;
            TENECommMgr.getInstance().registerNEStateListener(neIDInt, (NEStateNoticeHandle)new NECommuStateNoticeReceiver());
            TELogFactory.getNormalLogger().info("register add QXNE  NEStateListener,NE: (neid:" + neID + ",NeName: " + neName + ")");
        }
    }

    public void registerNEStateListener(TENE neobj) {
        if (neobj == null) {
            return;
        }
        long neID = neobj.getNEID();
        if (neobj.getIsTL1OrQX() == 1) {
            TETL1NECommMgr.getInstance().registerNEStateListener(neID, (com.huawei.uflight.tl1.NEStateNoticeHandle)new TETL1NEStateNoticeReceiver());
            TELogFactory.getNormalLogger().info("register add TL1NE NEStateListener,NE: " + neobj.toString());
        } else {
            TENECommMgr.getInstance().registerNEStateListener(neobj.getNEID(), (NEStateNoticeHandle)new NECommuStateNoticeReceiver());
            TELogFactory.getNormalLogger().info("register add QXNE  NEStateListener,NE: " + neobj.toString());
        }
    }

    public int closeConectWithNe(TENE neobj) {
        int result = 0;
        if (neobj == null) {
            return -1;
        }
        TELogFactory.getNormalLogger().info("begin to close connect with ne: " + neobj.toString());
        long neID = neobj.getNEID();
        int isTL1OrQX = neobj.getIsTL1OrQX();
        String ipAddress = neobj.getNEGWAddress();
        int port = Integer.parseInt(neobj.getPort());
        int neGWType = neobj.getNEGWType();
        if (isTL1OrQX == 0) {
            result = TENECommMgr.getInstance().closeConnect(neID, port, ipAddress, neGWType);
            TENECommMgr.getInstance().unregisterNEStateListener(neobj.getNEID());
            TENECommMgr.getInstance().deleteNEID(neID);
            TENEStatusMgr.getInstance().removeNe(neobj);
        } else {
            result = TETL1NECommMgr.getInstance().closeConnect(neID, port, ipAddress, neGWType);
            TETL1NECommMgr.getInstance().unregisterNEStateListener(neID);
            TETL1NECommMgr.getInstance().deleteTL1NEID(neID);
        }
        TELogFactory.getNormalLogger().info("end to close connect with ne: " + neobj.toString());
        return result;
    }

    public int deleteNE(int neID, int phyNEID) {
        TENE tmpNE = null;
        boolean found = false;
        tmpNE = this.neMap.get(neID);
        if (tmpNE != null && tmpNE.getRealNEID() != phyNEID) {
            TENEListMgr.getInstance().delNEFromNEListOnly(tmpNE);
            found = true;
        }
        if (found) {
            this.closeConectWithNe(tmpNE);
            TEInnerDelNEEventMsg eventMsg = new TEInnerDelNEEventMsg(neID, phyNEID);
            TEInnerDelNEEventCenter.getInstance().notifyObservers(eventMsg);
        }
        return 0;
    }

    public int deleteIntergrationNE(int neID, int phyNEID) {
        embededWnemgrlog.info("deleteIntergrationNE begin. neID->" + neID + "phyNEID->" + phyNEID);
        TENE tmpNE = null;
        boolean found = false;
        tmpNE = this.neMap.get(neID);
        if (tmpNE != null && tmpNE.getRealNEID() == phyNEID) {
            TENEHandlerMgr.getInstance().doNEDeleteHandle(neID);
            TENEListMgr.getInstance().delNEFromNEListOnly(tmpNE);
            found = true;
        }
        if (found) {
            this.closeConectWithNe(tmpNE);
            TEInnerDelNEEventMsg eventMsg = new TEInnerDelNEEventMsg(neID, phyNEID);
            TEInnerDelNEEventCenter.getInstance().notifyObservers(eventMsg);
        } else {
            embededWnemgrlog.error("ne not found.");
        }
        TELogFactory.getembededWnemgrLogger().info("deleteIntergrationNE end.");
        return 0;
    }

    public int deleteNE(TENE ne) {
        int neID = ne.getNEID();
        int phyNEID = ne.getRealNEID();
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS != TESysManagerBean.getInstance().getSysStauts() && !TEResourceManager.deleteNeListInfoNENode(NELIST_PATH, neID) && phyNEID != 0) {
            return 2;
        }
        this.closeConectWithNe(ne);
        TENEHandlerMgr.getInstance().doNEDeleteHandle(neID);
        TENEListMgr.getInstance().delNEFromNEListOnly(ne);
        TEInnerDelNEEventMsg eventMsg = new TEInnerDelNEEventMsg(neID, phyNEID);
        TEInnerDelNEEventCenter.getInstance().notifyObservers(eventMsg);
        return 0;
    }

    public int deleteNE(int neID, String neName) {
        TETL1NE tmpNE = null;
        boolean found = false;
        TENE ne = this.neMap.get(neID);
        if (ne != null && ne.getIsTL1OrQX() == 1 && (tmpNE = (TETL1NE)ne).getNEName().equals(neName)) {
            TENEListMgr.getInstance().delNEFromNEListOnly(tmpNE);
            found = true;
        }
        if (found) {
            this.closeConectWithNe(ne);
            TEInnerDelNEEventMsg eventMsg = new TEInnerDelNEEventMsg(neID);
            TEInnerDelNEEventCenter.getInstance().notifyObservers(eventMsg);
        }
        return 0;
    }

    public TENE getNEByNEName(String neName) {
        Collection<TENE> allNe = this.neMap.values();
        for (TENE tmpNE : allNe) {
            if (!tmpNE.getNEName().equals(neName)) continue;
            return tmpNE;
        }
        TELogFactory.getNormalLogger().info("get ne failed. neName->" + neName);
        TELogFactory.getNormalLogger().info("neid list ->" + this.getNEListLogInfo());
        return null;
    }

    public TENE getTL1NEByNEName(String neName) {
        TENE ne = this.getNEByNEName(neName);
        if (ne == null || ne.getIsTL1OrQX() != 1) {
            TELogFactory.getNormalLogger().info("get TL1 ne failed. neName->" + neName);
            TELogFactory.getNormalLogger().info("neid list ->" + this.getNEListLogInfo());
            return null;
        }
        return ne;
    }

    public boolean isAddedNE(int neID) {
        return this.neMap.containsKey(neID);
    }

    public boolean isAddedNE(String neName) {
        Collection<TENE> allNe = this.neMap.values();
        for (TENE tmpNE : allNe) {
            if (!tmpNE.getNEName().equals(neName)) continue;
            return true;
        }
        return false;
    }

    public boolean isLogMaxNumNE() {
        int count = 0;
        Collection<TENE> allNe = this.neMap.values();
        for (TENE tmpNE : allNe) {
            if (1 != tmpNE.getLogStatus()) continue;
            ++count;
        }
        return count >= 32;
    }

    public void refreshInterNE() {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        try {
            TEDaoOperationResult drb = TECommonDaoService.findAll(TENEMOPO.class);
            if (0 != drb.getResult()) {
                embededWnemgrlog.error("refreshInterNE Get all ne mo failed!");
            } else {
                List<Object> cmgrNEList = drb.getData();
                TENEMOPO nepo = null;
                if (cmgrNEList.isEmpty()) {
                    embededWnemgrlog.info("refreshInterNE The size of neList is 0.");
                }
                TENE subNE = null;
                for (Object obj : cmgrNEList) {
                    nepo = (TENEMOPO)obj;
                    subNE = TENEListMgr.convertTENEPO2TENE(nepo);
                    if (null == subNE || TENEListMgr.getInstance().isNEExist(subNE)) continue;
                    TENEListMgr.getInstance().addNEToNEListOnly(subNE);
                    TENEListMgr.regeisterNEStateListener(subNE);
                }
                cmgrNEList.clear();
            }
        }
        catch (Exception e1) {
            embededWnemgrlog.error("refreshInterNE addInterNEOnStart error", (Throwable)e1);
        }
    }

    private static TENE convertTENEPO2TENE(TENEMOPO nepo) {
        int neID = (int)nepo.getNEID();
        int phyID = (int)nepo.getPhyID();
        int logicNEType = nepo.getType();
        int phyNEType = TEGetNEDomainVersion.getInstance().getNeType(logicNEType);
        if (phyNEType <= 0) {
            return null;
        }
        String subClassName = TENELdDevPkgNoticeReceiver.getSubNEClass(phyNEType);
        String neName = nepo.getName();
        embededWnemgrlog.info("TENEListMgr.addInterNEOnStart().subClassName is:" + subClassName);
        TENE subNE = null;
        if (null == subClassName) {
            embededWnemgrlog.info("TENEListMgr:subClassName is null! neid is: " + neID + "logicNEType: " + logicNEType);
        } else {
            try {
                subNE = (TENE)Class.forName(subClassName).newInstance();
            }
            catch (Exception e) {
                embededWnemgrlog.error("Class.forName error", (Throwable)e);
            }
            if (null != subNE) {
                subNE.setNEID(neID);
                subNE.setRealNEID(phyID);
                subNE.setNEType(phyNEType);
                subNE.setNEName(neName);
            }
        }
        return subNE;
    }

    private static void regeisterNEStateListener(TENE ne) {
        int phyID = ne.getRealNEID();
        int neID = ne.getNEID();
        if (0 != (phyID & 0x4000000)) {
            String neName = ne.getNEName();
            TETL1NECommMgr.getInstance().putLogicNEIDName((long)neID, neName);
            embededWnemgrlog.info("TENEListMgr:addInterNEOnStart: neID = " + neID + "neName = " + neName);
            TETL1NECommMgr.getInstance().registerNEStateListener((long)neID, (com.huawei.uflight.tl1.NEStateNoticeHandle)new NECommuStateReceiverTL1OnI());
        } else {
            TENECommMgr.getInstance().putLogicNEID((long)phyID, (long)neID);
            embededWnemgrlog.info("TENEListMgr:addInterNEOnStart: neID = " + neID + "phyID = " + phyID);
            TENECommMgr.getInstance().registerNEStateListener(neID, (NEStateNoticeHandle)new NECommuStateReceiverQxOnI());
        }
    }

    public void registerNewNeToList(TENE ne) {
        this.addNEToNEListOnly(ne);
        TENEListMgr.regeisterNEStateListener(ne);
    }

    private void addNEToNEListOnly(TENE ne) {
        TELogFactory.getNormalLogger().info("add ne from nemap->ne" + ne.toString());
        this.neMap.put(ne.getNEID(), ne);
    }

    private boolean isNEExist(TENE ne) {
        return this.neMap.containsKey(ne.getNEID());
    }

    protected static void receiveJNIAddNEMessage(int neID) {
        embededWnemgrlog.info("TENEListMgr:receiveJNIAddNEMessage. neID is: " + neID);
        TENEListMgr.addInterNE(neID);
        TENEListMgr.loginInterNE(neID);
    }

    private static void loginInterNE(final int neID) {
        new Thread(){

            @Override
            public void run() {
                int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
                if (0 != retCode) {
                    String tipStr = String.format("connect ne fail! neID:%d,retCode:%d", neID, retCode);
                    embededWnemgrlog.error(tipStr);
                }
            }
        }.start();
    }

    protected static void receiveJNIRemoveNEMessage(int neID) {
        embededWnemgrlog.info("TENEListMgr:receiveJNIRemoveNEMessage. neID is: " + neID);
        if (TESpecialAttrMgr.getInstance().isNESupport(neID, "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")) {
            try {
                TEIProcessOnReceiveNeMsg pro = (TEIProcessOnReceiveNeMsg)Class.forName(TESpecialAttrMgr.getInstance().getNEAttrValue(neID, "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")).newInstance();
                TELogFactory.getNormalLogger().info("start remove l3vpn data of ne on removing ne event!" + neID);
                pro.processOnRemove(neID);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("construct process on remove ne failed! " + neID, (Throwable)e);
            }
        } else {
            TELogFactory.getNormalLogger().info("this ne do not support l3vpn! " + neID);
        }
        try {
            TENEListMgr.removeInterNEDataOnDel(neID);
            TENEHandlerMgr.getInstance().doNEDeleteHandle(neID);
        }
        catch (Exception e) {
            embededWnemgrlog.error("exception before del ne.", (Throwable)e);
        }
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null != ne) {
            TENEListMgr.getInstance().deleteIntergrationNE(ne.getNEID(), ne.getRealNEID());
        }
    }

    private static void removeInterNEDataOnDel(int neID) {
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null != ne) {
                ne.removeInterNEDataBeforeDel();
            }
        }
        catch (Exception e) {
            embededWnemgrlog.info("TENEListMgr:removeInterNEDataOnDel. neID is: " + neID);
        }
    }

    protected void delNEFromNEListOnly(TENE ne) {
        TELogFactory.getNormalLogger().info("remove ne from nemap->ne" + ne.toString());
        this.neMap.remove(ne.getNEID());
    }

    protected static void addInterNE(int neID) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        if (TENEListMgr.getInstance().isAddedNE(neID)) {
            embededWnemgrlog.info("ne already exists.... neID->" + neID);
            return;
        }
        TEDaoOperationResult drb = null;
        try {
            drb = TECommonDaoService.findNE(new int[]{neID});
        }
        catch (Exception e1) {
            embededWnemgrlog.info("", (Throwable)e1);
        }
        if (null == drb || 0 != drb.getResult()) {
            embededWnemgrlog.error("addInterNE ---Get ne mo failed! neID->" + neID);
            return;
        }
        List<Object> cmgrNEList = drb.getData();
        if (cmgrNEList.isEmpty()) {
            embededWnemgrlog.error("addInterNE ---Get ne mo failed! neID->" + neID);
            embededWnemgrlog.info("The size of neList is 0.");
            return;
        }
        TENEMOPO nepo = (TENEMOPO)cmgrNEList.get(0);
        int phyID = -1;
        int logicNEType = -1;
        int phyNEType = -1;
        String neName = null;
        String subClassName = null;
        TENE subNE = null;
        phyID = (int)nepo.getPhyID();
        logicNEType = nepo.getType();
        phyNEType = TEGetNEDomainVersion.getInstance().getNeType(logicNEType);
        subClassName = TENELdDevPkgNoticeReceiver.getSubNEClass(phyNEType);
        neName = nepo.getName();
        embededWnemgrlog.info("addInterNE().subClassName is:" + subClassName);
        if (null == subClassName) {
            embededWnemgrlog.info("TENEListMgr:subClassName is null! neid is: " + neID + "logicNEType: " + logicNEType);
        } else {
            try {
                subNE = (TENE)Class.forName(subClassName).newInstance();
            }
            catch (Exception e) {
                embededWnemgrlog.error("Class.forName error", (Throwable)e);
            }
            if (null != subNE) {
                subNE.setNEID(neID);
                subNE.setRealNEID(phyID);
                subNE.setNEType(phyNEType);
                subNE.setNEName(neName);
                TENEListMgr.getInstance().addNEToNEListOnly(subNE);
                if (0 != (phyID & 0x4000000)) {
                    neName = nepo.getName();
                    TETL1NECommMgr.getInstance().putLogicNEIDName((long)neID, neName);
                    embededWnemgrlog.info("TENEListMgr:addInterNE: neID = " + neID + "neName = " + neName);
                    TETL1NECommMgr.getInstance().registerNEStateListener((long)neID, (com.huawei.uflight.tl1.NEStateNoticeHandle)new NECommuStateReceiverTL1OnI());
                } else {
                    TENECommMgr.getInstance().putLogicNEID((long)phyID, (long)neID);
                    embededWnemgrlog.info("TENEListMgr:addInterNE: neID = " + neID + "phyID = " + phyID);
                    TENECommMgr.getInstance().registerNEStateListener(neID, (NEStateNoticeHandle)new NECommuStateReceiverQxOnI());
                }
                subNE.initInterNEDataAfterCreate();
            }
            TENEListMgr.addNEToIPProces(neID);
        }
        cmgrNEList.clear();
    }

    private static void addNEToIPProces(int neID) {
        if (TESpecialAttrMgr.getInstance().isNESupport(neID, "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")) {
            try {
                TEIProcessOnReceiveNeMsg pro = (TEIProcessOnReceiveNeMsg)Class.forName(TESpecialAttrMgr.getInstance().getNEAttrValue(neID, "TE_FUNC_CFG_NE_ATTRIBUTE", "NE_ATTR_SUPPORT_PROCESS_ONRECEIVENEMSG")).newInstance();
                TELogFactory.getNormalLogger().info("start add l3vpn ne to inventory table on adding ne event!" + neID);
                pro.processOnAdd(neID);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("construct process on adding ne failed! " + neID, (Throwable)e);
            }
        } else {
            TELogFactory.getNormalLogger().info("this ne do not support l3vpn! " + neID);
        }
    }

    public static void registerLogicNEID(TENE ne) {
        int neID = ne.getNEID();
        int phyID = ne.getRealNEID();
        if (0 != (phyID & 0x4000000)) {
            String neName = ne.getNEName();
            TETL1NECommMgr.getInstance().putLogicNEIDName((long)neID, neName);
            embededWnemgrlog.info("TENEListMgr:addInterNEOnStart: neID = " + neID + "neName = " + neName);
        } else {
            TENECommMgr.getInstance().putLogicNEID((long)phyID, (long)neID);
            embededWnemgrlog.info("TENEListMgr:addInterNEOnStart: neID = " + neID + "phyID = " + phyID);
        }
    }

    public static void unregisterLogicNEID(TENE ne) {
        int isQXOrTL1 = ne.getIsTL1OrQX();
        TELogFactory.getNormalLogger().info("unregister LogicNEID,ne->" + ne.toString());
        if (isQXOrTL1 == 0) {
            TENECommMgr.getInstance().deleteNEID((long)ne.getNEID());
        } else {
            TETL1NECommMgr.getInstance().deleteTL1NEID((long)ne.getNEID());
        }
    }

    public void clearAllNePassWord() {
        Collection<TENE> allNe = this.neMap.values();
        for (TENE tmpNE : allNe) {
            if (1 == tmpNE.getLogStatus()) {
                tmpNE.logout();
            }
            byte[] clearPwd = new byte[]{};
            tmpNE.setCurUserPassword(clearPwd);
        }
    }

    static {
        TEWNEMgrJniDllLoader.loadWNEMgrDll();
        instance = null;
    }

    class TEJNINeUploadEndHandler
    implements EventHandler {
        TEJNINeUploadEndHandler() {
        }

        @Override
        public void handleEvent(Event event) {
            TEJNINeCfgChgNtf eventContext = (TEJNINeCfgChgNtf)event.getEventContext();
            embededWnemgrlog.info("Receive Ne Upload End Event." + eventContext.toString());
            if (eventContext.getOperType() != 3) {
                return;
            }
            int logicNeID = eventContext.getNeID();
            TENE ne = TENEListMgr.this.getNE(logicNeID);
            if (null == ne) {
                embededWnemgrlog.info("Ne is not exist,it will be add.neID->" + logicNeID);
                TENEListMgr.addInterNE(logicNeID);
                TENEListMgr.loginInterNE(logicNeID);
            }
        }
    }

    class TEJNIModifyNENameHandler
    implements EventHandler {
        TEJNIModifyNENameHandler() {
        }

        @Override
        public void handleEvent(Event event) {
            TEJNIModifyNEIDNameObj eventContext = (TEJNIModifyNEIDNameObj)event.getEventContext();
            int logicNeID = eventContext.logicNEID;
            TENE ne = TENEListMgr.this.getNE(logicNeID);
            if (null == ne) {
                TELogFactory.getNormalLogger().info("get ne failed, neid->" + logicNeID);
                return;
            }
            boolean isTL1 = 1 == ne.getIsTL1OrQX();
            String newNEName = eventContext.neName;
            int newLogicType = eventContext.logicNEType;
            TELogFactory.getNormalLogger().info("receive ne type name changed event");
            TELogFactory.getNormalLogger().info("new name->" + newNEName);
            TELogFactory.getNormalLogger().info("new netype->" + newLogicType);
            if (0 != newLogicType) {
                ne = TENEListMgr.this.getNE(logicNeID);
                if (null == ne) {
                    embededWnemgrlog.info("modify ne name. ne is null!. logicNeID->" + logicNeID);
                    return;
                }
                int phyType = TEGetNEDomainVersion.getInstance().getNeType(newLogicType);
                String subClassName = TENELdDevPkgNoticeReceiver.getSubNEClass(phyType);
                TENE subNE = null;
                if (null == subClassName) {
                    embededWnemgrlog.info("TENEListMgr:subClassName is null! neid is: " + ne.getNEID() + "logicNEType: " + newLogicType);
                    return;
                }
                try {
                    subNE = (TENE)Class.forName(subClassName).newInstance();
                }
                catch (Exception e) {
                    embededWnemgrlog.error("Class.forName", (Throwable)e);
                }
                if (subNE == null) {
                    embededWnemgrlog.error("Refactor Class.forName=" + subClassName + " failed!");
                    return;
                }
                subNE.setNEID(logicNeID);
                subNE.setRealNEID(ne.getRealNEID());
                subNE.setNEType(phyType);
                subNE.setNEName(ne.getNEName());
                TENEListMgr.this.replaceNEAfterNEGetRealType(ne, subNE);
            }
            if (null != newNEName) {
                ne = TENEListMgr.this.getNE(logicNeID);
                if (null == ne) {
                    embededWnemgrlog.info("modify ne name. ne is null!. logicNeID->" + logicNeID);
                    return;
                }
                if (isTL1) {
                    TETL1NECommMgr.getInstance().deleteTL1NEID((long)logicNeID);
                    TETL1NECommMgr.getInstance().putLogicNEIDName((long)logicNeID, newNEName);
                }
                ne.setNEName(newNEName);
            }
        }
    }

    class TEJNIModifyNEIDHandler
    implements EventHandler {
        TEJNIModifyNEIDHandler() {
        }

        @Override
        public void handleEvent(Event event) {
            TEJNIModifyNEIDNameObj eventContext = (TEJNIModifyNEIDNameObj)event.getEventContext();
            int logicNeID = eventContext.logicNEID;
            int nePhyID = eventContext.nePhyID;
            if (0 != nePhyID) {
                TENE ne = TENEListMgr.this.getNE(logicNeID);
                if (null != ne) {
                    boolean isQx;
                    ne.getNeImplInterface().setPhyID(nePhyID);
                    boolean bl = isQx = 0 == ne.getIsTL1OrQX();
                    if (isQx) {
                        ne.setLogStatus(0);
                        TENECommMgr.getInstance().deleteNEID((long)logicNeID);
                        TENECommMgr.getInstance().putLogicNEID((long)nePhyID, (long)logicNeID);
                    }
                } else {
                    embededWnemgrlog.info("modify nePhyID. ne is null!. logicNeID->" + logicNeID);
                }
            }
            embededWnemgrlog.info("new nePhyID is: " + nePhyID);
        }
    }

    class NENENMIDNoticeReceiver
    implements NENMIDHandle {
        NENENMIDNoticeReceiver() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleNoticeNeNMID(int neID, boolean succToApplyNMID) {
            if (succToApplyNMID) {
                System.out.println("notifyAll before: " + System.currentTimeMillis());
                Object object = TENEListMgr.this.sendNMIDObject;
                synchronized (object) {
                    System.out.println("notifyAll after: " + System.currentTimeMillis());
                    TENEListMgr.this.sendNMIDObject.notifyAll();
                }
            }
        }
    }
}

