/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.bscfg.procinnerevent.TEProcInnerEventMgr;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.pnp.TEPNPBundleLoadMgr;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.db.jni.dbservice.TEMitDataMgr;
import com.huawei.nglct.db.jni.hbnconfiguration.TEHibernateConfigurationMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENECommMgrFacade;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configuration.TEDataLoadMgr;
import com.huawei.nglct.nelist.model.eventinterpret.TEEventNoticeHandlerMgr;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.eventinterpret.TETL1EventNoticeHandlerMgr;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.uflight.qxprotocol.TETaskManager;
import gnu.trove.TIntArrayList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public class TENEListInit {
    private static TENEListInit instance = new TENEListInit();
    private boolean inited = false;

    private TENEListInit() {
    }

    public static TENEListInit getInstance() {
        return instance;
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.inited = true;
        TETaskManager.instance();
        try {
            TEDataLoadMgr.getInstance().loadingFirstStepData();
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("loadingFirstStepDatafail!", (Throwable)ex);
        }
        TEPNPBundleLoadMgr.getInstance().reloadAllPNPFile();
        if (TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_INTEGRATION_STATUS) {
            try {
                TEHibernateConfigurationMgr.initHbnConfiguration();
                TEMitDataMgr.init();
                TEScriptOperationMgr.getInstance();
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TENEListInit.init() fail!", (Throwable)e);
            }
        }
        TENEListMgr.getInstance().initIntegrationData();
        if (TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_INTEGRATION_STATUS) {
            TETL1EventNoticeHandlerMgr.getInstance().eventIntegrationRegister();
            TEProcInnerEventMgr.getInstance();
        } else {
            TEEventNoticeHandlerMgr.getInstance().eventRegister();
            TETL1EventNoticeHandlerMgr.getInstance().eventRegister();
            this.updateLctStatus();
        }
        TENECommMgrFacade.getInstance().setFilterLogCmds();
        TELogFactory.getNormalLogger().info("TENEListInitServlet initing!!!!!!!!!");
    }

    public void loginNEOnI(final String domain) {
        if (TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_INTEGRATION_STATUS) {
            new Thread(){

                @Override
                public void run() {
                    TIntArrayList neIDList = TENEListMgr.getInstance().getNEIDList();
                    int len = neIDList.size();
                    for (int i = 0; i < len; ++i) {
                        int neID = neIDList.get(i);
                        TENE ne = TENEListMgr.getInstance().getNE(neID);
                        if (!TEGetNEDomainVersion.getInstance().getDomain(ne.getNEType()).equals(domain) && !domain.equals("")) {
                            return;
                        }
                        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
                        if (0 == retCode) continue;
                        String tipStr = String.format("connect ne fail! neID:%d,retCode:%d", neID, retCode);
                        TELogFactory.getNormalLogger().error(tipStr);
                    }
                }
            }.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateLctStatus() {
        String rootDir = System.getProperty("user.dir");
        File file = new File(rootDir + File.separator + "bin" + File.separator + "st.ini");
        TELogFactory.getNormalLogger().info(rootDir + File.separator + "bin" + File.separator + "st.ini");
        if (!file.exists()) {
            TELogFactory.getNormalLogger().info("st.ini not exsit!");
            return;
        }
        Properties pros = new Properties();
        FileInputStream input = null;
        OutputStream output = null;
        try {
            input = new FileInputStream(file);
            pros.load(input);
            TELogFactory.getNormalLogger().info("start write file!");
            output = new FileOutputStream(file);
            pros.setProperty("start", "1");
            pros.setProperty("time", "0");
            pros.store(output, "");
            ((InputStream)input).close();
            output.close();
            TELogFactory.getNormalLogger().info("end write file!");
        }
        catch (FileNotFoundException e) {
            TELogFactory.getNormalLogger().info("st.ini not exsit!");
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().info("st.ini can't be read and write!");
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e1) {
                    TELogFactory.getNormalLogger().info(e1.getMessage());
                }
            }
            if (input != null) {
                try {
                    ((InputStream)input).close();
                }
                catch (IOException e1) {
                    TELogFactory.getNormalLogger().info(e1.getMessage());
                }
            }
        }
    }
}

