/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.nelist.TEAlarmData;
import com.huawei.nglct.nelist.TEAlarmKey;
import com.huawei.nglct.nelist.TEAlarmPara;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.nemanager.TETL1AlarmKey;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class TENEListConstant {
    private static TENEListConstant instance = null;
    public static final int EXIGENCE_ALM = 1;
    public static final int PRIMARY_ALM = 2;
    public static final int SECONDARY_ALM = 3;
    public static final int PROMPT_ALM = 4;
    public static final int UNKNOW = -1;
    public static final int DEFAULTNEID = -1;
    public static final int DEFAULTNETYPE = -1;
    public static final int PUS_IDLE = 0;
    public static final int PUS_BUSY = 1;
    public static final int PUS_SOURCE_USED = 2;
    public static final int PUS_SINK_USED = 3;
    public static final int PUS_UNKNOW = 0;
    public static final int NORMAL = 1;
    public static final int ABNORMAL = 0;
    public static final int LOG_NORMAL = 1;
    public static final int LOG_ABNORMAL = 0;
    public static final int UPDATING_ID = 2;
    private HashMap alarmData = new HashMap();
    private HashMap alarmTL1Data = new HashMap();
    private HashMap alarmNMTl1Data = new HashMap();
    private ArrayList alarmParaList = new ArrayList();
    private String path = null;

    private TENEListConstant() {
        if (this.alarmData.size() == 0) {
            this.initAlarmData();
        }
        if (this.alarmParaList.size() == 0) {
            this.initAlarmPara();
        }
        if (!TESysManagerBean.getInstance().isIntegratedStatus() && this.alarmTL1Data.size() == 0) {
            this.initAlarmTL1Data("alarmDatas_TL1.xml");
            this.initAlarmTL1Data("alarmDatas_TL1_MARINE.xml");
        }
    }

    private void initAlarmPara() {
        this.path = TEResourceManager.getPath() + File.separator + "conf" + File.separator + "alarmparamap_" + TESysManagerBean.getInstance().getlanguage() + ".xml";
        Document doc = TEParseXMLFile.parseFile(this.path);
        NodeList list = doc.getElementsByTagName("param");
        TEAlarmPara tEAlarmPara = null;
        int len = list.getLength();
        for (int i = 0; i < len; ++i) {
            Element element = (Element)list.item(i);
            int nodeType = new Integer(element.getAttribute("NodeType"));
            int cPType = new Long(element.getAttribute("CPType")).intValue();
            int eqType = new Long(element.getAttribute("EqType")).intValue();
            int aeID = new Integer(element.getAttribute("AeID"));
            int paraBit = new Integer(element.getAttribute("ParaBit"));
            int paraValue = new Integer(element.getAttribute("ParaValue"));
            String paraReq = element.getAttribute("ParaRep");
            tEAlarmPara = new TEAlarmPara(nodeType, cPType, eqType, aeID, paraBit, paraValue, paraReq);
            this.alarmParaList.add(tEAlarmPara);
        }
    }

    public void initAlarmData() {
        String language = TESysManagerBean.getInstance().getlanguage();
        this.path = TEResourceManager.getPath() + File.separator + "conf" + File.separator + "alarmdata_" + language + ".xml";
        Document doc = TEParseXMLFile.parseFile(this.path);
        if (null != doc) {
            NodeList list = doc.getElementsByTagName("param");
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                TEAlarmData almData = this.parseAlarmData((Element)list.item(i));
                this.alarmData.put(new TEAlarmKey(almData.getEqType(), almData.getAeID()), almData);
            }
        }
    }

    private TEAlarmData parseAlarmData(Element element) {
        int eqType = new Integer(element.getAttribute("EqType"));
        int aeID = new Integer(element.getAttribute("AeID"));
        int aIDType = new Integer(element.getAttribute("AIDType"));
        int aeType = new Integer(element.getAttribute("AeType"));
        int location = new Integer(element.getAttribute("Location"));
        int direction = new Integer(element.getAttribute("Direction"));
        int aeSeverity = new Integer(element.getAttribute("AeSeverity"));
        int autoReportState = new Integer(element.getAttribute("AutoReportState"));
        int suppressState = new Integer(element.getAttribute("SuppressState"));
        int effectState = new Integer(element.getAttribute("EffectState"));
        int ispath = new Integer(element.getAttribute("Ispath"));
        String aeName = element.getAttribute("AeName");
        String aeDetailName = element.getAttribute("AeDetailName");
        String aeReason = element.getAttribute("AeReason");
        String probableCase = element.getAttribute("ProbableCase");
        int objectType = new Integer(element.getAttribute("ObjectType"));
        TEAlarmData almData = new TEAlarmData(eqType, aeID, aIDType, aeType, location, direction, aeSeverity, autoReportState, suppressState, effectState, ispath, aeName, aeDetailName, aeReason, probableCase, objectType);
        return almData;
    }

    public void initAlarmTL1Data(String fileName) {
        String tl1Path = File.separator + "nemgr" + File.separator + "tl1necommon" + File.separator + "conf" + File.separator + fileName;
        Document doc = null;
        try {
            doc = TEParseXMLFile.parseFile("com.huawei.weblct.tl1necommon", tl1Path);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TENEListConstant.initAlarmTL1Data() fail!", (Throwable)e);
        }
        if (null != doc) {
            NodeList list = doc.getElementsByTagName("param");
            int len = list.getLength();
            for (int i = 0; i < len; ++i) {
                TEAlarmData almData = this.parseAlarmData((Element)list.item(i));
                this.alarmTL1Data.put(new TETL1AlarmKey(almData.getLocation(), almData.getDirection(), almData.getAIDType(), almData.getAeName()), almData);
                this.alarmNMTl1Data.put(new TEAlarmKey(almData.getEqType(), almData.getAeID()), almData);
            }
        }
    }

    public static String convertNEID(int neID) {
        int subNEID = neID % 65536;
        int extID = (neID - subNEID) / 65536;
        return extID + "-" + subNEID;
    }

    public static synchronized TENEListConstant getInstance() {
        if (instance == null) {
            instance = new TENEListConstant();
        }
        return instance;
    }

    public HashMap getAlmData() {
        if (this.alarmData.size() == 0) {
            this.initAlarmData();
        }
        return this.alarmData;
    }

    public HashMap getTL1AlmData() {
        if (this.alarmTL1Data.size() == 0) {
            this.initAlarmTL1Data("alarmDatas_TL1.xml");
            this.initAlarmTL1Data("alarmDatas_TL1_MARINE.xml");
        }
        return this.alarmTL1Data;
    }

    public HashMap getTL1NMAlmData() {
        return this.alarmNMTl1Data;
    }

    public ArrayList getAlarmParaList() {
        return this.alarmParaList;
    }
}

