/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.integrateexplorer.TEInterNEExplorerBean;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEAbstractImpl;
import com.huawei.nglct.nelist.TENEAlarmAnalyse;
import com.huawei.nglct.nelist.TENECommMgrFacade;
import com.huawei.nglct.nelist.TESubrack;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNEIDList;
import com.huawei.nglct.nemgr.f_interface.dcn.AsnCommuGetNeDataCondReq;
import com.huawei.nglct.nemgr.f_interface.dcn.AsnCommuGetNeDataCondRsp;
import com.huawei.nglct.nemgr.f_interface.dcn.AsnCommuNeData;
import com.huawei.nglct.po.TESubrackTypes;
import com.huawei.nglct.po.embeddednemgrmo.TEAsonNodeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.TECommuNeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.TEEthGneMOPO;
import com.huawei.nglct.po.embeddednemgrmo.TENASubrackContainerMOPO;
import com.huawei.nglct.po.embeddednemgrmo.TENASubrackMOPO;
import com.huawei.nglct.po.embeddednemgrmo.TENEMOPO;
import com.huawei.nglct.po.embeddednemgrmo.TESubrackMOPO;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TEDesEnc;
import com.huawei.nglct.security.TESecurityVerify;
import com.huawei.nglct.util.convertor.IPAddressUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEStringUtils;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TENEInterImpl
extends TENEAbstractImpl {
    private static final int NE_TYPE_RTN980 = 1978;
    private static final int ST_MetroR001 = 16;
    private static final int TECMDCODE_COMMU_GET_NE_DATA = 2121737;
    private static Logger normalLoger = TELogFactory.getNormalLogger();
    private static Logger embededWnemgrlog = TELogFactory.getembededWnemgrLogger();
    private static final int TL1NEID_MASK = 0x4000000;
    private int neID = -1;
    private int phyNEID = -1;
    private int phyNEType = -1;
    private String neName = null;
    protected String nodeID = "0";
    private String neGlobalSign = "0";
    private int neDatacfgStatus = 255;
    protected int logStatus = 0;
    protected String neIP = null;
    protected String nePort = null;
    public TENEAlarmAnalyse alarmAnalyse = new TENEAlarmAnalyse();
    private String neVersion;
    private TEEthGneMOPO currentConGne = null;

    public TENEInterImpl(int neID) {
        this.neID = neID;
    }

    @Override
    public int getShelfType() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            if (ne.getType() == 1978) {
                short nmType = ne.getShelfType();
                return this.shelfTypeE2Q(nmType);
            }
            return ne.getShelfType();
        }
        normalLoger.error("The JNI ne is invalid!");
        return -1;
    }

    private int shelfTypeE2Q(int nmType) {
        int qx = nmType - 16 + 1;
        return qx;
    }

    @Override
    public void setShelfType(int shelfType) {
    }

    @Override
    public final String getNeName() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            if (ne.getName() == null || ne.getName().isEmpty()) {
                normalLoger.error("Can not find neName From JNI. Use Local neName = " + this.neName);
                return this.neName;
            }
            return ne.getName();
        }
        normalLoger.error("The JNI ne is invalid!");
        return this.neName;
    }

    @Override
    public void setNeName(String neName) {
        this.neName = neName;
    }

    @Override
    public final String getDeviceType() {
        return TEEquipmentDescription.getInstance().getDeviceTypeName(this.phyNEType);
    }

    @Override
    public void setDeviceType(String deviceType) {
    }

    @Override
    public int getNeGateWay() {
        return TENECommMgr.getInstance().getNEGateWay((long)this.neID);
    }

    @Override
    public void setNeGateWay(int neGateWay) {
    }

    @Override
    public int getNeGWType() {
        TECommInfo cin = TENECommMgr.getInstance().getCommInfo(this.neID);
        if (cin == null) {
            normalLoger.error("can not get TECommInfo ,neID is " + this.neID);
            return -1;
        }
        return cin.getCommType();
    }

    @Override
    public void setNeGWType(int neGWType) {
    }

    @Override
    public String getNeGWAddress() {
        TECommInfo cin = TENECommMgr.getInstance().getCommInfo(this.neID);
        if (cin == null) {
            normalLoger.error("can not get TECommInfo ,neID is " + this.neID);
            return "-1";
        }
        return cin.getAddress();
    }

    @Override
    public void setNeGWAddress(String neGWAddress) {
    }

    @Override
    public Vector getLastQueryAlarmList() {
        return null;
    }

    @Override
    public void setLastQueryAlarmList(Vector lastQueryAlarmList) {
    }

    @Override
    public Vector getLastQueryHisAlarmList() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            return null;
        }
        normalLoger.error("The JNI ne is invalid!");
        return null;
    }

    @Override
    public void setLastQueryHisAlarmList(Vector lastQueryHisAlarmList) {
    }

    @Override
    public String getNeIp() {
        TEEthGneMOPO ne = this.getTEEthGne();
        if (null != ne) {
            String neip = IPAddressUtil.convertIPLongToStr(ne.getIp());
            embededWnemgrlog.info("Get ne ip:" + neip);
            return neip;
        }
        embededWnemgrlog.error("The JNI ne is invalid!");
        return null;
    }

    @Override
    public void setNeIp(String neIp) {
        this.neIP = neIp;
    }

    @Override
    public String getPort() {
        TECommInfo cin = TENECommMgr.getInstance().getCommInfo(this.neID);
        if (cin == null) {
            normalLoger.error("can not get TECommInfo ,neID is " + this.neID);
            return "-1";
        }
        return String.valueOf(cin.getPort());
    }

    @Override
    public String getNePort() {
        if (this.nePort != null) {
            return this.nePort;
        }
        TEEthGneMOPO ne = this.getTEEthGne();
        if (null != ne) {
            embededWnemgrlog.info("Get ne port:" + ne.getPort());
            return String.valueOf(ne.getPort());
        }
        embededWnemgrlog.error("The JNI ne is invalid!");
        return "1400";
    }

    @Override
    public void setPort(String port) {
    }

    @Override
    public String getBaudRate() {
        TECommInfo cin = TENECommMgr.getInstance().getCommInfo(this.neID);
        if (cin == null) {
            normalLoger.error("can not get TECommInfo ,neID is " + this.neID);
            return "-1";
        }
        return cin.getParamValue("baudrate");
    }

    @Override
    public void setBaudRate(String baudRate) {
    }

    @Override
    public int getCommunicateStatus() {
        return 1;
    }

    @Override
    public void setCommunicateStatus(int communicateStatus) {
    }

    @Override
    public int getLogStatus() {
        return this.logStatus;
    }

    @Override
    public void setLogStatus(int logStatus) {
        this.logStatus = logStatus;
    }

    @Override
    public String getDevPkgVersion() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            return null;
        }
        normalLoger.error("The JNI ne is invalid!");
        return null;
    }

    @Override
    public void setDevPkgVersion(String devPkgVersion) {
    }

    @Override
    public int getNeVersion() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            return (int)ne.getVersion();
        }
        normalLoger.error("The JNI ne is invalid!");
        return -1;
    }

    @Override
    public void setNeVersion(int neVersion) {
    }

    @Override
    public String getHostVersion() {
        if (this.neVersion == null || this.neVersion.isEmpty()) {
            int neVer = this.getNeVersion();
            this.neVersion = TEConvertUtil.neVersionToString(neVer);
        }
        return this.neVersion;
    }

    @Override
    public void setHostVersion(String hostVersion) {
    }

    @Override
    public String getShowNEVersion() {
        return this.getHostVersion();
    }

    @Override
    public void setShowNEVersion(String showNEVersion) {
        this.neVersion = showNEVersion;
    }

    @Override
    public String getNeGlobalSign() {
        return this.neGlobalSign;
    }

    @Override
    public void setNeGlobalSign(String neGlobalSign) {
        this.neGlobalSign = neGlobalSign;
    }

    @Override
    public String getNeState() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            return null;
        }
        normalLoger.error("The JNI ne is invalid!");
        return null;
    }

    @Override
    public void setNeState(String neState) {
    }

    @Override
    public final String getCurUser() {
        String curUser = null;
        TECommuNeMOPO ne = this.getTECommuNe();
        if (null != ne) {
            curUser = ne.getNEUser();
        } else {
            normalLoger.error("The JNI ne is invalid!");
            curUser = null;
        }
        return curUser;
    }

    @Override
    public void setCurUser(String curUser) {
    }

    @Override
    public byte[] getCurUserPassword() {
        TECommuNeMOPO ne = this.getTECommuNe();
        if (null != ne) {
            String pwd = ne.getEncryptPassword();
            char[] charPwd = EncryptUtils.decryptAESStr2Char(pwd);
            byte[] userPassword = EncryptUtils.decodePlainText(charPwd);
            userPassword = IOStreamConvertor.removeByteZero(userPassword);
            EncryptUtils.clearChar(charPwd);
            return userPassword;
        }
        normalLoger.error("The JNI ne is invalid!");
        return null;
    }

    @Override
    public void setCurUserPassword(byte[] curUserPassword) {
    }

    @Override
    @Deprecated
    public byte[] getEncryUser() {
        return null;
    }

    @Override
    @Deprecated
    public void setEncryUser(byte[] encryUser) {
    }

    @Override
    @Deprecated
    public byte[] getEncryPassword() {
        return null;
    }

    @Override
    @Deprecated
    public void setEncryPassword(byte[] encryPassword) {
    }

    @Override
    public String getNodeID() {
        return this.nodeID;
    }

    @Override
    public void setNodeID(String nodeID) {
        this.nodeID = nodeID;
    }

    public TENE.LoginEventNoticeHandler getLoginNoticeHandler() {
        return null;
    }

    public void setLoginNoticeHandler(TENE.LoginEventNoticeHandler loginNoticeHandler) {
    }

    public TENE.LogoutEventNoticeHandler getLogoutNoticeHandler() {
        return null;
    }

    public void setLogoutNoticeHandler(TENE.LogoutEventNoticeHandler logoutNoticeHandler) {
    }

    @Override
    public Timer getBoardTimer() {
        return null;
    }

    @Override
    public void setBoardTimer(Timer boardTimer) {
    }

    @Override
    public TimerTask getBoardTimerTask() {
        return null;
    }

    @Override
    public void setBoardTimerTask(TimerTask boardTimerTask) {
    }

    @Override
    public boolean isSchedule() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            return ne.getAutoSync() == 1;
        }
        normalLoger.error("The JNI ne is invalid!");
        return false;
    }

    @Override
    public void setSchedule(boolean isSchedule) {
    }

    @Override
    public boolean isBoardUpdateFlag() {
        return false;
    }

    @Override
    public void setBoardUpdateFlag(boolean boardUpdateFlag) {
    }

    @Override
    public boolean isPreConfig() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            return ne.isPreConfig();
        }
        normalLoger.error("The JNI ne is invalid!");
        return false;
    }

    @Override
    public void setPreConfig(boolean preConfig) {
    }

    @Override
    public int getConfiged() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            return ne.getConfigState();
        }
        normalLoger.error("The JNI ne is invalid!");
        return -1;
    }

    @Override
    public void setConfiged(int configed) {
    }

    public final int getPhyID() {
        return this.phyNEID;
    }

    @Override
    public void setPhyID(int phyID) {
        this.phyNEID = phyID;
    }

    @Override
    public TENEAlarmAnalyse getAlarmAnalyse() {
        return this.alarmAnalyse;
    }

    @Override
    public void setAlarmAnalyse(TENEAlarmAnalyse alarmAnalyse) {
        this.alarmAnalyse = alarmAnalyse;
    }

    @Override
    public boolean isAlarmChanged() {
        return false;
    }

    @Override
    public void setAlarmChanged(boolean alarmChanged) {
    }

    @Override
    public Vector getThrshDataList() {
        return null;
    }

    @Override
    public void setThrshDataList(Vector thrshDataList) {
    }

    @Override
    public int getIsTL1OrQX() {
        int phyID = this.getRealNEID();
        if (0 != (phyID & 0x4000000)) {
            return 1;
        }
        return 0;
    }

    @Override
    public void setIsTL1OrQX(int isTL1OrQX) {
    }

    @Override
    public int getNeType() {
        return this.phyNEType;
    }

    @Override
    public void setNeType(int neType) {
        this.phyNEType = neType;
    }

    @Override
    public final int getRealNEID() {
        return this.phyNEID;
    }

    @Override
    public void setRealNEID(int realNEID) {
        this.phyNEID = realNEID;
    }

    @Override
    public Object clone() {
        try {
            TENEInterImpl obj = (TENEInterImpl)this.getClass().newInstance();
            return obj;
        }
        catch (Exception e) {
            throw new InternalError();
        }
    }

    @Override
    public int getNeID() {
        return this.neID;
    }

    @Override
    public String getTimeZome() {
        return null;
    }

    @Override
    public void setNeID(int neID) {
        this.neID = neID;
    }

    @Override
    public void setTimeZome(String timeZome) {
    }

    @Override
    public int getTERMINAL_TYPE() {
        boolean EMS_TERMINAL_TYPE = true;
        return 1;
    }

    @Override
    public void setTERMINAL_TYPE(int terminal_type) {
    }

    @Override
    public int getAlarmChangeCount() {
        return 0;
    }

    @Override
    public int getONeID() {
        return 0;
    }

    @Override
    public boolean isServerOrClient() {
        return false;
    }

    @Override
    public boolean isSupportGlobal() {
        return false;
    }

    @Override
    public void setAlarmChangeCount(int alarmChangeCount) {
    }

    @Override
    public void setONeID(int neID) {
    }

    @Override
    public void setServerOrClient(boolean serverOrClient) {
    }

    @Override
    public void setSupportGlobal(boolean isSupportGlobal) {
    }

    public TENEMOPO getTENEPO() {
        TENEMOPO ne = null;
        TEDaoOperationResult drb = null;
        try {
            drb = this.isDataCfgStausNeedLock() ? TECommonDaoService.findNE(new int[]{this.neID}) : TECommonDaoService.findNE_NonLock(new int[]{this.neID});
            ne = (TENEMOPO)drb.getData().get(0);
            int result = drb.getResult();
            if (0 != result) {
                embededWnemgrlog.error("Get TENEMOPO fail! result is: " + result);
                embededWnemgrlog.error(this.getTENEMOPOMessage(ne));
            }
            return ne;
        }
        catch (Exception e1) {
            embededWnemgrlog.error("Get TENEMOPO fail: " + e1.getMessage());
            return null;
        }
    }

    private String getTENEMOPOMessage(TENEMOPO ne) {
        StringBuffer sbNeMO = new StringBuffer();
        if (null == ne) {
            sbNeMO.append("The ne is null!");
        } else {
            sbNeMO.append("getCid is: ").append(ne.getCid()).append("\n");
            sbNeMO.append("getOid is: ").append(ne.getOid()).append("\n");
            sbNeMO.append("getName is: ").append(ne.getName()).append("\n");
            sbNeMO.append("getMemo is: ").append(ne.getMemo()).append("\n");
            sbNeMO.append("getType is: ").append(ne.getType()).append("\n");
            sbNeMO.append("getUserLabel is: ").append(ne.getUserLabel()).append("\n");
            sbNeMO.append("getOwner is: ").append(ne.getOwner()).append("\n");
            sbNeMO.append("getNEID is: ").append(ne.getNEID()).append("\n");
            sbNeMO.append("getPhyID is: ").append(ne.getPhyID()).append("\n");
            sbNeMO.append("getVersion is: ").append(ne.getVersion()).append("\n");
            sbNeMO.append("getAutoSync is: ").append(ne.getAutoSync()).append("\n");
            sbNeMO.append("getSyncNumber is: ").append(ne.getSyncNumber()).append("\n");
            sbNeMO.append("getEnableIntelligence is: ").append(ne.getEnableIntelligence()).append("\n");
            sbNeMO.append("getPreConfig is: ").append(ne.getPreConfig()).append("\n");
            sbNeMO.append("getConfigState is: ").append(ne.getConfigState()).append("\n");
            sbNeMO.append("getLastDBCHGSEQ is: ").append(ne.getLastDBCHGSEQ()).append("\n");
            sbNeMO.append("getLastSyncTime is: ").append(ne.getLastSyncTime()).append("\n");
            sbNeMO.append("getBuildTime is: ").append(ne.getBuildTime()).append("\n");
            sbNeMO.append("getPfmMonitor15m is: ").append(ne.getPfmMonitor15m()).append("\n");
            sbNeMO.append("getPfmMonNeverStop15m is: ").append(ne.getPfmMonNeverStop15m()).append("\n");
            sbNeMO.append("getPfmMonitor24h is: ").append(ne.getPfmMonitor24h()).append("\n");
            sbNeMO.append("getPfmMonNeverStop24h is: ").append(ne.getPfmMonNeverStop24h()).append("\n");
            sbNeMO.append("getPfmMonStartTime24h is: ").append(ne.getPfmMonStartTime24h()).append("\n");
            sbNeMO.append("getPfmMonEndTime24h is: ").append(ne.getPfmMonEndTime24h()).append("\n");
            sbNeMO.append("getNE_ATTRIB_TimeDivision is: ").append(ne.getNE_ATTRIB_TimeDivision()).append("\n");
            sbNeMO.append("getShelfType is: ").append(ne.getShelfType()).append("\n");
            sbNeMO.append("getSCBMode is: ").append(ne.getSCBMode()).append("\n");
            sbNeMO.append("getVRCBVer is: ").append(ne.getVRCBVer()).append("\n");
            sbNeMO.append("getPatchVerList is: ").append(ne.getPatchVerList()).append("\n");
            sbNeMO.append("getCodeSet is: ").append(ne.getCodeSet()).append("\n");
            sbNeMO.append("getRackType is: ").append(ne.getRackType()).append("\n");
        }
        return sbNeMO.toString();
    }

    private TEEthGneMOPO getTEEthGne() {
        TEEthGneMOPO ne = null;
        try {
            List<Object> gneList = this.isDataCfgStausNeedLock() ? TECommonDaoService.findAll(TEEthGneMOPO.class).getData() : TECommonDaoService.findAll_NonLock(TEEthGneMOPO.class).getData();
            for (int i = 0; i < gneList.size(); ++i) {
                ne = (TEEthGneMOPO)gneList.get(i);
                if (ne.getLogicNeId() != (long)this.getNeID()) continue;
                return ne;
            }
            return null;
        }
        catch (Exception e1) {
            embededWnemgrlog.error("Get TEEthGneMOPO fail: " + e1.getMessage());
            return null;
        }
    }

    private TEEthGneMOPO getTEEthGne(long phyID) {
        TEEthGneMOPO ne = null;
        try {
            List<Object> gneList = this.isDataCfgStausNeedLock() ? TECommonDaoService.findAll(TEEthGneMOPO.class).getData() : TECommonDaoService.findAll_NonLock(TEEthGneMOPO.class).getData();
            for (int i = 0; i < gneList.size(); ++i) {
                ne = (TEEthGneMOPO)gneList.get(i);
                if (ne.getNeId() != phyID) continue;
                return ne;
            }
            return null;
        }
        catch (Exception e1) {
            embededWnemgrlog.error("Get TEEthGneMOPO fail: " + e1.getMessage());
            return null;
        }
    }

    private TECommuNeMOPO getTECommuNe() {
        TEDaoOperationResult drb = null;
        ArrayList<TEDaoNameValuePair> cr = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair p = new TEDaoNameValuePair();
        p.setName("LogicNeId");
        p.setValue(String.valueOf(this.neID));
        cr.add(p);
        TECommuNeMOPO ne = null;
        try {
            drb = this.isDataCfgStausNeedLock() ? TECommonDaoService.findByID(TECommuNeMOPO.class, cr) : TECommonDaoService.findByID_NonLock(TECommuNeMOPO.class, cr);
            if (drb.getResult() == 0) {
                if (!drb.getData().isEmpty()) {
                    ne = (TECommuNeMOPO)drb.getData().get(0);
                    embededWnemgrlog.info("Get TECommuNeMOPO sucess:" + ne.toString());
                } else {
                    embededWnemgrlog.info("Cannot get TECommuNeMOPO for neID=" + this.neID);
                    return null;
                }
            }
            return ne;
        }
        catch (Exception e1) {
            embededWnemgrlog.error("Get TECommuNeMOPO fail: " + e1.getMessage());
            return null;
        }
    }

    public Vector getPhyBoardList() {
        Vector newPhyBoardList = new Vector();
        Operation oper = TECreateObjectFactory.getOperation(this.getNeID(), "NSCMD_CFG_GET_PHY_BD");
        ArrayList<Object> operationList = new ArrayList<Object>();
        operationList.add(oper.clone());
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.getNeID(), operationList, 10);
        if (0 == result.retCode) {
            this.handlePHYBDQuery(operationList, newPhyBoardList);
        } else {
            TELogFactory.getNormalLogger().info("query board fail,the errorCode is " + result.retCode);
        }
        return newPhyBoardList;
    }

    private void handlePHYBDQuery(List operationList, Vector newPhyBoardList) {
        int slotID = -1;
        int boardType = -1;
        Operation oper = (Operation)operationList.get(0);
        if (oper == null) {
            return;
        }
        for (Output output : oper.getOutput()) {
            if (!output.getFault()[0].getCode().equals("0") || null == output.getPart(1) || null == output.getPart(1).getValue() || output.getPart(1).getValue().equals("0")) continue;
            for (Part part : output.getPart()) {
                String name = part.getName();
                String value = part.getValue();
                if (name.equals("slotID") && value != null) {
                    slotID = Integer.parseInt(value);
                    continue;
                }
                if (!name.equals("boardType") || value == null) continue;
                boardType = Integer.parseInt(value);
            }
            TEBoard board = new TEBoard(this.getNeID(), slotID, boardType);
            newPhyBoardList.add(board);
        }
    }

    protected Vector getSubrackListQxImpl() {
        Vector<TESubrack> subrackList = new Vector<TESubrack>();
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            Set subrackVec = ne.getSubrackVec();
            String subrackID = null;
            String subrackType = null;
            String subrackName = null;
            TESubrackMOPO subrackMO = null;
            TESubrack tempSubrack = null;
            for (Object obj : subrackVec) {
                subrackMO = (TESubrackMOPO)obj;
                subrackID = String.valueOf(subrackMO.getSubrackID());
                subrackType = TESubrackTypes.getInstance().getSubrackType(subrackMO.getSubrackType());
                subrackName = subrackMO.getSubrackName();
                tempSubrack = new TESubrack(subrackID, subrackType, subrackName);
                tempSubrack.setCrossMode(subrackMO.getSubrackXCMode());
                subrackList.add(tempSubrack);
            }
        } else {
            normalLoger.error("The JNI ne is invalid!");
        }
        return subrackList;
    }

    protected Vector getSubrackListTL1Impl() {
        Vector<TESubrack> subrackList = new Vector<TESubrack>();
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = this.isDataCfgStausNeedLock() ? TECommonDaoService.findAll(new int[]{this.getNeID()}, TENASubrackContainerMOPO.class) : TECommonDaoService.findAll_NonLock(new int[]{this.getNeID()}, TENASubrackContainerMOPO.class);
        }
        catch (Exception e) {
            normalLoger.error("Get date from db error.", (Throwable)e);
        }
        if (null != dbResult) {
            int result = dbResult.getResult();
            if (0 == result) {
                List<Object> data = dbResult.getData();
                String subrackID = null;
                String subrackType = null;
                String subrackName = null;
                String subrackFIC = null;
                TENASubrackContainerMOPO subrackContainer = null;
                TENASubrackMOPO subrackMO = null;
                TESubrack tempSubrack = null;
                Set<TENASubrackMOPO> subrackVec = null;
                for (Object containerObj : data) {
                    subrackContainer = (TENASubrackContainerMOPO)containerObj;
                    if (null == subrackContainer) continue;
                    subrackVec = subrackContainer.getSubrackVec();
                    Iterator<TENASubrackMOPO> i$ = subrackVec.iterator();
                    while (i$.hasNext()) {
                        TENASubrackMOPO subrackObj;
                        subrackMO = subrackObj = i$.next();
                        subrackID = String.valueOf(subrackMO.getSubrackID());
                        subrackType = TESubrackTypes.getInstance().getSubrackType(subrackMO.getSubrackType());
                        subrackName = subrackMO.getSubrackName();
                        subrackFIC = subrackMO.getSubrackFIC();
                        tempSubrack = new TESubrack(subrackID, subrackType, subrackName);
                        tempSubrack.setFicInfo(subrackFIC);
                        subrackList.add(tempSubrack);
                    }
                }
            }
        } else {
            normalLoger.error("The JNI ne is invalid!");
        }
        return subrackList;
    }

    public void queryNodeID() {
        TEDaoOperationResult drb = null;
        TEAsonNodeMOPO asonNode = null;
        try {
            drb = this.isDataCfgStausNeedLock() ? TECommonDaoService.findByID(new int[]{this.neID}, TEAsonNodeMOPO.class, null) : TECommonDaoService.findByID_NonLock(new int[]{this.neID}, TEAsonNodeMOPO.class, null);
            if (drb.getResult() == 0) {
                if (!drb.getData().isEmpty()) {
                    asonNode = (TEAsonNodeMOPO)drb.getData().get(0);
                    embededWnemgrlog.info("Get ason nodeID:" + asonNode.getNodeID() + " from MO ");
                    this.nodeID = TEStringUtils.convertStringToProtolType(Integer.toHexString((int)asonNode.getNodeID()), 8);
                } else {
                    embededWnemgrlog.info("Get ason Node MO is empty ");
                    this.nodeID = "";
                }
            }
        }
        catch (Exception e1) {
            embededWnemgrlog.error("Get TEAsonNodeMOPO fail: " + e1.getMessage());
            this.nodeID = "";
        }
    }

    @Override
    public int getNeDatacfgStatus() {
        return this.neDatacfgStatus;
    }

    @Override
    public void setNeDatacfgStatus(int neDatacfgStatus) {
        TELogFactory.getNormalLogger().info("Set ne data cfg status. neID->" + this.neID + " Old neDatacfgStatus->" + this.neDatacfgStatus);
        this.neDatacfgStatus = neDatacfgStatus;
        TELogFactory.getNormalLogger().info("Set ne data cfg status. neID->" + this.neID + " New neDatacfgStatus->" + neDatacfgStatus);
    }

    @Override
    public boolean isDataCfgStausNeedLock() {
        return 255 == this.getNeDatacfgStatus();
    }

    @Override
    public short getASONFeatureState() {
        TENEMOPO ne = this.getTENEPO();
        if (null != ne) {
            return ne.getEnableIntelligence();
        }
        normalLoger.error("The JNI ne is invalid!");
        return -1;
    }

    @Override
    public int login(String userName, byte[] userPassword, int forceLogin) {
        this.setTERMINAL_TYPE(1);
        this.setCurUser(userName);
        this.setCurUserPassword(userPassword);
        TEDesEnc des = new TEDesEnc();
        byte[] inUser = new byte[16];
        byte[] inPsw = new byte[16];
        byte[] encUserByte = new byte[16];
        byte[] encPasswordByte = new byte[16];
        try {
            des.init(TEDesEnc.ENCRYPT_MODE, "OSPV1R10".getBytes());
            if (userName != "" && userName != null && !userName.equals("")) {
                System.arraycopy(userName.getBytes(), 0, inUser, 0, userName.getBytes().length);
                des.deNCBCEncrypt(userName.getBytes(), "OSPV1R10".getBytes(), 0, inUser, 16, encUserByte);
            }
            if (userPassword != null && userPassword.length > 0) {
                System.arraycopy(userPassword, 0, inPsw, 0, userPassword.length);
                des.deNCBCEncrypt("OSPV1R10".getBytes(), "OSPV1R10".getBytes(), 0, inPsw, 16, encPasswordByte);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
        ArrayList<Object> operationList2 = new ArrayList<Object>();
        int retCode = 1090650120;
        try {
            Input input2;
            long neVersion = this.getNeVersion();
            boolean encryLogin = false;
            if (neVersion >= 87229204L && neVersion <= 0x5336363L || neVersion >= 87294740L && neVersion <= 87319395L || neVersion >= 88277258L && neVersion <= 88302435L) {
                encryLogin = true;
            }
            Operation oper2 = null;
            TELogFactory.getNormalLogger().debug("TENE.login().encryLogin is:" + encryLogin);
            if (encryLogin) {
                oper2 = TECreateObjectFactory.getOperation(QX_DES_PATH, "NSCMD_SM_LOGIN_NEW_V01_ENCRY");
                input2 = oper2.getInput();
                for (Part part : input2.getPart()) {
                    if (part.getName().equals("terminalType")) {
                        part.setValue(String.valueOf(this.getTERMINAL_TYPE()));
                        continue;
                    }
                    if (part.getName().equals("userName")) {
                        part.setValue(IOStreamConvertor.hexChangToString(encUserByte));
                        continue;
                    }
                    if (!part.getName().equals("userPassword")) continue;
                    part.setValue(IOStreamConvertor.hexChangToString(encPasswordByte));
                }
            } else {
                oper2 = TECreateObjectFactory.getOperation(QX_DES_PATH, "ForceLoginNEV01");
                input2 = oper2.getInput();
                for (Part part : input2.getPart()) {
                    if (part.getName().equals("terminalType")) {
                        part.setValue(String.valueOf(this.getTERMINAL_TYPE()));
                        continue;
                    }
                    if (part.getName().equals("userName")) {
                        part.setValue(userName);
                        continue;
                    }
                    if (!part.getName().equals("userPassword")) continue;
                    part.setValue(EncryptUtils.encryptAESByte2Str(userPassword));
                }
            }
            operationList2.add(oper2.clone());
            OperationResult result = TENECommMgrFacade.getInstance().sendCommand(this.neID, operationList2, 10);
            TELogFactory.getNormalLogger().debug("TENE.login().result is:" + result.retCode);
            if (result.retCode != 0) {
                return result.retCode;
            }
            int size = operationList2.size();
            for (int i = 0; i < size; ++i) {
                Operation operation = (Operation)operationList2.get(i);
                for (Output output : operation.getOutput()) {
                    for (Fault fault : output.getFault()) {
                        String code = fault.getCode();
                        if (code.equals("0")) {
                            this.setLogStatus(1);
                            TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot(this.neID, Integer.parseInt(code)));
                        } else {
                            TELogFactory.getNormalLogger().error("Login ne error code is " + code + ",user name is " + userName);
                            this.setLogStatus(0);
                        }
                        retCode = Integer.parseInt(code);
                    }
                }
            }
            this.getNECharsetFromMO();
            userPassword = null;
            return retCode;
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("login ne failed", (Throwable)ex);
            return 1090646019;
        }
    }

    public void getNECharsetFromMO() {
        short charset = this.getTENEPO().getCodeSet();
        this.setNeGlobalSign(String.valueOf(charset - 1));
        TENECommMgr.getInstance().putCharset((long)this.neID, TENE.convertNECharset(String.valueOf(charset - 1)));
    }

    @Override
    public boolean isAutoLoginNE() {
        return false;
    }

    @Override
    public void setAutoLoginNE(boolean autoLoginNE) {
    }

    @Override
    public int loginWithSetStatusFlag(String userName, byte[] userPassword, int forceLogin, boolean isSetStatus) {
        return 0;
    }

    @Override
    public Vector getAlarmList() {
        return null;
    }

    @Override
    public HashMap getAlmDataMap() {
        return null;
    }

    @Override
    public void setAlarmList(Vector alarmList) {
    }

    @Override
    public void setAlmDataMap(HashMap almDataMap) {
    }

    @Override
    public String getGateNeIp() {
        TECommuNeMOPO commuNe = this.getTECommuNe();
        if (commuNe == null) {
            embededWnemgrlog.info("Get TECommuNeMOPO failed, LogicNeId=" + this.neID);
            return "";
        }
        long curNeID = this.getActiveNeID(this.neID, commuNe);
        this.currentConGne = this.getTEEthGne(curNeID);
        if (this.currentConGne != null) {
            String neip = IPAddressUtil.convertIPLongToStr(this.currentConGne.getIp());
            embededWnemgrlog.info("Get NE Gate IP,neid->:" + this.neID + ",IP=" + neip);
            return neip;
        }
        embededWnemgrlog.info("Get TEEthGneMOPO faield: neID=" + commuNe.getNeId());
        return "";
    }

    @Override
    public String getGatePort() {
        if (this.currentConGne != null) {
            String port = String.valueOf(this.currentConGne.getPort());
            embededWnemgrlog.info("Get NE Gate Port,neid->:" + this.neID + ",Port=" + port);
            return port;
        }
        TECommuNeMOPO commuNe = this.getTECommuNe();
        if (commuNe == null) {
            embededWnemgrlog.info("Get TECommuNeMOPO failed, LogicNeId=" + this.neID);
            return "";
        }
        long curNeID = this.getActiveNeID(this.neID, commuNe);
        TEEthGneMOPO ne = this.getTEEthGne(curNeID);
        if (ne != null) {
            String port = String.valueOf(ne.getPort());
            embededWnemgrlog.info("Get NE Gate Port,neid->:" + this.neID + ",Port=" + port);
            return port;
        }
        embededWnemgrlog.info("Get TEEthGneMOPO faield: neID=" + commuNe.getNeId());
        return "";
    }

    private long getActiveNeID(int neID, TECommuNeMOPO commuNe) {
        long activeNeID = 0L;
        int neGneState = 0;
        AsnNEIDList asnNEIDList = TENEInterImpl.getAsnNEIDList(new int[]{neID});
        AsnCommuGetNeDataCondReq req = new AsnCommuGetNeDataCondReq();
        req.neIdList = asnNEIDList;
        req.userId = BigInteger.valueOf(TESecurityVerify.getSuperUserID());
        AsnCommuGetNeDataCondRsp rsp = new AsnCommuGetNeDataCondRsp();
        int result = new TEInterNEExplorerBean(){

            @Override
            public Datainterface sendAsnMsg() {
                return null;
            }
        }.sendCommand(neID, (FStruct)req, (FStruct)rsp, 2121737);
        if (result != 0 || rsp.neDataList.isEmpty()) {
            neGneState = 0;
        } else {
            AsnCommuNeData asnCommuNeData = (AsnCommuNeData)rsp.neDataList.elementAt(0);
            neGneState = asnCommuNeData.neGneState.value;
        }
        switch (neGneState) {
            case 1: {
                activeNeID = commuNe.getBackup1GneId();
                break;
            }
            case 2: {
                activeNeID = commuNe.getBackup2GneId();
                break;
            }
            case 3: {
                activeNeID = commuNe.getBackup3GneId();
                break;
            }
            case 4: {
                activeNeID = 0L;
                break;
            }
            default: {
                activeNeID = commuNe.getMainGneId();
            }
        }
        return activeNeID;
    }

    private static AsnNEIDList getAsnNEIDList(int[] intArray) {
        AsnNEIDList asnNEIDList = new AsnNEIDList();
        if (intArray == null || intArray.length == 0) {
            return asnNEIDList;
        }
        for (int i = 0; i < intArray.length; ++i) {
            asnNEIDList.add(intArray[i]);
        }
        return asnNEIDList;
    }
}

