/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TENEDataBackupToCF
implements TENEListInterface {
    private static final String UNKNOWN = "UNKNOWN";
    private Datainterface outputData = null;
    private int failedNeCount = 0;
    private static final int TIME_OUT = 600;

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        this.outputData = new Datainterface();
        BussinessParams returnBParams = new BussinessParams();
        try {
            ArrayList operationList = this.getOperationList(inputData);
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            Operation tempOperation = null;
            int timeout = 600;
            Datainterface outputTmp = null;
            for (int i = 0; i < rParams.length; ++i) {
                ArrayList<Operation> tempList = new ArrayList<Operation>();
                String neid = rParams[i].getParam("neid").getValue();
                for (int j = operationList.size() - 1; j >= 0; --j) {
                    tempOperation = (Operation)operationList.get(j);
                    Part tempPart = new Part();
                    tempPart.setName("neid");
                    tempPart.setValue(neid);
                    tempPart.setType("int");
                    if (!neid.equals(tempOperation.getInput().getPartValue("neid"))) continue;
                    operationList.remove(tempOperation);
                    tempOperation.getInput().removePart(tempPart);
                    tempList.add(tempOperation);
                }
                if (tempList.isEmpty()) continue;
                OperationResult oper = TECommuNEMgr.getInstance().sendCommand(Integer.parseInt(neid), tempList, timeout, subFunc);
                if (oper.retCode == 0) {
                    outputTmp = TEDataConverter.convertToDatainterface(Integer.parseInt(neid), subFunc, tempList);
                    if (!outputTmp.getErrorMessage().getErrorcode().equals("2")) continue;
                    for (int m = 0; m < outputTmp.getBussinessParams().getRowParamsCount(); ++m) {
                        returnBParams.addRowParams(outputTmp.getBussinessParams().getRowParams(m));
                    }
                    ++this.failedNeCount;
                    continue;
                }
                String neName = UNKNOWN;
                TENE ne = TENEListMgr.getInstance().getNE(Integer.parseInt(neid));
                if (null != ne) {
                    neName = ne.getNEName();
                }
                RowParams rowParams = new RowParams();
                rowParams.addParam(new Param("neid", neid));
                rowParams.addParam(new Param("nename", neName));
                RowErrors rowError = new RowErrors();
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage(oper.retCode));
                rowError.addParam(new Param("neid", neid));
                rowError.addParam(new Param("nename", neName));
                rowParams.addRowErrors(rowError);
                returnBParams.addRowParams(rowParams);
                ++this.failedNeCount;
            }
            ErrorMessage bigErr = this.failedNeCount == 0 ? TEErrorResourceUtil.getErrorMessage(0) : (this.failedNeCount == rParams.length ? TEErrorResourceUtil.getErrorMessage(2) : TEErrorResourceUtil.getErrorMessage(1));
            this.outputData.setBussinessParams(returnBParams);
            this.outputData.setErrorMessage(bigErr);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TENEDataBackupToCF.subFuncProcessed() fail!", (Throwable)ex);
        }
        return this.outputData;
    }

    private ArrayList getOperationList(Datainterface inputData) {
        ArrayList<Object> operList = new ArrayList<Object>();
        Operation operation = TECreateObjectFactory.getOperation("NSCMD_PE_BACKUP_DATA_WEX");
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        Input input = operation.getInput();
        String slotid = "0";
        String neid = "0";
        for (int i = rows.length - 1; i >= 0; --i) {
            slotid = rows[i].getParam("slotid").getValue();
            if (slotid.equalsIgnoreCase("0")) {
                input.setPartValue("datatype", "2");
            } else {
                input.setPartValue("datatype", "0");
            }
            input.setPartValue("slotid", slotid);
            neid = rows[i].getParam("neid").getValue();
            Part vPart = new Part();
            vPart.setName("neid");
            vPart.setValue(neid);
            vPart.setType("int");
            input.addPart(vPart);
            operList.add(operation.clone());
            input.removePart(vPart);
        }
        return operList;
    }

    static class TESendCommandAsyn
    implements Runnable {
        int neID = -1;
        ArrayList<Operation> operationListOfThread = new ArrayList();
        int timeout = 20;
        SubFunc subFunc = null;

        public TESendCommandAsyn(int neid, ArrayList<Operation> operList, int timeout, SubFunc subFunc) {
            this.neID = neid;
            this.operationListOfThread = operList;
            this.timeout = timeout;
            this.subFunc = subFunc;
        }

        @Override
        public void run() {
            if (this.operationListOfThread.size() == 0) {
                return;
            }
            OperationResult result = TECommuNEMgr.getInstance().sendCommand(this.neID, this.operationListOfThread, this.timeout, this.subFunc);
            TELogFactory.getNormalLogger().info("TESendCommandAsyn result:" + result);
        }
    }
}

