/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;

public class TENEDataBackupBean
implements TENEListInterface {
    private Datainterface outputData = null;
    private int failedNeCount = 0;
    private static final int TIME_OUT = 600;
    private SubFunc subfunc = null;
    private String QX_DES_PATH = "conf" + File.separator + "qxdescrib.xml";

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        this.subfunc = subFunc;
        this.outputData = new Datainterface();
        BussinessParams returnBParams = new BussinessParams();
        try {
            ArrayList operationList = TEDataConverter.convertToOperation(subFunc, inputData, this.QX_DES_PATH);
            ArrayList<Operation> tempList = new ArrayList<Operation>();
            RowParams[] rParams = inputData.getBussinessParams().getRowParams();
            Operation tempOperation = null;
            for (int i = 0; i < rParams.length; ++i) {
                tempList.clear();
                String neid = rParams[i].getParam("neid").getValue();
                for (int j = operationList.size() - 1; j >= 0; --j) {
                    tempOperation = (Operation)operationList.get(j);
                    if (!neid.equals(tempOperation.getInput().getPartValue("neid"))) continue;
                    operationList.remove(tempOperation);
                    Part tempPart = new Part();
                    tempPart.setName("neid");
                    tempPart.setValue(neid);
                    tempPart.setType("int");
                    tempOperation.getInput().removePart(tempPart);
                    tempList.add(tempOperation);
                }
                if (tempList.isEmpty()) continue;
                OperationResult result = null;
                for (Operation operOne : tempList) {
                    ArrayList<Operation> tempOneList = new ArrayList<Operation>();
                    tempOneList.add(operOne);
                    result = TECommuNEMgr.getInstance().sendCommand(Integer.parseInt(neid), tempOneList, 600, subFunc);
                    if (result.retCode == 0) continue;
                    break;
                }
                Datainterface tempDatainterface = this.handleMessage(Integer.parseInt(neid), tempList, subFunc, result.retCode, returnBParams);
                this.writeLog(Integer.parseInt(neid), this.subfunc, inputData, TESysManagerBean.getInstance().getSysUser(), ipAddress, tempDatainterface);
            }
            ErrorMessage bigErr = this.failedNeCount == 0 ? TEErrorResourceUtil.getErrorMessage(0) : (this.failedNeCount == rParams.length ? TEErrorResourceUtil.getErrorMessage(2) : TEErrorResourceUtil.getErrorMessage(1));
            this.outputData.setBussinessParams(returnBParams);
            this.outputData.setErrorMessage(bigErr);
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("TENEDataBackupBean.subFuncProcessed() fail!", (Throwable)ex);
        }
        return this.outputData;
    }

    public Datainterface handleMessage(int neid, ArrayList<Operation> operationList, SubFunc subfunc, int retCode, BussinessParams returnBParams) {
        Datainterface temp = null;
        if (retCode != 0) {
            temp = new Datainterface();
            RowParams rowParam = new RowParams();
            RowErrors rowErr = new RowErrors();
            Param errParam = new Param("neid", String.valueOf(neid));
            rowErr.addParam(errParam);
            errParam = new Param("nename", TENEListMgr.getInstance().getNE(neid).getNEName());
            rowErr.addParam(errParam);
            rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, retCode));
            rowParam.addRowErrors(rowErr);
            returnBParams.addRowParams(rowParam);
            ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage(2);
            temp.setBussinessParams(returnBParams);
            temp.setErrorMessage(bigErr);
            this.failedNeCount = operationList.size();
        } else {
            temp = TEDataConverter.convertToDatainterface(neid, subfunc, operationList, null);
            RowParams[] rParams = temp.getBussinessParams().getRowParams();
            for (int i = 0; i < rParams.length; ++i) {
                returnBParams.addRowParams(rParams[i]);
                if (rParams[i].getRowErrorsCount() == 0) continue;
                ++this.failedNeCount;
            }
        }
        return temp;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final SubFunc nsubfunc = subfunc;
        new TEWriteLogCommonImpl(){

            @Override
            public String getOperationDescribtion() {
                return nsubfunc.getSubFuncDes();
            }

            @Override
            public String getOperationName(int neid, SubFunc subfunc) {
                return nsubfunc.getSubFuncDes();
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }
}

