/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;

public class TENEBackUpParams {
    public static String isSupportAutoBackupToCF(int neid, int neType, String hostVersion) {
        String isSupported = "false";
        if (hostVersion == null || hostVersion.equals("")) {
            return "false";
        }
        try {
            long version = TENEBackUpParams.getVersion(hostVersion);
            switch (neType) {
                case 29: {
                    if (85266954L <= version && version <= 0x515FFFFL) {
                        isSupported = "true";
                    }
                    break;
                }
                case 31: {
                    if (86249994L <= version && version <= 86310911L) {
                        isSupported = "true";
                    }
                    break;
                }
                case 36: {
                    if (86249994L <= version && version <= 86310911L) {
                        isSupported = "true";
                    }
                    break;
                }
                case 41: {
                    if (85266954L <= version && version <= 0x515FFFFL) {
                        isSupported = "true";
                    }
                    break;
                }
                case 51: {
                    if (87229204L <= version) {
                        isSupported = "true";
                    }
                    break;
                }
                case 52: {
                    if (87229204L <= version) {
                        isSupported = "true";
                    }
                    break;
                }
                case 68: {
                    if (87229204L <= version) {
                        isSupported = "true";
                    }
                    break;
                }
                case 74: {
                    isSupported = "true";
                    break;
                }
                case 84: {
                    isSupported = "true";
                    break;
                }
                case 71: {
                    isSupported = "true";
                    break;
                }
                case 73: {
                    isSupported = "true";
                    break;
                }
                case 75: {
                    isSupported = "true";
                    break;
                }
                case 85: {
                    isSupported = "true";
                    break;
                }
                case 109: {
                    isSupported = "true";
                    break;
                }
                case 116: {
                    isSupported = "true";
                    break;
                }
                default: {
                    boolean isSupport = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_AUTOBACKUP_CF");
                    if (isSupport) {
                        isSupported = "true";
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Parse Number fail!", (Throwable)e);
        }
        return isSupported;
    }

    public static String[] isSupportBackupToCF(int neid, int neType, String hostVersion) {
        String[] isSupported = new String[]{"true", "5", "false", "false"};
        if (hostVersion == null || hostVersion.equals("")) {
            isSupported[0] = "false";
            return isSupported;
        }
        try {
            long version = TENEBackUpParams.getVersion(hostVersion);
            switch (neType) {
                case 52: {
                    if (87294740L > version) {
                        isSupported[0] = "false";
                    }
                    if (87295498L <= version) {
                        isSupported[3] = "true";
                    }
                    break;
                }
                case 51: {
                    if (87229204L > version) {
                        isSupported[0] = "false";
                    }
                    if (87229962L <= version) {
                        isSupported[3] = "true";
                    }
                    break;
                }
                case 68: {
                    if (87229204L > version) {
                        isSupported[0] = "false";
                    }
                    if (87229962L <= version) {
                        isSupported[3] = "true";
                    }
                    break;
                }
                case 74: {
                    isSupported[0] = "true";
                    if (87229962L <= version) {
                        isSupported[3] = "true";
                    }
                    break;
                }
                case 84: {
                    isSupported[0] = "true";
                    if (87229962L <= version) {
                        isSupported[3] = "true";
                    }
                    break;
                }
                case 54: 
                case 55: 
                case 60: 
                case 67: {
                    isSupported[0] = "false";
                    break;
                }
                case 92: {
                    isSupported[0] = "false";
                    isSupported[1] = "7";
                    isSupported[2] = "true";
                    break;
                }
                case 77: 
                case 114: {
                    isSupported[0] = "true";
                    isSupported[1] = "7";
                    isSupported[2] = "true";
                    break;
                }
                case 76: 
                case 83: 
                case 95: {
                    isSupported[0] = "true";
                    isSupported[1] = "7";
                    isSupported[2] = "true";
                    break;
                }
                case 71: {
                    isSupported[0] = "true";
                    break;
                }
                case 73: {
                    isSupported[0] = "true";
                    break;
                }
                case 75: {
                    isSupported[0] = "true";
                    break;
                }
                case 85: {
                    isSupported[0] = "true";
                    break;
                }
                case 66: {
                    isSupported[0] = "false";
                    break;
                }
                case 115: {
                    isSupported[0] = "false";
                    break;
                }
                default: {
                    boolean isSupportNew;
                    boolean isSupportBefore;
                    String mode;
                    boolean isNotSupportCF = TESpecialAttrMgr.getInstance().isNENotSupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_BACKUP_CF");
                    if (isNotSupportCF) {
                        isSupported[0] = "false";
                    }
                    if ((mode = TESpecialAttrMgr.getInstance().getNEAttrValue(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_BACKUP_CF_MODE")) != null && !mode.equals("")) {
                        isSupported[1] = mode;
                    }
                    if (isSupportBefore = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_BACKUP_CF_BEFOR")) {
                        isSupported[2] = "true";
                    }
                    if (isSupportNew = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_BACKUP_CF_NEW")) {
                        isSupported[3] = "true";
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            TELogFactory.getNormalLogger().error("Parse Number fail!", (Throwable)e);
        }
        return isSupported;
    }

    public static String[] isSupportBackupToSCC(int neid, int neType, String hostVersion) {
        String mode;
        String[] isSupported = new String[]{"true", "0"};
        if (hostVersion == null || hostVersion.equals("")) {
            return isSupported;
        }
        switch (neType) {
            default: 
        }
        boolean isNotSupportSCC = TESpecialAttrMgr.getInstance().isNENotSupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_BACKUP_SCC");
        if (isNotSupportSCC) {
            isSupported[0] = "false";
        }
        if ((mode = TESpecialAttrMgr.getInstance().getNEAttrValue(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_BACKUP_SCC_MODE")) != null && !mode.equals("")) {
            isSupported[1] = mode;
        }
        return isSupported;
    }

    public static String isSupportRestoreNEDatabase(int neid, int neType, String hostVersion) {
        String isSupportedRestore = "false";
        if (hostVersion == null || hostVersion.equals("")) {
            return "false";
        }
        long version = TENEBackUpParams.getVersion(hostVersion);
        switch (neType) {
            case 52: {
                if (87229962L > version) break;
                isSupportedRestore = "true";
                break;
            }
            case 51: {
                if (87229962L > version) break;
                isSupportedRestore = "true";
                break;
            }
            case 68: {
                if (87229962L > version) break;
                isSupportedRestore = "true";
                break;
            }
            case 74: {
                if (87229962L > version) break;
                isSupportedRestore = "true";
                break;
            }
            case 84: {
                if (87229962L > version) break;
                isSupportedRestore = "true";
                break;
            }
            case 71: {
                isSupportedRestore = "true";
                break;
            }
            case 73: {
                isSupportedRestore = "true";
                break;
            }
            case 75: {
                isSupportedRestore = "true";
                break;
            }
            case 85: {
                isSupportedRestore = "true";
                break;
            }
            case 109: {
                isSupportedRestore = "true";
                break;
            }
            case 116: {
                isSupportedRestore = "true";
                break;
            }
            default: {
                boolean isSupport = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_RESTORE_DATABASE");
                if (!isSupport) break;
                isSupportedRestore = "true";
            }
        }
        return isSupportedRestore;
    }

    public static String isSupportDownloadConfig(int neid, int neType, String hostVersion) {
        String isSupported = "false";
        if (hostVersion == null || hostVersion.equals("")) {
            return "false";
        }
        switch (neType) {
            case 54: {
                isSupported = "true";
                break;
            }
            case 55: {
                isSupported = "true";
                break;
            }
            case 60: {
                isSupported = "true";
                break;
            }
            case 76: {
                isSupported = "true";
                break;
            }
            case 77: {
                isSupported = "true";
                break;
            }
            case 114: {
                isSupported = "true";
                break;
            }
            case 83: {
                isSupported = "true";
                break;
            }
            case 92: {
                isSupported = "true";
                break;
            }
            case 95: {
                isSupported = "true";
                break;
            }
            case 115: {
                isSupported = "true";
                break;
            }
            default: {
                boolean isSupport = TESpecialAttrMgr.getInstance().isNESupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_DOWNLOAD_CONFIG");
                if (!isSupport) break;
                isSupported = "true";
            }
        }
        return isSupported;
    }

    public static String isSupportModifyNeID(int neid, int neType, int neConnectType, String hostVersion) {
        String isSupported = "true";
        if (neConnectType == 1) {
            return "false";
        }
        if (hostVersion == null || hostVersion.equals("")) {
            return "false";
        }
        switch (neType) {
            case 72: {
                isSupported = "false";
                break;
            }
            case 113: {
                isSupported = "false";
                break;
            }
            default: {
                boolean isNotSupport = TESpecialAttrMgr.getInstance().isNENotSupport(neid, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_MODIFY_NEID");
                if (!isNotSupport) break;
                isSupported = "false";
            }
        }
        return isSupported;
    }

    private static long getVersion(String hostVersion) throws NumberFormatException {
        hostVersion = hostVersion.replace(".", "");
        long l = Long.parseLong(hostVersion, 16);
        return l;
    }
}

