/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.gencfg.TETimeTocalizationSwitchBean;
import com.huawei.nglct.neinterface.neadapter.TECommuNEMgr;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TEDevicePackageUpload;
import com.huawei.nglct.nelist.TENEAlarmAnalyse;
import com.huawei.nglct.nelist.TENEImplInterface;
import com.huawei.nglct.nelist.TENEInterImpl;
import com.huawei.nglct.nelist.TENELdDevPkgNoticeReceiver;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENESingleImpl;
import com.huawei.nglct.nelist.TERemoveAlarmByBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.po.embeddednemgrmo.TECircuitPackMOPO;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TEEncryptForNeListInfo;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.tl1.TETL1DBCHGData;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEConvertUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.NoticeHandler;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.Vector;

public class TENE
implements TERemoveAlarmByBoard,
Cloneable {
    public static final long osn6800LowVer = 87229204L;
    public static final long osn6800HigVer = 0x5336363L;
    public static final long osn3800LowVer = 87294740L;
    public static final long osn3800HigVer = 87319395L;
    public static final long osn1800LowVer = 88277258L;
    public static final long osn1800HigVer = 88302435L;
    private static final String QX_DES_PATH = "conf" + File.separator + "qxdescrib.xml";
    public static final int TIMEOUT = 10;
    public static final String CHARSET_DEFAULT = "0";
    public static final String CHARSET_GBK = "1";
    public static final String CHARSET_ISO8859_1 = "2";
    public static final String CHARSET_UTF_8 = "3";
    public static final String CHARSET_GBK_NAME = "GBK";
    public static final String CHARSET_ISO8859_NAME = "ISO-8859-1";
    public static final String CHARSET_UTF_8_NAME = "UTF-8";
    protected static final String KEY = "OSPV1R10";
    protected int neID = -1;
    protected TENEImplInterface neImplInterface;
    private static final HashMap devPkgVersionMap = new HashMap();
    protected Set<Long> featureList = Collections.synchronizedSet(new HashSet());

    public Vector getThrshData() {
        return this.neImplInterface.getThrshDataList();
    }

    public boolean getServerOrClient() {
        return this.neImplInterface.isServerOrClient();
    }

    public void setServerOrClient(boolean serverOrClient) {
        this.neImplInterface.setServerOrClient(serverOrClient);
    }

    public synchronized boolean isAlarmChanged() {
        return this.neImplInterface.isAlarmChanged();
    }

    public synchronized void setAlarmChanged(boolean alarmChanged) {
        this.neImplInterface.setAlarmChanged(alarmChanged);
    }

    public void setLastBoardModifyTime() {
    }

    public boolean isCanUpdateBoardList() {
        return true;
    }

    public TENE() {
        this.initNeContent();
    }

    public TENE(int neID, int neGWType, String neGWAddress, String port, String baudRate) {
        this.neID = neID;
        this.initNeContent();
        this.setNEGWType(neGWType);
        this.setNEGWAddress(neGWAddress);
        this.setPort(port);
        this.setBaudRate(baudRate);
    }

    public TENE(int neID, int neGWType, String neGWAddress, String port, String baudRate, String userName, byte[] userPassword) {
        this.neID = neID;
        this.initNeContent();
        this.setNEGWType(neGWType);
        this.setNEGWAddress(neGWAddress);
        this.setPort(port);
        this.setBaudRate(baudRate);
        this.setCurUser(userName);
        this.setCurUserPassword(userPassword);
    }

    public boolean modifyNEGWAddr(int neGWType, String neGWAddress, String gwPort) {
        if (!TEResourceManager.setNeListInfoKeyValue(TENEListMgr.NELIST_PATH, this.neID, "neGWType", String.valueOf(neGWType))) {
            TELogFactory.getNormalLogger().info("modify nelistinfo.xml neGWType failed");
            return false;
        }
        if (!TEResourceManager.setNeListInfoKeyValue(TENEListMgr.NELIST_PATH, this.neID, "neGWAddress", String.valueOf(neGWAddress))) {
            TELogFactory.getNormalLogger().info("modify nelistinfo.xml GWAddress failed");
            return false;
        }
        if (!TEResourceManager.setNeListInfoKeyValue(TENEListMgr.NELIST_PATH, this.neID, "port", String.valueOf(gwPort))) {
            TELogFactory.getNormalLogger().info("modify nelistinfo.xml port failed");
            return false;
        }
        TELogFactory.getNormalLogger().info("modify ne GWAddress successed");
        this.setNEGWType(neGWType);
        this.setNEGWAddress(neGWAddress);
        this.setPort(gwPort);
        return true;
    }

    public int login(String userName, byte[] userPassword, int forceLogin) {
        int retCode = this.getNeImplInterface().login(userName, userPassword, forceLogin);
        EncryptUtils.clearByte(userPassword);
        return retCode;
    }

    public int loginWithSetStatusFlag(String userName, byte[] userPassword, int forceLogin, boolean isSetStatus) {
        return this.getNeImplInterface().loginWithSetStatusFlag(userName, userPassword, forceLogin, isSetStatus);
    }

    public void update(TETL1DBCHGData data) {
    }

    public int logout() {
        ArrayList<Object> operationList = new ArrayList<Object>();
        int retCode = -1;
        try {
            Operation oper = TECreateObjectFactory.getOperation(QX_DES_PATH, "LogoutNE");
            operationList.add(oper.clone());
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
            if (result.retCode == 1090650120) {
                this.afterLogoutNE();
                return 0;
            }
            int size = operationList.size();
            for (int i = 0; i < size; ++i) {
                Operation operation = (Operation)operationList.get(i);
                for (Output output : operation.getOutput()) {
                    for (Fault fault : output.getFault()) {
                        String code = fault.getCode();
                        if (CHARSET_DEFAULT.equals(code)) {
                            this.afterLogoutNE();
                            if (!this.isInterrationStatus()) {
                                this.neImplInterface.setLogStatus(0);
                            }
                            if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                                this.setCurTopLevelAlm(-1);
                            }
                            TELogFactory.getNormalLogger().info("logout ne successed");
                        } else {
                            TELogFactory.getNormalLogger().error("Log out ne error,error code =" + code);
                            if (code.trim().equals("")) {
                                code = String.valueOf(1090650120);
                            }
                        }
                        retCode = Integer.parseInt(code);
                    }
                }
            }
            return retCode;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("logout ne failed", (Throwable)e);
            return retCode;
        }
    }

    public void queryNEAttribute() {
        String devPkgVersion = "";
        String neName = "";
        String deviceType = "";
        String hostVersion = this.getHostVersion();
        String neState = "unkonwstate";
        ArrayList<Object> operationList = new ArrayList<Object>();
        ArrayList<Object> neTypeOperationList = new ArrayList<Object>();
        ArrayList<Object> neVersionOperationList = new ArrayList<Object>();
        try {
            String showNEVer;
            Operation oper = TECreateObjectFactory.getOperation(QX_DES_PATH, "NSCMD_SYS_GET_NESOFT_VER");
            neVersionOperationList.add(oper.clone());
            if (this.getNEType() != 112 && this.getNEType() != 111 && this.getNEType() != 117 && this.getNEType() != 118 && !TESpecialAttrMgr.getInstance().isNENotSupport(this.neID, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_NESTATE")) {
                oper = TECreateObjectFactory.getOperation(QX_DES_PATH, "NSCMD_CFG_GET_NE_STATE");
                operationList.add(oper.clone());
            } else {
                neState = "runstate";
            }
            oper = TECreateObjectFactory.getOperation(QX_DES_PATH, "GetNEName");
            operationList.add(oper.clone());
            oper = TECreateObjectFactory.getOperation(QX_DES_PATH, "GetNEName");
            operationList.add(oper.clone());
            oper = TECreateObjectFactory.getOperation(QX_DES_PATH, "NSCMD_CFG_GET_DEVICE_TYPE");
            neTypeOperationList.add(oper.clone());
            OperationResult operResult = TENECommMgr.getInstance().sendCommand(this.neID, neTypeOperationList, 30);
            if (operResult.retCode != 0) {
                return;
            }
            Operation neTypeOper = (Operation)neTypeOperationList.get(0);
            for (Output output : neTypeOper.getOutput()) {
                Fault[] faultArr = output.getFault();
                String code = null;
                for (Fault fault : faultArr) {
                    code = fault.getCode();
                    if (!CHARSET_DEFAULT.equals(code)) continue;
                    for (Part part : output.getPart()) {
                        if (part.getName().equals("deviceType")) {
                            deviceType = part.getValue();
                            this.setNEType(Integer.parseInt(deviceType));
                            continue;
                        }
                        if (!part.getName().equals("shelfType")) continue;
                        this.setShelfType(Integer.parseInt(part.getValue()));
                    }
                }
            }
            TELogFactory.getNormalLogger().info("device type is " + this.neImplInterface.getNeType() + "; shelf type is " + this.neImplInterface.getShelfType());
            OperationResult neverResult = TENECommMgr.getInstance().sendCommand(this.neID, neVersionOperationList, 30);
            if (neverResult.retCode != 0) {
                return;
            }
            Operation neVerOper = (Operation)neVersionOperationList.get(0);
            TEDataConverter.handleSpecialStr(neVerOper);
            Output[] neVerOutputArr = neVerOper.getOutput();
            int len = neVerOutputArr.length;
            for (int j = 0; j < len; ++j) {
                String tempVer = "";
                String tempactive = "";
                Output output = neVerOutputArr[j];
                Fault[] faultArr = output.getFault();
                String code = null;
                for (Fault fault : faultArr) {
                    code = fault.getCode();
                    if (!CHARSET_DEFAULT.equals(code)) continue;
                    for (Part part : output.getPart()) {
                        if (part.getName().equals("verSignal")) {
                            if (!part.getValue().equals("NSF1") && !part.getValue().equals("NSF2")) break;
                            continue;
                        }
                        if (part.getName().equals("versionStr") && !part.getValue().equals("")) {
                            tempVer = part.getValue();
                            continue;
                        }
                        if (!part.getName().equals("activeSignal") || part.getValue().equals("")) continue;
                        tempactive = part.getValue();
                    }
                    if (!"active".equals(tempactive) || "".equals(tempVer)) continue;
                    showNEVer = tempVer;
                    hostVersion = this.getHostVer(showNEVer);
                }
            }
            TELogFactory.getNormalLogger().info("hostVersion is " + hostVersion);
            hostVersion = this.convertDeviceVersion(this.getNEType(), hostVersion);
            showNEVer = this.convertDeviceVersion(this.getNEType(), hostVersion);
            String temp = (String)devPkgVersionMap.get(String.valueOf(this.getNEType()));
            if (null != temp && !"".equals(temp)) {
                devPkgVersion = temp;
            }
            this.setDevPkgVersion(devPkgVersion);
            this.setHostVersion(hostVersion);
            this.setShowNEVersion(showNEVer);
            this.setDeviceType(TEEquipmentDescription.getInstance().getDeviceTypeName(this.getNEType()));
            OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
            if (result.retCode != 0) {
                return;
            }
            int size = operationList.size();
            for (int i = 0; i < size; ++i) {
                String code;
                Fault[] faultArr;
                Operation operation = (Operation)operationList.get(i);
                TEDataConverter.handleSpecialStr(operation);
                if (operation.getName().equals("NSCMD_CFG_GET_NE_STATE")) {
                    for (Output output : operation.getOutput()) {
                        faultArr = output.getFault();
                        code = null;
                        for (Fault fault : faultArr) {
                            code = fault.getCode();
                            if (!CHARSET_DEFAULT.equals(code)) continue;
                            for (Part part : output.getPart()) {
                                if (!part.getName().equals("neState") || null == part.getValue() || "".equals(part.getValue())) continue;
                                if (CHARSET_DEFAULT.equals(part.getValue())) {
                                    neState = "installstate";
                                    continue;
                                }
                                if (!CHARSET_GBK.equals(part.getValue())) continue;
                                neState = "runstate";
                            }
                        }
                    }
                    continue;
                }
                if (!operation.getName().equals("GetNEName")) continue;
                for (Output output : operation.getOutput()) {
                    faultArr = output.getFault();
                    code = null;
                    for (Fault fault : faultArr) {
                        code = fault.getCode();
                        if (!CHARSET_DEFAULT.equals(code)) continue;
                        for (Part part : output.getPart()) {
                            if (!part.getName().equals("neName")) continue;
                            neName = part.getValue();
                        }
                    }
                }
            }
            this.setNEState(neState);
            this.setNEName(neName.trim());
            this.queryNEPNPFeatureList();
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
        }
    }

    public void afterLogoutNE() {
        this.neImplInterface.setAutoLoginNE(false);
    }

    public void initNEData() {
    }

    public int getNEType() {
        return this.neImplInterface.getNeType();
    }

    public int getNEID() {
        return this.neID;
    }

    public int getONEID() {
        return this.neImplInterface.getONeID();
    }

    public int getRealNEID() {
        return this.neImplInterface.getRealNEID();
    }

    public String getNEName() {
        String neName = this.neImplInterface.getNeName();
        if (null == neName || "".equals(neName.trim())) {
            return "NE(" + this.neImplInterface.getRealNEID() / 65536 + "-" + this.neImplInterface.getRealNEID() % 65536 + ")";
        }
        return neName.trim();
    }

    public String getNEGWAddress() {
        return this.neImplInterface.getNeGWAddress();
    }

    public int getNEGateWay() {
        if (this.getIsTL1OrQX() == 0) {
            this.neImplInterface.setNeGateWay(TENECommMgr.getInstance().getNEGateWay((long)this.neID));
        }
        return this.neImplInterface.getNeGateWay();
    }

    public int getNEGWType() {
        return this.neImplInterface.getNeGWType();
    }

    public String getPort() {
        return this.neImplInterface.getPort();
    }

    public String getNePort() {
        return this.neImplInterface.getNePort();
    }

    public String getGatePort() {
        return this.neImplInterface.getGatePort();
    }

    public String getBaudRate() {
        return this.neImplInterface.getBaudRate();
    }

    public int getComStarus() {
        return this.neImplInterface.getCommunicateStatus();
    }

    public int getLogStatus() {
        return this.neImplInterface.getLogStatus();
    }

    public String getDevPkgVersion() {
        return this.neImplInterface.getDevPkgVersion();
    }

    public int getNEVersion() {
        return this.neImplInterface.getNeVersion();
    }

    public String getNEState() {
        return this.neImplInterface.getNeState();
    }

    public String getHostVersion() {
        return this.neImplInterface.getHostVersion();
    }

    public String getCurUser() {
        return this.neImplInterface.getCurUser();
    }

    public byte[] getCurUserPassword() {
        return this.neImplInterface.getCurUserPassword();
    }

    public void setNEType(int neType) {
        this.neImplInterface.setNeType(neType);
    }

    public void setNEID(int id) {
        this.neID = id;
        this.neImplInterface.setNeID(id);
    }

    public void setONEID(int id) {
        this.neImplInterface.setONeID(id);
    }

    public void setRealNEID(int realNEID) {
        this.neImplInterface.setRealNEID(realNEID);
    }

    public void setNEName(String name) {
        this.neImplInterface.setNeName(name);
    }

    public void setNEGateWay(int neGateWay) {
        this.neImplInterface.setNeGateWay(neGateWay);
    }

    public void setNEGWType(int neGWType) {
        this.neImplInterface.setNeGWType(neGWType);
    }

    public void setNEGWAddress(String neGWAddress) {
        this.neImplInterface.setNeGWAddress(neGWAddress);
    }

    public void setPort(String port) {
        this.neImplInterface.setPort(port);
    }

    public void setBaudRate(String baudRate) {
        this.neImplInterface.setBaudRate(baudRate);
    }

    public void setComStatus(int status) {
        this.neImplInterface.setCommunicateStatus(status);
    }

    public void setLogStatus(int logStatus) {
        this.neImplInterface.setLogStatus(logStatus);
    }

    public void setDevPkgVersion(String devPkgVersion) {
        this.neImplInterface.setDevPkgVersion(devPkgVersion);
    }

    public void setNeVersion(int neVersion) {
        this.neImplInterface.setNeVersion(neVersion);
    }

    public void setNEState(String neState) {
        this.neImplInterface.setNeState(neState);
    }

    public void setHostVersion(String hostVersion) {
        this.neImplInterface.setHostVersion(hostVersion);
    }

    public void setCurUser(String curUser) {
        this.neImplInterface.setCurUser(curUser);
    }

    public void setCurUserPassword(byte[] password) {
        this.neImplInterface.setCurUserPassword(password);
    }

    public void setCurTopLevelAlm(int almLevel) {
    }

    public void setIsSchedule(boolean isSchedule) {
        this.neImplInterface.setSchedule(isSchedule);
    }

    public boolean getIsSchedule() {
        return this.neImplInterface.isSchedule();
    }

    public void setBoardTimer(Timer timer) {
        this.neImplInterface.setBoardTimer(timer);
    }

    public Timer getBoardTimer() {
        return this.neImplInterface.getBoardTimer();
    }

    public int getCurTopLevelAlm(int slotID) {
        return -1;
    }

    public TENEAlarmAnalyse getCurTopLevelAlmOnSubrack(int subrackID) {
        return null;
    }

    public synchronized Vector getBoardList() {
        return null;
    }

    public synchronized Vector getPhyBoardList() {
        return null;
    }

    public synchronized Vector getClonedBoardList() {
        return null;
    }

    public synchronized Vector getOldBoardList() {
        return null;
    }

    public synchronized void setOldBoardList(Vector list) {
    }

    public synchronized void setBoardList(Vector newBoardList) {
    }

    public synchronized Vector getClonedPhyBoardList() {
        return null;
    }

    public synchronized void setPhyBoardList(Vector newBoardList) {
    }

    public TEBoard getBoard(int slotID) {
        if (this.isInterrationStatus()) {
            return this.getBoardOnInter(slotID);
        }
        return this.getBoardOnSingle(slotID);
    }

    protected TEBoard getBoardOnInter(int slotID) {
        TEBoard board = null;
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = this.isDataCfgStausNeedLock() ? TECommonDaoService.findBoards(this.neID, new int[]{slotID}) : TECommonDaoService.findBoards_NonLock(this.neID, new int[]{slotID});
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get board error!", (Throwable)e);
            return board;
        }
        if (null == dbResult) {
            TELogFactory.getNormalLogger().error("dbResult is null.");
            return board;
        }
        if (0 != dbResult.getResult()) {
            TELogFactory.getNormalLogger().error("dbResult.result is: " + dbResult.getResult());
            return board;
        }
        List<Object> boards = dbResult.getData();
        if (!boards.isEmpty()) {
            TECircuitPackMOPO cp = (TECircuitPackMOPO)boards.get(0);
            int boardType = cp.getTypeID();
            int slotId = (int)cp.getSlotID();
            int cpMode = (int)cp.getCpMode();
            board = new TEBoard(this.neID, slotId, boardType, cpMode);
        }
        return board;
    }

    protected TEBoard getBoardOnSingle(int slotID) {
        Vector bdList = this.getBoardList();
        if (null == bdList) {
            return null;
        }
        TEBoard board = null;
        int size = bdList.size();
        for (int i = 0; i < size; ++i) {
            board = (TEBoard)bdList.get(i);
            if (board.getSlotID() != slotID) continue;
            return board;
        }
        return null;
    }

    public TEBoard getPhyBoard(int slotID) {
        Vector bdList = this.getPhyBoardList();
        if (bdList == null) {
            return null;
        }
        int size = bdList.size();
        for (int i = 0; i < size; ++i) {
            TEBoard board = (TEBoard)bdList.get(i);
            if (board.getSlotID() != slotID) continue;
            return board;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TENE)) {
            return false;
        }
        TENE ne = (TENE)obj;
        return ne.getNEID() == this.neID;
    }

    public int hashCode() {
        return this.neID;
    }

    public String toString() {
        int subNEID = -1;
        int extID = -1;
        subNEID = this.neImplInterface.getRealNEID() % 65536;
        extID = (this.neImplInterface.getRealNEID() - subNEID) / 65536;
        return "neid:" + this.neID + ",nename:" + extID + "-" + subNEID;
    }

    public void queryBoard() {
    }

    public void querySubrack() {
    }

    public String getTimeZome() {
        return this.getNeImplInterface().getTimeZome();
    }

    public void setTimeZome(String timeZome) {
        this.getNeImplInterface().setTimeZome(timeZome);
    }

    public String getDeviceType() {
        return this.neImplInterface.getDeviceType();
    }

    public void setDeviceType(String deviceType) {
        this.neImplInterface.setDeviceType(deviceType);
    }

    public boolean getBoardUpdateFlag() {
        return this.neImplInterface.isBoardUpdateFlag();
    }

    public void setBoardUpdateFlag(boolean boardUpdateFlag) {
        this.neImplInterface.setBoardUpdateFlag(boardUpdateFlag);
    }

    @Override
    public void removeAlarm(int slotID, int portID) {
    }

    @Override
    public void removeLogicPortBySlot(int neID, int slotID, int boardType) {
        TEConfigurationDataMgr.getInstance().deletLogicPortBySlot(neID, slotID, boardType);
    }

    public String getNeIp() {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            String neIP = this.neImplInterface.getNeIp();
            if (0 == this.getIsTL1OrQX() && (neIP == null || "".equals(neIP)) && 1 == this.getLogStatus()) {
                neIP = this.queryNEIPForQx(this.neImplInterface.getNeID());
            }
            return neIP;
        }
        return this.neImplInterface.getNeIp();
    }

    public String getGateNeIp() {
        return this.neImplInterface.getGateNeIp();
    }

    public void setNeIp(String neIp) {
        this.neImplInterface.setNeIp(neIp);
    }

    public Vector getLastQueryAlarmList() {
        return this.neImplInterface.getLastQueryAlarmList();
    }

    public void setLastQueryAlarmList(Vector lastQueryAlarmList) {
        this.neImplInterface.setLastQueryAlarmList(lastQueryAlarmList);
    }

    public Vector getLastQueryHisAlarmList() {
        return this.neImplInterface.getLastQueryHisAlarmList();
    }

    public void setLastQueryHisAlarmList(Vector lastQueryHisAlarmList) {
        this.neImplInterface.setLastQueryHisAlarmList(lastQueryHisAlarmList);
    }

    public String getEncPswStr() {
        byte[] curUserPassword = this.neImplInterface.getCurUserPassword();
        TEEncryptForNeListInfo des = new TEEncryptForNeListInfo();
        if (null == curUserPassword) {
            return "";
        }
        String result = des.byte2hex(des.doEncrypt(curUserPassword));
        EncryptUtils.clearByte(curUserPassword);
        return result;
    }

    public String getShowNEVersion() {
        return this.neImplInterface.getShowNEVersion();
    }

    public void setShowNEVersion(String showNEVersion) {
        this.neImplInterface.setShowNEVersion(showNEVersion);
    }

    public String getHostVer(String showNEVer) {
        if (showNEVer == null || showNEVer.equals("") || showNEVer.equalsIgnoreCase("NULL")) {
            return "";
        }
        String[] showNEVerArr = showNEVer.split("\\p{Punct}");
        showNEVer = showNEVerArr[0] + "." + showNEVerArr[1] + "." + showNEVerArr[2] + "." + showNEVerArr[3].substring(0, 2);
        return showNEVer;
    }

    public int getShelfType() {
        return this.neImplInterface.getShelfType();
    }

    public void setShelfType(int shelfType) {
        this.neImplInterface.setShelfType(shelfType);
    }

    public String getNodeID() {
        return this.neImplInterface.getNodeID();
    }

    public void setNodeID(String nodeID) {
        this.neImplInterface.setNodeID(nodeID);
    }

    public Vector getAlarmList() {
        return null;
    }

    public void queryAlarm() {
    }

    public void queryHistoryAlarm() {
    }

    public Vector getHistoryAlarmList() {
        return null;
    }

    public int[] deleteAlm(int[] evtSerialNums) {
        return null;
    }

    public boolean isPreConfig() {
        return this.neImplInterface.isPreConfig();
    }

    public void setPreConfig(boolean preConfig) {
        this.neImplInterface.setPreConfig(preConfig);
    }

    public int getConfiged() {
        return this.neImplInterface.getConfiged();
    }

    public void setConfiged(int configed) {
        this.neImplInterface.setConfiged(configed);
    }

    public synchronized Vector getSubrackList() {
        return null;
    }

    public synchronized Vector getClonedSubrackList() {
        return null;
    }

    public synchronized void setSubrackList(Vector newSubrackList) {
    }

    public synchronized Vector getBackupSubrackList() {
        return null;
    }

    public synchronized void setBackupSubrackList(Vector newSubrackList) {
    }

    private String convertDeviceVersion(int netype, String srcVersion) {
        boolean isPTNBox;
        boolean bl = isPTNBox = srcVersion.indexOf("64") > 0 || srcVersion.indexOf("65") > 0 || srcVersion.indexOf("91") > 0 || srcVersion.indexOf("94") > 0;
        if (srcVersion != "" || !"".equals(srcVersion)) {
            if (isPTNBox && this.getNeImplInterface().getNeType() == 65) {
                srcVersion = srcVersion.replaceFirst("64", "65");
            }
            if (isPTNBox && this.getNeImplInterface().getNeType() == 91) {
                srcVersion = srcVersion.replaceFirst("64", "91");
            }
            if (isPTNBox && this.getNeImplInterface().getNeType() == 94) {
                srcVersion = srcVersion.replaceFirst("64", "94");
            }
            if (srcVersion.indexOf("77") > 0 && this.getNeImplInterface().getNeType() == 77) {
                srcVersion = srcVersion.replaceFirst("77", "76");
            }
            return srcVersion;
        }
        String version = srcVersion;
        switch (netype) {
            case 29: {
                if (!"".equals(srcVersion.trim())) break;
                version = "5.21.19.60";
                break;
            }
            case 36: {
                if (!"".equals(srcVersion.trim())) break;
                version = "5.36.19.60";
                break;
            }
            case 67: {
                version = "5.67.01.10";
                break;
            }
            case 51: 
            case 68: {
                version = "5.51.04.20";
                break;
            }
            case 52: {
                version = "5.52.04.20";
                break;
            }
            case 63: {
                version = "5.63.01.10";
                break;
            }
            case 64: {
                version = "5.64.02.10";
                break;
            }
            case 65: {
                version = "5.65.02.10";
                break;
            }
            case 74: 
            case 109: {
                version = "5.51.08.13";
                break;
            }
            case 76: {
                version = "5.76.02.10";
                break;
            }
            case 77: {
                version = "5.77.02.10";
                break;
            }
            case 58: {
                version = "5.58.01.10";
                break;
            }
            case 59: {
                version = "5.59.01.10";
                break;
            }
            case 78: {
                version = "5.78.02.30";
                break;
            }
            case 79: {
                version = "5.51.06.10";
                break;
            }
            case 121: {
                version = "5.67.03.60";
                break;
            }
            case 114: {
                version = "5.114.05.20";
            }
            case 125: {
                version = "5.51.09.10";
            }
            case 127: {
                version = "5.51.09.10";
            }
        }
        return version;
    }

    public int shelfTypeQ2E(int neType, int qx) {
        return qx;
    }

    public int getSCCSlot() {
        TEBoard board = null;
        List fbTypeList = null;
        Vector boardList = this.getBoardList();
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        int size = boardList.size();
        for (int i = 0; i < size; ++i) {
            board = (TEBoard)boardList.get(i);
            fbTypeList = mgr.getBoardSupportFBTypeList(this.neID, board.getBoardType());
            if (!fbTypeList.contains(26) || board.getSlotID() >= 65536) continue;
            return board.getSlotID();
        }
        return 1;
    }

    public int getIsTL1OrQX() {
        return this.neImplInterface.getIsTL1OrQX();
    }

    public void setIsTL1OrQX(int isTL1OrQX) {
        this.neImplInterface.setIsTL1OrQX(isTL1OrQX);
    }

    public String getNeGlobalSign() {
        return this.neImplInterface.getNeGlobalSign();
    }

    public void setNeGlobalSign(String neGlobalSign) {
        this.neImplInterface.setNeGlobalSign(neGlobalSign);
    }

    public boolean isSupportGlobal() {
        return this.neImplInterface.isSupportGlobal();
    }

    public void setSupportGlobal(boolean isSupportGlobal) {
        this.neImplInterface.setSupportGlobal(isSupportGlobal);
    }

    public Vector getCpThrshDataList() {
        return null;
    }

    public TENEAlarmAnalyse getAlarmAnalyse() {
        return this.neImplInterface.getAlarmAnalyse();
    }

    public void setAlarmAnalyse(TENEAlarmAnalyse alarmAnalyse) {
        this.neImplInterface.setAlarmAnalyse(alarmAnalyse);
    }

    public int getTERMINAL_TYPE() {
        return this.getNeImplInterface().getTERMINAL_TYPE();
    }

    public void setTERMINAL_TYPE(int type) {
        this.getNeImplInterface().setTERMINAL_TYPE(type);
    }

    public boolean isInterrationStatus() {
        return TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts();
    }

    public TENEImplInterface getNeImplInterface() {
        return this.neImplInterface;
    }

    public void setNeImplInterface(TENEImplInterface neContent) {
        this.neImplInterface = neContent;
    }

    private void initNeContent() {
        this.neImplInterface = this.isInterrationStatus() ? new TENEInterImpl(this.neID) : new TENESingleImpl(this.neID);
    }

    public static String convertNECharset(String charsetValue) {
        if (charsetValue.equals(CHARSET_GBK)) {
            return CHARSET_GBK_NAME;
        }
        if (charsetValue.equals(CHARSET_ISO8859_1)) {
            return CHARSET_ISO8859_NAME;
        }
        if (charsetValue.equals(CHARSET_UTF_8)) {
            return CHARSET_UTF_8_NAME;
        }
        String sysLangyage = TESysManagerBean.getInstance().getlanguage();
        if (sysLangyage.equals("zh")) {
            return CHARSET_GBK_NAME;
        }
        return CHARSET_ISO8859_NAME;
    }

    public void afterCloseNEMgr() {
    }

    protected Object clone() throws CloneNotSupportedException {
        TENE obj = null;
        try {
            obj = (TENE)this.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new CloneNotSupportedException();
        }
        catch (IllegalAccessException e) {
            throw new CloneNotSupportedException();
        }
        obj.neID = this.neID;
        obj.neImplInterface = (TENEImplInterface)this.neImplInterface.clone();
        return obj;
    }

    public void deleteNE() {
    }

    public void initInterNEDataAfterCreate() {
        try {
            String neIP;
            TENEInterImpl neImpl = (TENEInterImpl)this.getNeImplInterface();
            if (this.getIsTL1OrQX() == 0 && ((neIP = neImpl.getNeIp()) == null || "".equals(neIP))) {
                this.neImplInterface.setNeIp(neIP);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().info("initInterNEDataAfterCreate fail! neID->" + this.neID);
        }
    }

    public void initInterNEDataAfterLogin() {
        TENEInterImpl neImpl = (TENEInterImpl)this.getNeImplInterface();
        if (this.getIsTL1OrQX() == 0) {
            String neIP = neImpl.getNeIp();
            if (neIP == null || "".equals(neIP)) {
                neIP = this.queryNEIPForQx(neImpl.getNeID());
            }
            this.neImplInterface.setNeIp(neIP);
            neImpl.getNECharsetFromMO();
        }
        String showNEVersion = TEConvertUtil.neVersionToString(this.neImplInterface.getNeVersion());
        TELogFactory.getNormalLogger().info("Set NEVersion = " + showNEVersion);
        this.neImplInterface.setShowNEVersion(showNEVersion);
        this.queryNETimeZone(this.neImplInterface.getNeID());
        this.queryNEPNPFeatureList();
    }

    public void queryNETimeZone(int neid) {
        final int tmpNeID = neid;
        new Thread(){

            @Override
            public void run() {
                try {
                    TETimeTocalizationSwitchBean.getTimeZoneDateInstance(tmpNeID).getNETimeZone();
                }
                catch (Exception e) {
                    TELogFactory.getNormalLogger().error("Query NE Time Zone Error! neid=" + tmpNeID, (Throwable)e);
                }
            }
        }.start();
    }

    public void removeInterNEDataBeforeDel() {
    }

    public boolean isDataCfgStausNeedLock() {
        return this.getNeImplInterface().isDataCfgStausNeedLock();
    }

    public String queryNEIPForQx(int neLogicID) {
        String neIP = "";
        int TIMEOUT = 10;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        try {
            Operation oper = TECreateObjectFactory.getOperation(this.neID, "NSCMD_CM_GET_IP");
            if (oper != null) {
                Operation operation;
                Output output;
                operationList.add(oper);
                OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
                if (0 == result.retCode && (output = (operation = (Operation)operationList.get(0)).getOutput(0)).getFault(0).getCode().equals(String.valueOf(0)) && output.getPart("IP") != null && output.getPartValue("IP") != null && !output.getPart("IP").getValue().equals("")) {
                    neIP = TEConvertUtil.ipToString(Long.parseLong(output.getPartValue("IP")));
                }
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get NE IP Address fail", (Throwable)e);
        }
        return neIP;
    }

    public boolean isAutoLoginNE() {
        return this.neImplInterface.isAutoLoginNE();
    }

    public void setAutoLoginNE(boolean autoLoginNE) {
        this.neImplInterface.setAutoLoginNE(autoLoginNE);
    }

    public long getShowOrHostVersion() {
        String neVersion = this.getShowNEVersion();
        if (neVersion != null && !neVersion.equals("")) {
            neVersion = this.getHostVersion();
        } else {
            TELogFactory.getNormalLogger().error("neversion is null!neid=" + this.getNEID());
        }
        return Long.parseLong(neVersion.replace(".", ""));
    }

    public Set<Long> getFeatureList() {
        return this.featureList;
    }

    public void setFeatureList(Set<Long> featureList) {
        this.featureList = featureList;
    }

    public void queryNEPNPFeatureList() {
        if (!TESpecialAttrMgr.getInstance().isNESupport(this.neID, "TE_FUNC_CFG_NE_ATTRIB", "NE_ATTR_SUPPORT_FEATURE")) {
            TELogFactory.getNormalLogger().info("this ne don't support pnp feature" + this.neID);
            return;
        }
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation(QX_DES_PATH, "NSCMD_PNP_GET_OPT_FEATURE_LIST");
        operationList.add((Operation)oper.clone());
        OperationResult operResult = TENECommMgr.getInstance().sendCommand(this.neID, operationList, 10);
        if (operResult.retCode != 0) {
            return;
        }
        TELogFactory.getNormalLogger().info("queryNEPNPFeatureList sucess,dealwith it start.");
        this.featureList.clear();
        Operation featureOper = (Operation)operationList.get(0);
        int len = featureOper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            Output output = featureOper.getOutput(i);
            if (!String.valueOf(0).equals(output.getFault(0).getCode()) || output.getPartValue("featureLen") == null) {
                TELogFactory.getNormalLogger().info("this ne query pnp feature failed!" + output.getFault(0).getCode());
                continue;
            }
            int featureLen = Integer.parseInt(output.getPartValue("featureLen"));
            String featureListStr = output.getPartValue("featureList");
            for (int j = 0; j < featureLen; ++j) {
                if (featureListStr.length() < (j + 1) * 8) continue;
                this.featureList.add(IOStreamConvertor.readUnSignedPositiveLong(featureListStr.substring(j * 8, (j + 1) * 8).getBytes(), 0));
            }
        }
        TELogFactory.getNormalLogger().info("queryNEPNPFeatureList sucess,dealwith it end.");
    }

    public boolean isSupportFeature(long featureID) {
        boolean bExist = false;
        if (null != this.featureList && !this.featureList.isEmpty()) {
            bExist = this.featureList.contains(featureID);
        }
        return bExist;
    }

    static {
        devPkgVersionMap.put("52", "ne_05520110v01");
        devPkgVersionMap.put("51", "ne_05240100v01");
        devPkgVersionMap.put("54", "ne_05540110v01");
        devPkgVersionMap.put("55", "ne_05540110v01");
        devPkgVersionMap.put("58", "ne_05580110v01");
        devPkgVersionMap.put("59", "ne_05590110v01");
        devPkgVersionMap.put("60", "ne_05600110v01");
        devPkgVersionMap.put("61", "ne_05610110v01");
        devPkgVersionMap.put("63", "ne_05630110v01");
        devPkgVersionMap.put("64", "ne_05640110v01");
        devPkgVersionMap.put("65", "ne_05650110v01");
        devPkgVersionMap.put("29", "ne_05211910v01");
        devPkgVersionMap.put("31", "ne_05361910v01");
        devPkgVersionMap.put("36", "ne_05361910v01");
        devPkgVersionMap.put("37", "ne_05370710v01");
        devPkgVersionMap.put("41", "ne_05211910v01");
        devPkgVersionMap.put("43", "ne_05361910v01");
        devPkgVersionMap.put("67", "ne_05670110v01");
        devPkgVersionMap.put("68", "ne_05240100v01");
        devPkgVersionMap.put("76", "ne_05760210v01");
        devPkgVersionMap.put("77", "ne_05760210v01");
        devPkgVersionMap.put("78", "ne_05780230v01");
        devPkgVersionMap.put("86", "ne_05860110v01");
        devPkgVersionMap.put("87", "ne_05870110v01");
    }

    static class LogoutEventNoticeHandler
    implements NoticeHandler {
        LogoutEventNoticeHandler() {
        }

        public synchronized void handleNotice(int cmdkey, int neID, Operation operation) {
            String logoutUserName = "";
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                return;
            }
            Output[] outputArr = operation.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                for (Part part : outputArr[i].getPart()) {
                    String name = part.getName();
                    String value = "";
                    if (part.getValue() != null) {
                        value = IOStreamConvertor.replaceSpecialStr(part.getValue());
                    }
                    if (!"logoutUserName".equals(name)) continue;
                    logoutUserName = value;
                }
            }
            TELogFactory.getInterfaceLogger().info("NE:" + ne.toString() + " logout notice" + "logoutUserName=" + logoutUserName);
            if (logoutUserName.equals(ne.getCurUser())) {
                ne.setLogStatus(0);
                if (TESysManagerConstants.SYS_SINGLE_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
                    ne.setCurTopLevelAlm(-1);
                } else {
                    TECommuNEMgr.getInstance().getCommuNE(ne.getNEID()).setLogined(false);
                }
                ne.afterLogoutNE();
            }
        }
    }

    static class LoginEventNoticeHandler
    implements NoticeHandler {
        LoginEventNoticeHandler() {
        }

        public synchronized void handleNotice(int cmdkey, int neID, Operation operation) {
            String userName = null;
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            ArrayList<TENE> succNEList = new ArrayList<TENE>();
            Output[] outputArr = operation.getOutput();
            int len = outputArr.length;
            for (int i = 0; i < len; ++i) {
                for (Part part : outputArr[i].getPart()) {
                    String name = part.getName();
                    String value = IOStreamConvertor.replaceSpecialStr(part.getValue());
                    if (!"userName".equals(name)) continue;
                    userName = value;
                }
            }
            TELogFactory.getInterfaceLogger().info("NE:" + ne.toString() + " login notice" + "UserName=" + userName);
            if (userName.equals(ne.getCurUser())) {
                ne.setLogStatus(1);
                succNEList.add(ne);
                if (succNEList != null && !succNEList.isEmpty()) {
                    TEDevicePackageUpload devPkgLoader = TEDevicePackageUpload.getInstance();
                    devPkgLoader.devicePakageUpload(succNEList, new TENELdDevPkgNoticeReceiver());
                }
            }
        }
    }
}

