/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEDevicePackageUpload;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENELdDevPkgNoticeReceiver;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TEWarningScreenData;
import com.huawei.nglct.nelist.pnp.TEUploadPNPFileMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.security.TEFetchMac;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashMap;

public class TELoginNEBean
implements TENEListInterface {
    private boolean allSuccess = true;
    private boolean allFailed = true;
    private static final int LOAD_FILE_FROM_NE = 2;
    private static final int LOAD_FROM_DEV = 1;
    private static final int LOAD_FROM_LOCAL = 0;
    private TELogInfo loginfo = new TELogInfo();

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        Datainterface rtnDatainterface = new Datainterface();
        BussinessParams rtnBParams = new BussinessParams();
        ArrayList<TENE> succNEList = new ArrayList<TENE>();
        HashMap<String, TEWarningScreenData> warningScreenMap = new HashMap<String, TEWarningScreenData>();
        int neID = 0;
        String userName = null;
        byte[] userPassword = null;
        int forceLogin = -1;
        RowParams[] rowParamsArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamsArr.length;
        for (int i = 0; i < len; ++i) {
            for (Param tmpParam : rowParamsArr[i].getParam()) {
                if (tmpParam.getName().equals("neID")) {
                    neID = new Integer(tmpParam.getValue());
                    continue;
                }
                if (tmpParam.getName().equals("userName")) {
                    userName = tmpParam.getValue();
                    continue;
                }
                if (tmpParam.getName().equals("userPassword")) {
                    userPassword = EncryptUtils.decrypt(tmpParam.getValue());
                    continue;
                }
                if (!tmpParam.getName().equals("forceLogin")) continue;
                forceLogin = new Integer(tmpParam.getValue());
            }
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            TEResourceUtil res = null;
            StringBuffer filePath = new StringBuffer();
            filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("funcdesres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            res = TEResourceUtil.getInstance(filePath.toString());
            this.loginfo.setOperateName(res.getString(subFunc.getDes()));
            this.loginfo.setUserName("admin");
            this.loginfo.setLocation(ipAddress);
            this.loginfo.setOperateObject(ne.getNEName());
            this.loginfo.setCmdID(subFunc.getCode());
            int retCode = ne.login(userName, userPassword, forceLogin);
            if (retCode != 0) {
                this.allSuccess = false;
                RowParams rowParam = new RowParams();
                RowErrors rowErr = new RowErrors();
                Param errParam = new Param();
                errParam.setName("neID");
                errParam.setValue(String.valueOf(neID));
                rowErr.addParam(errParam);
                errParam = new Param();
                errParam.setName("neIDStr");
                errParam.setValue(ne.getNEName());
                rowErr.addParam(errParam);
                rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neID, retCode));
                rowParam.addRowErrors(rowErr);
                rtnBParams.addRowParams(rowParam);
                this.loginfo.setResult(2);
                this.loginfo.setErrCode(retCode);
                this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(neID, retCode));
                this.loginfo.setOperateDesc(res.getString("NE_LOGIN") + " " + res.getString("USERNAME") + userName + res.getString("ERRORCODE") + retCode + " " + res.getString("ERRORINFO") + TEErrorResourceUtil.getErrCodeResWithDot(neID, retCode));
                TELogMgr.writeLog(this.loginfo);
            } else {
                this.allFailed = false;
                ne.queryNEAttribute();
                succNEList.add(ne);
                if (TESysManagerBean.getInstance().getSysStauts() == TESysManagerConstants.SYS_SINGLE_STATUS) {
                    TEWarningScreenData waringInfoData = new TEWarningScreenData(ne.getNEName(), TELoginNEBean.queryWarningScreenInfo(ne.getNEID()));
                    warningScreenMap.put(String.valueOf(ne.getNEID()), waringInfoData);
                    this.setNMInfoToNE(ne.getNEID());
                }
                this.loginfo.setResult(0);
                this.loginfo.setErrCode(retCode);
                this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(neID, retCode));
                this.loginfo.setOperateDesc(res.getString("NE_LOGIN") + " " + res.getString("USERNAME") + userName);
                TELogMgr.writeLog(this.loginfo);
            }
            TEResourceManager.addNeListInfoNENode(TENEListMgr.NELIST_PATH, ne, true);
        }
        if (succNEList != null) {
            int succNeid;
            int uploadtype = new Integer(TESysManagerBean.getInstance().getProperty("uploadtype"));
            if (uploadtype == 0) {
                int len2 = succNEList.size();
                for (int i = 0; i < len2; ++i) {
                    succNeid = ((TENE)succNEList.get(i)).getNEID();
                    new TENELdDevPkgNoticeReceiver().handleNotice(succNeid);
                }
            } else if (uploadtype == 1) {
                TEDevicePackageUpload devPkgLoader = TEDevicePackageUpload.getInstance();
                devPkgLoader.devicePakageUpload(succNEList, new TENELdDevPkgNoticeReceiver());
            } else if (uploadtype == 2) {
                boolean isSucc = false;
                int len3 = succNEList.size();
                for (int i = 0; i < len3; ++i) {
                    succNeid = ((TENE)succNEList.get(i)).getNEID();
                    new TENELdDevPkgNoticeReceiver().handleNotice(succNeid);
                    int uploadResult = TEUploadPNPFileMgr.getInstance().uploadPNPFile(succNeid);
                    if (isSucc) continue;
                    isSucc = uploadResult == 0;
                }
                if (isSucc) {
                    RowParams tipsRowParam = new RowParams();
                    tipsRowParam.addParam("isPNPUpdate", "true");
                    rtnBParams.addRowParams(tipsRowParam);
                }
            }
        }
        ErrorMessage bigErr = this.allSuccess ? TEErrorResourceUtil.getErrorMessage(0) : (this.allFailed ? TEErrorResourceUtil.getErrorMessage(2) : TEErrorResourceUtil.getErrorMessage(1));
        rtnDatainterface.setBussinessParams(rtnBParams);
        rtnDatainterface.setErrorMessage(bigErr);
        TELoginNEBean.addWarningScreenParams(rtnDatainterface, warningScreenMap);
        EncryptUtils.clearByte(userPassword);
        return rtnDatainterface;
    }

    public static void addWarningScreenParams(Datainterface rtnDatainterface, HashMap warningScreenMap) {
        RowParams aRowParam = null;
        for (TEWarningScreenData waringInfoData : warningScreenMap.values()) {
            aRowParam = new RowParams();
            aRowParam.addParam("nename", waringInfoData.getNeName());
            aRowParam.addParam("wsinfo", waringInfoData.getWarningScreenInfo());
            rtnDatainterface.getBussinessParams().addRowParams(aRowParam);
        }
    }

    public static String queryWarningScreenInfo(int neID) {
        try {
            Operation aOperation;
            Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_SM_GET_WARNSCR_V01");
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            int result = TENECommMgr.getInstance().sendCommand((int)neID, operationList, (int)15).retCode;
            if (result == 0 && (aOperation = (Operation)operationList.get(0)).getOutput()[0].getFault()[0].getCode().equals(String.valueOf(0))) {
                TEDataConverter.handleSpecialStr(aOperation);
                return aOperation.getOutput(0).getPartValue("wsinfo");
            }
        }
        catch (Exception e) {
            return "";
        }
        return "";
    }

    private void setNMInfoToNE(int neID) {
        Operation oper = TECreateObjectFactory.getOperation(neID, "NSCMD_SM_LOGIN_OPERATORINFO");
        if (null != oper) {
            this.getNMInfo(oper);
            ArrayList<Operation> operationList = new ArrayList<Operation>();
            operationList.add(oper);
            TENECommMgr.getInstance().sendMessage(neID, operationList, null, 10);
        }
    }

    private void getNMInfo(Operation oper) {
        TEFetchMac fetchMac = new TEFetchMac();
        String hostName = fetchMac.getHostName();
        String mac = fetchMac.getMac()[0];
        String ipAddr = fetchMac.getIP();
        Input tempInput = oper.getInput();
        tempInput.setPartValue("ipAddr", ipAddr);
        tempInput.setPartValue("macAddr", mac);
        tempInput.setPartValue("infoLength", String.valueOf(hostName.length()));
        tempInput.setPartValue("info", hostName);
        TELogFactory.getNormalLogger().debug("Set NM Info.IP:" + ipAddr + ",MAC:" + mac + ",Host Name:" + hostName);
    }
}

