/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEModifyNEIDData;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEBackUpParams;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import gnu.trove.TIntArrayList;

public class TEGetNEListBean
implements TENEListInterface {
    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        TENEListMgr neListMgr = TENEListMgr.getInstance();
        TIntArrayList neIDList = neListMgr.getNEIDList();
        Datainterface datainterface = new Datainterface();
        BussinessParams bParams = new BussinessParams();
        datainterface.setBussinessParams(bParams);
        datainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage(0));
        int size = neIDList.size();
        for (int i = 0; i < size; ++i) {
            try {
                RowParams tempRowParams = new RowParams();
                Param tempParam = null;
                int tNEID = neIDList.get(i);
                TENE tempNE = neListMgr.getNE(tNEID);
                if (null == tempNE) {
                    TELogFactory.getNormalLogger().error("NE is continued, NEID is" + tNEID);
                    continue;
                }
                int neType = tempNE.getNEType();
                String hostVersion = tempNE.getHostVersion();
                tempParam = new Param();
                tempParam.setName("neID");
                tempParam.setValue(String.valueOf(tempNE.getNEID()));
                tempRowParams.addParam(tempParam);
                tempParam = new Param();
                tempParam.setName("realNEID");
                tempParam.setValue(String.valueOf(tempNE.getRealNEID()));
                tempRowParams.addParam(tempParam);
                tempParam = new Param();
                tempParam.setName("neGateWay");
                tempParam.setValue(String.valueOf(tempNE.getNEGateWay()));
                tempRowParams.addParam(tempParam);
                if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
                    tempParam = new Param();
                    tempParam.setName("neGWType");
                    tempParam.setValue(String.valueOf(tempNE.getNEGWType()));
                    tempRowParams.addParam(tempParam);
                    tempParam = new Param();
                    tempParam.setName("neGWAddress");
                    if (tempNE.getNEGWType() == 3) {
                        tempParam.setValue("COM" + tempNE.getPort());
                    } else {
                        tempParam.setValue(tempNE.getNEGWAddress());
                    }
                    tempRowParams.addParam(tempParam);
                }
                tempParam = new Param();
                tempParam.setName("communicateStatus");
                tempParam.setValue(String.valueOf(tempNE.getComStarus()));
                tempRowParams.addParam(tempParam);
                tempParam = new Param();
                tempParam.setName("logStatus");
                int logStatus = tempNE.getLogStatus();
                int commStatus = tempNE.getComStarus();
                if (TENEModifyNEIDData.getInstance().contions(tempNE.getNEID())) {
                    int oldState = TENEModifyNEIDData.getInstance().getNeCurrState(tempNE.getNEID());
                    if (commStatus == 0) {
                        logStatus = 2;
                        TENEModifyNEIDData.getInstance().setNeCurrState(tempNE.getNEID(), 0);
                    } else if (logStatus == 1 && oldState == 0) {
                        TENEModifyNEIDData.getInstance().remove(tempNE.getNEID());
                    }
                }
                tempParam.setValue(String.valueOf(logStatus));
                tempRowParams.addParam(tempParam);
                tempParam = new Param();
                tempParam.setName("neTopAlmLevel");
                tempParam.setValue(String.valueOf(tempNE.getCurTopLevelAlm(-1)));
                tempRowParams.addParam(tempParam);
                String nename = tempNE.getNEName();
                tempParam = new Param();
                tempParam.setName("neName");
                tempParam.setValue(nename);
                tempRowParams.addParam(tempParam);
                String devtype = tempNE.getDeviceType();
                tempParam = new Param();
                tempParam.setName("deviceType");
                if (devtype == null || devtype.equalsIgnoreCase("-1")) {
                    tempParam.setValue("---");
                } else {
                    tempParam.setValue(devtype);
                }
                tempRowParams.addParam(tempParam);
                tempRowParams.addParam("autoBackupToCF", TENEBackUpParams.isSupportAutoBackupToCF(tNEID, neType, hostVersion));
                String[] strBackupCF = TENEBackUpParams.isSupportBackupToCF(tNEID, neType, hostVersion);
                tempRowParams.addParam("backupToCF", strBackupCF[0]);
                tempRowParams.addParam("CFMode", strBackupCF[1]);
                tempRowParams.addParam("CFBefore", strBackupCF[2]);
                tempRowParams.addParam("CFNew", strBackupCF[3]);
                String[] strBackupSCC = TENEBackUpParams.isSupportBackupToSCC(tNEID, neType, hostVersion);
                tempRowParams.addParam("backupToSCC", strBackupSCC[0]);
                tempRowParams.addParam("SCCMode", strBackupSCC[1]);
                tempRowParams.addParam("restoreToNe", TENEBackUpParams.isSupportRestoreNEDatabase(tNEID, neType, hostVersion));
                tempRowParams.addParam("modifyNeID", TENEBackUpParams.isSupportModifyNeID(tNEID, neType, tempNE.getIsTL1OrQX(), hostVersion));
                tempRowParams.addParam("downloadConfig", TENEBackUpParams.isSupportDownloadConfig(tNEID, neType, hostVersion));
                tempRowParams.addParam("switchtoMMLMode", String.valueOf(TESpecialAttrMgr.getInstance().isNESupport(tNEID, "TE_FUNC_COMMU_DCCACCESSCTRL", "DCCACCESSCTRL_ATTR_SUPPORT_USB_ACC")));
                String neConnectType = String.valueOf(tempNE.getIsTL1OrQX());
                tempParam = new Param();
                tempParam.setName("neConnectType");
                tempParam.setValue(neConnectType);
                tempRowParams.addParam(tempParam);
                tempParam = new Param();
                tempParam.setName("issupportglobal");
                tempParam.setValue(String.valueOf(tempNE.isSupportGlobal()));
                tempRowParams.addParam(tempParam);
                String neglobalsign = "-1";
                if (tempNE.getLogStatus() == 1) {
                    String sysLangyage;
                    neglobalsign = !tempNE.getNeGlobalSign().equals("0") ? new Integer(tempNE.getNeGlobalSign()).toString() : ((sysLangyage = TESysManagerBean.getInstance().getlanguage()).equals("zh") ? "1" : "2");
                }
                tempParam = new Param();
                tempParam.setName("language");
                tempParam.setValue(neglobalsign);
                tempRowParams.addParam(tempParam);
                String neVersion = tempNE.getHostVersion();
                tempParam = new Param();
                tempParam.setName("neVersion");
                tempParam.setValue(neVersion);
                tempRowParams.addParam(tempParam);
                bParams.addRowParams(tempRowParams);
                continue;
            }
            catch (Exception ex) {
                TELogFactory.getNormalLogger().error("Get NEList info exception!", (Throwable)ex);
            }
        }
        return datainterface;
    }
}

