/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENELoadDevPkgNoticeReceiver;
import com.huawei.nglct.nelist.TEThreadPool;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarInputStream;
import java.util.zip.Adler32;
import java.util.zip.CheckedInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.slf4j.Logger;

public class TEDevicePackageUpload {
    private static TEDevicePackageUpload instance = null;
    private static final String PAKAGE_PATH = TEResourceManager.getPath() + File.separator + TEPathManager.PACKAGE_PATH;
    private TEThreadPool pool = TEThreadPool.newInstance();
    private Logger log = TELogFactory.getNormalLogger();

    private TEDevicePackageUpload() {
    }

    public static synchronized TEDevicePackageUpload getInstance() {
        if (null == instance) {
            instance = new TEDevicePackageUpload();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList devicePakageUpload(ArrayList neidList, TENELoadDevPkgNoticeReceiver handle) {
        TEDevicePackageUpload tEDevicePackageUpload = this;
        synchronized (tEDevicePackageUpload) {
            if (null != neidList && neidList.size() > 0) {
                HashMap neversionMap = new HashMap();
                HashMap repeatneMap = new HashMap();
                this.hasRequireUpload(neversionMap, repeatneMap, neidList, handle);
                if (null != neversionMap && !neversionMap.isEmpty()) {
                    Thread uploadpkgRunnable2 = new Thread(new uploadpkgRunnable(neversionMap, repeatneMap, handle));
                    uploadpkgRunnable2.start();
                }
            }
        }
        return neidList;
    }

    private void hasRequireUpload(HashMap neversionMap, HashMap repeatneMap, ArrayList neidlist, TENELoadDevPkgNoticeReceiver handle) {
        TENE neObj = null;
        String version = "";
        File file = new File(PAKAGE_PATH);
        File[] fileArr = file.listFiles();
        HashSet<String> fileset = new HashSet<String>();
        for (int filelen = fileArr.length - 1; filelen >= 0; --filelen) {
            if (!fileArr[filelen].isDirectory()) continue;
            fileset.add(fileArr[filelen].getName());
        }
        for (int i = neidlist.size() - 1; i >= 0; --i) {
            neObj = (TENE)neidlist.get(i);
            int neid = neObj.getNEID();
            version = neObj.getDevPkgVersion();
            if (!neversionMap.containsValue(version)) {
                if (fileset.contains(version)) {
                    this.pool.start(new TEHandleNoticeRunner(neid, handle));
                    neidlist.remove(i);
                    continue;
                }
                neversionMap.put(new Integer(neid), version);
                continue;
            }
            repeatneMap.put(new Integer(neid), version);
        }
    }

    private boolean unJarFile(String fileName, String unJarFilePath) {
        boolean flag = true;
        FileInputStream fi = null;
        String zeName = "";
        String filename = "";
        String filepath = "";
        try {
            ZipEntry ze;
            fi = new FileInputStream(fileName);
            CheckedInputStream csumi = new CheckedInputStream(fi, new Adler32());
            JarInputStream in2 = new JarInputStream(new BufferedInputStream(csumi));
            while ((ze = ((ZipInputStream)in2).getNextEntry()) != null) {
                int x;
                zeName = ze.getName();
                filename = unJarFilePath + File.separator + zeName;
                if (ze.isDirectory()) {
                    File dir = new File(filename);
                    dir.mkdir();
                    continue;
                }
                FileOutputStream file = new FileOutputStream(filename);
                while ((x = in2.read()) != -1) {
                    file.write(x);
                }
                file.close();
                if (!this.hasUnJarFile(filename)) continue;
                File jarfile = new File(filename);
                filepath = jarfile.getParentFile().getPath();
                if (!this.unJarFile(filename, filepath)) {
                    flag = false;
                    this.deleteFile(filepath);
                    continue;
                }
                File f = new File(filename);
                f.delete();
            }
            in2.close();
        }
        catch (Exception e) {
            flag = false;
            TELogFactory.getNormalLogger().error("UnZip file fail!", (Throwable)e);
            this.deleteFile(filename);
        }
        return flag;
    }

    private boolean hasUnJarFile(String fileName) {
        boolean flag = false;
        File file = new File(fileName);
        String lastProfix = fileName.substring(fileName.lastIndexOf(".") + 1);
        String parent = file.getParentFile().getName();
        if (lastProfix.equals("jar") && !parent.equals("path") && !parent.equals("lib")) {
            flag = true;
        }
        return flag;
    }

    private void deleteFile(String filePath) {
        File file = new File(filePath);
        if (file.isDirectory()) {
            File[] filelist = file.listFiles();
            if (null != filelist && filelist.length > 0) {
                for (int i = filelist.length - 1; i >= 0; --i) {
                    this.deleteFile(filelist[i].getPath());
                }
            }
            file.delete();
        } else {
            file.delete();
        }
    }

    static class TEHandleNoticeRunner
    implements Runnable {
        private int neid;
        private TENELoadDevPkgNoticeReceiver receviver;

        public TEHandleNoticeRunner(int neid, TENELoadDevPkgNoticeReceiver receviver) {
            this.neid = neid;
            this.receviver = receviver;
        }

        @Override
        public void run() {
            this.receviver.handleNotice(this.neid);
        }
    }

    private class uploadpkgRunnable
    implements Runnable {
        private TENELoadDevPkgNoticeReceiver receviver;
        private HashMap neversionMap;
        private HashMap repeatneMap;

        public uploadpkgRunnable(HashMap neversionMap, HashMap repeatneMap, TENELoadDevPkgNoticeReceiver receviver) {
            this.neversionMap = neversionMap;
            this.repeatneMap = repeatneMap;
            this.receviver = receviver;
        }

        @Override
        public void run() {
            String uploadFileName = null;
            for (Object obj : this.neversionMap.keySet()) {
                int neid = (Integer)obj;
                String host = "129.9.0.101";
                int bid = 11;
                String fileName = "/ofs1/hwx/ne_05370410v01.jar";
                try {
                    InputStream instream = TEDevicePackageUpload.class.getClassLoader().getResourceAsStream("neconfig.ini");
                    Properties property = new Properties();
                    property.load(instream);
                    host = property.getProperty("host");
                    bid = Integer.parseInt(property.getProperty("bid"));
                    fileName = property.getProperty("fileName");
                }
                catch (Exception ex) {
                    TELogFactory.getNormalLogger().error("TEDevicePackageUpload.run() fail!", (Throwable)ex);
                }
                try {
                    TEDevicePackageUpload.this.log.info("call NetUtil.UploadFile upload file:" + fileName);
                    uploadFileName = "";
                    if (null == uploadFileName) {
                        throw new Exception("Upload file Fail!!");
                    }
                }
                catch (Exception e) {
                    TEDevicePackageUpload.this.log.error("Upload File fail :\n", (Throwable)e);
                    continue;
                }
                TEDevicePackageUpload.this.log.info("call unJarFile function with param:(uploadFileName:" + uploadFileName + " unJarFilePath:" + PAKAGE_PATH + ")");
                if (!TEDevicePackageUpload.this.unJarFile(uploadFileName, PAKAGE_PATH)) continue;
                TEDevicePackageUpload.this.deleteFile(uploadFileName);
                TEDevicePackageUpload.this.pool.start(new TEHandleNoticeRunner(neid, this.receviver));
                Iterator iterator2 = this.repeatneMap.keySet().iterator();
                while (iterator2.hasNext()) {
                    Object tmpObj = iterator2.next();
                    int tmpneid = (Integer)tmpObj;
                    if (this.repeatneMap.get(tmpObj).equals(this.neversionMap.get(obj))) {
                        TEDevicePackageUpload.this.pool.start(new TEHandleNoticeRunner(tmpneid, this.receviver));
                    }
                    iterator2.remove();
                }
            }
        }
    }
}

