/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEPort;
import com.huawei.nglct.nelist.model.TESubBoard;
import com.huawei.nglct.po.embeddednemgrmo.TESubCircuitPackMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEBoard
implements Cloneable,
Comparable {
    private static final int HASHCODE_MULTIPLIED = 37;
    private static final int HASHCODE_INITVALUE = 17;
    private static final Logger normalLogger = TELogFactory.getNormalLogger();
    private int neID = -1;
    private int slotID = -1;
    private int boardType = -1;
    private int boardLoop = -1;
    private int boardPG = -1;
    private int state = 255;
    private int boardMode = -1;
    private String boardName = null;
    private int topAlmLevel = -1;
    private ArrayList subBoardList = new ArrayList();
    private byte dpsStatus = (byte)-1;

    public TEBoard(int neid, int slotID, int boardType) {
        this.neID = neid;
        this.slotID = slotID;
        this.boardType = boardType;
    }

    public TEBoard(int neid, int slotID, int boardType, int boardMode) {
        this.neID = neid;
        this.slotID = slotID;
        this.boardType = boardType;
        this.boardMode = boardMode;
    }

    public int getTopAlmLevel() {
        return this.topAlmLevel;
    }

    public void setTopAlmLevel(int topAlmLevel) {
        this.topAlmLevel = topAlmLevel;
    }

    public TEBoard(int neID, int slotID, int boardType, String boardName) {
        this(neID, slotID, boardType);
        this.boardName = boardName;
    }

    public int getNEID() {
        return this.neID;
    }

    public void setNEID(int neID) {
        this.neID = neID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public int getBoardType() {
        return this.boardType;
    }

    public int getBoardLoop() {
        return this.boardLoop;
    }

    public int getBoardPG() {
        return this.boardPG;
    }

    public List getSubBoardList() {
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            ArrayList<TESubBoard> tempSubBoardList = new ArrayList<TESubBoard>();
            TEDaoOperationResult dbresult = null;
            try {
                TENE ne = TENEListMgr.getInstance().getNE(this.neID);
                if (null == ne) {
                    TELogFactory.getNormalLogger().error("The ne is not exist! neID->" + this.neID);
                    return tempSubBoardList;
                }
                dbresult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll(new int[]{this.neID, this.slotID}, TESubCircuitPackMOPO.class) : TECommonDaoService.findAll_NonLock(new int[]{this.neID, this.slotID}, TESubCircuitPackMOPO.class);
                if (null == dbresult) {
                    return tempSubBoardList;
                }
                int result = dbresult.getResult();
                if (0 != result) {
                    normalLogger.error("Get SubBoard fail! result->" + result);
                }
                List<Object> subCPMOPOs = dbresult.getData();
                for (Object obj : subCPMOPOs) {
                    TESubCircuitPackMOPO subCPMOPO = (TESubCircuitPackMOPO)obj;
                    TESubBoard subCP = new TESubBoard(this, this.neID, (int)subCPMOPO.getSlotID(), subCPMOPO.getTypeID());
                    tempSubBoardList.add(subCP);
                }
                normalLogger.info("tempSubBoardList.size->" + tempSubBoardList.size());
            }
            catch (Exception e) {
                normalLogger.error(e.getMessage());
            }
            return tempSubBoardList;
        }
        return this.subBoardList;
    }

    public String getBoardName() {
        if (this.boardName == null) {
            StringBuffer strbuff = new StringBuffer();
            String typeName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neID, this.boardType);
            strbuff.append(typeName);
            this.boardName = strbuff.toString();
        }
        return this.boardName;
    }

    public String getBoardTypeName() {
        return TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neID, this.boardType);
    }

    public void setSubBoardList(ArrayList theSubBoardList) {
        this.subBoardList = theSubBoardList;
    }

    public void addSubBoardList(List<TESubBoard> subBoardList) {
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            return;
        }
        if (subBoardList != null) {
            this.subBoardList.addAll(subBoardList);
        }
    }

    public void addSubBoard(TESubBoard subBoard) {
        if (TESysManagerConstants.SYS_INTEGRATION_STATUS == TESysManagerBean.getInstance().getSysStauts()) {
            return;
        }
        if (subBoard != null) {
            this.subBoardList.add(subBoard);
        }
    }

    public void removeSubBoardList(ArrayList subBoardList) {
        if (subBoardList != null) {
            this.subBoardList.removeAll(subBoardList);
        }
    }

    public void removeSubBoard(TESubBoard subBoard) {
        if (subBoard != null) {
            this.subBoardList.remove(subBoard);
        }
    }

    public int getBoardMode() {
        return this.boardMode;
    }

    public void setBoardMode(int boardMode) {
        this.boardMode = boardMode;
    }

    public boolean isWDMBoard() {
        if (TEConfigurationDataMgr.getInstance().isSCCBoard(this.neID, this.boardType)) {
            return false;
        }
        return TEConfigurationDataMgr.getInstance().isWDMBoardType(this.neID, this.boardType);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.neID;
        result = 37 * result + this.slotID;
        result = 37 * result + this.boardType;
        return result;
    }

    public int compareTo(Object obj) {
        if (obj == null) {
            return -1;
        }
        TEBoard compareboard = (TEBoard)obj;
        int neidDiff = this.neID - compareboard.getNEID();
        if (neidDiff != 0) {
            return neidDiff;
        }
        int slotDiff = this.slotID - compareboard.getSlotID();
        if (slotDiff != 0) {
            return slotDiff;
        }
        return this.boardType - compareboard.boardType;
    }

    public Object clone() {
        try {
            TEBoard result = (TEBoard)super.clone();
            result.neID = this.neID;
            result.slotID = this.slotID;
            result.boardType = this.boardType;
            result.boardName = this.boardName;
            result.boardLoop = this.boardLoop;
            result.boardPG = this.boardPG;
            result.state = this.state;
            result.topAlmLevel = this.topAlmLevel;
            result.subBoardList = (ArrayList)this.subBoardList.clone();
            int size = this.subBoardList.size();
            for (int i = 0; i < size; ++i) {
                result.subBoardList.set(i, ((TESubBoard)this.subBoardList.get(i)).clone());
            }
            return result;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    public String toString() {
        return this.getBoardName();
    }

    public ArrayList getPortList(int porttype) {
        ArrayList returnlist = (ArrayList)TEConfigurationDataMgr.getInstance().getPortList(this.neID, this.slotID, porttype);
        return returnlist;
    }

    public TEPort getPort(int portno) {
        TEPort port = TEConfigurationDataMgr.getInstance().getPort(this.neID, this.slotID, portno);
        return port;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public void setBoardType(int boardType) {
        this.boardType = boardType;
    }

    public void setBoardLoop(int boardLoop) {
        this.boardLoop = boardLoop;
    }

    public void setBoardPG(int boardPG) {
        this.boardPG = boardPG;
    }

    public byte getDpsStatus() {
        return this.dpsStatus;
    }

    public void setDpsStatus(byte dpsStatus) {
        this.boardPG = dpsStatus;
        this.dpsStatus = dpsStatus;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TEBoard)) {
            return false;
        }
        TEBoard board = (TEBoard)obj;
        return board.getSlotID() == this.slotID && board.getBoardType() == this.boardType && board.getSubBoardList().size() == this.getSubBoardList().size();
    }

    public int getState() {
        return this.state;
    }

    public void setState(int state) {
        this.state = state;
    }
}

