/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.datamgr.TENEConfigurationDataMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class TEBeforeBackupToCFbean
implements TENEListInterface {
    private static final List<Integer> BOARD_TYPE_LIST = new ArrayList<Integer>();
    private Datainterface outputData = null;

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        this.outputData = new Datainterface();
        BussinessParams returnBParams = new BussinessParams();
        ErrorMessage bigErr = TEErrorResourceUtil.getErrorMessage(0);
        this.outputData.setBussinessParams(returnBParams);
        this.outputData.setErrorMessage(bigErr);
        RowParams[] rows = inputData.getBussinessParams().getRowParams();
        String[] neids = null;
        if (null != rows[0] && null != rows[0].getParam("neids").getValue()) {
            neids = rows[0].getParam("neids").getValue().split(",");
        }
        if (null == neids || neids.length == 0) {
            return this.outputData;
        }
        int neid = 0;
        TENE ne = null;
        String nename = "";
        int slotid = 0;
        String boardname = "";
        Vector<TEBoard> bdList = null;
        RowParams row = null;
        for (int i = 0; i < neids.length; ++i) {
            neid = Integer.valueOf(neids[i]);
            ne = TENEListMgr.getInstance().getNE(neid);
            if (!TENEConfigurationDataMgr.getInstance().isRTNDomainNE(neid)) continue;
            bdList = this.getOnBoardList(ne, BOARD_TYPE_LIST);
            nename = ne.getNEName();
            for (int j = bdList.size() - 1; j >= 0; --j) {
                row = new RowParams();
                slotid = bdList.get(j).getSlotID();
                boardname = bdList.get(j).getBoardName();
                row.addParam("neid", neids[i]);
                row.addParam("nename", nename);
                row.addParam("slotid", "" + slotid);
                row.addParam("boardname", boardname);
                returnBParams.addRowParams(row);
            }
        }
        return this.outputData;
    }

    public Vector<TEBoard> getOnBoardList(TENE ne) {
        Vector<TEBoard> onBoardList = new Vector<TEBoard>();
        Vector boardList = ne.getBoardList();
        Vector phyBoardList = ne.getPhyBoardList();
        int boardType = 0;
        int slotid = 0;
        block0: for (int i = boardList.size() - 1; i >= 0; --i) {
            TEBoard board = (TEBoard)boardList.get(i);
            boardType = board.getBoardType();
            slotid = board.getSlotID();
            for (int j = phyBoardList.size() - 1; j >= 0; --j) {
                TEBoard phyBoard = (TEBoard)boardList.get(i);
                if (slotid != phyBoard.getSlotID() || boardType != phyBoard.getBoardType()) continue;
                onBoardList.add(board);
                continue block0;
            }
        }
        return onBoardList;
    }

    public Vector<TEBoard> getOnBoardList(TENE ne, int bdType) {
        Vector<TEBoard> onBoardList = new Vector<TEBoard>();
        Vector boardList = ne.getBoardList();
        Vector phyBoardList = ne.getPhyBoardList();
        int boardType = 0;
        int slotid = 0;
        block0: for (int i = boardList.size() - 1; i >= 0; --i) {
            TEBoard board = (TEBoard)boardList.get(i);
            boardType = board.getBoardType();
            if (bdType != boardType) continue;
            slotid = board.getSlotID();
            for (int j = phyBoardList.size() - 1; j >= 0; --j) {
                TEBoard phyBoard = (TEBoard)boardList.get(i);
                if (slotid != phyBoard.getSlotID() || boardType != phyBoard.getBoardType()) continue;
                onBoardList.add(board);
                continue block0;
            }
        }
        return onBoardList;
    }

    public Vector<TEBoard> getOnBoardList(TENE ne, List<Integer> bdTypelist) {
        Vector<TEBoard> onBoardList = new Vector<TEBoard>();
        Vector boardList = ne.getBoardList();
        Vector phyBoardList = ne.getPhyBoardList();
        int boardType = 0;
        int slotid = 0;
        block0: for (int i = boardList.size() - 1; i >= 0; --i) {
            TEBoard board = (TEBoard)boardList.get(i);
            boardType = board.getBoardType();
            if (!bdTypelist.contains(boardType) && !TEConfigurationDataMgr.getInstance().isSCCBoard(ne.neID, boardType)) continue;
            slotid = board.getSlotID();
            for (int j = phyBoardList.size() - 1; j >= 0; --j) {
                TEBoard phyBoard = (TEBoard)phyBoardList.get(j);
                if (slotid != phyBoard.getSlotID() || boardType != phyBoard.getBoardType()) continue;
                onBoardList.add(board);
                continue block0;
            }
        }
        return onBoardList;
    }

    static {
        BOARD_TYPE_LIST.add(1410);
        BOARD_TYPE_LIST.add(1411);
        BOARD_TYPE_LIST.add(1607);
        BOARD_TYPE_LIST.add(1608);
        BOARD_TYPE_LIST.add(2089);
        BOARD_TYPE_LIST.add(2090);
        BOARD_TYPE_LIST.add(2091);
        BOARD_TYPE_LIST.add(2092);
        BOARD_TYPE_LIST.add(1412);
        BOARD_TYPE_LIST.add(2077);
        BOARD_TYPE_LIST.add(2078);
        BOARD_TYPE_LIST.add(2263);
        BOARD_TYPE_LIST.add(2409);
        BOARD_TYPE_LIST.add(2270);
        BOARD_TYPE_LIST.add(2453);
        BOARD_TYPE_LIST.add(2548);
        BOARD_TYPE_LIST.add(2470);
        BOARD_TYPE_LIST.add(2546);
    }
}

