/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.gencfg.TimeZoneDateBean;
import com.huawei.nglct.nelist.TEAlarmPara;
import com.huawei.nglct.nelist.TENEListConstant;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.alarm.TEAlarmMonObjID;
import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;

public class TEAlarm {
    private int evtSerialNum = -1;
    private int eqType = 1;
    private int alarmID = -1;
    private String alarmName = null;
    private int alarmType = -1;
    private int alarmLevel = 0;
    private int shelf = -1;
    private int slotID = -1;
    private int bdType = -1;
    private String bdName = null;
    private int port = -1;
    private String portName = "SDH";
    private int path = -1;
    private int funcBlock = -1;
    private String fbName = "";
    private int eventStatus = 0;
    private Calendar startTime = null;
    private Calendar endTime = null;
    private String almDetail = null;
    private String almReasion = null;
    private int[] almEventParam = new int[5];
    private String MonObject = "";
    private String almEventParamStr = "";
    private String alarmDetailHexStr = "";
    private static TimeZoneDateBean TimeProccessor = null;
    private static final int SLOTCONSTATNS = 100;
    private boolean isLongParam = false;
    private String asonString = "";
    public static final String ALARM_SOURCE_FILE = "res" + File.separator + "alarmsource_" + TENEListUtils.getLanguage() + ".ini";

    public TEAlarm() {
    }

    public TEAlarm(int evtSerialNum, int eqType, int alarmID, String alarmName, int alarmType, int alarmLevel, int shelf, int slotID, int bdType, String bdName, int port, String portName, int path, int funcBlock, String fbName, int eventStatus, Calendar startTime, String almDetail, String almReasion, int[] almEventParam) {
        this.evtSerialNum = evtSerialNum;
        this.eqType = eqType;
        this.alarmID = alarmID;
        this.alarmName = alarmName;
        this.alarmType = alarmType;
        this.alarmLevel = alarmLevel;
        this.shelf = shelf;
        this.slotID = slotID;
        this.bdType = bdType;
        this.bdName = bdName;
        this.port = port;
        this.portName = portName;
        this.path = path;
        this.funcBlock = funcBlock;
        this.fbName = fbName;
        this.eventStatus = eventStatus;
        this.startTime = startTime;
        this.almDetail = almDetail;
        this.almReasion = almReasion;
        int[] array = new int[almEventParam.length];
        System.arraycopy(almEventParam, 0, array, 0, almEventParam.length);
        this.almEventParam = array;
    }

    public TEAlarm(int evtSerialNum, int eqType, int alarmID, String alarmName, int alarmType, int alarmLevel, int shelf, int slotID, int bdType, String bdName, int port, String portName, int path, int funcBlock, String fbName, int eventStatus, Calendar startTime, Calendar endTime, String almDetail, String almReasion, int[] almEventParam) {
        this.evtSerialNum = evtSerialNum;
        this.eqType = eqType;
        this.alarmID = alarmID;
        this.alarmName = alarmName;
        this.alarmType = alarmType;
        this.alarmLevel = alarmLevel;
        this.shelf = shelf;
        this.slotID = slotID;
        this.bdType = bdType;
        this.bdName = bdName;
        this.port = port;
        this.portName = portName;
        this.path = path;
        this.funcBlock = funcBlock;
        this.fbName = fbName;
        this.eventStatus = eventStatus;
        this.startTime = startTime;
        this.endTime = endTime;
        this.almDetail = almDetail;
        this.almReasion = almReasion;
        int[] array = new int[almEventParam.length];
        System.arraycopy(almEventParam, 0, array, 0, almEventParam.length);
        this.almEventParam = array;
    }

    public void setAsonString(String asonString) {
        this.asonString = asonString;
    }

    public String getAsonString() {
        return this.asonString;
    }

    public void setEndTime(Calendar endTime) {
        this.endTime = endTime;
    }

    public Calendar getEndTime() {
        return this.endTime;
    }

    public void setEvtSerialNum(int evtSerialNum) {
        this.evtSerialNum = evtSerialNum;
    }

    public void setEqType(int eqType) {
        this.eqType = eqType;
    }

    public void setAlarmID(int alarmID) {
        this.alarmID = alarmID;
    }

    public void setAlarmName(String alarmName) {
        this.alarmName = alarmName;
    }

    public void setAlarmType(int alarmType) {
        this.alarmType = alarmType;
    }

    public void setAlarmLevel(int alarmLevel) {
        this.alarmLevel = alarmLevel;
    }

    public void setShelf(int shelf) {
        this.shelf = shelf;
    }

    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    public void setBdType(int bdType) {
        this.bdType = bdType;
    }

    public void setBdName(String bdName) {
        this.bdName = bdName;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setPortName(String portName) {
        this.portName = portName;
    }

    public void setPath(int path) {
        this.path = path;
    }

    public void setFuncBlock(int funcBlock) {
        this.funcBlock = funcBlock;
    }

    public void setEventStatus(int eventStatus) {
        this.eventStatus = eventStatus;
    }

    public void setStartTime(Calendar startTime) {
        this.startTime = startTime;
    }

    public void setAlmDetail(String almDetail) {
        this.almDetail = almDetail;
    }

    public void setAlmReasion(String almReasion) {
        this.almReasion = almReasion;
    }

    public void setAlmEventParam(int[] almEventParam) {
        int[] array = new int[5];
        System.arraycopy(almEventParam, 0, array, 0, almEventParam.length);
        this.almEventParam = array;
    }

    public int getAlarmID() {
        return this.alarmID;
    }

    public String getAlarmName() {
        if (this.alarmName == null) {
            return "";
        }
        return this.alarmName;
    }

    public int getAlarmType() {
        return this.alarmType;
    }

    public int getAlarmLevel() {
        return this.alarmLevel;
    }

    public Calendar getStartTime() {
        return this.startTime;
    }

    public int getEqType() {
        return this.eqType;
    }

    public int getShelf() {
        return this.shelf;
    }

    public int getSlotID() {
        return this.slotID;
    }

    public int getBdType() {
        return this.bdType;
    }

    public String getBdName() {
        if (this.bdName == null) {
            return "";
        }
        return this.bdName;
    }

    public int getPort() {
        return this.port;
    }

    public int getPath() {
        return this.path;
    }

    public int getFuncBlock() {
        return this.funcBlock;
    }

    public String getPortName() {
        if (this.portName == null) {
            return "";
        }
        return this.portName;
    }

    public int getEventStatus() {
        return this.eventStatus;
    }

    public int getEvtSerialNum() {
        return this.evtSerialNum;
    }

    public String getAlmDetail() {
        if (this.almDetail == null) {
            return "";
        }
        return this.almDetail;
    }

    public String getAlmReasion() {
        if (this.almReasion == null) {
            return "";
        }
        return this.almReasion;
    }

    public boolean getIsLongParam() {
        return this.isLongParam;
    }

    public void setIsLongParam(boolean isLongParam) {
        this.isLongParam = isLongParam;
    }

    public int[] getAlmEventParam() {
        int[] array = new int[this.almEventParam.length];
        System.arraycopy(this.almEventParam, 0, array, 0, this.almEventParam.length);
        return array;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TEAlarm)) {
            return false;
        }
        TEAlarm alm = (TEAlarm)obj;
        return alm.getEvtSerialNum() == this.evtSerialNum;
    }

    public int hashCode() {
        return this.evtSerialNum;
    }

    public String getFbName() {
        return this.fbName;
    }

    public void setFbName(String fbName) {
        this.fbName = fbName;
    }

    public String toString() {
        return "TEALarm (slotid:" + this.slotID + " port:" + this.port + " path:" + this.path + ")";
    }

    public String getMonObject() {
        return this.MonObject;
    }

    public void setMonObject(String monObject) {
        this.MonObject = monObject;
    }

    public static void parseAlarmParam(TEAlarm alarm, int neID) {
        TEAlarmMonObjID tEAlarmMonObjID = new TEAlarmMonObjID();
        tEAlarmMonObjID.m_ulNEID = neID;
        tEAlarmMonObjID.m_usSlotID = alarm.getSlotID();
        tEAlarmMonObjID.m_usFBType = alarm.getFuncBlock();
        tEAlarmMonObjID.m_usPortID = alarm.getPort();
        tEAlarmMonObjID.m_usPathID = alarm.getPath();
        tEAlarmMonObjID.setAsonString(alarm.getAsonString());
        tEAlarmMonObjID.decPathID();
        alarm.MonObject = tEAlarmMonObjID.toString();
        StringBuffer buffer = new StringBuffer();
        int[] almEventParam = alarm.almEventParam;
        ArrayList alarmParaList = TENEListConstant.getInstance().getAlarmParaList();
        TEAlarmPara tEAlarmPara = null;
        int nIndex = 0;
        int length = almEventParam.length;
        for (int i = 0; i < length; ++i) {
            int para = almEventParam[i];
            if (para == -1 || para == 255) continue;
            nIndex = i + 1;
            if (alarm.alarmID == 121 || alarm.alarmID == 625) {
                if (alarm.isLongParam) {
                    nIndex = i;
                    para = almEventParam[0] * 100 + almEventParam[1];
                } else if (para > 32) {
                    para = para / 32 * 100 + para % 32;
                }
            }
            int size = alarmParaList.size();
            for (int j = 0; j < size; ++j) {
                tEAlarmPara = (TEAlarmPara)alarmParaList.get(j);
                if (alarm.alarmID != tEAlarmPara.getAeID() || nIndex != tEAlarmPara.getParaBit() && nIndex + 3 != tEAlarmPara.getParaBit()) continue;
                if (tEAlarmPara.getParaValue() == 255) {
                    buffer.append(tEAlarmPara.getParaReq()).append(para).append(" ");
                    continue;
                }
                if (almEventParam[i] != tEAlarmPara.getParaValue()) continue;
                buffer.append(tEAlarmPara.getParaReq()).append(" ");
            }
        }
        alarm.setAlmEventParamStr(buffer.toString());
        buffer = new StringBuffer();
        int paramSize = alarm.getAlmEventParam().length;
        for (int k = 0; k < paramSize; ++k) {
            int value = alarm.getAlmEventParam()[k];
            String eventParam = Integer.toHexString(value);
            String temp = "";
            if (eventParam.length() == 1) {
                temp = "0" + eventParam;
                buffer.append("0x" + temp + " ");
                continue;
            }
            buffer.append("0x" + eventParam + " ");
        }
        alarm.setalarmDetailHexStr(buffer.toString());
    }

    public static void iniTimeProccessor(TimeZoneDateBean TP) {
        TimeProccessor = TP;
    }

    public RowParams toRowParam() {
        RowParams row = new RowParams();
        Param param = new Param();
        param.setName("evtSerialNum");
        param.setValue(String.valueOf(this.evtSerialNum));
        row.addParam(param);
        param = new Param();
        param.setName("eqType");
        param.setValue(String.valueOf(this.eqType));
        row.addParam(param);
        param = new Param();
        param.setName("alarmID");
        param.setValue(String.valueOf(this.alarmID));
        row.addParam(param);
        param = new Param();
        param.setName("alarmName");
        param.setValue(this.getAlarmName());
        row.addParam(param);
        param = new Param();
        param.setName("alarmType");
        if (-1 == this.getAlarmType()) {
            param.setValue(TENEListUtils.getString("alarmType", ALARM_SOURCE_FILE));
        } else {
            param.setValue(TENEListUtils.getString("alarmType" + this.getAlarmType(), ALARM_SOURCE_FILE));
        }
        row.addParam(param);
        param = new Param();
        param.setName("level");
        param.setValue(this.getAlarmLevel() + "");
        row.addParam(param);
        param = new Param();
        param.setName("alarmLevel");
        if (-1 == this.getAlarmLevel()) {
            param.setValue(TENEListUtils.getString("alarmLevel", ALARM_SOURCE_FILE));
        } else {
            param.setValue(TENEListUtils.getString("alarmLevel" + this.getAlarmLevel(), ALARM_SOURCE_FILE));
        }
        row.addParam(param);
        param = new Param();
        param.setName("shelf");
        param.setValue(new Integer(this.getShelf()).toString());
        row.addParam(param);
        param = new Param();
        param.setName("monObj");
        param.setValue(this.getMonObject());
        row.addParam(param);
        param = new Param();
        param.setName("startTime");
        param.setValue(TimeProccessor.calendarToTime((Calendar)this.getStartTime().clone()));
        row.addParam(param);
        if (this.endTime != null) {
            param = new Param();
            param.setName("endTime");
            param.setValue(TimeProccessor.calendarToTime((Calendar)this.endTime.clone()));
            row.addParam(param);
        }
        param = new Param();
        param.setName("alarmdetailname");
        param.setValue(this.getAlmDetail());
        row.addParam(param);
        param = new Param();
        param.setName("almReasion");
        param.setValue(this.getAlmReasion());
        row.addParam(param);
        param = new Param();
        param.setName("alarmDetail");
        param.setValue(this.alarmDetailHexStr);
        row.addParam(param);
        param = new Param();
        param.setName("almEventParam");
        param.setValue(this.almEventParamStr);
        row.addParam(param);
        return row;
    }

    public RowParams toPrintRow() {
        RowParams row = new RowParams();
        Param param = new Param();
        param.setName("alarmName");
        param.setValue(this.getAlarmName());
        row.addParam(param);
        param = new Param();
        param.setName("alarmType");
        if (-1 == this.getAlarmType()) {
            param.setValue(TENEListUtils.getString("alarmType", ALARM_SOURCE_FILE));
        } else {
            param.setValue(TENEListUtils.getString("alarmType" + this.getAlarmType(), ALARM_SOURCE_FILE));
        }
        row.addParam(param);
        param = new Param();
        param.setName("alarmLevel");
        if (-1 == this.getAlarmLevel()) {
            param.setValue(TENEListUtils.getString("alarmLevel", ALARM_SOURCE_FILE));
        } else {
            param.setValue(TENEListUtils.getString("alarmLevel" + this.getAlarmLevel(), ALARM_SOURCE_FILE));
        }
        row.addParam(param);
        param = new Param();
        param.setName("monObj");
        param.setValue(this.MonObject);
        row.addParam(param);
        param = new Param();
        param.setName("startTime");
        param.setValue(TimeProccessor.calendarToTime((Calendar)this.getStartTime().clone()));
        row.addParam(param);
        if (this.endTime != null) {
            param = new Param();
            param.setName("endTime");
            param.setValue(TimeProccessor.calendarToTime((Calendar)this.getEndTime().clone()));
            row.addParam(param);
        }
        return row;
    }

    public String getalarmDetailHexStr() {
        return this.alarmDetailHexStr;
    }

    public void setalarmDetailHexStr(String alarmDetail) {
        this.alarmDetailHexStr = alarmDetail;
    }

    public String getAlmEventParamStr() {
        return this.almEventParamStr;
    }

    public void setAlmEventParamStr(String almEventParamStr) {
        this.almEventParamStr = almEventParamStr;
    }
}

