/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.common.functions.TECheckInputParam;
import com.huawei.nglct.nelist.TEDevicePackageUpload;
import com.huawei.nglct.nelist.TEGetUSBSerialPortAndBaudRate;
import com.huawei.nglct.nelist.TELoginNEBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENELdDevPkgNoticeReceiver;
import com.huawei.nglct.nelist.TENEListInterface;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.TEWarningScreenData;
import com.huawei.nglct.nelist.pnp.TEUploadPNPFileMgr;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import java.util.ArrayList;
import java.util.HashMap;

public class TEAddNEBean
implements TENEListInterface {
    private boolean allSuccess = true;
    private boolean allFailed = true;
    private ArrayList succNEList = new ArrayList();
    private HashMap warningScreenMap = new HashMap();
    private static final int LOAD_FROM_LOCAL = 0;
    private static final int LOAD_FROM_DEV = 1;
    private static final int LOAD_FILE_FROM_NE = 2;
    private TELogInfo loginfo = new TELogInfo();

    @Override
    public Datainterface subFuncProcessed(SubFunc subFunc, Datainterface inputData, String ipAddress) {
        TELogFactory.getNormalLogger().info("Begin to add ne,time:" + System.currentTimeMillis());
        if (null == inputData || null == inputData.getBussinessParams()) {
            Datainterface data = new Datainterface();
            ErrorMessage errorMessage = new ErrorMessage();
            errorMessage.setErrorcode("0");
            errorMessage.setErrorinfo("");
            data.setErrorMessage(errorMessage);
            return data;
        }
        RowParams[] rowParams = inputData.getBussinessParams().getRowParams();
        int neID = 0;
        int neGWType = 0;
        String neGWAddress = null;
        String port = null;
        String baudRate = null;
        String userName = null;
        byte[] userPassword = null;
        int forceLogin = -1;
        Datainterface rtnDatainterface = new Datainterface();
        BussinessParams rtnBParams = new BussinessParams();
        int len = rowParams.length;
        for (int i = 0; i < len; ++i) {
            int logicNEID = TENEListUtils.getLogicNEID();
            for (Param paramtmp : rowParams[i].getParam()) {
                String paramName = paramtmp.getName();
                String paramValue = paramtmp.getValue();
                if (paramName.equals("neID")) {
                    neID = new Integer(paramValue);
                    continue;
                }
                if (paramName.equals("neGWType")) {
                    neGWType = Integer.parseInt(paramValue);
                    continue;
                }
                if (paramName.equals("neGWAddress")) {
                    neGWAddress = paramValue;
                    continue;
                }
                if (paramName.equals("port")) {
                    port = paramValue;
                    continue;
                }
                if (paramName.equals("baudRate")) {
                    baudRate = paramValue;
                    continue;
                }
                if (paramtmp.getName().equals("userName")) {
                    userName = paramtmp.getValue();
                    continue;
                }
                if (paramtmp.getName().equals("userPassword")) {
                    userPassword = EncryptUtils.decrypt(paramtmp.getValue());
                    continue;
                }
                if (!paramtmp.getName().equals("forceLogin")) continue;
                forceLogin = new Integer(paramtmp.getValue());
            }
            if (neGWType == 5) {
                port = TEGetUSBSerialPortAndBaudRate.getUSBSerialPort();
                baudRate = TEGetUSBSerialPortAndBaudRate.getUSBSerialBaudRate();
            }
            if (!TESysManagerConstants.isSerialPort(neGWType) && !this.checkInputParam(port, neGWAddress)) {
                rtnDatainterface.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1107427165));
                return rtnDatainterface;
            }
            TENEListMgr neMgr = TENEListMgr.getInstance();
            TENE ne = new TENE(logicNEID, neGWType, neGWAddress, port, baudRate, userName, userPassword);
            TELogFactory.getNormalLogger().info("Add new ne:" + logicNEID + "," + neGWType + "," + neGWAddress + "," + port + "," + baudRate);
            ne.setRealNEID(neID);
            StringBuffer filePath = new StringBuffer();
            filePath.append(TEPathManager.RESOURCE_PROFILE_PATH).append("funcdesres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            TEResourceUtil res = TEResourceUtil.getInstance(filePath.toString());
            this.loginfo.setOperateName(res.getString(subFunc.getDes()));
            this.loginfo.setUserName("admin");
            this.loginfo.setLocation(ipAddress);
            this.loginfo.setOperateObject(ne.getNEName());
            this.loginfo.setCmdID(subFunc.getCode());
            TENECommMgr.getInstance().putLogicNEID((long)neID, (long)logicNEID);
            int rtnCode = -1;
            rtnCode = neMgr.addNE(ne);
            if (rtnCode != 0) {
                this.allSuccess = false;
                RowParams rowParamTmp = new RowParams();
                RowErrors rowErr = new RowErrors();
                Param errParam = new Param();
                errParam.setName("neID");
                errParam.setValue(String.valueOf(neID));
                rowErr.addParam(errParam);
                rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neID, rtnCode));
                rowParamTmp.addRowErrors(rowErr);
                rtnBParams.addRowParams(rowParamTmp);
                this.loginfo.setResult(2);
                this.loginfo.setErrCode(rtnCode);
                this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(neID, rtnCode));
                this.loginfo.setOperateDesc(res.getString("NE_ADD") + " " + res.getString("ERRORCODE") + rtnCode + " " + res.getString("ERRORINFO") + TEErrorResourceUtil.getErrCodeResWithDot(neID, rtnCode));
                TELogMgr.writeLog(this.loginfo);
                continue;
            }
            if (null == userName || userName.trim().equals("") || userPassword == null || userPassword.length == 0 || ne.getComStarus() == 0) {
                this.loginfo.setResult(0);
                this.loginfo.setOperateDesc(res.getString("NE_ADD"));
                TELogMgr.writeLog(this.loginfo);
                this.allFailed = false;
                continue;
            }
            rtnCode = ne.login(userName, userPassword, forceLogin);
            if (rtnCode != 0) {
                this.loginfo.setResult(1);
                this.loginfo.setErrCode(rtnCode);
                this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(neID, rtnCode));
                this.loginfo.setOperateDesc(res.getString("NE_ADD") + res.getString("SUCC_OPERATION") + " " + res.getString("NE_LOGIN") + res.getString("FAIL_OPERATION"));
                TELogMgr.writeLog(this.loginfo);
            } else {
                this.allFailed = false;
                ne.queryNEAttribute();
                this.succNEList.add(ne);
                TEWarningScreenData waringInfoData = new TEWarningScreenData(ne.getNEName(), TELoginNEBean.queryWarningScreenInfo(ne.getNEID()));
                this.warningScreenMap.put(String.valueOf(ne.getNEID()), waringInfoData);
                this.loginfo.setResult(0);
                this.loginfo.setErrCode(rtnCode);
                this.loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot(neID, rtnCode));
                this.loginfo.setOperateDesc(res.getString("NE_ADD"));
                TELogMgr.writeLog(this.loginfo);
            }
            TEResourceManager.addNeListInfoNENode(TENEListMgr.NELIST_PATH, ne, true);
        }
        if (this.succNEList != null && this.succNEList.size() > 0) {
            int uploadtype = new Integer(TESysManagerBean.getInstance().getProperty("uploadtype"));
            if (uploadtype == 0) {
                int size = this.succNEList.size();
                for (int i = 0; i < size; ++i) {
                    new TENELdDevPkgNoticeReceiver().handleNotice(((TENE)this.succNEList.get(i)).getNEID());
                }
            } else if (uploadtype == 1) {
                TEDevicePackageUpload devPkgLoader = TEDevicePackageUpload.getInstance();
                devPkgLoader.devicePakageUpload(this.succNEList, new TENELdDevPkgNoticeReceiver());
            } else if (uploadtype == 2) {
                boolean isSucc = false;
                int len2 = this.succNEList.size();
                for (int i = 0; i < len2; ++i) {
                    int succNeid = ((TENE)this.succNEList.get(i)).getNEID();
                    new TENELdDevPkgNoticeReceiver().handleNotice(succNeid);
                    int uploadResult = TEUploadPNPFileMgr.getInstance().uploadPNPFile(succNeid);
                    if (isSucc) continue;
                    isSucc = uploadResult == 0;
                }
                if (isSucc) {
                    RowParams tipsRowParam = new RowParams();
                    tipsRowParam.addParam("isPNPUpdate", "true");
                    rtnBParams.addRowParams(tipsRowParam);
                }
            }
        }
        ErrorMessage bigErr = null;
        bigErr = this.allSuccess ? TEErrorResourceUtil.getErrorMessage(neID, 0) : (this.allFailed ? TEErrorResourceUtil.getErrorMessage(neID, 2) : TEErrorResourceUtil.getErrorMessage(neID, 1));
        rtnDatainterface.setBussinessParams(rtnBParams);
        rtnDatainterface.setErrorMessage(bigErr);
        TELogFactory.getNormalLogger().info("End to add ne,time:" + System.currentTimeMillis());
        TELoginNEBean.addWarningScreenParams(rtnDatainterface, this.warningScreenMap);
        EncryptUtils.clearByte(userPassword);
        return rtnDatainterface;
    }

    private boolean checkInputParam(String port, String neGWAddress) {
        return TECheckInputParam.checkInt(port) && TECheckInputParam.checkIP(neGWAddress);
    }
}

