/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nelist;

import com.huawei.nglct.bscfg.equipment.TEEquipmentDescription;
import com.huawei.nglct.nelist.model.TEAbNormalEvent;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import java.util.Comparator;

public class TEAbnormalComparator
implements Comparator {
    public static final int EVENT_ID = 1;
    public static final int EVENT_NAME = 2;
    public static final int EVENT_LEVEL = 3;
    public static final int EVENT_MONOBJ = 4;
    public static final int EVENT_RISEDTIME = 5;
    public static final int EVENT_DESCRIPTION = 6;
    public static final int EVENT_TYPE = 7;
    public static final int EVENT_NODETYPE = 8;
    private int sortBy = 0;
    private int sortcol = 5;

    public void setSortCol(String sortCol) {
        this.sortcol = this.convertSortCol(sortCol);
    }

    public int getSortCol() {
        return this.sortcol;
    }

    public void setSortBy(String sortBy) {
        this.sortBy = this.convertSortBy(sortBy);
    }

    public int getSortBy() {
        return this.sortBy;
    }

    public int compare(Object o1, Object o2) {
        TEAbNormalEvent event1 = (TEAbNormalEvent)o1;
        TEAbNormalEvent event2 = (TEAbNormalEvent)o2;
        switch (this.sortcol) {
            case 1: {
                return this.eventIDCompare(event1, event2);
            }
            case 2: {
                return this.eventNameCompare(event1, event2);
            }
            case 3: {
                return this.eventLevelCompare(event1, event2);
            }
            case 4: {
                return this.eventMonObjCompare(event1, event2);
            }
            case 5: {
                return this.eventRisedTimeCompare(event1, event2);
            }
            case 6: {
                return this.eventDescriptionCompare(event1, event2);
            }
            case 7: {
                return this.eventTypeCompare(event1, event2);
            }
            case 8: {
                return this.eventNodeTypeCompare(event1, event2);
            }
        }
        return this.eventRisedTimeCompare(event1, event2);
    }

    private int eventTypeCompare(TEAbNormalEvent event1, TEAbNormalEvent event2) {
        if (0 == this.sortBy) {
            return event1.typeStr.compareTo(event2.typeStr);
        }
        return event2.typeStr.compareTo(event1.typeStr);
    }

    private int eventNodeTypeCompare(TEAbNormalEvent event1, TEAbNormalEvent event2) {
        String nodeTypeStr1 = TEEquipmentDescription.getInstance().getTopoTypeName(TEGetNEDomainVersion.getInstance().getDevType(event1.nodeType));
        String nodeTypeStr2 = TEEquipmentDescription.getInstance().getTopoTypeName(TEGetNEDomainVersion.getInstance().getDevType(event2.nodeType));
        if (0 == this.sortBy) {
            return nodeTypeStr1.compareTo(nodeTypeStr2);
        }
        return nodeTypeStr2.compareTo(nodeTypeStr1);
    }

    private int eventDescriptionCompare(TEAbNormalEvent event1, TEAbNormalEvent event2) {
        if (0 == this.sortBy) {
            return event1.comment.compareTo(event2.comment);
        }
        return event2.comment.compareTo(event1.comment);
    }

    private int eventRisedTimeCompare(TEAbNormalEvent event1, TEAbNormalEvent event2) {
        if (0 == this.sortBy) {
            return event1.timeRiseStr.compareTo(event2.timeRiseStr);
        }
        return event2.timeRiseStr.compareTo(event1.timeRiseStr);
    }

    private int eventMonObjCompare(TEAbNormalEvent event1, TEAbNormalEvent event2) {
        if (0 == this.sortBy) {
            return event1.objStr.compareTo(event2.objStr);
        }
        return event2.objStr.compareTo(event1.objStr);
    }

    private int eventLevelCompare(TEAbNormalEvent event1, TEAbNormalEvent event2) {
        if (0 == this.sortBy) {
            return event1.severityLevel - event2.severityLevel;
        }
        return event2.severityLevel - event1.severityLevel;
    }

    private int eventNameCompare(TEAbNormalEvent event1, TEAbNormalEvent event2) {
        if (0 == this.sortBy) {
            return event1.eventName.compareTo(event2.eventName);
        }
        return event2.eventName.compareTo(event1.eventName);
    }

    private int eventIDCompare(TEAbNormalEvent event1, TEAbNormalEvent event2) {
        if (0 == this.sortBy) {
            return event1.eventID - event2.eventID;
        }
        return event2.eventID - event1.eventID;
    }

    private int convertSortBy(String sequense) {
        if (0 == sequense.compareTo("asc")) {
            return 0;
        }
        return 1;
    }

    private int convertSortCol(String sortObject) {
        if (sortObject.equals("eventID")) {
            return 1;
        }
        if (sortObject.equals("eventName")) {
            return 2;
        }
        if (sortObject.equals("level")) {
            return 3;
        }
        if (sortObject.equals("monObj")) {
            return 4;
        }
        if (sortObject.equals("risedTime")) {
            return 5;
        }
        if (sortObject.equals("desciption")) {
            return 6;
        }
        if (sortObject.equals("type")) {
            return 7;
        }
        if (sortObject.equals("nodeTypeStr")) {
            return 8;
        }
        return 5;
    }
}

