/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.snmp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.snmpfunctions.SubFun;
import com.huawei.nglct.common.snmpfunctions.toperation.Terror;
import com.huawei.nglct.common.snmpfunctions.toperation.Tinput;
import com.huawei.nglct.common.snmpfunctions.toperation.Toperation;
import com.huawei.nglct.common.snmpfunctions.toperation.Toutput;
import com.huawei.nglct.common.snmpfunctions.toperation.Tparam;
import com.huawei.nglct.neinterface.neadapter.snmp.SnmpUtil;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpMgr;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpNEInfo;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpReceiver;
import com.huawei.nglct.nelist.TESnmpNEListMgr;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.snmp4j.PDU;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

public class TESnmpSrvMgr {
    private static Logger log = TELogFactory.getNormalLogger();
    private static int TIMEOUT = 60;
    private static TESnmpSrvMgr instance = null;
    private TESnmpMgr snmpMgr = TESnmpMgr.getInstance();

    public static synchronized TESnmpSrvMgr getInstance() {
        if (instance == null) {
            instance = new TESnmpSrvMgr();
        }
        return instance;
    }

    private TESnmpSrvMgr() {
    }

    public void sendMessage(String neIP, ArrayList operationList, SubFun subfun, int perBulkTimeOut) {
        Toperation top = null;
        TESnmpNEInfo neInfo = null;
        neInfo = TESnmpNEListMgr.getInstance().getNE(neIP);
        ResponseEvent response = null;
        PDU request = null;
        if (perBulkTimeOut == 0) {
            perBulkTimeOut = TIMEOUT;
        }
        int count = operationList.size();
        for (int i = 0; i < count; ++i) {
            top = (Toperation)operationList.get(i);
            request = this.constructReq(top, neInfo);
            if (request == null) {
                log.error("skip operation,because constructReq is null");
                continue;
            }
            if (top.getMiboper().equals("getall")) {
                TESnmpReceiver receiver = new TESnmpReceiver(top, subfun);
                this.snmpMgr.sendBulkRequest(neInfo, request, receiver, perBulkTimeOut);
                continue;
            }
            response = this.snmpMgr.sendCommand(request, neInfo.getTarget(request.getType()));
            if (this.handleResponse(top, response, subfun)) continue;
            return;
        }
    }

    private PDU constructReq(Toperation top, TESnmpNEInfo neInfo) {
        PDU request = neInfo.createPDU(null);
        if (top.getMiboper().equals("getnext") || top.getMiboper().equals("getall")) {
            request.setType(-95);
        } else if (top.getMiboper().equals("set")) {
            request.setType(-93);
        }
        Tinput tinput = null;
        int opCount = top.getTinputCount();
        for (int ti = 0; ti < opCount; ++ti) {
            tinput = top.getTinput(ti);
            Tparam tp = null;
            VariableBinding vb = null;
            OID oid = null;
            int pCount = tinput.getTparamCount();
            for (int pi = 0; pi < pCount; ++pi) {
                tp = tinput.getTparam(pi);
                if (tp.getIsIndex()) continue;
                oid = new OID(tp.getOid());
                vb = new VariableBinding(oid);
                if (tp.getValue() != null && !tp.getValue().equals("")) {
                    try {
                        Variable var = SnmpUtil.getVariable(tp.getValue(), tp.getType());
                        vb.setVariable(var);
                    }
                    catch (IllegalArgumentException e) {
                        log.error("constructReq failed.", (Throwable)e);
                        return null;
                    }
                }
                request.add(vb);
            }
        }
        return request;
    }

    private boolean handleResponse(Toperation top, ResponseEvent response, SubFun subfun) {
        PDU rsp = response.getResponse();
        if (rsp == null) {
            this.handleTimeOut(top);
            return false;
        }
        if (rsp.getErrorIndex() != 0) {
            this.handleError(top, response);
            return false;
        }
        VariableBinding vb = null;
        Toutput output = new Toutput();
        Tparam tparam = null;
        Tinput tinput = top.getTinput(0);
        Tparam tparamOut = null;
        OID index = null;
        int count = rsp.getVariableBindings().size();
        for (int i = 0; i < count; ++i) {
            vb = rsp.get(i);
            tparam = null;
            OID oid = null;
            int piCount = tinput.getTparamCount();
            for (int pi = 0; pi < piCount; ++pi) {
                tparam = tinput.getTparam(pi);
                if (tparam.getIsIndex()) continue;
                oid = new OID(tparam.getOid());
                if (!vb.getOid().toString().startsWith(tparam.getOid())) continue;
                index = new OID(vb.getOid().getValue(), oid.size(), vb.getOid().size() - oid.size());
                break;
            }
            if (index.toString().equals("")) {
                index = new OID("0");
            }
            if (tparam == null) continue;
            tparamOut = new Tparam();
            tparamOut.setName(tparam.getName());
            tparamOut.setOid(tparam.getOid());
            tparamOut.setType(tparam.getType());
            tparamOut.setValue(vb.getVariable().toString());
            output.addTparam(tparamOut);
        }
        int tiCount = tinput.getTparamCount();
        for (int ti = 0; ti < tiCount; ++ti) {
            Tparam p = tinput.getTparam(ti);
            if (!p.getIsIndex()) continue;
            tparamOut = new Tparam();
            tparamOut.setIsIndex(true);
            tparamOut.setName(p.getName());
            if (index != null) {
                tparamOut.setValue(index.toString());
            }
            output.addTparam(tparamOut);
        }
        top.addToutput(output);
        return true;
    }

    public void handleTimeOut(Toperation top) {
        Toutput output = new Toutput();
        Terror error = new Terror();
        error.setCode(131080);
        error.setDesc(TEErrorResourceUtil.getErrorMessage(131080).getErrorinfo());
        output.setTerror(error);
        top.addToutput(output);
    }

    public void handleError(Toperation top, ResponseEvent event) {
        Toutput output = new Toutput();
        Terror error = new Terror();
        PDU rsp = event.getResponse();
        PDU req = event.getResponse();
        error.setCode(rsp.getErrorStatus());
        int errorIndex = rsp.getErrorIndex();
        VariableBinding vb = req.get(errorIndex - 1);
        Tinput tinput = top.getTinput(0);
        Tparam oParam = new Tparam();
        int tiCount = tinput.getTparamCount();
        for (int ti = 0; ti < tiCount; ++ti) {
            Tparam param = tinput.getTparam(ti);
            if (param.getOid() != null && param.getOid().startsWith(vb.getOid().toString())) {
                error.setDesc(param.getName());
                error.setValue(param.getValue());
            }
            oParam.setIsIndex(param.getIsIndex());
            oParam.setName(param.getName());
            oParam.setOid(param.getOid());
            oParam.setType(param.getType());
            oParam.setValue("ERROR_UNKNOWN_VALUE_2008_9_8");
            output.addTparam(oParam);
        }
        output.setTerror(error);
        top.addToutput(output);
    }
}

