/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.snmp;

import com.huawei.nglct.common.snmpfunctions.SubFun;
import com.huawei.nglct.common.snmpfunctions.toperation.Terror;
import com.huawei.nglct.common.snmpfunctions.toperation.Tinput;
import com.huawei.nglct.common.snmpfunctions.toperation.Toperation;
import com.huawei.nglct.common.snmpfunctions.toperation.Toutput;
import com.huawei.nglct.common.snmpfunctions.toperation.Tparam;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.util.TableEvent;
import org.snmp4j.util.TableListener;

public class TESnmpReceiver
implements TableListener {
    private Toperation t;
    private SubFun subFun;
    private boolean isFinished = false;

    public TESnmpReceiver(Toperation t, SubFun subFun) {
        this.t = t;
        this.subFun = subFun;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished(TableEvent event) {
        Object object = event.getUserObject();
        synchronized (object) {
            event.getUserObject().notify();
        }
        if (event.getStatus() == 0) {
            return;
        }
        Toutput output = new Toutput();
        Terror error = new Terror();
        int es = event.getStatus();
        if (es == -1) {
            error.setCode(131080);
            output.setTerror(error);
        }
        this.t.addToutput(output);
        this.isFinished = true;
    }

    public boolean next(TableEvent event) {
        this.handleResponse(this.t, event, this.subFun);
        ((Counter32)event.getUserObject()).increment();
        return true;
    }

    public void handleTimeOut() {
        Toutput output = new Toutput();
        Terror error = new Terror();
        error.setCode(131080);
        output.setTerror(error);
        this.isFinished = true;
    }

    private void handleResponse(Toperation top, TableEvent event, SubFun subfun) {
        if (event == null) {
            return;
        }
        VariableBinding vb2 = null;
        Toutput output = new Toutput();
        Tparam tparam = null;
        Tinput tinput = top.getTinput(0);
        Tparam tparamOut = null;
        OID index = null;
        for (VariableBinding vb2 : event.getColumns()) {
            tparam = null;
            OID oid = null;
            int piCount = tinput.getTparamCount();
            for (int pi = 0; pi < piCount; ++pi) {
                tparam = tinput.getTparam(pi);
                if (tparam.getIsIndex()) continue;
                oid = new OID(tparam.getOid());
                if (!vb2.getOid().toString().startsWith(tparam.getOid())) continue;
                index = new OID(vb2.getOid().getValue(), oid.size(), vb2.getOid().size() - oid.size());
                break;
            }
            if (tparam == null) continue;
            tparamOut = new Tparam();
            tparamOut.setName(tparam.getName());
            tparamOut.setOid(tparam.getOid());
            tparamOut.setType(tparam.getType());
            tparamOut.setValue(vb2.getVariable().toString());
            output.addTparam(tparamOut);
        }
        int tiCount = tinput.getTparamCount();
        for (int ti = 0; ti < tiCount; ++ti) {
            Tparam p = tinput.getTparam(ti);
            if (!p.getIsIndex()) continue;
            tparamOut = new Tparam();
            tparamOut.setIsIndex(true);
            tparamOut.setName(p.getName());
            if (index != null) {
                tparamOut.setValue(index.toString());
            }
            output.addTparam(tparamOut);
            break;
        }
        top.addToutput(output);
        this.isFinished = true;
    }

    public boolean isFinished() {
        return this.isFinished;
    }
}

