/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.snmp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.snmp.Neid;
import com.huawei.nglct.nelist.snmpparams.Snmpparam;
import java.net.InetAddress;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.Target;
import org.snmp4j.UserTarget;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.util.PDUFactory;

public class TESnmpNEInfo
implements PDUFactory {
    private int neType = 1000;
    private String version = "5.1000.01.01";
    private Snmpparam template = null;
    private Neid neinfo = null;
    private Address address = null;

    public TESnmpNEInfo(Neid neinfo, Snmpparam loginTemplate) {
        this.template = loginTemplate;
        this.neinfo = neinfo;
        try {
            this.address = new UdpAddress(InetAddress.getByName(neinfo.getIp()), loginTemplate.getPort());
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("parese address error", (Throwable)e);
        }
    }

    public String getNEIP() {
        return this.neinfo.getIp();
    }

    public Address getAddress() {
        return this.address;
    }

    public String getNESimpleDesc() {
        return "";
    }

    public PDU createPDU(Target target) {
        ScopedPDU request;
        if (this.template.getVersion() == 3) {
            ScopedPDU scopedPDU = request = new ScopedPDU();
            if (this.template.getContextID() != null) {
                scopedPDU.setContextEngineID(new OctetString(this.template.getContextID()));
            }
            if (this.template.getContextName() != null) {
                scopedPDU.setContextName(new OctetString(this.template.getContextName()));
            }
        } else {
            request = new PDU();
        }
        return request;
    }

    public Target getTarget(int pduType) {
        UserTarget _target = null;
        if (this.template.getVersion() == 3) {
            UserTarget target;
            _target = target = new UserTarget();
            if (this.template.getAuthenticationPassphrase() != null) {
                if (this.template.getPrivacyPassphrase() != null) {
                    target.setSecurityLevel(3);
                } else {
                    target.setSecurityLevel(2);
                }
            } else {
                target.setSecurityLevel(1);
            }
            target.setSecurityName(new OctetString(this.template.getSecurityname()));
        } else {
            OctetString community = new OctetString(this.template.getReadcommunity());
            if (pduType == -93) {
                community = new OctetString(this.template.getWritecommunity());
            }
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(community);
            _target = target;
        }
        _target.setAddress(this.address);
        _target.setMaxSizeRequestPDU(65535);
        _target.setRetries(this.template.getRetries());
        _target.setTimeout((long)this.template.getTimeout());
        _target.setVersion(this.template.getVersion());
        return _target;
    }

    public void setNeType(int neType) {
        this.neType = neType;
    }

    public int getNeType() {
        return this.neType;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }
}

