/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.snmp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpNEInfo;
import com.huawei.nglct.neinterface.neadapter.snmp.TESnmpReceiver;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.Session;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.StateReference;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.Priv3DES;
import org.snmp4j.security.PrivacyProtocol;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.smi.Counter32;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.UdpAddress;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.snmp4j.util.MultiThreadedMessageDispatcher;
import org.snmp4j.util.PDUFactory;
import org.snmp4j.util.TableListener;
import org.snmp4j.util.TableUtils;
import org.snmp4j.util.ThreadPool;
import org.snmp4j.util.WorkerPool;

public class TESnmpMgr
implements CommandResponder,
PDUFactory {
    private Snmp snmp161 = null;
    private Snmp snmp162 = null;
    private int numDispatcherThreads = 2;
    private Logger commLogger = null;
    private Logger normalLogger = null;
    private HashMap targetMap = new HashMap();
    private OctetString localEngineID = new OctetString(MPv3.createLocalEngineID());
    private Timer asySendTimer = new Timer();
    private static TESnmpMgr instance = null;

    public static synchronized TESnmpMgr getInstance() {
        if (instance == null) {
            instance = new TESnmpMgr();
        }
        return instance;
    }

    private TESnmpMgr() {
        this.commLogger = TELogFactory.getCommuLogger();
        this.normalLogger = TELogFactory.getNormalLogger();
        this.initSending();
        this.initReceive();
    }

    private void initSending() {
        try {
            DefaultUdpTransportMapping udpMapping = new DefaultUdpTransportMapping();
            this.snmp161 = new Snmp((TransportMapping)udpMapping);
            this.snmp161.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv1());
            this.snmp161.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv2c());
            this.snmp161.getMessageDispatcher().addMessageProcessingModel((MessageProcessingModel)new MPv3(this.localEngineID.getValue()));
            this.snmp161.listen();
        }
        catch (Exception e) {
            this.commLogger.error("SNMP NE: localhost, Create Socket Failed!: ", (Throwable)e);
        }
    }

    private void initReceive() {
        UdpAddress rUdpAdd = new UdpAddress("0.0.0.0/162");
        ThreadPool threadPool = ThreadPool.create((String)"DispatcherPool", (int)this.numDispatcherThreads);
        MultiThreadedMessageDispatcher receiveMtDispatcher = new MultiThreadedMessageDispatcher((WorkerPool)threadPool, (MessageDispatcher)new MessageDispatcherImpl());
        receiveMtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv1());
        receiveMtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv2c());
        receiveMtDispatcher.addMessageProcessingModel((MessageProcessingModel)new MPv3(this.localEngineID.getValue()));
        SecurityProtocols.getInstance().addDefaultProtocols();
        SecurityProtocols.getInstance().addPrivacyProtocol((PrivacyProtocol)new Priv3DES());
        try {
            DefaultUdpTransportMapping receiveTm = new DefaultUdpTransportMapping(rUdpAdd);
            this.snmp162 = new Snmp((MessageDispatcher)receiveMtDispatcher, (TransportMapping)receiveTm);
            this.snmp162.addCommandResponder((CommandResponder)this);
            receiveTm.listen();
            this.normalLogger.info("Listening on " + rUdpAdd.toString());
        }
        catch (IOException ioe) {
            this.normalLogger.error("Init Receive failed:" + rUdpAdd.toString(), (Throwable)ioe);
        }
    }

    public boolean registerSnmpNE(TESnmpNEInfo neInfo) {
        try {
            DefaultUdpTransportMapping udpMapping = new DefaultUdpTransportMapping();
            this.snmp161.addTransportMapping((TransportMapping)udpMapping);
        }
        catch (IOException e) {
            this.commLogger.error("SNMP NE:" + neInfo.getNESimpleDesc() + " create socket failed!: ", (Throwable)e);
            return false;
        }
        return true;
    }

    public void registerTarget(TESnmpNEInfo neInfo, Target target) {
        this.targetMap.put(neInfo, target);
    }

    public Target getTarget(TESnmpNEInfo neInfo) {
        return (Target)this.targetMap.get(neInfo);
    }

    public ResponseEvent sendCommand(PDU request, Target target) {
        ResponseEvent responseEvent = null;
        try {
            responseEvent = this.snmp161.send(request, target);
        }
        catch (Exception e) {
            this.commLogger.error("Target SNMP NE:" + target.getAddress().toString() + " send syn command failed!: ", (Throwable)e);
        }
        return responseEvent;
    }

    public PDU sendCommand(TESnmpNEInfo neInfo, PDU request) {
        ResponseEvent responseEvent = null;
        PDU response = null;
        Target target = neInfo.getTarget(request.getType());
        try {
            responseEvent = this.snmp161.send(request, target);
            if (responseEvent != null) {
                response = responseEvent.getResponse();
            }
        }
        catch (Exception e) {
            this.commLogger.error("Target SNMP NE:" + target.getAddress().toString() + " send syn command failed!: ", (Throwable)e);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendBulkRequest(TESnmpNEInfo neInfo, PDU pdu, final TESnmpReceiver receiver, int timeOut) {
        final Counter32 counter = new Counter32();
        TableUtils tableUtils = new TableUtils((Session)this.snmp161, (PDUFactory)neInfo);
        OID[] oids = new OID[pdu.getVariableBindings().size()];
        for (int i = 0; i < pdu.getVariableBindings().size(); ++i) {
            oids[i] = ((VariableBinding)pdu.getVariableBindings().get(i)).getOid();
        }
        tableUtils.getTable(neInfo.getTarget(pdu.getType()), oids, (TableListener)receiver, (Object)counter, null, null);
        TimerTask tt = new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Counter32 counter32 = counter;
                synchronized (counter32) {
                    counter.notify();
                    receiver.handleTimeOut();
                }
            }
        };
        this.asySendTimer.schedule(tt, timeOut * 1000);
        Counter32 counter32 = counter;
        synchronized (counter32) {
            try {
                counter.wait();
                tt.cancel();
            }
            catch (InterruptedException ex) {
                this.normalLogger.error("SendAsyCommand failed", (Throwable)ex);
            }
        }
    }

    public List sendBulkRequestLite(TESnmpNEInfo neInfo, PDU pdu) {
        TableUtils tableUtils = new TableUtils((Session)this.snmp161, (PDUFactory)neInfo);
        OID[] oids = new OID[pdu.getVariableBindings().size()];
        for (int i = 0; i < pdu.getVariableBindings().size(); ++i) {
            oids[i] = ((VariableBinding)pdu.getVariableBindings().get(i)).getOid();
        }
        return tableUtils.getTable(neInfo.getTarget(pdu.getType()), oids, null, null);
    }

    public PDU createPDU(Target target) {
        PDU request = new PDU();
        request.setType(-95);
        return request;
    }

    public ResponseEvent createRow(TESnmpNEInfo neInfo, OID rowStatusColumnOID, OID rowIndex, VariableBinding[] values) {
        TableUtils tableUtils = new TableUtils((Session)this.snmp161, (PDUFactory)neInfo);
        return tableUtils.createRow(neInfo.getTarget(-93), rowStatusColumnOID, rowIndex, values);
    }

    public ResponseEvent destroyRow(TESnmpNEInfo neInfo, OID rowStatusColumnOID, OID rowIndex) {
        TableUtils tableUtils = new TableUtils((Session)this.snmp161, (PDUFactory)neInfo);
        return tableUtils.destroyRow(neInfo.getTarget(-93), rowStatusColumnOID, rowIndex);
    }

    public void processPdu(CommandResponderEvent e) {
        PDU command = e.getPDU();
        if (command != null) {
            System.out.println(command.toString());
            if (command.getType() != -89 && command.getType() != -92 && command.getType() != -88 && command.getType() != -94) {
                command.setErrorIndex(0);
                command.setErrorStatus(0);
                command.setType(-94);
                StatusInformation statusInformation = new StatusInformation();
                StateReference ref = e.getStateReference();
                try {
                    e.getMessageDispatcher().returnResponsePdu(e.getMessageProcessingModel(), e.getSecurityModel(), e.getSecurityName(), e.getSecurityLevel(), command, e.getMaxSizeResponsePDU(), ref, statusInformation);
                }
                catch (MessageException ex) {
                    this.normalLogger.error("Error while sending response: " + ex.getMessage());
                }
            }
        }
    }

    public boolean close() {
        boolean closeSuccess = true;
        if (this.snmp161 != null) {
            try {
                this.snmp161.close();
            }
            catch (Exception e) {
                this.commLogger.error("close snmp161 fails", (Throwable)e);
                closeSuccess = false;
            }
        }
        if (this.snmp162 != null) {
            try {
                this.snmp162.close();
            }
            catch (Exception e) {
                this.commLogger.error("close snmp162 fails", (Throwable)e);
                closeSuccess = false;
            }
        }
        return closeSuccess;
    }
}

