/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.snmp;

import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.IpAddress;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.TimeTicks;
import org.snmp4j.smi.UnsignedInteger32;
import org.snmp4j.smi.Variable;

public class SnmpUtil {
    public static Variable getVariable(String sValue, String type) throws IllegalArgumentException {
        Integer32 variable = null;
        if (sValue != null) {
            if (type.equals("SYNTAX_INTEGER")) {
                variable = new Integer32(Integer.parseInt(sValue));
            } else if (type.equals("SYNTAX_GAUGE32")) {
                variable = new UnsignedInteger32(Long.parseLong(sValue));
            } else if (type.equals("SYNTAX_OCTET_STRING")) {
                variable = new OctetString(sValue);
            } else if (type.equals("HEXOctetString")) {
                variable = OctetString.fromString((String)sValue, (char)':', (int)16);
            } else if (type.equals("DECOctetString")) {
                variable = OctetString.fromString((String)sValue, (char)'.', (int)10);
            } else if (type.equals("SYNTAX_OBJECT_IDENTIFIER")) {
                variable = new OID(sValue);
            } else if (type.equals("BinaryOctetString")) {
                variable = OctetString.fromString((String)sValue, (char)' ', (int)2);
            } else if (type.equals("SYNTAX_NULL")) {
                variable = new Null();
            } else if (type.equals("SYNTAX_TIMETICKS")) {
                variable = new TimeTicks(Long.parseLong(sValue));
            } else if (type.equals("SYNTAX_IPADDRESS")) {
                variable = new IpAddress(sValue);
            } else {
                throw new IllegalArgumentException("Variable type " + type + " not supported");
            }
        }
        return variable;
    }
}

