/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.qxadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.TECommand;

public class TEQx5Command
extends TECommand {
    private int m_usAckMode;
    private int m_usCommandKey;
    int paraLen = 0;
    private int m_nExecResult;
    private byte[] m_BufVec;
    private byte[] m_BufResultVec;

    public TEQx5Command() {
    }

    public TEQx5Command(int cmdKey) {
        this.m_usAckMode = 32768;
        if (cmdKey != 2 || cmdKey != 1) {
            this.m_usCommandKey = cmdKey;
        }
        this.m_nExecResult = 0;
    }

    public boolean isCommandEnd() {
        return (this.m_usAckMode & 0x2000) == 0;
    }

    public int getParaSize() {
        if (this.m_BufVec == null) {
            TELogFactory.getNEAdapterLogger().info("TEQx5Command: Command ParaLen is 0");
            this.paraLen = 0;
            return this.paraLen;
        }
        this.paraLen = this.m_BufVec.length;
        return this.paraLen;
    }

    public byte[] getPara() {
        return this.m_BufVec;
    }

    public byte[] getData(int nOffset, int nLength) {
        int nSize = this.m_BufVec.length;
        byte[] buffer = null;
        if (nSize - nOffset <= 0) {
            return buffer;
        }
        buffer = new byte[nSize - nOffset];
        nLength = nSize - nOffset >= nLength ? nLength : nSize - nOffset;
        System.arraycopy(this.m_BufResultVec, nOffset, buffer, 0, nLength);
        return buffer;
    }

    public byte[] getResultData(int nOffset, int nLength) {
        if (this.m_BufResultVec == null || this.m_BufResultVec.length == 0) {
            TELogFactory.getNEAdapterLogger().info("TEQx5Command: no data for the QX5 command.");
            return null;
        }
        int nSize = this.m_BufResultVec.length;
        byte[] buffer = null;
        if (nOffset >= nSize) {
            return buffer;
        }
        buffer = new byte[nLength];
        System.arraycopy(this.m_BufResultVec, nOffset, buffer, 0, nLength);
        return buffer;
    }

    public byte[] getResultData(int nOffset) {
        if (this.m_BufResultVec == null || this.m_BufResultVec.length == 0) {
            TELogFactory.getNEAdapterLogger().info("TEQx5Command: no data for the QX5 command.");
            return null;
        }
        int nSize = this.m_BufResultVec.length;
        byte[] buffer = null;
        if (nOffset >= nSize) {
            return buffer;
        }
        buffer = new byte[nSize - nOffset];
        System.arraycopy(this.m_BufResultVec, nOffset, buffer, 0, nSize - nOffset);
        return buffer;
    }

    public void setData(int nOffset, int nLength, byte[] buffer, boolean preFill) {
        byte[] tmpBuffer = null;
        if (nLength <= 0) {
            TELogFactory.getNEAdapterLogger().info("TEQx5Command: no data for the QX5 command.");
            return;
        }
        if (this.m_BufVec == null || this.m_BufVec.length == 0) {
            this.m_BufVec = new byte[nOffset + nLength];
        }
        if (nOffset + nLength > this.m_BufVec.length) {
            tmpBuffer = new byte[this.m_BufVec.length];
            System.arraycopy(this.m_BufVec, 0, tmpBuffer, 0, this.m_BufVec.length);
            this.m_BufVec = new byte[nOffset + nLength];
        }
        if (preFill) {
            System.arraycopy(buffer, 0, this.m_BufVec, this.m_BufVec.length - buffer.length, buffer.length);
        } else {
            System.arraycopy(buffer, 0, this.m_BufVec, nOffset, buffer.length);
        }
        if (tmpBuffer != null && tmpBuffer.length < this.m_BufVec.length) {
            System.arraycopy(tmpBuffer, 0, this.m_BufVec, 0, tmpBuffer.length);
        }
    }

    public void setResultData(int nOffset, int nLength, byte[] buffer) {
        if (nLength <= 0) {
            TELogFactory.getNEAdapterLogger().info("TEQx5Command setResultData: Qx5\u00c3\u00fc\u00c1\u00ee\u00b7\u00b5\u00bb\u00d8\u00ca\u00fd\u00be\u00dd\u00ce\u00de");
            return;
        }
        if (this.m_BufVec == null || this.m_BufVec.length == 0) {
            this.m_BufResultVec = new byte[nLength];
        }
        System.arraycopy(buffer, nOffset, this.m_BufResultVec, 0, nLength);
    }

    public static boolean isReportCommand(int usCmdKey) {
        return usCmdKey >= 28416 && usCmdKey <= 28671 || usCmdKey >= 16384 && usCmdKey <= 24575;
    }

    public byte[] getByte(int nOffset) {
        if (this.m_BufResultVec == null || nOffset >= this.m_BufResultVec.length) {
            TELogFactory.getNEAdapterLogger().info("TEQx5Command::GetByte, Msg from ne error! \n");
            return null;
        }
        byte[] m_byte = new byte[]{this.m_BufResultVec[nOffset]};
        return m_byte;
    }

    public byte[] getWord(int nOffset) {
        if (this.m_BufResultVec == null || nOffset >= this.m_BufResultVec.length) {
            TELogFactory.getNEAdapterLogger().info("TEQx5Command::GetWord, Msg from ne error! \n");
            return null;
        }
        byte[] m_byte = new byte[2];
        int length = m_byte.length;
        for (int i = 0; i < length; ++i) {
            m_byte[i] = this.m_BufResultVec[nOffset + i];
        }
        return m_byte;
    }

    public byte[] getDword(int nOffset) {
        if (this.m_BufResultVec == null || nOffset >= this.m_BufResultVec.length) {
            TELogFactory.getNEAdapterLogger().info("TEQx5Command::GetWord, Msg from ne error! \n");
            return null;
        }
        byte[] m_byte = new byte[4];
        int length = m_byte.length;
        for (int i = 0; i < length; ++i) {
            m_byte[i] = this.m_BufResultVec[nOffset + i];
        }
        return m_byte;
    }

    public int getCommandKey() {
        return this.m_usCommandKey;
    }

    public void setCommandKey(int usCmd) {
        this.m_usCommandKey = usCmd;
    }

    public int getAckMode() {
        return this.m_usAckMode;
    }

    public void setAckMode(int usAckMode) {
        this.m_usAckMode = usAckMode;
    }

    public int getExecResult() {
        return this.m_nExecResult;
    }

    public void setExecResult(int nResult) {
        this.m_nExecResult = nResult;
    }

    public int getCommandSize() {
        return 16;
    }

    public int getQx5CommandSize() {
        return 12;
    }

    public String toString() {
        String cmdString = "CMD: " + this.m_usCommandKey + ", EXEResult:" + this.m_nExecResult;
        return cmdString;
    }
}

