/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.hfcpadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPCommuMgr;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPDataInfo;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFileDataMgr;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFrame;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFrameHead;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFrameSet;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPHandler;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPMappingData;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPPacketHead;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPTaskManager;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommunicationMgr;
import org.slf4j.Logger;

public class TEHFCPUtil {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static final int BRBASE_DOWNLOAD_TYPE = 2;
    private static final int NE_NOT_EXIST = 1090629639;
    private static final int timeOut = 5;

    public static int doSingleDownloadStartReq(int neid) {
        TEHFCPDataInfo dataInfo1 = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo1) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadStartReq TEHFCPDataInfo is null!");
            return -1;
        }
        String neFilePath = dataInfo1.getNeFilePath();
        String localFilePath = dataInfo1.getLocalFilePath();
        String fileName = dataInfo1.getFileName();
        log.info("<HFCP> HFCP Util ---- doSingleDownloadStartReq begin!");
        TEHFCPPacketHead packetHead1 = TEHFCPUtil.buildHFCPPacketHead(neid);
        packetHead1.setM_nLen(542);
        byte[] bufVec = new byte[558];
        TEHFCPFrameHead frameHead = TEHFCPUtil.buildHFCPFrameHead((short)64);
        System.arraycopy(packetHead1.getPacketHead(), 0, bufVec, 0, packetHead1.getHFCPPacketHeadSize());
        byte[] frameBodyData1 = new byte[510];
        String neFileName = neFilePath + "/" + fileName;
        String localFileName = localFilePath + fileName;
        byte[] neFileNameArray = neFileName.getBytes();
        System.arraycopy(neFileNameArray, 0, frameBodyData1, 0, neFileNameArray.length);
        byte[] localFileNameArray = localFileName.getBytes();
        System.arraycopy(localFileNameArray, 0, frameBodyData1, 255, localFileNameArray.length);
        frameHead.setUBodyCheckSum(TEHFCPUtil.calcCheckSum(frameBodyData1, 510));
        frameHead.setUHeaderCheckSum(TEHFCPUtil.calcCheckSum(frameHead.getFrameHead(), 32));
        System.arraycopy(frameHead.getFrameHead(), 0, bufVec, packetHead1.getHFCPPacketHeadSize(), 32);
        System.arraycopy(frameBodyData1, 0, bufVec, 48, frameBodyData1.length);
        TEHFCPFrame tmpFrame = new TEHFCPFrame();
        tmpFrame.setM_FrameHead(frameHead);
        tmpFrame.setM_BufVec(frameBodyData1);
        TEHFCPFrameSet reqFrameSet = new TEHFCPFrameSet(neid, tmpFrame);
        int index = reqFrameSet.getFrameIndex();
        if (null == dataInfo1.getMappingData(index)) {
            TEHFCPMappingData firstData = new TEHFCPMappingData(index);
            firstData.setReqFrameSet(reqFrameSet);
            dataInfo1.addHFCPData(index, firstData);
        }
        TEHFCPMappingData data = dataInfo1.getMappingData(index);
        data.setSendCount(data.getSendCount() + 1);
        TECommInfo commInfo = TEHFCPCommuMgr.instance().getNeCommuInfo(neid);
        if (null == commInfo) {
            TEHFCPUtil.handleSendResult(0, neid, 1090629639);
            return -1;
        }
        int ret = TECommunicationMgr.instance().send(commInfo, bufVec, 5);
        if (-1 == ret) {
            TEHFCPUtil.handleSendResult(0, neid, 1090629639);
            return -1;
        }
        log.info("<HFCP> HFCP Util ---- doSingleDownloadStartReq send result is : " + ret);
        return ret;
    }

    public static int doSingleDownloadStartRsp(int retIndex, int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleDownloadStartRsp begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadStartRsp TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPMappingData hfcpMappingData = dataInfo.getMappingData(retIndex);
        if (null == hfcpMappingData) {
            dataInfo.removeHFCPData(retIndex);
            return 0;
        }
        TEHFCPFrameSet frameSet = hfcpMappingData.getRspFrameSet();
        boolean blnRtn = TEHFCPUtil.checkPacket(frameSet);
        if (!blnRtn) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadStartRsp check sum failed!");
            hfcpMappingData.setSendTime(0);
            return TEHFCPUtil.doSingleDownloadStartReq(neid);
        }
        TEHFCPFrameHead frameHead = frameSet.getFrame().getM_FrameHead();
        short result = frameHead.getUsResult();
        log.info("<HFCP> HFCP Util ---- doSingleDownloadStartRsp return result is : " + result);
        if (0 != result) {
            int error = IOStreamConvertor.readInt(frameSet.getFrame().getM_BufVec(), 0);
            if (32779 != error && (32769 == error || 32770 == error)) {
                log.info("<HFCP> HFCP Util ---- doSingleDownloadStartRsp check head and body error!");
                hfcpMappingData.setSendTime(0);
                return TEHFCPUtil.doSingleDownloadStartReq(neid);
            }
            TEHFCPUtil.handleSendResult(retIndex, neid, error);
            return error;
        }
        dataInfo.removeHFCPData(retIndex);
        log.info("<HFCP> HFCP Util ---- doSingleDownloadStartRsp end!");
        return TEHFCPUtil.startMultiSend(neid);
    }

    public static int doSingleDownloadDataReq(int retIndex, int neid) {
        byte[] frameBodyData;
        log.info("<HFCP> HFCP Util ---- doSingleDownloadDataReq begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadDataReq TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPPacketHead packetHead = TEHFCPUtil.buildHFCPPacketHead(neid);
        packetHead.setM_nLen(832);
        byte[] bufVec = new byte[848];
        System.arraycopy(packetHead.getPacketHead(), 0, bufVec, 0, packetHead.getPacketHead().length);
        int frameBfuLen = TEHFCPUtil.getFrameBufLen(retIndex, dataInfo);
        TEHFCPFrameHead frameHead = new TEHFCPFrameHead();
        frameHead.init();
        frameHead.setUsPackType((short)68);
        frameHead.setUsSerialNum((short)retIndex);
        frameHead.setUsResult((short)0);
        frameHead.setUsEndTag(65280);
        frameHead.setUDataLen(frameBfuLen);
        frameHead.setUBufLen(frameBfuLen);
        if (0 != frameBfuLen) {
            frameBodyData = new byte[800];
            int dataIndex = (retIndex - 1) * 800;
            int frameLen = 800;
            if (retIndex == dataInfo.getPacketSum()) {
                frameHead.setUsEndTag(65281);
                frameLen = dataInfo.getData().length - dataIndex;
            }
            System.arraycopy(dataInfo.getData(), dataIndex, frameBodyData, 0, frameLen);
            frameHead.setUBodyCheckSum(TEHFCPUtil.calcCheckSum(frameBodyData, 800));
            frameHead.setUHeaderCheckSum(TEHFCPUtil.calcCheckSum(frameHead.getFrameHead(), 32));
            System.arraycopy(frameHead.getFrameHead(), 0, bufVec, 16, 32);
            System.arraycopy(frameBodyData, 0, bufVec, 48, frameBodyData.length);
        } else {
            frameBodyData = new byte[]{};
            frameHead.setUBodyCheckSum(TEHFCPUtil.calcCheckSum(frameBodyData, 0));
            frameHead.setUHeaderCheckSum(TEHFCPUtil.calcCheckSum(frameHead.getFrameHead(), 32));
            System.arraycopy(frameHead.getFrameHead(), 0, bufVec, 16, 32);
            System.arraycopy(frameBodyData, 0, bufVec, 48, frameBodyData.length);
        }
        TEHFCPFrame tmpFrame = new TEHFCPFrame();
        tmpFrame.setM_FrameHead(frameHead);
        tmpFrame.setM_BufVec(frameBodyData);
        TEHFCPFrameSet reqFrameSet = new TEHFCPFrameSet(neid, tmpFrame);
        if (null == dataInfo.getMappingData(retIndex)) {
            TEHFCPMappingData mappingData = new TEHFCPMappingData(retIndex);
            mappingData.setReqFrameSet(reqFrameSet);
            dataInfo.addHFCPData(retIndex, mappingData);
        }
        TEHFCPMappingData data = dataInfo.getMappingData(retIndex);
        data.setSendCount(data.getSendCount() + 1);
        TECommInfo commInfo = TEHFCPCommuMgr.instance().getNeCommuInfo(neid);
        if (null == commInfo) {
            TEHFCPUtil.handleSendResult(retIndex, neid, 1090629639);
            return -1;
        }
        int ret = TECommunicationMgr.instance().send(commInfo, bufVec, 5);
        if (-1 == ret) {
            TEHFCPUtil.handleSendResult(retIndex, neid, 1090629639);
            return -1;
        }
        log.info("<HFCP> HFCP Util ---- doSingleDownloadDataReq the packet : " + retIndex + " send!");
        return ret;
    }

    public static int doSingleDownloadDataRsp(int retIndex, int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPMappingData hfcpMappingData = dataInfo.getMappingData(retIndex);
        TEHFCPFrameSet frameSet = hfcpMappingData.getRspFrameSet();
        int ret = 0;
        boolean blnRtn = TEHFCPUtil.checkPacket(frameSet);
        if (!blnRtn) {
            hfcpMappingData.setSendTime(0);
            TEHFCPUtil.doSingleDownloadDataReq(retIndex, neid);
            return 0;
        }
        TEHFCPFrameHead frameHead = frameSet.getFrame().getM_FrameHead();
        short result = frameHead.getUsResult();
        log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp The" + frameHead.getUsSerialNum() + " packet send to NE result is : " + result);
        if (0 != result) {
            int packetNo = 0;
            int error = (int)IOStreamConvertor.readUnsignedInt(frameSet.getFrame().getM_BufVec(), 0);
            if (32779 == error) {
                packetNo = (int)IOStreamConvertor.readUnsignedInt(frameSet.getFrame().getM_BufVec(), 16);
                log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp HFCP packet : " + packetNo + " is packet number error!");
                return 0;
            }
            if (32779 != error && (32769 == error || 32770 == error)) {
                log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp check head and body error!");
                hfcpMappingData.setSendTime(0);
                TEHFCPUtil.doSingleDownloadDataReq(retIndex, neid);
                return error;
            }
            TEHFCPUtil.handleSendResult(retIndex, neid, error);
            return error;
        }
        int packetCount = dataInfo.getPacketSum();
        dataInfo.setSendedPacketCount(dataInfo.getSendedPacketCount() + 1);
        dataInfo.removeHFCPData(retIndex);
        log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp transfer progress is :  neid->" + neid + "process->" + TEHFCPHandler.instance().getTransferProgress(neid) + "%");
        if (retIndex == packetCount) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp this is the last packet!");
            dataInfo.setSendedPacketCount(dataInfo.getPacketSum());
            TEHFCPUtil.doSingleDownloadEndReq(neid);
        } else {
            if (-1 == (retIndex = TEHFCPUtil.checkReqIndex(retIndex, dataInfo.getPacketSum()))) {
                return 0;
            }
            ret = TEHFCPUtil.doSingleDownloadDataReq(retIndex, neid);
        }
        return ret;
    }

    public static int doSingleDownloadEndReq(int neid) {
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadEndReq TEHFCPDataInfo is null!");
            return 0;
        }
        log.info("<HFCP> HFCP Util ---- doSingleDownloadEndReq begin!");
        TEHFCPPacketHead packetHead = TEHFCPUtil.buildHFCPPacketHead(neid);
        packetHead.setM_nLen(32);
        byte[] bufVec = new byte[48];
        System.arraycopy(packetHead.getPacketHead(), 0, bufVec, 0, packetHead.getPacketHead().length);
        TEHFCPFrameHead frameHead1 = new TEHFCPFrameHead();
        frameHead1.init();
        frameHead1.setUsPackType((short)72);
        frameHead1.setUsResult((short)0);
        frameHead1.setUsEndTag(65281);
        byte[] frameBodyData = new byte[]{};
        frameHead1.setUBodyCheckSum(0);
        frameHead1.setUHeaderCheckSum(TEHFCPUtil.calcCheckSum(frameHead1.getFrameHead(), 32));
        System.arraycopy(frameHead1.getFrameHead(), 0, bufVec, 16, 32);
        System.arraycopy(frameBodyData, 0, bufVec, 48, frameBodyData.length);
        TEHFCPFrame tmpFrame1 = new TEHFCPFrame();
        tmpFrame1.setM_FrameHead(frameHead1);
        tmpFrame1.setM_BufVec(frameBodyData);
        TEHFCPFrameSet reqFrameSet1 = new TEHFCPFrameSet(neid, tmpFrame1);
        int index = reqFrameSet1.getFrameIndex();
        if (null == dataInfo.getMappingData(index)) {
            TEHFCPMappingData endData = new TEHFCPMappingData(index);
            endData.setReqFrameSet(reqFrameSet1);
            dataInfo.addHFCPData(index, endData);
        }
        TEHFCPMappingData data = dataInfo.getMappingData(index);
        data.setSendCount(data.getSendCount() + 1);
        TECommInfo commInfo1 = TEHFCPCommuMgr.instance().getNeCommuInfo(neid);
        if (null == commInfo1) {
            TEHFCPUtil.handleSendResult(0, neid, 1090629639);
            return -1;
        }
        int ret = TECommunicationMgr.instance().send(commInfo1, bufVec, 5);
        if (-1 == ret) {
            TEHFCPUtil.handleSendResult(0, neid, 1090629639);
            return -1;
        }
        return ret;
    }

    public static int doSingleDownloadEndRsp(int retIndex, int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleDownloadEndRsp begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadEndRsp TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPMappingData hfcpMappingData = dataInfo.getMappingData(retIndex);
        TEHFCPFrameSet frameSet = hfcpMappingData.getRspFrameSet();
        boolean blnRtn = TEHFCPUtil.checkPacket(frameSet);
        if (!blnRtn) {
            log.info("<HFCP> HFCP Util ---- doSingleDownloadEndRsp check failed!");
            hfcpMappingData.setSendTime(0);
            return TEHFCPUtil.doSingleDownloadEndReq(neid);
        }
        TEHFCPFrameHead frameHead = frameSet.getFrame().getM_FrameHead();
        short result = frameHead.getUsResult();
        log.info("<HFCP> HFCP Util ---- doSingleDownloadEndRsp The" + frameHead.getUsSerialNum() + " packet send to NE result is : " + result);
        if (0 != result) {
            int error = IOStreamConvertor.readInt(frameSet.getFrame().getM_BufVec(), 0);
            if (32779 != error && (32769 == error || 32770 == error)) {
                log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp check head and body error!");
                hfcpMappingData.setSendTime(0);
                return TEHFCPUtil.doSingleDownloadEndReq(neid);
            }
            TEHFCPUtil.handleSendResult(retIndex, neid, error);
            return error;
        }
        TEHFCPUtil.handleSendResult(retIndex, neid, 0);
        return 0;
    }

    public static int doSingleUploadStartReq(int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleUploadStartReq begin");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadStartReq TEHFCPDataInfo is null!");
            return -1;
        }
        String neFilePath = dataInfo.getNeFilePath();
        String localFilePath = dataInfo.getLocalFilePath();
        String fileName = dataInfo.getFileName();
        TEHFCPPacketHead packetHead = TEHFCPUtil.buildHFCPPacketHead(neid);
        packetHead.setM_nLen(542);
        byte[] bufVec = new byte[558];
        TEHFCPFrameHead frameHead = TEHFCPUtil.buildHFCPFrameHead((short)66);
        System.arraycopy(packetHead.getPacketHead(), 0, bufVec, 0, packetHead.getHFCPPacketHeadSize());
        byte[] frameBodyData = new byte[510];
        String neFileName = neFilePath + "/" + fileName;
        String localFileName = localFilePath + fileName;
        byte[] neFileNameArray = neFileName.getBytes();
        System.arraycopy(neFileNameArray, 0, frameBodyData, 0, neFileNameArray.length);
        byte[] localFileNameArray = localFileName.getBytes();
        System.arraycopy(localFileNameArray, 0, frameBodyData, 255, localFileNameArray.length);
        frameHead.setUBodyCheckSum(TEHFCPUtil.calcCheckSum(frameBodyData, 510));
        frameHead.setUHeaderCheckSum(TEHFCPUtil.calcCheckSum(frameHead.getFrameHead(), 32));
        System.arraycopy(frameHead.getFrameHead(), 0, bufVec, packetHead.getHFCPPacketHeadSize(), 32);
        System.arraycopy(frameBodyData, 0, bufVec, 48, frameBodyData.length);
        TEHFCPFrame tmpFrame = new TEHFCPFrame();
        tmpFrame.setM_FrameHead(frameHead);
        tmpFrame.setM_BufVec(frameBodyData);
        TEHFCPFrameSet reqFrameSet = new TEHFCPFrameSet(neid, tmpFrame);
        int index = reqFrameSet.getFrameIndex();
        if (null == dataInfo.getMappingData(index)) {
            TEHFCPMappingData firstData = new TEHFCPMappingData(index);
            firstData.setReqFrameSet(reqFrameSet);
            dataInfo.addHFCPData(index, firstData);
        }
        TEHFCPMappingData data = dataInfo.getMappingData(index);
        data.setSendCount(data.getSendCount() + 1);
        TECommInfo commInfo = TEHFCPCommuMgr.instance().getNeCommuInfo(neid);
        if (null == commInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadStartReq- ne commoninfo doesn't exist.");
            TEHFCPUtil.handleSendResult(0, neid, 1090629639);
            return -1;
        }
        int ret = TECommunicationMgr.instance().send(commInfo, bufVec, 5);
        if (-1 == ret) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadStartReq- failed to send upload start req to ne, result= " + ret);
            TEHFCPUtil.handleSendResult(0, neid, 1090629639);
            return -1;
        }
        log.info("<HFCP> HFCP Util ---- doSingleUploadStartReq send result is : " + ret);
        return ret;
    }

    public static int doSingleUploadStartRsp(int retIndex, int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleUploadStartRsp begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadStartRsp TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPMappingData hfcpMappingData = dataInfo.getMappingData(retIndex);
        TEHFCPFrameSet frameSet = hfcpMappingData.getRspFrameSet();
        boolean blnRtn = TEHFCPUtil.checkPacket(frameSet);
        if (!blnRtn) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadStartRsp check sum failed!");
            hfcpMappingData.setSendTime(0);
            TEHFCPUtil.doSingleUploadStartReq(neid);
            return 0;
        }
        TEHFCPFrameHead frameHead = frameSet.getFrame().getM_FrameHead();
        short result = frameHead.getUsResult();
        log.info("<HFCP> HFCP Util ---- doSingleUploadStartRsp return result is : " + result);
        if (0 != result) {
            int error = IOStreamConvertor.readInt(frameSet.getFrame().getM_BufVec(), 0);
            log.info("<HFCP> HFCP Util ---- doSingleUploadStartRsp. return error is : " + error);
            if (32779 != error && (32769 == error || 32770 == error)) {
                hfcpMappingData.setSendTime(0);
                TEHFCPUtil.doSingleUploadStartReq(neid);
                return error;
            }
            TEHFCPUtil.handleSendResult(retIndex, neid, error);
            return error;
        }
        dataInfo.removeHFCPData(retIndex);
        byte[] fileLenArray = new byte[frameHead.getUDataLen()];
        System.arraycopy(frameSet.getFrame().getM_BufVec(), 0, fileLenArray, 0, frameHead.getUDataLen());
        int fileLen = (int)IOStreamConvertor.readUnsignedInt(fileLenArray, 0);
        int packetSum = 0;
        packetSum = 0 == fileLen ? 1 : (0 < fileLen % 800 ? fileLen / 800 + 1 : fileLen / 800);
        dataInfo.setPacketSum(packetSum);
        dataInfo.setData(new byte[fileLen]);
        return TEHFCPUtil.startMultiSend(neid);
    }

    public static int doSingleUploadDataReq(int retIndex, int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleUploadDataReq begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadDataReq TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPPacketHead packetHead = TEHFCPUtil.buildHFCPPacketHead(neid);
        packetHead.setM_nLen(32);
        byte[] bufVec = new byte[48];
        System.arraycopy(packetHead.getPacketHead(), 0, bufVec, 0, packetHead.getPacketHead().length);
        int frameBfuLen = TEHFCPUtil.getFrameBufLen(retIndex, dataInfo);
        TEHFCPFrameHead frameHead = new TEHFCPFrameHead();
        frameHead.init();
        frameHead.setUsPackType((short)70);
        frameHead.setUsSerialNum((short)retIndex);
        frameHead.setUsResult((short)0);
        frameHead.setUsEndTag(65281);
        frameHead.setUBufAddr((retIndex - 1) * 800);
        frameHead.setUBufLen(frameBfuLen);
        byte[] frameBodyData = new byte[]{};
        frameHead.setUBodyCheckSum(0);
        frameHead.setUHeaderCheckSum(TEHFCPUtil.calcCheckSum(frameHead.getFrameHead(), 32));
        System.arraycopy(frameHead.getFrameHead(), 0, bufVec, 16, 32);
        System.arraycopy(frameBodyData, 0, bufVec, 48, frameBodyData.length);
        TEHFCPFrame tmpFrame = new TEHFCPFrame();
        tmpFrame.setM_FrameHead(frameHead);
        tmpFrame.setM_BufVec(frameBodyData);
        TEHFCPFrameSet reqFrameSet = new TEHFCPFrameSet(neid, tmpFrame);
        if (null == dataInfo.getMappingData(retIndex)) {
            TEHFCPMappingData mappingData = new TEHFCPMappingData(retIndex);
            mappingData.setReqFrameSet(reqFrameSet);
            dataInfo.addHFCPData(retIndex, mappingData);
        }
        TEHFCPMappingData data = dataInfo.getMappingData(retIndex);
        data.setSendCount(data.getSendCount() + 1);
        TECommInfo commInfo = TEHFCPCommuMgr.instance().getNeCommuInfo(neid);
        if (null == commInfo) {
            TEHFCPUtil.handleSendResult(retIndex, neid, 1090629639);
            return -1;
        }
        log.info("<HFCP> HFCP Util ---- doSingleUploadDataReq the packet : " + frameHead.getUsSerialNum() + " send!");
        int ret = TECommunicationMgr.instance().send(commInfo, bufVec, 5);
        if (-1 == ret) {
            TEHFCPUtil.handleSendResult(retIndex, neid, 1090629639);
            return -1;
        }
        return ret;
    }

    public static int doSingleUploadDataRsp(int retIndex, int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleUploadDataRsp begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadDataRsp TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPMappingData hfcpMappingData = dataInfo.getMappingData(retIndex);
        TEHFCPFrameSet frameSet = hfcpMappingData.getRspFrameSet();
        int ret = 0;
        boolean blnRtn = TEHFCPUtil.checkPacket(frameSet);
        if (!blnRtn) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadDataRsp packet check FAILED. retIndex = " + retIndex);
            hfcpMappingData.setSendTime(0);
            TEHFCPUtil.doSingleUploadDataReq(retIndex, neid);
            return 0;
        }
        TEHFCPFrameHead frameHead = frameSet.getFrame().getM_FrameHead();
        short result = frameHead.getUsResult();
        if (0 != result) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadDataRsp The" + frameHead.getUsSerialNum() + " packet updaload file from NE result is : " + result);
            int error = IOStreamConvertor.readInt(frameSet.getFrame().getM_BufVec(), 0);
            if (32779 != error && (32769 == error || 32770 == error)) {
                log.info("<HFCP> HFCP Util ---- doSingleUploadDataRsp check head and body error!");
                hfcpMappingData.setSendTime(0);
                TEHFCPUtil.doSingleUploadDataReq(retIndex, neid);
                return error;
            }
            TEHFCPUtil.handleSendResult(retIndex, neid, error);
            return error;
        }
        int packetCount = dataInfo.getPacketSum();
        dataInfo.setSendedPacketCount(dataInfo.getSendedPacketCount() + 1);
        dataInfo.removeHFCPData(retIndex);
        log.info("<HFCP> HFCP Util ---- doSingleUploadDataRsp transfer progress is :  neid->" + neid + "process->" + TEHFCPHandler.instance().getTransferProgress(neid) + "%");
        TEHFCPUtil.writeData(frameSet);
        if (retIndex == packetCount) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadDataRsp this is the last packet!");
            dataInfo.setSendedPacketCount(dataInfo.getPacketSum());
            TEHFCPUtil.doSingleUploadEndReq(neid);
        } else {
            if (-1 == (retIndex = TEHFCPUtil.checkReqIndex(retIndex, dataInfo.getPacketSum()))) {
                return 0;
            }
            ret = TEHFCPUtil.doSingleUploadDataReq(retIndex, neid);
        }
        return ret;
    }

    public static int doSingleUploadEndReq(int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleDownloadEndReq begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadEndReq TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPPacketHead packetHead = TEHFCPUtil.buildHFCPPacketHead(neid);
        packetHead.setM_nLen(32);
        byte[] bufVec = new byte[48];
        System.arraycopy(packetHead.getPacketHead(), 0, bufVec, 0, 16);
        TEHFCPFrameHead frameHead = new TEHFCPFrameHead();
        frameHead.init();
        frameHead.setUsPackType((short)80);
        frameHead.setUsSerialNum((short)0);
        frameHead.setUsResult((short)0);
        frameHead.setUsEndTag(65281);
        byte[] frameBodyData = new byte[]{};
        frameHead.setUBodyCheckSum(0);
        frameHead.setUHeaderCheckSum(TEHFCPUtil.calcCheckSum(frameHead.getFrameHead(), 32));
        System.arraycopy(frameHead.getFrameHead(), 0, bufVec, 16, 32);
        System.arraycopy(frameBodyData, 0, bufVec, 48, frameBodyData.length);
        TEHFCPFrame tmpFrame = new TEHFCPFrame();
        tmpFrame.setM_FrameHead(frameHead);
        tmpFrame.setM_BufVec(frameBodyData);
        TEHFCPFrameSet reqFrameSet = new TEHFCPFrameSet(neid, tmpFrame);
        int index = reqFrameSet.getFrameIndex();
        if (null == dataInfo.getMappingData(index)) {
            TEHFCPMappingData endData = new TEHFCPMappingData(index);
            endData.setReqFrameSet(reqFrameSet);
            dataInfo.addHFCPData(index, endData);
        }
        TEHFCPMappingData data = dataInfo.getMappingData(index);
        data.setSendCount(data.getSendCount() + 1);
        TECommInfo commInfo = TEHFCPCommuMgr.instance().getNeCommuInfo(neid);
        if (null == commInfo) {
            TEHFCPUtil.handleSendResult(0, neid, 1090629639);
            return -1;
        }
        int ret = TECommunicationMgr.instance().send(commInfo, bufVec, 5);
        if (-1 == ret) {
            TEHFCPUtil.handleSendResult(0, neid, 1090629639);
            return -1;
        }
        return ret;
    }

    public static int doSingleUploadEndRsp(int retIndex, int neid) {
        log.info("<HFCP> HFCP Util ---- doSingleUploadEndRsp begin!");
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadEndRsp TEHFCPDataInfo is null!");
            return 0;
        }
        TEHFCPMappingData hfcpMappingData = dataInfo.getMappingData(retIndex);
        TEHFCPFrameSet frameSet = hfcpMappingData.getRspFrameSet();
        boolean blnRtn = TEHFCPUtil.checkPacket(frameSet);
        if (!blnRtn) {
            log.info("<HFCP> HFCP Util ---- doSingleUploadEndRsp check failed!");
            hfcpMappingData.setSendTime(0);
            TEHFCPUtil.doSingleUploadEndReq(neid);
            return 0;
        }
        TEHFCPFrameHead frameHead = frameSet.getFrame().getM_FrameHead();
        short result = frameHead.getUsResult();
        log.info("<HFCP> HFCP Util ---- doSingleUploadEndRsp The" + frameHead.getUsSerialNum() + " packet send to NE result is : " + result);
        if (0 != result) {
            int error = IOStreamConvertor.readInt(frameSet.getFrame().getM_BufVec(), 0);
            if (32779 != error && (32769 == error || 32770 == error)) {
                log.info("<HFCP> HFCP Util ---- doSingleDownloadDataRsp check head and body error!");
                hfcpMappingData.setSendTime(0);
                TEHFCPUtil.doSingleUploadEndReq(neid);
                return 0;
            }
            TEHFCPUtil.handleSendResult(retIndex, neid, error);
            return error;
        }
        TEHFCPUtil.handleSendResult(retIndex, neid, 0);
        return 0;
    }

    private static TEHFCPPacketHead buildHFCPPacketHead(int neid) {
        TEHFCPPacketHead packetHead = new TEHFCPPacketHead();
        packetHead.init();
        packetHead.fillPacketHead(neid, 0);
        return packetHead;
    }

    private static TEHFCPFrameHead buildHFCPFrameHead(short frameType) {
        int dataLen = 510;
        TEHFCPFrameHead frameHead = new TEHFCPFrameHead();
        frameHead.init();
        frameHead.setUsPackType(frameType);
        frameHead.setUsSerialNum((short)0);
        frameHead.setUsResult((short)0);
        frameHead.setUsEndTag(65281);
        frameHead.setUDataLen(dataLen);
        return frameHead;
    }

    private static void writeData(TEHFCPFrameSet frameSet) {
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(frameSet.getNeid());
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- writeData TEHFCPDataInfo is null!");
            return;
        }
        byte[] frameData = frameSet.getFrame().getM_BufVec();
        int copyIndex = (frameSet.getFrame().getM_FrameHead().getUsSerialNum() - 1) * 800;
        int dataLen = frameData.length;
        if (dataInfo.getData().length - copyIndex < 800) {
            dataLen = dataInfo.getData().length - copyIndex;
        }
        log.info("<HFCP> HFCP Util ---- writeData copy index is : " + copyIndex);
        System.arraycopy(frameData, 0, dataInfo.getData(), copyIndex, dataLen);
    }

    private static int startMultiSend(int neid) {
        log.info("<HFCP> HFCP Util ---- startMultiSend begin!");
        int ret = 0;
        int startIndex = 1;
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        int sendType = dataInfo.getSendType();
        int packetSum = dataInfo.getPacketSum();
        int multiSum = 8;
        if (packetSum < 8) {
            multiSum = packetSum;
        }
        for (int index = startIndex; index <= multiSum; ++index) {
            ret = sendType == 2 ? TEHFCPUtil.doSingleDownloadDataReq(index, neid) : TEHFCPUtil.doSingleUploadDataReq(index, neid);
        }
        return ret;
    }

    private static int calcCheckSum(byte[] data, int len) {
        int sum = 0;
        int dataNum = 0;
        for (int i = 0; i < len; ++i) {
            dataNum = IOStreamConvertor.readUnsignedByte(data[i]);
            sum += dataNum;
        }
        return sum;
    }

    private static boolean checkPacket(TEHFCPFrameSet frameSet) {
        log.info("<HFCP> HFCP Util ---- checkPacket begin!");
        int checkSum = 0;
        TEHFCPFrameHead frameHead = frameSet.getFrame().getM_FrameHead();
        checkSum = TEHFCPUtil.calcCheckSum(frameHead.getFrameHead(), 28);
        boolean ret = false;
        log.info("<HFCP> HFCP Util ---- checkPacket : frame head check Sum is " + checkSum);
        if (checkSum == frameHead.getUHeaderCheckSum()) {
            ret = true;
        }
        if (!ret || 0 == frameHead.getFrameHead().length) {
            return ret;
        }
        if (null == frameSet.getFrame().getM_BufVec()) {
            return false;
        }
        checkSum = TEHFCPUtil.calcCheckSum(frameSet.getFrame().getM_BufVec(), frameSet.getFrame().getM_BufVec().length);
        log.info("<HFCP> HFCP Util ---- checkPacket : frame body check Sum is " + checkSum);
        return frameHead.getUDataLen() == 0 || checkSum == frameHead.getUBodyCheckSum();
    }

    private static int checkReqIndex(int index, int packetSum) {
        if (index + 8 > packetSum) {
            return -1;
        }
        return index + 8;
    }

    private static int getFrameBufLen(int frameSerialNum, TEHFCPDataInfo dataInfo) {
        if (frameSerialNum == dataInfo.getPacketSum()) {
            int tmpDataLen = dataInfo.getData().length % 800;
            return tmpDataLen;
        }
        return 800;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSendResult(int retIndex, int neid, int errorcode) {
        log.info("<HFCP> HFCP Util ---- handleSendResult begin, errocode is : " + errorcode);
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            log.info("<HFCP> HFCP Util ---- handleSendResult TEHFCPDataInfo is null!");
            return;
        }
        dataInfo.endAllTimer();
        TEHFCPTaskManager.instance().setNECanReceive(neid, false);
        log.info("<HFCP> HFCP Util ---- handleSendResult end timer success!");
        TEHFCPDataInfo tEHFCPDataInfo = dataInfo;
        synchronized (tEHFCPDataInfo) {
            try {
                dataInfo.setFinished();
                TEHFCPHandler.instance().setRet(errorcode);
                dataInfo.notifyAll();
            }
            catch (Exception e) {
                log.info("<HFCP> HFCP Util ---- handleSendSucc stop thread exception!");
                log.error("HFCP failed", (Throwable)e);
            }
        }
    }
}

