/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.hfcpadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPDataInfo;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFileDataMgr;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFrameHead;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFrameSet;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPHandler;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPMappingData;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPUtil;
import com.huawei.uflight.necomm.TEMessageBlock;
import com.huawei.uflight.necomm.TEMessageQueue;
import org.slf4j.Logger;

public class TEHFCPTaskManager {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static TEHFCPTaskManager hfcpTaskManager = new TEHFCPTaskManager();
    private TEMessageQueue responseQueue = new TEMessageQueue();
    private Thread responseProcessThread = null;
    private Object responseMux = new Object();
    private static int STARTCOUNT = 0;
    private static int MAXCOUNT = 4;
    private Thread.UncaughtExceptionHandler rspThreadExcptionHandler = new RspThreadExceptionHandler();

    public static TEHFCPTaskManager instance() {
        return hfcpTaskManager;
    }

    private TEHFCPTaskManager() {
        this.startHPCPRspProcessThread();
    }

    public void startHPCPRspProcessThread() {
        this.responseProcessThread = new Thread(){

            @Override
            public void run() {
                log.info("<HFCP> HFCP Task Manager ---- The thread HFCP Response Thread has start! the count is " + STARTCOUNT);
                while (true) {
                    TEMessageBlock msgBlock = TEHFCPTaskManager.this.deResponseQueue();
                    TEHFCPFrameSet frameSet = (TEHFCPFrameSet)msgBlock.getObj();
                    int ret = TEHFCPTaskManager.instance().handleRspFrame(frameSet);
                    TEHFCPHandler.instance().setRet(ret);
                }
            }
        };
        this.responseProcessThread.setName("HFCPResponseThread");
        this.responseProcessThread.setPriority(2);
        this.responseProcessThread.setUncaughtExceptionHandler(this.rspThreadExcptionHandler);
        ++STARTCOUNT;
        this.responseProcessThread.start();
    }

    public int getCount() {
        return STARTCOUNT;
    }

    public int getMaxCount() {
        return MAXCOUNT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enResponseQueue(TEMessageBlock msgBlock) {
        Object object = this.responseMux;
        synchronized (object) {
            log.info("One message has input in the HFCPResponseThread!");
            this.responseQueue.enqueue(msgBlock);
            this.responseMux.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEMessageBlock deResponseQueue() {
        Object object = this.responseMux;
        synchronized (object) {
            while (this.responseQueue.getSize() == 0) {
                try {
                    this.responseMux.wait(500000L);
                }
                catch (Exception e) {
                    log.error("TEHFCPTaskManager.deResponseQueue() fail!", (Throwable)e);
                }
            }
            log.info("<HFCP> HFCP Task Manager ---- One message has output from the HFCPResponseThread!");
            return this.responseQueue.dequeue();
        }
    }

    private int handleRspFrame(TEHFCPFrameSet frameSet) {
        log.info("<HFCP> HFCP Task Manager ---- Handle response frame begin!");
        int ret = 1090613363;
        TEHFCPFrameHead frameHead = frameSet.getFrame().getM_FrameHead();
        if ("@SBS".equals(frameHead.getSzHeader())) {
            short packetType = frameHead.getUsPackType();
            int returnIndex = frameSet.getFrameIndex();
            int neid = frameSet.getNeid();
            switch (packetType) {
                case 67: {
                    if (0 != this.addToHFCPMapping(1, frameSet)) break;
                    ret = TEHFCPUtil.doSingleUploadStartRsp(returnIndex, neid);
                    break;
                }
                case 65: {
                    if (0 != this.addToHFCPMapping(2, frameSet)) {
                        ret = 1090613363;
                        break;
                    }
                    ret = TEHFCPUtil.doSingleDownloadStartRsp(returnIndex - 1, neid);
                    break;
                }
                case 71: {
                    if (0 != this.addToHFCPMapping(1, frameSet)) break;
                    ret = TEHFCPUtil.doSingleUploadDataRsp(returnIndex, neid);
                    break;
                }
                case 69: {
                    if (0 != this.addToHFCPMapping(2, frameSet)) break;
                    ret = TEHFCPUtil.doSingleDownloadDataRsp(returnIndex - 1, neid);
                    break;
                }
                case 81: {
                    if (0 != this.addToHFCPMapping(1, frameSet)) break;
                    ret = TEHFCPUtil.doSingleUploadEndRsp(returnIndex, neid);
                    break;
                }
                case 73: {
                    if (0 != this.addToHFCPMapping(2, frameSet)) break;
                    ret = TEHFCPUtil.doSingleDownloadEndRsp(returnIndex - 1, neid);
                    break;
                }
                default: {
                    ret = 0;
                }
            }
        }
        return ret;
    }

    public Thread getResponseProcessThread() {
        return this.responseProcessThread;
    }

    private int addToHFCPMapping(int sendType, TEHFCPFrameSet rspFrameSet) {
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(rspFrameSet.getNeid());
        int index = 2 == sendType ? rspFrameSet.getFrameIndex() - 1 : rspFrameSet.getFrameIndex();
        if (null == dataInfo) {
            return -1;
        }
        TEHFCPMappingData hfcpMappingData = dataInfo.getMappingData(index);
        if (null == hfcpMappingData) {
            return -1;
        }
        hfcpMappingData.setRspFrameSet(rspFrameSet);
        return 0;
    }

    public boolean isReceive(TEMessageBlock msgBolck) {
        boolean canRecieve = TEHFCPFileDataMgr.instance().canReceive(msgBolck);
        return canRecieve;
    }

    public void setNECanReceive(int neID, boolean canReceive) {
        TEHFCPFileDataMgr.instance().setNECanReceive(neID, canReceive);
    }

    private static class RspThreadExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private RspThreadExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            log.error("<HFCP> HFCP Occur An Unknown Exception!", e);
        }
    }
}

