/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.hfcpadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.util.io.IOStreamConvertor;

public class TEHFCPPacketHead {
    private long m_ulDstAddr = 0L;
    private long m_ulSrcAddr = 0L;
    private int m_nType = 0;
    private int m_nLen = 0;
    private long m_ulReserved = 0L;

    public void init() {
        this.setM_ulDstAddr(0L);
        this.setM_ulSrcAddr(0L);
        this.setM_nType(0);
        this.setM_nLen(0);
        this.setM_ulReserved(0L);
    }

    public void fillPacketHead(long DstAddr, int Type2) {
        this.setM_ulDstAddr(DstAddr);
        this.setM_nType(Type2);
        this.setM_ulReserved(0L);
    }

    public int readFromStream(byte[] bufVec) {
        if (bufVec.length < this.getHFCPPacketHeadSize()) {
            TELogFactory.getNEAdapterLogger().info(" data not enough long ! \n");
            return -2;
        }
        this.m_ulDstAddr = IOStreamConvertor.readUnsignedInt(bufVec, 0);
        this.m_ulSrcAddr = IOStreamConvertor.readUnsignedInt(bufVec, 4);
        this.m_nType = IOStreamConvertor.readUnsignedShort(bufVec, 8);
        this.m_nLen = IOStreamConvertor.readUnsignedShort(bufVec, 10);
        this.m_ulReserved = IOStreamConvertor.readUnsignedInt(bufVec, 12);
        return 0;
    }

    public byte[] getPacketHead() {
        byte[] packetHeadByte = new byte[16];
        int nOffset = 0;
        byte[] tmpByte = IOStreamConvertor.int2Bytes((int)this.m_ulDstAddr);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset, 4);
        tmpByte = IOStreamConvertor.int2Bytes((int)this.m_ulSrcAddr);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset += 4, 4);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.m_nType);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset += 4, 2);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.m_nLen);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset += 2, 2);
        tmpByte = IOStreamConvertor.int2Bytes((int)this.m_ulReserved);
        System.arraycopy(tmpByte, 0, packetHeadByte, nOffset += 2, 4);
        return packetHeadByte;
    }

    public int getHFCPPacketHeadSize() {
        return 16;
    }

    public int getM_nLen() {
        return this.m_nLen;
    }

    public void setM_nLen(int len) {
        this.m_nLen = len;
    }

    public int getM_nType() {
        return this.m_nType;
    }

    public void setM_nType(int type) {
        this.m_nType = type;
    }

    public long getM_ulDstAddr() {
        return this.m_ulDstAddr;
    }

    public void setM_ulDstAddr(long dstAddr) {
        this.m_ulDstAddr = dstAddr;
    }

    public long getM_ulReserved() {
        return this.m_ulReserved;
    }

    public void setM_ulReserved(long reserved) {
        this.m_ulReserved = reserved;
    }

    public long getM_ulSrcAddr() {
        return this.m_ulSrcAddr;
    }

    public void setM_ulSrcAddr(long srcAddr) {
        this.m_ulSrcAddr = srcAddr;
    }
}

