/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.hfcpadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFrameSet;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPUtil;
import org.slf4j.Logger;

public class TEHFCPMappingData {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private int index;
    private TEHFCPFrameSet reqFrameSet;
    private TEHFCPFrameSet rspFrameSet;
    private int sendCount = 0;
    private int sendTime = 0;
    private static final int HFCP_REQ_TIME = 1000;
    private static final int HFCP_REQ_DELAY_TIME = 5000;
    private static final int HFCP_SEND_COUNT = 5;

    public TEHFCPMappingData(int index) {
        this.index = index;
    }

    public void printLog() {
        log.info("<HFCP> Mapping Data ---- TEHFCPMappingData the frame index ID is : " + this.index);
    }

    public int getSendCount() {
        return this.sendCount;
    }

    public void setSendCount(int sendCount) {
        this.sendCount = sendCount;
    }

    public int reSendHFCPReq() {
        log.info("<HFCP> Mapping Data ---- reSendHFCPReq begin!");
        int ret = 0;
        this.sendTime = 0;
        TEHFCPFrameSet reqFrameSet = this.getReqFrameSet();
        if (null == reqFrameSet) {
            log.info("<HFCP> Mapping Data ---- reSendHFCPReq reqFrameSet is null. stop resend ");
            return -1;
        }
        int neid = reqFrameSet.getNeid();
        short sendType = reqFrameSet.getFrame().getM_FrameHead().getUsPackType();
        log.info("<HFCP> Mapping Data ---- reSendHFCPReq send type is " + sendType);
        switch (sendType) {
            case 64: {
                log.info("<HFCP> Mapping Data ---- doSingleDownloadStartReq resend");
                ret = TEHFCPUtil.doSingleDownloadStartReq(neid);
                break;
            }
            case 68: {
                log.info("<HFCP> Mapping Data ---- doSingleDownloadDataReq resend");
                ret = TEHFCPUtil.doSingleDownloadDataReq(this.index, neid);
                break;
            }
            case 72: {
                log.info("<HFCP> Mapping Data ---- doSingleDownloadEndReq resend");
                ret = TEHFCPUtil.doSingleDownloadEndReq(neid);
                break;
            }
            case 66: {
                log.info("<HFCP> Mapping Data ---- doSingleUploadStartReq resend");
                ret = TEHFCPUtil.doSingleUploadStartReq(neid);
                break;
            }
            case 70: {
                log.info("<HFCP> Mapping Data ---- doSingleUploadDataReq resend");
                ret = TEHFCPUtil.doSingleUploadDataReq(this.index, neid);
                break;
            }
            case 80: {
                log.info("<HFCP> Mapping Data ---- doSingleUploadEndReq resend");
                ret = TEHFCPUtil.doSingleUploadEndReq(neid);
                break;
            }
            default: {
                ret = 0;
            }
        }
        return ret;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public synchronized TEHFCPFrameSet getRspFrameSet() {
        return this.rspFrameSet;
    }

    public synchronized void setRspFrameSet(TEHFCPFrameSet rspFrameSet) {
        this.rspFrameSet = rspFrameSet;
    }

    public synchronized TEHFCPFrameSet getReqFrameSet() {
        return this.reqFrameSet;
    }

    public synchronized void setReqFrameSet(TEHFCPFrameSet reqFrameSet) {
        this.reqFrameSet = reqFrameSet;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.index;
        result = 31 * result + (this.rspFrameSet == null ? 0 : this.rspFrameSet.hashCode());
        result = 31 * result + (this.reqFrameSet == null ? 0 : this.reqFrameSet.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEHFCPMappingData other = (TEHFCPMappingData)obj;
        if (this.index != other.index) {
            return false;
        }
        if (this.rspFrameSet == null ? other.rspFrameSet != null : !this.rspFrameSet.equals(other.rspFrameSet)) {
            return false;
        }
        return !(this.reqFrameSet == null ? other.reqFrameSet != null : !this.reqFrameSet.equals(other.reqFrameSet));
    }

    public int getSendTime() {
        return this.sendTime;
    }

    public void setSendTime(int sendTime) {
        this.sendTime = sendTime;
    }
}

