/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.hfcpadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPCommuMgr;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPDataInfo;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFileDataMgr;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPMessageValidater;
import com.huawei.uflight.qxprotocol.IMessageValidater;
import com.huawei.uflight.qxprotocol.TEAdapterManager;
import org.slf4j.Logger;

public class TEHFCPHandler {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static final int BRBASE_UPLOAD_TYPE = 1;
    private static final int BRBASE_DOWNLOAD_TYPE = 2;
    private static TEHFCPHandler hfcpHandler = new TEHFCPHandler();
    private int ret = 0;
    private IMessageValidater hfcpChecker = null;

    public static TEHFCPHandler instance() {
        hfcpHandler.registerHandler();
        return hfcpHandler;
    }

    private void registerHandler() {
        if (null == this.hfcpChecker) {
            this.hfcpChecker = new TEHFCPMessageValidater();
            TEAdapterManager.instance().registerMessageValidater(this.hfcpChecker);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendHFCPFile(byte[] fileData, String neFilePath, String localFilePath, String fileName, int neid) {
        log.info("<HFCP> HFCP Handler ---- Send file " + fileName + "begin!");
        TEHFCPDataInfo dataInfo = new TEHFCPDataInfo(neid, fileData, 2, neFilePath, localFilePath, fileName);
        TEHFCPFileDataMgr.instance().registerHFCPData(neid, dataInfo);
        this.ret = TEHFCPCommuMgr.instance().sendFile(neFilePath, localFilePath, fileName, neid);
        if (-1 == this.ret) {
            log.info("<HFCP> HFCP Handler ---- The first HFCP packet send failed!");
            log.info("<HFCP> HFCP Handler ---- Send file result is : " + this.ret);
            dataInfo.stopReceive();
            dataInfo.setFinished();
            dataInfo.endAllTimer();
            TEHFCPFileDataMgr.instance().unregisterHFCPData(neid);
            return this.ret;
        }
        log.info("<HFCP> HFCP Handler ---- Send file block the main thread begin!");
        dataInfo.proceedReceive();
        TEHFCPDataInfo tEHFCPDataInfo = dataInfo;
        synchronized (tEHFCPDataInfo) {
            while (!dataInfo.getCanFinishFlag()) {
                try {
                    dataInfo.wait(1800000L);
                }
                catch (Exception e) {
                    log.info("<HFCP> HFCP Handler ---- Send file block the main thread exception!");
                    log.error("HFCP failed", (Throwable)e);
                }
            }
        }
        log.info("<HFCP> HFCP Handler ---- Send file block the main thread end!");
        dataInfo.stopReceive();
        dataInfo.endAllTimer();
        TEHFCPFileDataMgr.instance().unregisterHFCPData(neid);
        log.info("<HFCP> HFCP Handler ---- Send file result is : " + this.ret);
        return this.ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getHFCPFile(String neFilePath, String localFilePath, String fileName, int neid) {
        log.info("<HFCP> HFCP Handler ---- Get file " + fileName + "begin!");
        TEHFCPDataInfo dataInfo = new TEHFCPDataInfo(neid, null, 1, neFilePath, localFilePath, fileName);
        TEHFCPFileDataMgr.instance().registerHFCPData(neid, dataInfo);
        this.ret = TEHFCPCommuMgr.instance().getFile(neFilePath, localFilePath, fileName, neid);
        if (-1 == this.ret) {
            log.info("<HFCP> HFCP Handler ---- The first HFCP packet send failed!");
            dataInfo.stopReceive();
            dataInfo.setFinished();
            dataInfo.endAllTimer();
            TEHFCPFileDataMgr.instance().unregisterHFCPData(neid);
            return null;
        }
        dataInfo.proceedReceive();
        TEHFCPDataInfo tEHFCPDataInfo = dataInfo;
        synchronized (tEHFCPDataInfo) {
            while (!dataInfo.getCanFinishFlag()) {
                try {
                    dataInfo.wait(1800000L);
                }
                catch (Exception e) {
                    log.info("<HFCP> HFCP Handler ---- Get file block the main thread exception!");
                    log.error("HFCP failed", (Throwable)e);
                }
            }
        }
        dataInfo.stopReceive();
        dataInfo.endAllTimer();
        TEHFCPFileDataMgr.instance().unregisterHFCPData(neid);
        log.info("<HFCP> HFCP Handler ---- Get file success!");
        int dataLength = 0;
        dataLength = null == dataInfo.getData() ? 0 : dataInfo.getData().length;
        log.info("<HFCP> HFCP Handler ---- The file length is " + dataLength);
        return dataInfo.getData();
    }

    public int getTransferProgress(int neid) {
        TEHFCPDataInfo dataInfo = TEHFCPFileDataMgr.instance().getDataInfo(neid);
        if (null == dataInfo) {
            return -1;
        }
        log.info("<HFCP> HFCP Handler ---- Get transfer progress is:  neid-> " + neid + "  process->" + dataInfo.getProgress() + "%");
        return dataInfo.getProgress();
    }

    public synchronized int getRet() {
        return this.ret;
    }

    public synchronized void setRet(int ret) {
        this.ret = ret;
    }
}

