/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.hfcpadapter;

import com.huawei.nglct.util.io.IOStreamConvertor;

public class TEHFCPFrameHead {
    private String szHeader;
    private short usPackType;
    private short usSerialNum;
    private short usResult;
    private int usEndTag;
    private int uDataLen;
    private int uBufAddr;
    private int uBufLen;
    private int uBodyCheckSum;
    private int uHeaderCheckSum;

    public void init() {
        short initData = 0;
        this.setSzHeader("@SBS");
        this.setUsPackType(initData);
        this.setUsSerialNum(initData);
        this.setUsResult(initData);
        this.setUsEndTag(initData);
        this.setUDataLen(initData);
        this.setUBufAddr(initData);
        this.setUBufLen(initData);
        this.setUBodyCheckSum(initData);
        this.setUHeaderCheckSum(initData);
    }

    public int readFromStream(byte[] bufVec) {
        int usSize = 0;
        if (null == bufVec || bufVec.length == 0) {
            return usSize;
        }
        byte[] temp = new byte[4];
        System.arraycopy(bufVec, 0, temp, 0, 4);
        String hfcpFrameHeader = new String(temp);
        this.setSzHeader(hfcpFrameHeader);
        this.setUsPackType((short)IOStreamConvertor.readUnsignedShort(bufVec, 4));
        this.setUsSerialNum((short)IOStreamConvertor.readUnsignedShort(bufVec, 6));
        this.setUsResult((short)IOStreamConvertor.readUnsignedShort(bufVec, 8));
        this.setUsEndTag((short)IOStreamConvertor.readUnsignedShort(bufVec, 10));
        this.setUDataLen((int)IOStreamConvertor.readUnsignedInt(bufVec, 12));
        this.setUBufAddr((int)IOStreamConvertor.readUnsignedInt(bufVec, 16));
        this.setUBufLen((int)IOStreamConvertor.readUnsignedInt(bufVec, 20));
        this.setUBodyCheckSum((int)IOStreamConvertor.readUnsignedInt(bufVec, 24));
        this.setUHeaderCheckSum((int)IOStreamConvertor.readUnsignedInt(bufVec, 28));
        return 0;
    }

    public byte[] getFrameHead() {
        byte[] frameHeadByte = new byte[32];
        int nOffset = 0;
        System.arraycopy("@SBS".getBytes(), 0, frameHeadByte, nOffset, 4);
        byte[] tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.getUsPackType());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 4, 2);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.getUsSerialNum());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 2, 2);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.getUsResult());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 2, 2);
        tmpByte = IOStreamConvertor.unsignedShort2Bytes(this.getUsEndTag());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 2, 2);
        tmpByte = IOStreamConvertor.int2Bytes(this.getUDataLen());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 2, 4);
        tmpByte = IOStreamConvertor.int2Bytes(this.getUBufAddr());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 4, 4);
        tmpByte = IOStreamConvertor.int2Bytes(this.getUBufLen());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 4, 4);
        tmpByte = IOStreamConvertor.int2Bytes(this.getUBodyCheckSum());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 4, 4);
        tmpByte = IOStreamConvertor.int2Bytes(this.getUHeaderCheckSum());
        System.arraycopy(tmpByte, 0, frameHeadByte, nOffset += 4, 4);
        return frameHeadByte;
    }

    public int getTypeSize() {
        return 32;
    }

    public String getSzHeader() {
        return this.szHeader;
    }

    public void setSzHeader(String szHeader) {
        this.szHeader = szHeader;
    }

    public int getUBodyCheckSum() {
        return this.uBodyCheckSum;
    }

    public void setUBodyCheckSum(int bodyCheckSum) {
        this.uBodyCheckSum = bodyCheckSum;
    }

    public int getUBufAddr() {
        return this.uBufAddr;
    }

    public void setUBufAddr(int bufAddr) {
        this.uBufAddr = bufAddr;
    }

    public int getUBufLen() {
        return this.uBufLen;
    }

    public void setUBufLen(int bufLen) {
        this.uBufLen = bufLen;
    }

    public int getUDataLen() {
        return this.uDataLen;
    }

    public void setUDataLen(int dataLen) {
        this.uDataLen = dataLen;
    }

    public int getUHeaderCheckSum() {
        return this.uHeaderCheckSum;
    }

    public void setUHeaderCheckSum(int headerCheckSum) {
        this.uHeaderCheckSum = headerCheckSum;
    }

    public int getUsEndTag() {
        return this.usEndTag;
    }

    public void setUsEndTag(int usEndTag) {
        this.usEndTag = usEndTag;
    }

    public short getUsPackType() {
        return this.usPackType;
    }

    public void setUsPackType(short usPackType) {
        this.usPackType = usPackType;
    }

    public short getUsResult() {
        return this.usResult;
    }

    public void setUsResult(short usResult) {
        this.usResult = usResult;
    }

    public short getUsSerialNum() {
        return this.usSerialNum;
    }

    public void setUsSerialNum(short usSerialNum) {
        this.usSerialNum = usSerialNum;
    }
}

