/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.hfcpadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFileDataMgr;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPHandler;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPMappingData;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPTaskManager;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.util.Timer;
import java.util.TimerTask;
import org.slf4j.Logger;

public class TEHFCPDataInfo {
    private static final int TIMER_PERIOD = 1000;
    private static final String TIMER_NAME = "TEHFCPTimer";
    private static final int HFCP_REQ_TIME = 1000;
    private static final int HFCP_REQ_DELAY_TIME = 10000;
    private static final int HFCP_SEND_COUNT = 5;
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private long neid;
    private byte[] data;
    private int sendType;
    private int sendedPacketCount = 0;
    private int packetSum;
    private TIntObjectHashMap<TEHFCPMappingData> hfcpDataMap = new TIntObjectHashMap();
    private String neFilePath = null;
    private String localFilePath = null;
    private String fileName = null;
    private boolean canReceive = true;
    private boolean canFinishFlag = false;
    private Timer timer = new Timer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endAllTimer() {
        TIntObjectHashMap<TEHFCPMappingData> tIntObjectHashMap = this.hfcpDataMap;
        synchronized (tIntObjectHashMap) {
            this.endTimer();
        }
    }

    private void startTimer() {
        this.endTimer();
        this.timer = new Timer(TIMER_NAME);
        TEHFCPTimerTask task = new TEHFCPTimerTask();
        this.timer.scheduleAtFixedRate((TimerTask)task, 0L, 1000L);
    }

    private void endTimer() {
        if (null != this.timer) {
            this.timer.cancel();
        }
    }

    public synchronized boolean getCanFinishFlag() {
        return this.canFinishFlag;
    }

    public synchronized void setFinished() {
        this.canFinishFlag = true;
    }

    public synchronized void setNotFinished() {
        this.canFinishFlag = false;
    }

    public synchronized boolean canReceive() {
        return this.canReceive;
    }

    public synchronized void stopReceive() {
        this.canReceive = false;
    }

    public synchronized void proceedReceive() {
        this.canReceive = true;
    }

    public TEHFCPDataInfo(long neid, byte[] data, int sendType, String neFilePath, String localFilePath, String fileName) {
        this.neid = neid;
        this.data = data;
        this.sendType = sendType;
        if (null == data || 0 == data.length) {
            this.packetSum = 1;
        } else {
            int cacPacketSum = data.length / 800;
            if (0 < data.length % 800) {
                ++cacPacketSum;
            }
            this.packetSum = cacPacketSum;
        }
        this.neFilePath = neFilePath;
        this.localFilePath = localFilePath;
        this.fileName = fileName;
        this.startTimer();
    }

    public int getProgress() {
        if (0 != this.packetSum) {
            return this.sendedPacketCount * 100 / this.packetSum;
        }
        return 100;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHFCPData(int index, TEHFCPMappingData data) {
        TIntObjectHashMap<TEHFCPMappingData> tIntObjectHashMap = this.hfcpDataMap;
        synchronized (tIntObjectHashMap) {
            if (this.hfcpDataMap.containsKey(index)) {
                return;
            }
            this.hfcpDataMap.put(index, (Object)data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeHFCPData(int index) {
        TIntObjectHashMap<TEHFCPMappingData> tIntObjectHashMap = this.hfcpDataMap;
        synchronized (tIntObjectHashMap) {
            this.hfcpDataMap.remove(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TEHFCPMappingData getMappingData(int index) {
        TIntObjectHashMap<TEHFCPMappingData> tIntObjectHashMap = this.hfcpDataMap;
        synchronized (tIntObjectHashMap) {
            return (TEHFCPMappingData)this.hfcpDataMap.get(index);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    public long getNeid() {
        return this.neid;
    }

    public void setNeid(long neid) {
        this.neid = neid;
    }

    public int getPacketSum() {
        return this.packetSum;
    }

    public void setPacketSum(int packetSum) {
        this.packetSum = packetSum;
    }

    public int getSendedPacketCount() {
        return this.sendedPacketCount;
    }

    public void setSendedPacketCount(int sendedPacketCount) {
        this.sendedPacketCount = sendedPacketCount;
    }

    public int getSendType() {
        return this.sendType;
    }

    public void setSendType(int sendType) {
        this.sendType = sendType;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getLocalFilePath() {
        return this.localFilePath;
    }

    public void setLocalFilePath(String localFilePath) {
        this.localFilePath = localFilePath;
    }

    public String getNeFilePath() {
        return this.neFilePath;
    }

    public void setNeFilePath(String neFilePath) {
        this.neFilePath = neFilePath;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + (this.fileName == null ? 0 : this.fileName.hashCode());
        result = 31 * result + (this.hfcpDataMap == null ? 0 : this.hfcpDataMap.hashCode());
        result = 31 * result + (this.localFilePath == null ? 0 : this.localFilePath.hashCode());
        result = 31 * result + (this.neFilePath == null ? 0 : this.neFilePath.hashCode());
        result = 31 * result + (int)(this.neid ^ this.neid >>> 32);
        result = 31 * result + this.packetSum;
        result = 31 * result + this.sendType;
        result = 31 * result + this.sendedPacketCount;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TEHFCPDataInfo other = (TEHFCPDataInfo)obj;
        if (this.fileName == null ? other.fileName != null : !this.fileName.equals(other.fileName)) {
            return false;
        }
        if (this.hfcpDataMap == null ? other.hfcpDataMap != null : !this.hfcpDataMap.equals(other.hfcpDataMap)) {
            return false;
        }
        if (this.localFilePath == null ? other.localFilePath != null : !this.localFilePath.equals(other.localFilePath)) {
            return false;
        }
        if (this.neFilePath == null ? other.neFilePath != null : !this.neFilePath.equals(other.neFilePath)) {
            return false;
        }
        if (this.neid != other.neid) {
            return false;
        }
        if (this.packetSum != other.packetSum) {
            return false;
        }
        if (this.sendType != other.sendType) {
            return false;
        }
        return this.sendedPacketCount == other.sendedPacketCount;
    }

    private class TEHFCPTimerTask
    extends TimerTask {
        private TEHFCPTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TIntObjectHashMap tIntObjectHashMap = TEHFCPDataInfo.this.hfcpDataMap;
            synchronized (tIntObjectHashMap) {
                TIntObjectIterator iter = TEHFCPDataInfo.this.hfcpDataMap.iterator();
                while (iter.hasNext()) {
                    iter.advance();
                    if (-1 != this.dataHandler((TEHFCPMappingData)iter.value())) continue;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int dataHandler(TEHFCPMappingData dataInfo) {
            int sendCount = dataInfo.getSendCount();
            int sendTime = dataInfo.getSendTime();
            if (sendCount < 5) {
                if (sendTime < 10000) {
                    dataInfo.setSendTime(sendTime + 1000);
                } else {
                    dataInfo.setSendTime(0);
                    log.info("<HFCP> Mapping Data ---- TEHFCPMappingData the frame time out, resend the req. pkg index->" + dataInfo.getIndex());
                    log.info("<HFCP> Mapping Data ---- TEHFCPMappingData the frame send count is : " + sendCount);
                    int ret = dataInfo.reSendHFCPReq();
                    if (ret != 0) {
                        log.info("<HFCP> Mapping Data ---- TEHFCPMappingData RESEND FAILED. result is : " + ret);
                        TEHFCPHandler.instance().setRet(ret);
                    }
                }
            } else {
                log.info("<HFCP> Mapping Data ---- TEHFCPMappingData the frame time out after resend 5 times, pkg index->" + dataInfo.getIndex());
                TEHFCPHandler.instance().setRet(1);
                int neID = dataInfo.getReqFrameSet().getNeid();
                TEHFCPTaskManager.instance().setNECanReceive(neID, false);
                TEHFCPDataInfo info = TEHFCPFileDataMgr.instance().getDataInfo(neID);
                if (null == info) {
                    return -1;
                }
                TEHFCPDataInfo tEHFCPDataInfo = info;
                synchronized (tEHFCPDataInfo) {
                    try {
                        info.setFinished();
                        info.endAllTimer();
                        TEHFCPHandler.instance().setRet(1090613363);
                        info.notifyAll();
                    }
                    catch (Exception e) {
                        log.info("<HFCP> HFCP Util ---- handleSendSucc stop thread exception!");
                        log.error("HFCP failed", (Throwable)e);
                    }
                }
                return -1;
            }
            return 0;
        }
    }
}

