/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter.hfcpadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFrame;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPFrameSet;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPPacket;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPPacketHead;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPTaskManager;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPUtil;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEEventCenter;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEEventMsg;
import com.huawei.nglct.util.innerevent.delneevent.TEInnerDelNEObserver;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TEMessageBlock;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import gnu.trove.TIntObjectHashMap;
import org.slf4j.Logger;

public class TEHFCPCommuMgr {
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static final int BRBASE_UPLOAD_TYPE = 1;
    private static final int BRBASE_DOWNLOAD_TYPE = 2;
    private static final int NE_NOT_EXIST = 1090629639;
    private TIntObjectHashMap<TEHFCPFrameSet> frameSetMap = new TIntObjectHashMap();
    private static TEHFCPCommuMgr hfcpCommuMgr = new TEHFCPCommuMgr();
    private TIntObjectHashMap<TECommInfo> neCommuInfoMap = new TIntObjectHashMap();

    public static TEHFCPCommuMgr instance() {
        return hfcpCommuMgr;
    }

    protected void receiveNEDelEvent(TEInnerDelNEEventMsg eventMsg) {
        int neID = eventMsg.getPhyNEID();
        this.unregisterCommu(neID);
    }

    public int sendFile(String neFilePath, String localFilePath, String fileName, int neid) {
        log.info("<HFCP> HFCP Communication Manager ---- Send file " + fileName + " begin!");
        int sendType = 2;
        TENE neData = TENEListMgr.getInstance().getPhyNE(neid);
        if (null == neData) {
            log.info("<HFCP> HFCP Communication Manager ---- The ne does not exist! neid -> " + neid);
            log.info("<HFCP> HFCP Communication Manager ---- Send file result is 1090629639");
            return 1090629639;
        }
        TECommInfo commInfo = TENECommMgr.getInstance().getCommInfo(neData.getNEID());
        if (null == commInfo) {
            log.info("<HFCP> HFCP Communication Manager ---- necommInfo is NULL.");
            return 1090629639;
        }
        log.info("<HFCP> HFCP Communication Manager ---- neid is " + neid + "  ,TECommInfo is " + commInfo);
        this.registerCommu(commInfo, neid);
        int ret = this.sendFirstPacket(sendType, neid);
        return ret;
    }

    public int getFile(String neFilePath, String localFilePath, String fileName, int neid) {
        log.info("<HFCP> HFCP Communication Manager ---- Get file " + fileName + " begin!");
        int sendType = 1;
        TENE neData = TENEListMgr.getInstance().getPhyNE(neid);
        if (null == neData) {
            log.info("<HFCP> HFCP Communication Manager ---- The ne does not exist! neid -> " + neid);
            log.info("<HFCP> HFCP Communication Manager ---- Get file result is 1090629639");
            return 1090629639;
        }
        TECommInfo commInfo = TENECommMgr.getInstance().getCommInfo(neData.getNEID());
        if (null == commInfo) {
            log.info("<HFCP> HFCP Communication Manager ---- necommInfo is NULL.");
            return 1090629639;
        }
        log.info("<HFCP> HFCP Communication Manager ---- neid is " + neid + "  ,TECommInfo is " + commInfo);
        this.registerCommu(commInfo, neid);
        int ret = this.sendFirstPacket(sendType, neid);
        return ret;
    }

    private int sendFirstPacket(int sendType, int neid) {
        log.info("<HFCP> HFCP Communication Manager ---- The first HFCP packet send begin!");
        int ret = 0;
        if (2 == sendType) {
            ret = TEHFCPUtil.doSingleDownloadStartReq(neid);
        } else if (1 == sendType) {
            ret = TEHFCPUtil.doSingleUploadStartReq(neid);
        }
        log.info("<HFCP> HFCP Communication Manager ---- The first HFCP packet send result is : " + ret);
        return ret;
    }

    public synchronized int registerCommu(TECommInfo commInfo, int neid) {
        if (this.neCommuInfoMap.containsKey(neid)) {
            return 0;
        }
        this.neCommuInfoMap.put(neid, (Object)commInfo);
        return 0;
    }

    public synchronized int unregisterCommu(int neid) {
        this.neCommuInfoMap.remove(neid);
        return 0;
    }

    public synchronized void registerFrameSet(int neid, TEHFCPFrameSet frameSet) {
        if (!this.frameSetMap.containsKey(neid)) {
            this.frameSetMap.put(neid, (Object)frameSet);
        }
    }

    public synchronized void unregisterFrameSet(int neid) {
        this.frameSetMap.remove(neid);
    }

    public int checkMessageValid(byte[] data, int offset, int size) {
        TEHFCPPacketHead packetHead = new TEHFCPPacketHead();
        int packetHeadLength = packetHead.getHFCPPacketHeadSize();
        if (size <= packetHeadLength) {
            return -2;
        }
        packetHead.init();
        int iRet = packetHead.readFromStream(data);
        if (iRet != 0) {
            return -2;
        }
        int usPacketLen = packetHeadLength + packetHead.getM_nLen();
        if (usPacketLen > 934) {
            return -1;
        }
        if (offset + size < usPacketLen) {
            return -2;
        }
        int bufsize = 848;
        byte[] dataByte = new byte[bufsize];
        System.arraycopy(data, 0, dataByte, 0, bufsize);
        TEHFCPPacket packet = new TEHFCPPacket();
        if (packet.readFromStream(dataByte) < 0) {
            return -2;
        }
        TEHFCPFrame frame = new TEHFCPFrame();
        if (frame.readFromStream(packet.getM_BufVec()) < 0) {
            return -2;
        }
        if (!"@SBS".equals(frame.getM_FrameHead().getSzHeader())) {
            log.info("<HFCP> HFCP Communication Manager ---- Frame error!The head of frame is not right!");
            return -1;
        }
        TEHFCPFrameSet frameSet = new TEHFCPFrameSet(packet, frame);
        TEMessageBlock msgBolck = new TEMessageBlock((Object)frameSet);
        TEHFCPTaskManager hfcpTask = TEHFCPTaskManager.instance();
        if (hfcpTask.isReceive(msgBolck)) {
            log.info("<HFCP> HFCP Communication Manager ---- TEHFCPCommuMgr is receiving!");
            hfcpTask.enResponseQueue(msgBolck);
            if (hfcpTask.getResponseProcessThread() == null || (hfcpTask.getResponseProcessThread().getState() == Thread.State.TERMINATED || hfcpTask.getResponseProcessThread().getState() == Thread.State.NEW) && hfcpTask.getCount() <= hfcpTask.getMaxCount()) {
                log.info("<HFCP> HFCP Now Restart HPCPRspThread!");
                hfcpTask.startHPCPRspProcessThread();
            }
        }
        return packetHead.getHFCPPacketHeadSize() + packetHead.getM_nLen();
    }

    public static TEHFCPCommuMgr getHfcpCommuMgr() {
        return hfcpCommuMgr;
    }

    public static void setHfcpCommuMgr(TEHFCPCommuMgr hfcpCommuMgr) {
        TEHFCPCommuMgr.hfcpCommuMgr = hfcpCommuMgr;
    }

    public synchronized TECommInfo getNeCommuInfo(int neID) {
        return (TECommInfo)this.neCommuInfoMap.get(neID);
    }

    static {
        TEInnerDelNEEventCenter.getInstance().addObserver(new TEInnerDelNEObserver(){

            @Override
            public void handleDelNEEvent(TEInnerDelNEEventMsg eventMsg) {
                TEHFCPCommuMgr.instance().receiveNEDelEvent(eventMsg);
            }
        });
    }
}

