/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.neadapter;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.common.moduleif.TEModuleFunctionIFMgr;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENECommMgrFacade;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.po.TECommuNe;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TECommuNEMgr {
    private static TECommuNEMgr instance = null;
    private HashMap logicNEIDMap = new HashMap();
    private HashMap neIDMap = new HashMap();
    private HashMap commuNeMap = new HashMap();

    public static synchronized TECommuNEMgr getInstance() {
        if (null == instance) {
            instance = new TECommuNEMgr();
        }
        return instance;
    }

    public OperationResult sendCommand(int neID, ArrayList operationList, int timeOut, SubFunc subFunc) {
        TENE ne;
        boolean transFlag = false;
        boolean isPwdNoLog = false;
        if (subFunc != null) {
            transFlag = subFunc.getTransSupport();
            isPwdNoLog = subFunc.getIsPwdNoLog();
        }
        if (null == (ne = TEConfigurationDataMgr.getInstance().getNE(neID))) {
            TELogFactory.getNormalLogger().error("The ne is not exist! neID->" + neID);
            return null;
        }
        OperationResult result = null;
        if (ne.isPreConfig()) {
            if (TEModuleFunctionIFMgr.getQXOperationDbImpl() != null) {
                result = TEModuleFunctionIFMgr.getQXOperationDbImpl().processQxOperationFromDB(ne, operationList);
            }
        } else {
            result = isPwdNoLog ? TENECommMgr.getInstance().sendCommandNoLog(neID, (List)operationList, timeOut) : (transFlag ? TENECommMgr.getInstance().sendCommand(neID, (List)operationList, null, timeOut, transFlag) : TENECommMgrFacade.getInstance().sendCommand(neID, operationList, timeOut));
            if (TEModuleFunctionIFMgr.getQXOperationDbImpl() != null && result.retCode == 0) {
                TELogFactory.getNormalLogger().info("Start processQxOperationToDB!");
                TEModuleFunctionIFMgr.getQXOperationDbImpl().processQxOperationToDB(ne, operationList);
                TELogFactory.getNormalLogger().info("Finish processQxOperationToDB!");
            }
        }
        return result;
    }

    public void putLogicNEID(int neID, int logicNEID) {
        this.logicNEIDMap.put(logicNEID, neID);
    }

    public int getNEID(int logicNEID) {
        Integer neID = (Integer)this.logicNEIDMap.get(logicNEID);
        if (neID == null) {
            return -1;
        }
        return neID;
    }

    public void deleteNEID(int logicNEID) {
        this.logicNEIDMap.remove(logicNEID);
    }

    public void putNEID(int neID, int logicNEID) {
        this.neIDMap.put(neID, logicNEID);
    }

    public int getLogicNEID(int neID) {
        Integer logicNEID = (Integer)this.neIDMap.get(neID);
        if (logicNEID == null) {
            return -1;
        }
        return logicNEID;
    }

    public void deleteLogicNEID(int neID) {
        this.neIDMap.remove(neID);
    }

    public void putCommuNE(int neID, TECommuNe commuNe) {
        this.commuNeMap.put(neID, commuNe);
    }

    public TECommuNe getCommuNE(int neID) {
        return (TECommuNe)this.commuNeMap.get(neID);
    }

    public TECommuNe getCommuNeByPhyID(int phyID) {
        TECommuNe commuNe = null;
        Iterator iter = this.commuNeMap.values().iterator();
        while (iter.hasNext() && phyID != (commuNe = (TECommuNe)iter.next()).getNeId()) {
        }
        return commuNe;
    }

    public Map getCommuNeMap() {
        return this.commuNeMap;
    }

    public void deleteCommuNE(int neID) {
        this.commuNeMap.remove(neID);
    }

    public Collection getAllCommuNE() {
        return this.commuNeMap.values();
    }

    public static String printOperation(List<Operation> operList) {
        StringBuffer sb = new StringBuffer();
        for (Operation oper : operList) {
            sb.append("\r\n=====================cmdid=" + oper.getCmdid() + "====================\r\n");
            sb.append("inputdata:");
            Input input = oper.getInput();
            Part[] parts = input.getPart();
            for (int i = 0; i < parts.length; ++i) {
                sb.append(" ").append(parts[i].getName()).append("=").append(parts[i].getValue());
            }
            Output[] outputs = oper.getOutput();
            for (int i = 0; i < outputs.length; ++i) {
                Fault[] faults = outputs[i].getFault();
                boolean isSuccess = true;
                for (int j = 0; j < faults.length; ++j) {
                    sb.append("\r\nerrcode=").append(faults[j].getCode());
                    isSuccess = faults[j].getCode().equals("0");
                }
                if (!isSuccess) continue;
                sb.append("\r\noutputdata:");
                Part[] outparts = outputs[i].getPart();
                for (int k = 0; k < outparts.length; ++k) {
                    sb.append(" ").append(outparts[k].getName()).append("=").append(outparts[k].getValue());
                }
            }
        }
        return sb.toString();
    }
}

