/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.devicesearch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.devicesearch.TESearchedNE;
import com.huawei.uflight.necomm.TECommData;
import com.huawei.uflight.necomm.TEInputDataReceiver;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;

public abstract class TENESearchTask
extends Thread
implements TEInputDataReceiver {
    protected String localIP;
    protected int searchState;
    private List searchedNEList = null;
    private ArrayList messageList = null;
    protected Timer sendTimer = null;
    protected boolean hasConn = false;

    protected TENESearchTask() {
    }

    public TENESearchTask(String ip) {
        this.localIP = ip;
        this.searchState = 0;
        this.searchedNEList = new ArrayList();
        this.messageList = new ArrayList();
    }

    protected abstract void receive();

    protected void endSearch() {
        this.setSearchStateEnd();
        this.processAfterSearch();
        TELogFactory.getNormalLogger().info("cancle the timer task;");
        if (this.sendTimer != null) {
            this.sendTimer.cancel();
        }
        TELogFactory.getNormalLogger().info("close the connection.");
        this.closeConnectToNE();
    }

    private void setSearchStateEnd() {
        TELogFactory.getNormalLogger().info("set the search thread searchstate :searchbegin 1");
        this.searchState = 0;
    }

    private void setSearchStateBegin() {
        TELogFactory.getNormalLogger().info("set the search thread searchstate: searchend 0");
        this.searchState = 1;
    }

    private void processAfterSearch() {
    }

    protected void startSearch() {
        this.setSearchStateBegin();
        this.initSearchedNEList();
        this.sendSearchMessage();
    }

    protected abstract void sendSearchMessage();

    private void initSearchedNEList() {
        if (this.searchedNEList == null) {
            this.searchedNEList = new ArrayList();
        } else {
            this.searchedNEList.clear();
        }
    }

    @Override
    public void run() {
        this.startSearch();
        this.receive();
    }

    protected abstract boolean isValidData(TECommData var1);

    public void processNEData(TESearchedNE newNE) {
        if (this.searchedNEList != null && !this.searchedNEList.contains(newNE)) {
            this.searchedNEList.add(newNE);
        }
    }

    protected abstract ArrayList convertToGNEData(byte[] var1, int var2, int var3);

    protected abstract TECommData convetToCommData(String var1, String var2);

    protected abstract void closeConnectToNE();

    public List getSearchedNEList() {
        this.processMessage();
        return this.searchedNEList;
    }

    protected synchronized void processMessage() {
        TECommData data = null;
        int size = this.messageList.size();
        for (int i = 0; i < size; ++i) {
            data = (TECommData)this.messageList.get(i);
            if (data == null) continue;
            ArrayList newNEList = this.convertToGNEData(data.getData(), data.getOffset(), data.getLength());
            int neListSize = newNEList.size();
            for (int j = 0; j < neListSize; ++j) {
                this.processNEData((TESearchedNE)newNEList.get(j));
            }
        }
        this.messageList.clear();
    }

    protected synchronized void addMessage(TECommData data) {
        if (null != this.messageList && this.searchState != 0 && data != null) {
            this.messageList.add(data);
        }
    }

    public int checkMessageValid(byte[] data, int offset, int length) {
        return 0;
    }

    public static final int readUnsignedByte(byte b) {
        return b >= 0 ? b : b + 256;
    }

    public static final int readUnsignedShort(byte[] b, int offset) {
        int ch1 = TENESearchTask.readUnsignedByte(b[0 + offset]);
        int ch2 = TENESearchTask.readUnsignedByte(b[1 + offset]);
        return (ch1 << 8) + (ch2 << 0);
    }

    public static final int readInt(byte[] b, int offset) {
        int ch1 = TENESearchTask.readUnsignedByte(b[0 + offset]);
        int ch2 = TENESearchTask.readUnsignedByte(b[1 + offset]);
        int ch3 = TENESearchTask.readUnsignedByte(b[2 + offset]);
        int ch4 = TENESearchTask.readUnsignedByte(b[3 + offset]);
        return (ch1 << 24) + (ch2 << 16) + (ch3 << 8) + (ch4 << 0);
    }

    synchronized void release() {
        if (this.searchedNEList != null) {
            this.searchedNEList.clear();
            this.searchedNEList = null;
        }
        if (this.messageList != null) {
            this.messageList.clear();
            this.messageList = null;
        }
    }

    public int getMaxPacketLength() {
        return 0;
    }

    public int getHeadLength() {
        return 0;
    }

    public int getFrameLength(byte[] paramArrayOfByte) {
        return 0;
    }
}

