/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.devicesearch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.devicesearch.IPSearchDomain;
import com.huawei.nglct.neinterface.devicesearch.TEGNESearcher;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.necomm.TECommunicationMgr;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class TENESearchMgr {
    private static final int ZERO_INT = 0;
    private static final int ONE_INT = 1;
    private static final int TWO_INT = 2;
    private static final int THREE_INT = 3;
    private static TENESearchMgr _instance = null;
    private TEGNESearcher neSearcher = null;
    private int searcherID = 1;
    private int searchState = 0;
    private String PATH_IPFIELD = "";
    File ipFieldFile = null;

    private TENESearchMgr() {
        String relativePath = "conf" + File.separator + "ipfield.ini";
        this.PATH_IPFIELD = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, relativePath);
        this.ipFieldFile = new File(this.PATH_IPFIELD);
    }

    public static synchronized TENESearchMgr getInstance() {
        if (null == _instance) {
            TELogFactory.getNormalLogger().info("init the search manager.");
            _instance = new TENESearchMgr();
        }
        return _instance;
    }

    public synchronized int searchNE(String ipField, int castType, String userName, String password) {
        TELogFactory.getNormalLogger().info("receive the search command\u00a1\u00a3");
        if (this.isSearching()) {
            TELogFactory.getNormalLogger().info("there is a search in progress, stop it before a new search.");
            this.receiveEndSearchRequest();
        }
        if (!this.validIP(ipField)) {
            TELogFactory.getNormalLogger().info("the address to be searched is invalid.");
            return 2;
        }
        this.setSearchStart();
        TELogFactory.getNormalLogger().info("the search state now is \"searching\"");
        this.createSearcher(this.searcherID, ipField, castType, userName, password);
        return 0;
    }

    private boolean isSearching() {
        return 1 == this.searchState;
    }

    private void createSearcher(int searcherid, String ipfield, int castType, String userName, String password) {
        TELogFactory.getNormalLogger().info("create a searcher.");
        if (this.neSearcher == null) {
            this.neSearcher = new TEGNESearcher(searcherid);
        }
        TELogFactory.getNormalLogger().info("the searcher begin to work.");
        this.neSearcher.startSearchGateway(ipfield, castType, userName, password);
    }

    public synchronized int receiveEndSearchRequest() {
        TELogFactory.getNormalLogger().info("receive the request to end search.");
        this.endSearch();
        this.release();
        return 0;
    }

    private void setSearchEnd() {
        TELogFactory.getNormalLogger().info("set the search mgr searchstate searchend : 0");
        this.searchState = 0;
    }

    private void setSearchStart() {
        TELogFactory.getNormalLogger().info("set search mgr searchstate : searchbegin 1");
        this.searchState = 1;
    }

    private boolean validIP(String ip) {
        if (ip.equals("")) {
            return false;
        }
        if (ip.equalsIgnoreCase("225.225.225.225")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(ip, ".");
        int i = 0;
        if (st.countTokens() - 1 != 3) {
            return false;
        }
        int numCount = 0;
        while (st.hasMoreTokens()) {
            ++i;
            try {
                int ipNumber = Integer.parseInt((String)st.nextElement());
                ++numCount;
                if (ipNumber > 255 || ipNumber < 0) {
                    return false;
                }
                if (1 != i || ipNumber <= 223) continue;
                return false;
            }
            catch (Exception e) {
                return false;
            }
        }
        return numCount == 4;
    }

    private void endSearch() {
        TELogFactory.getNormalLogger().info("start to end search.");
        TELogFactory.getNormalLogger().info("make sure the search is running");
        if (this.neSearcher != null && this.neSearcher.isSearching()) {
            TELogFactory.getNormalLogger().info("start to stop the searcher");
            this.neSearcher.endSearchGateway();
            TELogFactory.getNormalLogger().info("the searcher has stopped successfully.");
        }
        this.setSearchEnd();
        TELogFactory.getNormalLogger().info("search ends successfully.");
    }

    public synchronized List getAllSearchedNEList() {
        TELogFactory.getNormalLogger().info("receive the request of handling the search result.");
        TELogFactory.getNormalLogger().info("call searcher->getSearchedGNEList() to get the search result.make sure the searcher is running");
        ArrayList list = new ArrayList();
        if (null != this.neSearcher) {
            list = this.neSearcher.getSearchedGNEList();
        } else {
            TELogFactory.getNormalLogger().info("the search has stopped, i can't get the search result.");
        }
        TELogFactory.getNormalLogger().info("get the search result , the ne count is " + list.size());
        TELogFactory.getNormalLogger().info(((Object)list).toString());
        Collections.sort(list);
        return Collections.unmodifiableList(list);
    }

    public List getLocalIPList() {
        return TECommunicationMgr.getLocalAddrList();
    }

    public List getSerialPortList() {
        return TECommunicationMgr.getSerialPortList();
    }

    private void release() {
        TELogFactory.getNormalLogger().info("search ends, release the searcher");
        if (this.neSearcher != null) {
            this.neSearcher.release();
            this.neSearcher = null;
        }
    }

    public boolean modifySearchArea(IPSearchDomain searchDomain, String oldDomainAddress) {
        String lineSeparator = System.getProperty("line.separator");
        String domainType = String.valueOf(searchDomain.getDomainType());
        String domainAddress = searchDomain.getDomainAddress();
        try {
            if (!this.ipFieldFile.canWrite()) {
                TEResourceManager.neListResouceMgr(this.PATH_IPFIELD);
            }
            StringBuffer fileBuf = new StringBuffer();
            RandomAccessFile raf = new RandomAccessFile(this.PATH_IPFIELD, "rw");
            String aLine = null;
            while ((aLine = raf.readLine()) != null) {
                fileBuf.append(aLine);
                fileBuf.append(System.getProperty("line.separator"));
            }
            String fileStr = fileBuf.toString();
            int off = fileStr.indexOf("[IPFIELD_LIST domainAddress=" + oldDomainAddress + "]");
            int to = fileStr.indexOf("[/IPFIELD_LIST]", off) + "[/IPFIELD_LIST]".length();
            fileBuf.replace(off, to, "");
            fileBuf.append(lineSeparator);
            fileBuf.append("[IPFIELD_LIST domainAddress=" + domainAddress + "]" + lineSeparator);
            fileBuf.append("domainAddress=" + domainAddress + lineSeparator);
            fileBuf.append("domainType=" + domainType + lineSeparator);
            fileBuf.append("[/IPFIELD_LIST]" + lineSeparator);
            fileStr = fileBuf.toString();
            BufferedWriter out = new BufferedWriter(new FileWriter(this.PATH_IPFIELD));
            out.write(fileStr, 0, fileStr.length());
            out.flush();
            raf.close();
            out.close();
            return true;
        }
        catch (IOException e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
            return false;
        }
    }

    public boolean addSearchArea(IPSearchDomain searchDomain) {
        String lineSeparator = System.getProperty("line.separator");
        String domainType = String.valueOf(searchDomain.getDomainType());
        String domainAddress = searchDomain.getDomainAddress();
        try {
            if (!this.ipFieldFile.canWrite()) {
                TEResourceManager.neListResouceMgr(this.PATH_IPFIELD);
            }
            RandomAccessFile raf = new RandomAccessFile(this.PATH_IPFIELD, "rw");
            long fileLen = raf.length();
            raf.seek(fileLen);
            raf.writeBytes(lineSeparator);
            raf.writeBytes("[IPFIELD_LIST domainAddress=" + domainAddress + "]" + lineSeparator);
            raf.writeBytes("domainAddress=" + domainAddress + lineSeparator);
            raf.writeBytes("domainType=" + domainType + lineSeparator);
            raf.writeBytes("[/IPFIELD_LIST]" + lineSeparator);
            return true;
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("", (Throwable)ex);
            return false;
        }
    }

    public boolean delSearchArea(String domainAddress) {
        try {
            if (!this.ipFieldFile.canWrite()) {
                TEResourceManager.neListResouceMgr(this.PATH_IPFIELD);
            }
            StringBuffer fileBuf = new StringBuffer();
            RandomAccessFile raf = new RandomAccessFile(this.PATH_IPFIELD, "rw");
            String aLine = null;
            while ((aLine = raf.readLine()) != null) {
                fileBuf.append(aLine);
                fileBuf.append(System.getProperty("line.separator"));
            }
            String fileStr = fileBuf.toString();
            int off = fileStr.indexOf("[IPFIELD_LIST domainAddress=" + domainAddress + "]");
            int to = fileStr.indexOf("[/IPFIELD_LIST]", off) + "[/IPFIELD_LIST]".length();
            fileBuf.delete(off, to);
            fileStr = fileBuf.toString();
            BufferedWriter out = new BufferedWriter(new FileWriter(this.PATH_IPFIELD));
            out.write(fileStr, 0, fileStr.length());
            out.flush();
            raf.close();
            out.close();
            return true;
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("", (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSearchDomains() {
        ArrayList<IPSearchDomain> ipList = new ArrayList<IPSearchDomain>();
        try {
            File file = this.ipFieldFile;
            synchronized (file) {
                if (!this.ipFieldFile.canRead() && !this.ipFieldFile.createNewFile()) {
                    TELogFactory.getNormalLogger().error("cannot create ipfield.ini ");
                }
            }
            RandomAccessFile raf = new RandomAccessFile(this.PATH_IPFIELD, "r");
            String s = null;
            String domainAddress = null;
            int domainType = 1;
            IPSearchDomain searchDomain = null;
            while ((s = raf.readLine()) != null) {
                int index;
                if (s.startsWith("[/IPFIELD_LIST]")) {
                    searchDomain = new IPSearchDomain(domainAddress, domainType);
                    ipList.add(searchDomain);
                    continue;
                }
                if (s.startsWith("domainAddress")) {
                    index = s.indexOf("=");
                    domainAddress = s.substring(index + 1).trim();
                    continue;
                }
                if (!s.startsWith("domainType")) continue;
                index = s.indexOf("=");
                domainType = Integer.parseInt(s.substring(index + 1).trim());
            }
        }
        catch (Exception ex) {
            TELogFactory.getNormalLogger().error("", (Throwable)ex);
        }
        return ipList;
    }

    public static void main(String[] args) {
    }

    public String getSearchField(String ip) {
        TELogFactory.getNormalLogger().info("the ip to be converted is " + ip);
        int ipAddress = Integer.parseInt(ip.substring(0, ip.indexOf(".")));
        StringTokenizer st = new StringTokenizer(ip, ".");
        String[] ipArray = new String[4];
        int length = ipArray.length;
        int j = 0;
        while (st.hasMoreTokens()) {
            ipArray[j++] = (String)st.nextElement();
        }
        int i = 0;
        i = ipAddress < 128 ? 3 : (ipAddress < 192 ? 2 : 1);
        for (int k = 0; k < i; ++k) {
            ipArray[length - k - 1] = "255";
        }
        StringBuffer ipField = new StringBuffer();
        for (int k = 0; k < length; ++k) {
            ipField.append(ipArray[k]);
            if (k == 3) continue;
            ipField.append(".");
        }
        TELogFactory.getNormalLogger().info("the converted ipfield is " + ipField);
        return ipField.toString();
    }
}

