/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.devicesearch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.devicesearch.TEAddressStruct;
import com.huawei.nglct.neinterface.devicesearch.TEMultiCastGNE;
import com.huawei.nglct.neinterface.devicesearch.TEMultiCastSearcher;
import com.huawei.nglct.neinterface.devicesearch.TENESearchConstants;
import com.huawei.nglct.neinterface.devicesearch.TENESearchTask;
import com.huawei.nglct.neinterface.devicesearch.TESearchedNE;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.uflight.necomm.TECommData;
import com.huawei.uflight.necomm.TECommInfo;
import com.huawei.uflight.necomm.TECommunicationMgr;
import com.huawei.uflight.necomm.TEUDPCommInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;

public class TENESearchIPTask
extends TENESearchTask {
    private static final String DOT = ".";
    private static final String EMPTY_STRING = "";
    private static final String SEMICOLON = ";";
    private static final String COMMA = ",";
    private static final String EQUAL_SIGN = "=";
    private static final String ZERO_STRING = "0";
    private static final char BLANK_CHAR = ' ';
    private static final String RECORD_NO = "No";
    private static final String RECORD_ID = "ID";
    private static final String RECORD_INTF = "INTF";
    private static final String RECORD_ADDR = "ADDR";
    private static final String RECORD_PROT = "PROT";
    private static final String RECORD_GF = "GF";
    private static final String RECORD_MODE = "MODE";
    private static final int ZERO_INT = 0;
    private static final int ONE_INT = 1;
    private static final int TWO_INT = 2;
    private static final int THREE_INT = 3;
    private static final String IP_PROTOCOL_STRING = "IP";
    private static final String OSI_PROTOCOL_STRING = "OSI";
    private static final String SERIAL_PROTOCOL_STRING = "SERIAL";
    private static final String INIF_TL1 = "2";
    private TEUDPCommInfo broadInfo = null;
    protected TECommData broadData = new TECommData();
    private HashMap nEData = new HashMap();
    int count = 1;

    protected TENESearchIPTask() {
    }

    public TENESearchIPTask(String ip, int castType, String userName, String password) {
        super(ip);
        String bindAddr = ip;
        String echoAddr = ip;
        int bindPort = 1400;
        int echoPort = 1500;
        if (castType == 2) {
            bindPort = 8001;
            echoPort = 8002;
            bindAddr = "224.224.224.224";
            echoAddr = "225.225.225.225";
        }
        int type = castType == 3 ? 1 : castType;
        this.broadInfo = new TEUDPCommInfo(type, bindAddr, bindPort, bindAddr);
        this.broadInfo.setUserName(userName);
        this.broadInfo.setPassword(password);
        this.broadData = this.convetToCommData(castType);
        this.broadData.setAddr(echoAddr);
        this.broadData.setPort(echoPort);
    }

    private String getSearchField(String ip) {
        TELogFactory.getNormalLogger().info("the ip to be converted is " + ip);
        int ipAddress = Integer.parseInt(ip.substring(0, ip.indexOf(DOT)));
        StringTokenizer st = new StringTokenizer(ip, DOT);
        String[] ipArray = new String[4];
        int length = ipArray.length;
        int j = 0;
        while (st.hasMoreTokens()) {
            ipArray[j++] = (String)st.nextElement();
        }
        int i = 0;
        i = ipAddress < 128 ? 3 : (ipAddress < 192 ? 2 : 1);
        for (int k = 0; k < i; ++k) {
            ipArray[length - k - 1] = "255";
        }
        StringBuffer ipField = new StringBuffer();
        for (int k = 0; k < length; ++k) {
            ipField.append(ipArray[k]);
            if (k == 3) continue;
            ipField.append(DOT);
        }
        TELogFactory.getNormalLogger().info("the converted ipfield is " + ipField);
        return ipField.toString();
    }

    @Override
    public void receive() {
        if (!this.hasConn) {
            TELogFactory.getNormalLogger().info("no connection has been created. ");
            return;
        }
        TELogFactory.getNormalLogger().info("start to receive the udp message from the nes");
        while (this.searchState != 0) {
            TELogFactory.getNormalLogger().info("====start to receive the broadcast message:" + System.currentTimeMillis());
            TECommData broadData = TECommunicationMgr.instance().recv(this.broadInfo);
            TELogFactory.getNormalLogger().info("====end to receive the broadcast message:" + System.currentTimeMillis());
            try {
                if (this.broadInfo != null && this.broadInfo.getCommType() == 2 && broadData != null) {
                    TEMultiCastSearcher.getInstance().insertEthGne(broadData.getAddr(), broadData.getPort(), this.broadInfo.getUserName(), this.broadInfo.getPassword());
                    this.fillNEData(TEMultiCastSearcher.getInstance().getM_ListTempGne());
                    continue;
                }
                if (!this.isValidData(broadData)) continue;
                TELogFactory.getNormalLogger().info("addMessage to messageList");
                this.addMessage(broadData);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TENESearchIPTask.receive() fail!", (Throwable)e);
            }
        }
    }

    private void fillNEData(List<TEMultiCastGNE> mgNEList) {
        TELogFactory.getNormalLogger().info("start to fill udp NE Data, TEMultiCastGNE's count = " + mgNEList.size());
        int size = mgNEList.size();
        for (int i = 0; i < size; ++i) {
            TEMultiCastGNE gNE = mgNEList.get(i);
            TELogFactory.getNormalLogger().info("start to fill udp NE Data, TEMultiCastGNE's neid = " + gNE.getNeid());
            gNE.setNeID(String.valueOf(gNE.getNeid()));
            TEAddressStruct tempAdd = new TEAddressStruct(gNE.getIpAddr(), 1, 1);
            gNE.setCommengGNEAddress(tempAdd);
            gNE.addCommendGNEAddressList(tempAdd);
            this.processNEData(gNE);
        }
    }

    @Override
    protected ArrayList convertToGNEData(byte[] data, int offset, int length) {
        String dataStr = this.trimDataString(new String(data, 28, length - 28));
        TELogFactory.getNormalLogger().info("the valid info is \n" + dataStr);
        StringTokenizer st = new StringTokenizer(dataStr, SEMICOLON);
        ArrayList<DataStruct> routeList = new ArrayList<DataStruct>();
        boolean isFitFormat = true;
        String gnAddr = EMPTY_STRING;
        while (st.hasMoreTokens()) {
            String oneData = ((String)st.nextElement()).trim();
            StringTokenizer st1 = new StringTokenizer(oneData, COMMA);
            DataStruct recordData = new DataStruct();
            while (st1.hasMoreTokens()) {
                String twoData = ((String)st1.nextElement()).trim();
                if (twoData.indexOf(EQUAL_SIGN) != -1 && twoData.indexOf("'") != -1) {
                    isFitFormat = true;
                    String name = twoData.substring(0, twoData.indexOf(EQUAL_SIGN)).trim();
                    String newString = twoData.substring(twoData.indexOf(EQUAL_SIGN) + 1);
                    String value = EMPTY_STRING;
                    try {
                        value = newString.substring(newString.indexOf("'") + 1, newString.lastIndexOf("'"));
                    }
                    catch (Exception e) {
                        TELogFactory.getNormalLogger().error("TENESearchIPTask.convertToGNEData() fail!", (Throwable)e);
                        continue;
                    }
                    if (name.equals(RECORD_NO)) {
                        recordData.No = value;
                        continue;
                    }
                    if (name.equals(RECORD_ID)) {
                        recordData.ID = value;
                        continue;
                    }
                    if (name.equals(RECORD_INTF)) {
                        if (TESysManagerBean.getInstance().getlanguage().equals("zh") && INIF_TL1.equals(value)) {
                            isFitFormat = false;
                            break;
                        }
                        recordData.INTF = value;
                        continue;
                    }
                    if (name.equals(RECORD_ADDR)) {
                        if (ZERO_STRING.equals(recordData.No)) {
                            gnAddr = value;
                        }
                        recordData.ADDR = value;
                        recordData.GNADDR = gnAddr;
                        continue;
                    }
                    if (name.equals(RECORD_PROT)) {
                        recordData.PROT = value;
                        continue;
                    }
                    if (name.equals(RECORD_GF)) {
                        recordData.GF = value;
                        continue;
                    }
                    if (!name.equals(RECORD_MODE)) continue;
                    recordData.MODE = value;
                    continue;
                }
                isFitFormat = false;
            }
            if (!isFitFormat || EMPTY_STRING.equals(recordData.ADDR) || !this.getSearchField(recordData.ADDR).equals(this.getSearchField(this.localIP))) continue;
            routeList.add(recordData);
        }
        return this.processRouteList(routeList);
    }

    private ArrayList processRouteList(ArrayList routeList) {
        ArrayList list = new ArrayList();
        String realGNEAddress = EMPTY_STRING;
        TEAddressStruct tempAdd = null;
        if (routeList != null && routeList.size() > 0) {
            int size = routeList.size();
            for (int i = 0; i < size; ++i) {
                boolean isgne;
                DataStruct record = (DataStruct)routeList.get(i);
                TESearchedNE ne = (TESearchedNE)this.nEData.get(record.ID);
                if (null == ne) {
                    ne = new TESearchedNE();
                }
                int interf = Integer.parseInt(record.INTF);
                int prottype = this.parseProt(record.PROT);
                boolean bl = isgne = "T".equalsIgnoreCase(record.GF);
                if (ZERO_STRING.equals(record.No)) {
                    realGNEAddress = record.GNADDR;
                    tempAdd = new TEAddressStruct(realGNEAddress, prottype, interf);
                    ne.setIsGNE(isgne);
                    ne.setCommengGNEAddress(tempAdd);
                    ne.addCommendGNEAddressList(tempAdd);
                } else {
                    if (realGNEAddress.equals(EMPTY_STRING)) {
                        realGNEAddress = this.searchRealGNEIP(routeList);
                    }
                    ne.addCommendGNEAddressList(tempAdd);
                    ne.addCommendGNEAddressList(new TEAddressStruct(record.ADDR, prottype, interf));
                }
                ne.setNeID(this.parseNEID(record.ID, interf));
                this.nEData.put(record.ID, ne);
            }
        }
        list.addAll(this.nEData.values());
        return list;
    }

    private int parseProt(String string) {
        if (string.equals(IP_PROTOCOL_STRING)) {
            return 1;
        }
        if (string.equals(OSI_PROTOCOL_STRING)) {
            return 2;
        }
        if (string.equals(SERIAL_PROTOCOL_STRING)) {
            return 3;
        }
        return -1;
    }

    private String searchRealGNEIP(ArrayList routeList) {
        int size = 0;
        if (routeList != null && (size = routeList.size()) > 0) {
            for (int i = 0; i < size; ++i) {
                DataStruct record = (DataStruct)routeList.get(i);
                if (record == null || !record.No.equals(ZERO_STRING)) continue;
                return record.ADDR;
            }
        }
        return EMPTY_STRING;
    }

    private String trimDataString(String dataStr) {
        char[] strChar = new char[dataStr.length()];
        int k = 0;
        int size = dataStr.length();
        for (int i = 0; i < size; ++i) {
            if (dataStr.charAt(i) == ' ') continue;
            strChar[k++] = dataStr.charAt(i);
        }
        return new String(strChar, 0, k);
    }

    private String parseNEID(String nameString, int intf) {
        if (2 == intf) {
            return nameString;
        }
        int neID = Integer.parseInt(nameString, 16);
        return String.valueOf(neID);
    }

    @Override
    protected TECommData convetToCommData(String ip, String port) {
        TECommData commData = new TECommData();
        byte[] data = new byte[32];
        System.arraycopy(TENESearchConstants.UDP_BROADCAST_HEADER, 0, data, 0, data.length);
        commData.setData(data);
        commData.setOffset(0);
        commData.setLength(data.length);
        return commData;
    }

    private TECommData convetToCommData(int castType) {
        TECommData commData = new TECommData();
        byte[] data = new byte[32];
        if (castType == 2) {
            System.arraycopy(TENESearchConstants.UDP_MULTICAST_HEADER, 0, data, 0, data.length);
        } else if (castType == 3) {
            System.arraycopy(TENESearchConstants.UDP_BROADCAST_HEADER_SERVICE, 0, data, 0, data.length);
        } else {
            System.arraycopy(TENESearchConstants.UDP_BROADCAST_HEADER, 0, data, 0, data.length);
        }
        commData.setData(data);
        commData.setOffset(0);
        commData.setLength(data.length);
        return commData;
    }

    @Override
    protected boolean isValidData(TECommData neDataObj) {
        if (null != neDataObj) {
            byte[] data = neDataObj.getData();
            if (data.length < 27) {
                return false;
            }
            for (int i = 0; i < 20; ++i) {
                if (data[i] == TENESearchConstants.UDP_BROADCAST_HEADER[i] || data[i] == TENESearchConstants.UDP_BROADCAST_HEADER_SERVICE[i]) continue;
                return false;
            }
            int version = TENESearchIPTask.readUnsignedByte(data[20]);
            if (1 != version) {
                return false;
            }
            int packageLen = (TENESearchIPTask.readUnsignedByte(data[24]) << 8) + (TENESearchIPTask.readUnsignedByte(data[25]) << 0);
            return packageLen == neDataObj.getLength();
        }
        return false;
    }

    @Override
    protected void closeConnectToNE() {
        TECommunicationMgr.instance().close(this.broadInfo);
    }

    @Override
    protected void sendSearchMessage() {
        TELogFactory.getNormalLogger().info("make a udp connection");
        int connCount = 1;
        boolean bl = this.hasConn = TECommunicationMgr.instance().connect(this.broadInfo) == 0;
        while (!this.hasConn && connCount++ < 3) {
            this.hasConn = TECommunicationMgr.instance().connect(this.broadInfo) == 0;
        }
        if (this.hasConn) {
            this.send();
            this.sendTimer = new Timer();
            this.sendTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    TENESearchIPTask.this.send();
                }
            }, 15000L, 15000L);
        } else {
            TELogFactory.getNormalLogger().info("***************************connect failed **********************");
        }
    }

    public void send() {
        if (this.isSearching()) {
            TECommunicationMgr.instance().send(this.broadInfo, this.broadData);
            TELogFactory.getNormalLogger().info("broadcast the search message, i have sent for " + this.count + "times");
            ++this.count;
        }
    }

    public boolean isSearching() {
        return this.searchState == 1;
    }

    @Override
    void release() {
        super.release();
        if (this.nEData != null) {
            this.nEData.clear();
            this.nEData = null;
        }
        if (this.sendTimer != null) {
            this.sendTimer.cancel();
            this.sendTimer = null;
        }
    }

    public int checkMessageValid(byte[] arg0, int arg1, int arg2, TECommInfo arg3) {
        return 0;
    }

    private class DataStruct {
        String No = "";
        String ID = "";
        String INTF = "";
        String ADDR = "";
        String PROT = "";
        String GF = "";
        String MODE = "";
        String GNADDR = "";

        private DataStruct() {
        }
    }
}

