/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.devicesearch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.neinterface.devicesearch.TEMultiCastGNE;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.security.EncryptUtils;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TEMultiCastSearcher {
    private static TEMultiCastSearcher instance = null;
    private Map<String, TEMultiCastGNE> m_mapTempGne = null;
    private List<TEMultiCastGNE> m_ListTempGne = new ArrayList<TEMultiCastGNE>();
    private String QX_DES_PATH = "conf" + File.separator + "qxdescrib.xml";
    private static final String EMS_TERMINAL_TYPE = "1";

    private TEMultiCastSearcher() {
    }

    public static synchronized TEMultiCastSearcher getInstance() {
        if (instance == null) {
            instance = new TEMultiCastSearcher();
        }
        return instance;
    }

    public void insertEthGne(String ipAddr, int port, String userName, String password) {
        TELogFactory.getNormalLogger().info("Get MultiCast Ne: " + ipAddr + ":" + port);
        if (this.m_mapTempGne == null) {
            this.m_mapTempGne = new HashMap<String, TEMultiCastGNE>();
        }
        TEMultiCastGNE gNE = new TEMultiCastGNE(ipAddr, port, userName, password);
        if (!this.m_mapTempGne.containsKey(ipAddr)) {
            this.m_mapTempGne.put(ipAddr, gNE);
        }
        this.startConnectTempGne(gNE);
    }

    public void startConnectTempGne(TEMultiCastGNE gNE) {
        TELogFactory.getNormalLogger().info("Start Connect MultiCast Ne " + gNE.getIpAddr() + ":" + gNE.getPort());
        gNE.setIsGNE(true);
        int neID = (int)gNE.getNeid();
        int logicNEID = -1;
        if (this.m_ListTempGne.contains(gNE) && gNE.getNeid() != 0L) {
            return;
        }
        if (this.m_ListTempGne.contains(gNE) && gNE.getNeid() == 0L) {
            logicNEID = TENECommMgr.getInstance().getLogicNEID(0);
        }
        if (logicNEID == -1) {
            logicNEID = TENEListUtils.getLogicNEID();
        }
        TELogFactory.getNormalLogger().info("Start Connect MultiCast Ne " + gNE.getIpAddr() + ":" + gNE.getPort() + "; neid=" + gNE.getNeid() + ";logicNEID=" + logicNEID);
        TENECommMgr.getInstance().putLogicNEID((long)neID, (long)logicNEID);
        int rst = TENECommMgr.getInstance().createConect((long)logicNEID, 1400, gNE.getIpAddr(), 1);
        TELogFactory.getNormalLogger().info("Connect MultiCast Ne " + gNE.getIpAddr() + ":" + gNE.getPort() + " 's result is: " + rst);
        if (rst != 0) {
            TELogFactory.getNormalLogger().info("Connect MultiCast Ne failed, the ne is: " + gNE.getIpAddr() + "; neid=" + gNE.getNeid() + ";logicNEID=" + logicNEID);
            TENECommMgr.getInstance().closeConnect((long)logicNEID, 1400, gNE.getIpAddr(), 1);
            this.clear(logicNEID);
            return;
        }
        try {
            for (int count = 0; neID == 0 && count < 5; ++count) {
                Thread.sleep(100L);
                neID = TENECommMgr.getInstance().getNEID((long)logicNEID);
            }
        }
        catch (InterruptedException e) {
            TELogFactory.getNormalLogger().error(e.toString());
        }
        if (neID == 0) {
            TELogFactory.getNormalLogger().info("get the phyID failed, the ne is: " + gNE.getIpAddr() + "; neid=" + gNE.getNeid() + ";logicNEID=" + logicNEID);
        } else {
            gNE.setNeid(neID);
            this.addGNE(gNE);
            OperationResult result = TENECommMgr.getInstance().sendCommand(logicNEID, this.getLoginOperList(gNE), null, 10);
            if (result.retCode == 0) {
                ArrayList<Operation> operList = this.getEccOperList();
                result = TENECommMgr.getInstance().sendCommand(logicNEID, operList, null, 10);
                if (result.retCode == 0) {
                    TEMultiCastGNE ne = new TEMultiCastGNE();
                    Output[] outputs = operList.get(0).getOutput();
                    int len = outputs.length;
                    for (int i = 0; i < len; ++i) {
                        if (!outputs[i].getFault(0).getCode().equals(String.valueOf(0))) continue;
                        ne.setNeid(Integer.parseInt(outputs[i].getPartValue("DST-ID")));
                        ne.setIpAddr(gNE.getIpAddr());
                        this.addGNE(ne);
                    }
                }
            }
        }
        TENECommMgr.getInstance().closeConnect((long)logicNEID, 1400, gNE.getIpAddr(), 1);
        this.clear(logicNEID);
    }

    private void addGNE(TEMultiCastGNE gNE) {
        if (!this.m_ListTempGne.contains(gNE)) {
            this.m_ListTempGne.add(gNE);
            return;
        }
        int size = this.m_ListTempGne.size();
        for (int i = 0; i < size; ++i) {
            TEMultiCastGNE obj = this.m_ListTempGne.get(i);
            if (!obj.getIpAddr().equals(gNE.getIpAddr()) || obj.getNeid() != 0L) continue;
            obj.setNeid(gNE.getNeid());
            return;
        }
    }

    private ArrayList<Operation> getLoginOperList(TEMultiCastGNE gNE) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation(this.QX_DES_PATH, "ForceLoginNEV01");
        Input input = oper.getInput();
        input.getPart("terminalType").setValue(EMS_TERMINAL_TYPE);
        input.getPart("userName").setValue(gNE.getUserName());
        byte[] value = EncryptUtils.decryptAESStr2Byte(gNE.getPassword());
        input.getPart("userPassword").setValue(EncryptUtils.encryptAESByte2Str(value));
        EncryptUtils.clearByte(value);
        operationList.add(oper);
        return operationList;
    }

    private ArrayList<Operation> getEccOperList() {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation oper = TECreateObjectFactory.getOperation(this.QX_DES_PATH, "NSCMD_ECC_GET_ROUTE_EX");
        operationList.add(oper);
        return operationList;
    }

    private void clear(long logicNEID) {
        TENECommMgr.getInstance().deleteNEID((long)((int)logicNEID));
    }

    public List<TEMultiCastGNE> getM_ListTempGne() {
        return this.m_ListTempGne;
    }

    public void setM_ListTempGne(List<TEMultiCastGNE> mListTempGne) {
        this.m_ListTempGne = mListTempGne;
    }
}

