/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.neinterface.devicesearch;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.neinterface.devicesearch.TENESearchIPTask;
import com.huawei.nglct.neinterface.devicesearch.TENESearchTask;
import java.util.ArrayList;
import java.util.List;

public class TEGNESearcher {
    private int searcherID = 0;
    private String localSearchIP = null;
    private ArrayList searchedNEList = null;
    private int searchState;
    private TENESearchTask ipSearchTask = null;
    private TENESearchTask serialSearchTask = null;

    public TEGNESearcher(int id) {
        this.searcherID = id;
        this.searchedNEList = new ArrayList();
        this.setSearchEnd();
    }

    public void startSearchGateway(String ipField, int castType, String userName, String password) {
        if (this.isSearching()) {
            TELogFactory.getNormalLogger().info("the searcher is searching.....wait..");
            return;
        }
        this.searchedNEList.clear();
        this.localSearchIP = ipField;
        this.setSearchStart();
        this.startReceiveThread(ipField, castType, userName, password);
    }

    private void startReceiveThread(String ipField, int castType, String userName, String password) {
        TELogFactory.getNormalLogger().info("create the search thread then start it");
        this.ipSearchTask = new TENESearchIPTask(ipField, castType, userName, password);
        this.ipSearchTask.start();
    }

    public void endSearchGateway() {
        if (!this.isSearching()) {
            return;
        }
        this.setSearchEnd();
        this.ipSearchTask.endSearch();
    }

    private void setSearchEnd() {
        TELogFactory.getNormalLogger().info("the searcher's search state is now set searchEND == 0");
        this.searchState = 0;
    }

    private void setSearchStart() {
        this.searchState = 1;
    }

    private void fillSearchedNEList() {
        if (this.searchedNEList == null) {
            this.searchedNEList = new ArrayList();
        }
        this.searchedNEList.clear();
        if (this.ipSearchTask != null) {
            List ipList = this.ipSearchTask.getSearchedNEList();
            this.searchedNEList.addAll(ipList);
        } else {
            TELogFactory.getNormalLogger().info("the ip search thread is not running.");
        }
    }

    public String getLocalSearchIP() {
        return this.localSearchIP;
    }

    public int getSearchState() {
        return this.searchState;
    }

    public void setLocalSearchIP(String localSearchIP) {
        this.localSearchIP = localSearchIP;
    }

    private void setSearchState(int searchState) {
        this.searchState = searchState;
    }

    public ArrayList getSearchedGNEList() {
        this.fillSearchedNEList();
        return (ArrayList)this.searchedNEList.clone();
    }

    public boolean isSearching() {
        return this.searchState == 1;
    }

    public void release() {
        if (null != this.searchedNEList) {
            this.searchedNEList.clear();
            this.searchedNEList = null;
        }
        if (this.ipSearchTask != null) {
            this.ipSearchTask.release();
            this.ipSearchTask = null;
        }
        if (this.serialSearchTask != null) {
            this.serialSearchTask.release();
            this.serialSearchTask = null;
        }
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && this.getClass() != obj.getClass()) {
            return false;
        }
        if (obj == null) {
            return false;
        }
        TEGNESearcher temp = (TEGNESearcher)obj;
        return temp.searcherID == this.searcherID;
    }
}

