/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.modulemgr;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.modulemgr.ModuleDesc;
import com.huawei.nglct.modulemgr.ModuleInterface;
import com.huawei.nglct.modulemgr.ModuleObject;
import com.huawei.nglct.modulemgr.TaskMgrDesc;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class ModuleMgr {
    private Map<String, ModuleObject> m_ModuleTable = new HashMap<String, ModuleObject>();
    private Map<String, ModuleDesc> m_ModuleDescTable = new HashMap<String, ModuleDesc>();
    private TaskMgrDesc[] m_pTaskMgrDesc;
    private Lock m_Mutex = new ReentrantLock();
    private static ModuleMgr m_instance = null;

    private ModuleMgr() {
        this.m_pTaskMgrDesc = new TaskMgrDesc[0];
        this.readModuleFile();
    }

    public static synchronized ModuleMgr getInstance() {
        if (null == m_instance) {
            m_instance = new ModuleMgr();
        }
        return m_instance;
    }

    int readModuleFile() {
        int ret = -1;
        String strCfgFile = System.getProperty("user.dir") + "/conf/modules.cfg";
        File file = new File(strCfgFile);
        if (file.exists()) {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#") || line.trim().equals("")) continue;
                    String[] str = line.trim().split("\t");
                    ModuleDesc moduleDesc = new ModuleDesc();
                    moduleDesc.m_Name = str[0];
                    moduleDesc.m_FileName = str[1];
                    if ("".equals(moduleDesc.m_Name) || "".equals(moduleDesc.m_FileName)) continue;
                    this.m_ModuleDescTable.put(moduleDesc.m_Name, moduleDesc);
                }
                reader.close();
                ret = 0;
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("ModuleMgr.readModuleFile() fail!", (Throwable)e);
            }
        }
        return ret;
    }

    String getLibName(String strModuleName) {
        if (this.m_ModuleDescTable.containsKey(strModuleName)) {
            return this.m_ModuleDescTable.get((Object)strModuleName).m_FileName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleObject queryModule(String strModuleName) {
        this.m_Mutex.lock();
        try {
            if (!this.checkLicense(strModuleName)) {
                ModuleObject moduleObject = null;
                return moduleObject;
            }
            if (this.m_ModuleTable.containsKey(strModuleName)) {
                ModuleObject moduleObject = this.m_ModuleTable.get(strModuleName);
                return moduleObject;
            }
            ModuleObject moduleObject = null;
            return moduleObject;
        }
        finally {
            this.m_Mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ModuleObject loadModule(String strModuleName) {
        block11: {
            String strLibName;
            block10: {
                block9: {
                    block8: {
                        this.m_Mutex.lock();
                        if (this.checkLicense(strModuleName)) break block8;
                        ModuleObject moduleObject = null;
                        this.m_Mutex.unlock();
                        return moduleObject;
                    }
                    if (!this.m_ModuleTable.containsKey(strModuleName)) break block9;
                    ModuleObject moduleObject = this.m_ModuleTable.get(strModuleName);
                    this.m_Mutex.unlock();
                    return moduleObject;
                }
                strLibName = this.getLibName(strModuleName);
                if (null != strLibName) break block10;
                ModuleObject moduleObject = null;
                this.m_Mutex.unlock();
                return moduleObject;
            }
            Class<?> c = Class.forName(strLibName);
            c.newInstance();
            if (!this.m_ModuleTable.containsKey(strModuleName)) break block11;
            ModuleObject moduleObject = this.m_ModuleTable.get(strModuleName);
            this.m_Mutex.unlock();
            return moduleObject;
        }
        try {
            block12: {
                break block12;
                catch (Exception e) {
                    System.out.println("Module " + strModuleName + " is loaded, but hasn't registered.");
                    TELogFactory.getNormalLogger().error(e.toString());
                }
            }
            ModuleObject moduleObject = null;
            return moduleObject;
        }
        finally {
            this.m_Mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getModuleList(List<ModuleObject> rModuleList) {
        this.m_Mutex.lock();
        try {
            ModuleObject module = null;
            Iterator<Map.Entry<String, ModuleObject>> iter = this.m_ModuleTable.entrySet().iterator();
            while (iter.hasNext()) {
                module = iter.next().getValue();
                if (!this.checkLicense(module.getName())) continue;
                rModuleList.add(module);
            }
        }
        finally {
            this.m_Mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleInterface getInterface(String strModuleName, String strInterfaceName, int version) {
        this.m_Mutex.lock();
        try {
            if (!this.checkLicense(strModuleName)) {
                ModuleInterface moduleInterface = null;
                return moduleInterface;
            }
            if (!this.m_ModuleTable.containsKey(strModuleName)) {
                ModuleInterface moduleInterface = null;
                return moduleInterface;
            }
            ModuleInterface moduleInterface = this.m_ModuleTable.get(strModuleName).getInterface(strInterfaceName, version);
            return moduleInterface;
        }
        finally {
            this.m_Mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getInterface(String strInterfaceName, int version, List<ModuleInterface> rIfList) {
        rIfList.clear();
        this.m_Mutex.lock();
        try {
            ModuleInterface pIf = null;
            ModuleObject module = null;
            Iterator<Map.Entry<String, ModuleObject>> iter = this.m_ModuleTable.entrySet().iterator();
            while (iter.hasNext()) {
                module = iter.next().getValue();
                pIf = module.getInterface(strInterfaceName, version);
                if (null == pIf) continue;
                rIfList.add(pIf);
            }
        }
        finally {
            this.m_Mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerModule(ModuleObject pModule) {
        this.m_Mutex.lock();
        try {
            String strName = pModule.getName();
            this.m_ModuleTable.put(strName, pModule);
        }
        finally {
            this.m_Mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int init() {
        this.m_Mutex.lock();
        try {
            int level = -1;
            ModuleObject module = null;
            ArrayList<ModuleObject> moduleList = null;
            TreeMap initMap = new TreeMap();
            Iterator<Map.Entry<String, ModuleObject>> iter = this.m_ModuleTable.entrySet().iterator();
            while (iter.hasNext()) {
                module = iter.next().getValue();
                if (0 != module.getState()) continue;
                level = module.getLevel();
                if (initMap.containsKey(module.getLevel())) {
                    ((List)initMap.get(level)).add(module);
                    continue;
                }
                moduleList = new ArrayList<ModuleObject>();
                moduleList.add(module);
                initMap.put(level, moduleList);
            }
            int ret = 0;
            Iterator tmpIter = initMap.entrySet().iterator();
            while (tmpIter.hasNext()) {
                moduleList = (ArrayList<ModuleObject>)tmpIter.next().getValue();
                int m = moduleList.size();
                for (int i = 0; i < m; ++i) {
                    module = (ModuleObject)moduleList.get(i);
                    System.out.println("========== Init module ---" + module.getName() + " ==========");
                    ret = module.init();
                    if (ret == 0) continue;
                    System.out.println("Error: Init module " + module.getName() + " failed! errcode=" + ret);
                    int n = ret;
                    return n;
                }
            }
            int n = ret;
            return n;
        }
        finally {
            this.m_Mutex.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fini() {
        this.m_Mutex.lock();
        try {
            int level = -1;
            ModuleObject module = null;
            ArrayList<ModuleObject> moduleList = null;
            TreeMap initMap = new TreeMap();
            Iterator<Map.Entry<String, ModuleObject>> iter = this.m_ModuleTable.entrySet().iterator();
            while (iter.hasNext()) {
                module = iter.next().getValue();
                if (1 != module.getState()) continue;
                level = module.getLevel();
                if (initMap.containsKey(module.getLevel())) {
                    ((List)initMap.get(level)).add(module);
                    continue;
                }
                moduleList = new ArrayList<ModuleObject>();
                moduleList.add(module);
                initMap.put(level, moduleList);
            }
            Iterator tmpIter = initMap.entrySet().iterator();
            while (tmpIter.hasNext()) {
                moduleList = (ArrayList<ModuleObject>)tmpIter.next().getValue();
                int m = moduleList.size();
                for (int i = 0; i < m; ++i) {
                    module = (ModuleObject)moduleList.get(i);
                    System.out.println("========== Fini module --- " + module.getName() + " ==========");
                    module.removeAllInterface();
                    module.fini();
                }
            }
        }
        finally {
            this.m_Mutex.unlock();
        }
    }

    boolean checkLicense(String strModuleName) {
        return true;
    }

    public TaskMgrDesc[] getTaskMgrDesc() {
        if (null != this.m_pTaskMgrDesc) {
            this.m_pTaskMgrDesc = null;
        }
        TIntObjectHashMap tmpTaskMgrDescMap = new TIntObjectHashMap();
        String moduleName = null;
        ModuleDesc moduleDesc = null;
        TaskMgrDesc desc = null;
        TaskMgrDesc taskMgrDesc = null;
        List<TaskMgrDesc> tmpList = null;
        Map.Entry<String, ModuleObject> entry2 = null;
        for (Map.Entry<String, ModuleObject> entry2 : this.m_ModuleTable.entrySet()) {
            moduleName = entry2.getKey();
            if (!this.m_ModuleDescTable.containsKey(moduleName)) continue;
            moduleDesc = this.m_ModuleDescTable.get(moduleName);
            tmpList = moduleDesc.m_TaskMgrDescList;
            int m = tmpList.size();
            for (int i = 0; i < m; ++i) {
                taskMgrDesc = tmpList.get(i);
                if (tmpTaskMgrDescMap.containsKey(taskMgrDesc.m_nID)) {
                    desc = (TaskMgrDesc)tmpTaskMgrDescMap.get(taskMgrDesc.m_nID);
                    desc.m_nThreads += taskMgrDesc.m_nThreads;
                    continue;
                }
                desc = new TaskMgrDesc();
                desc.m_nID = taskMgrDesc.m_nID;
                desc.m_nThreads = taskMgrDesc.m_nThreads;
                tmpTaskMgrDescMap.put(taskMgrDesc.m_nID, (Object)desc);
            }
        }
        int taskMgrNum = tmpTaskMgrDescMap.size();
        this.m_pTaskMgrDesc = new TaskMgrDesc[taskMgrNum + 1];
        if (this.m_pTaskMgrDesc != null) {
            int n = 0;
            TIntObjectIterator tmpIter = tmpTaskMgrDescMap.iterator();
            while (tmpIter.hasNext()) {
                tmpIter.advance();
                this.m_pTaskMgrDesc[n] = (TaskMgrDesc)tmpIter.value();
                ++n;
            }
            this.m_pTaskMgrDesc[taskMgrNum].m_nID = 0;
            this.m_pTaskMgrDesc[taskMgrNum].m_nThreads = 0;
        }
        return this.m_pTaskMgrDesc;
    }
}

