/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.mo;

import com.huawei.nglct.cbb.xmlinterpreter.SDXMLInterpreterMgr;
import com.huawei.nglct.common.TEParseXMLFile;
import com.huawei.nglct.mo.AID;
import com.huawei.nglct.mo.TEAIDCPRec;
import com.huawei.nglct.mo.TEAIDDevInfo;
import com.huawei.nglct.mo.TEAIDDevVerInfo;
import com.huawei.nglct.mo.TEAIDPortRec;
import com.huawei.nglct.po.TENEPO;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEAIDDescMgr {
    private Map<TEAIDDevInfo, List<TEAIDCPRec>> m_devMap = new HashMap<TEAIDDevInfo, List<TEAIDCPRec>>();
    private static TEAIDDescMgr m_instance = null;

    private TEAIDDescMgr() {
    }

    public static synchronized TEAIDDescMgr getInstance() {
        if (null == m_instance) {
            m_instance = new TEAIDDescMgr();
        }
        return m_instance;
    }

    private TEAIDCPRec getCPRec(TEAIDDevVerInfo verInfo, int cpType, boolean isNA) {
        TEAIDCPRec tmp = null;
        if (!isNA) {
            int nDistance = -1;
            TEAIDCPRec pCPRec = null;
            Map.Entry<TEAIDDevInfo, List<TEAIDCPRec>> entry2 = null;
            block0: for (Map.Entry<TEAIDDevInfo, List<TEAIDCPRec>> entry2 : this.m_devMap.entrySet()) {
                TEAIDDevInfo info = entry2.getKey();
                if (info.m_neType != 2047 && (info.m_neType != verInfo.m_neType || verInfo.m_nVer < info.m_minNEVer || verInfo.m_nVer > info.m_maxNEVer) || verInfo.m_nVer - info.m_minNEVer >= nDistance) continue;
                List<TEAIDCPRec> cpRecList = entry2.getValue();
                int m = cpRecList.size();
                for (int i = 0; i < m; ++i) {
                    tmp = cpRecList.get(i);
                    if (cpType != tmp.m_nCPType) continue;
                    pCPRec = tmp;
                    nDistance = verInfo.m_nVer - info.m_minNEVer;
                    continue block0;
                }
            }
            return pCPRec;
        }
        List<TEAIDCPRec> pCPRecList = this.getCPRecList(verInfo);
        if (pCPRecList != null) {
            int m = pCPRecList.size();
            for (int i = 0; i < m; ++i) {
                tmp = pCPRecList.get(i);
                if (cpType != tmp.m_nCPType) continue;
                return tmp;
            }
        }
        return null;
    }

    private TEAIDPortRec getPortRec(TEAIDDevVerInfo verInfo, int cpType, int portNo, boolean isNA) {
        TEAIDPortRec portRec = null;
        if (!isNA) {
            TEAIDCPRec pCPRec = this.getCPRec(verInfo, cpType, isNA);
            if (pCPRec != null) {
                List<TEAIDPortRec> portRecList = pCPRec.m_portList;
                int m = portRecList.size();
                for (int i = 0; i < m; ++i) {
                    portRec = portRecList.get(i);
                    if (portNo != portRec.m_portNo) continue;
                    return portRec;
                }
            }
            return null;
        }
        TEAIDCPRec cpRec = null;
        List<TEAIDCPRec> pCPRecList = this.getCPRecList(verInfo);
        if (pCPRecList != null) {
            int m = pCPRecList.size();
            for (int i = 0; i < m; ++i) {
                cpRec = pCPRecList.get(i);
                if (cpType != cpRec.m_nCPType) continue;
                List<TEAIDPortRec> portRecList = cpRec.m_portList;
                int n = portRecList.size();
                for (int j = 0; j < n; ++j) {
                    portRec = portRecList.get(j);
                    if (portNo != portRec.m_portNo) continue;
                    return portRec;
                }
            }
        }
        return null;
    }

    private List<TEAIDCPRec> getCPRecList(TEAIDDevVerInfo verInfo) {
        Map.Entry<TEAIDDevInfo, List<TEAIDCPRec>> entry2 = null;
        for (Map.Entry<TEAIDDevInfo, List<TEAIDCPRec>> entry2 : this.m_devMap.entrySet()) {
            if (!entry2.getKey().isContainVersion(verInfo)) continue;
            return entry2.getValue();
        }
        return null;
    }

    public void loadXML(String strFile) {
        String strXMLFile = TEResourceManager.getPath() + "core/conf/" + strFile;
        Document doc = TEParseXMLFile.parseFile(strXMLFile);
        Node node = doc.getElementsByTagName("root").item(0);
        String name = null;
        TEAIDDevInfo m_curDev = null;
        NamedNodeMap namedNodeMap = null;
        SDXMLInterpreterMgr mgr = SDXMLInterpreterMgr.getInstance();
        NodeList nodeList = node.getChildNodes();
        int m = nodeList.getLength();
        for (int i = 0; i < m; ++i) {
            m_curDev = new TEAIDDevInfo();
            node = nodeList.item(i);
            name = node.getNodeName();
            if (!"ne_description".equals(name)) continue;
            namedNodeMap = node.getAttributes();
            m_curDev.m_neType = mgr.parseInt(namedNodeMap.getNamedItem("ne_type").getNodeValue());
        }
    }

    public String getMOD2(int cpType, int portID, TENEPO pNE, boolean isNA) {
        TEAIDPortRec pAIDPort;
        TEAIDDevVerInfo devInfo = new TEAIDDevVerInfo();
        devInfo.m_neType = 2047;
        devInfo.m_nVer = 0;
        if (!isNA && null != pNE) {
            devInfo.m_neType = pNE.getType();
            devInfo.m_nVer = pNE.getVersion();
        }
        if ((pAIDPort = this.getPortRec(devInfo, cpType, portID, isNA)) != null) {
            return pAIDPort.m_strMOD2;
        }
        return "";
    }

    public List<AID> getAIDList(int cpType, int portID, TENEPO pNE, boolean isNA) {
        TEAIDPortRec pAIDPort;
        TEAIDDevVerInfo devInfo = new TEAIDDevVerInfo();
        devInfo.m_neType = 2047;
        devInfo.m_nVer = 0;
        if (!isNA && null != pNE) {
            devInfo.m_neType = pNE.getType();
            devInfo.m_nVer = pNE.getVersion();
        }
        if ((pAIDPort = this.getPortRec(devInfo, cpType, portID, isNA)) != null) {
            return pAIDPort.m_aidList;
        }
        return new ArrayList<AID>();
    }
}

