/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.mo;

import com.huawei.nglct.mo.CfgData;
import com.huawei.nglct.mo.PayloadTranf;
import com.huawei.nglct.util.device.board.TESubrackTypeMapping;
import gnu.trove.TIntArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CfgDataMgr {
    private Map<MainKey, Set<SubKey>> m_dataMap = new HashMap<MainKey, Set<SubKey>>();
    private List<PayloadTranf> m_PaylodVec = new ArrayList<PayloadTranf>();
    private static CfgDataMgr m_instance = null;
    private List<TESubrackTypeMapping> m_subrackTypeVec = new ArrayList<TESubrackTypeMapping>();

    private CfgDataMgr() {
    }

    public static synchronized CfgDataMgr getInstance() {
        if (null == m_instance) {
            m_instance = new CfgDataMgr();
        }
        return m_instance;
    }

    public boolean getRecord(CfgData data, boolean bGetUnkTypeDataWhenNotFound) {
        boolean result = true;
        if (!this.getRecordImpl(data)) {
            int unkType = data.m_iPrimaryKey;
            data.m_iPrimaryKey = 2047;
            result = this.getRecordImpl(data);
            data.m_iPrimaryKey = unkType;
        }
        return result;
    }

    public boolean getRecord(int iDomain, int iPrimaryKey, List<CfgData> dataList) {
        dataList.clear();
        MainKey mainKey = new MainKey(iDomain, iPrimaryKey);
        if (!this.m_dataMap.containsKey(mainKey)) {
            return false;
        }
        SubKey tmp2 = null;
        for (SubKey tmp2 : this.m_dataMap.get(mainKey)) {
            dataList.add(new CfgData(iDomain, iPrimaryKey, tmp2.m_iattribName, tmp2.m_vSubkey, tmp2.m_vValue, tmp2.m_minNeVer, tmp2.m_maxNeVer));
        }
        return !dataList.isEmpty();
    }

    public boolean getRecord(int iDomain, int iPkey1, int iPkey2, List<CfgData> dataList) {
        dataList.clear();
        MainKey mainKey = new MainKey(iDomain, iPkey1);
        if (!this.m_dataMap.containsKey(mainKey)) {
            mainKey.mainKey = iPkey1 = iPkey2;
            if (!this.m_dataMap.containsKey(mainKey)) {
                return false;
            }
        }
        SubKey tmp2 = null;
        for (SubKey tmp2 : this.m_dataMap.get(mainKey)) {
            dataList.add(new CfgData(iDomain, iPkey1, tmp2.m_iattribName, tmp2.m_vSubkey, tmp2.m_vValue, tmp2.m_minNeVer, tmp2.m_maxNeVer));
        }
        return !dataList.isEmpty();
    }

    public boolean getRecord(int iDomain, TIntArrayList keyList, List<CfgData> dataList) {
        int key = 0;
        SubKey tmp2 = null;
        MainKey mainkey = null;
        Iterator<SubKey> iter = null;
        int m = keyList.size();
        for (int i = 0; i < m; ++i) {
            key = keyList.get(i);
            mainkey = new MainKey(iDomain, key);
            if (!this.m_dataMap.containsKey(mainkey)) continue;
            for (SubKey tmp2 : this.m_dataMap.get(mainkey)) {
                dataList.add(new CfgData(iDomain, key, tmp2.m_iattribName, tmp2.m_vSubkey, tmp2.m_vValue, tmp2.m_minNeVer, tmp2.m_maxNeVer));
            }
        }
        return !dataList.isEmpty();
    }

    public boolean getTypeInfoBySubrack(TESubrackTypeMapping data) {
        if (!this.m_subrackTypeVec.isEmpty()) {
            for (TESubrackTypeMapping one : this.m_subrackTypeVec) {
                if (one.subrackType != data.subrackType) continue;
                data.equipmentType = one.equipmentType;
                data.shelfType = one.shelfType;
                return true;
            }
        }
        return false;
    }

    public boolean getCurbyNG(PayloadTranf data) {
        if (!this.m_PaylodVec.isEmpty()) {
            PayloadTranf tmp = null;
            int m = this.m_PaylodVec.size();
            for (int i = 0; i < m; ++i) {
                tmp = this.m_PaylodVec.get(i);
                if (tmp.m_NGpayloadtype != data.m_NGpayloadtype) continue;
                data.m_Currencypayloadtype = tmp.m_Currencypayloadtype;
                return true;
            }
        }
        return false;
    }

    public boolean getNGbyCur(PayloadTranf data) {
        if (!this.m_PaylodVec.isEmpty()) {
            PayloadTranf tmp = null;
            int m = this.m_PaylodVec.size();
            for (int i = 0; i < m; ++i) {
                tmp = this.m_PaylodVec.get(i);
                if (tmp.m_Currencypayloadtype != data.m_Currencypayloadtype) continue;
                data.m_NGpayloadtype = tmp.m_NGpayloadtype;
                return true;
            }
        }
        return false;
    }

    public int getNMSerTypeByNE(int neSevType) {
        if (!this.m_PaylodVec.isEmpty()) {
            PayloadTranf tmp = null;
            int m = this.m_PaylodVec.size();
            for (int i = 0; i < m; ++i) {
                tmp = this.m_PaylodVec.get(i);
                if (tmp.m_NGpayloadtype != neSevType) continue;
                return tmp.m_Currencypayloadtype;
            }
        }
        return neSevType;
    }

    public int getNESerTypeByNM(int nmSevType) {
        if (!this.m_PaylodVec.isEmpty()) {
            PayloadTranf tmp = null;
            int m = this.m_PaylodVec.size();
            for (int i = 0; i < m; ++i) {
                tmp = this.m_PaylodVec.get(i);
                if (tmp.m_Currencypayloadtype != nmSevType) continue;
                return tmp.m_NGpayloadtype;
            }
        }
        return nmSevType;
    }

    public void addRecord(CfgData data) {
        MainKey mainKey = new MainKey(data);
        SubKey subKey = new SubKey(data);
        if (this.m_dataMap.containsKey(mainKey)) {
            this.m_dataMap.get(mainKey).add(subKey);
        } else {
            HashSet<SubKey> set = new HashSet<SubKey>();
            set.add(subKey);
            this.m_dataMap.put(mainKey, set);
        }
    }

    public void addRecord(PayloadTranf data) {
        this.m_PaylodVec.add(data);
    }

    public void addRecord(TESubrackTypeMapping data) {
        this.m_subrackTypeVec.add(data);
    }

    private boolean getRecordImpl(CfgData data) {
        MainKey mainKey = new MainKey(data);
        if (!this.m_dataMap.containsKey(mainKey)) {
            return false;
        }
        SubKey tmp2 = null;
        SubKey subKey = new SubKey(data);
        for (SubKey tmp2 : this.m_dataMap.get(mainKey)) {
            if (!tmp2.equals(subKey)) continue;
            data.m_vValue = tmp2.m_vValue;
            return true;
        }
        return false;
    }

    class SubKey {
        int m_iattribName;
        TIntArrayList m_vSubkey = null;
        TIntArrayList m_vValue = null;
        int m_minNeVer;
        int m_maxNeVer;

        SubKey() {
            this.m_iattribName = 0;
            this.m_vSubkey = new TIntArrayList();
            this.m_vValue = new TIntArrayList();
            this.m_minNeVer = 0;
            this.m_maxNeVer = 0;
        }

        SubKey(CfgData data) {
            this.m_iattribName = data.m_iattribName;
            this.m_vSubkey = data.m_vSubkey;
            this.m_vValue = data.m_vValue;
            this.m_minNeVer = data.m_minNeVer;
            this.m_maxNeVer = data.m_maxNeVer;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.m_iattribName;
            result = 31 * result + this.m_maxNeVer;
            result = 31 * result + this.m_minNeVer;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SubKey other = (SubKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.m_iattribName != other.m_iattribName) {
                return false;
            }
            if (this.m_maxNeVer != other.m_maxNeVer) {
                return false;
            }
            return this.m_minNeVer == other.m_minNeVer;
        }

        private CfgDataMgr getOuterType() {
            return CfgDataMgr.this;
        }
    }

    class MainKey {
        int domain;
        int mainKey;

        MainKey(int idomain, int imainkey) {
            this.domain = idomain;
            this.mainKey = imainkey;
        }

        MainKey(CfgData data) {
            this.domain = data.m_iDomain;
            this.mainKey = data.m_iPrimaryKey;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.domain;
            result = 31 * result + this.mainKey;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MainKey other = (MainKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.domain != other.domain) {
                return false;
            }
            return this.mainKey == other.mainKey;
        }

        private CfgDataMgr getOuterType() {
            return CfgDataMgr.this;
        }
    }
}

