/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.jni.radiolinkreport;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.consts.TEInteMacroCodeConstant;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.jni.TECNEMgrService;
import com.huawei.nglct.jni.radiolinkreport.TEJniNoticeResult;
import com.huawei.nglct.jni.radiolinkreport.TERTNDataChangeNoticeReq;
import com.huawei.nglct.jni.radiolinkreport.TERTNDataChangeNoticeRsp;
import com.huawei.nglct.po.embeddednemgrmo.gencfg.TEWebLCTBoardGenCfgMOPO;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;

public class TERTNDataChangedInformer {
    public static TEJniNoticeResult noticeU2000(int neid, TEWebLCTBoardGenCfgMOPO mopo) {
        TEGeneralKeyValue gnlKeyValue = new TEGeneralKeyValue();
        String attrName = mopo.getAttrName();
        int attrID = TERTNDataChangedInformer.convertAttrNameToAttrID(attrName);
        if (attrID == -1) {
            return new TEJniNoticeResult(0L);
        }
        gnlKeyValue.setAttrID(attrID);
        int[] objID = new int[]{neid, mopo.getSlotId(), -1, mopo.getPort(), mopo.getPath()};
        gnlKeyValue.setTEOBJECTID(objID);
        TEGnlValueElement element = new TEGnlValueElement();
        element.setGnlKeyValue(gnlKeyValue);
        element.setGnlValue(new TEGeneralValue());
        ArrayList<TEGnlValueElement> changedAttrList = new ArrayList<TEGnlValueElement>();
        changedAttrList.add(element);
        TERTNDataChangeNoticeReq req = new TERTNDataChangeNoticeReq(changedAttrList);
        TERTNDataChangeNoticeRsp rsp = new TERTNDataChangeNoticeRsp();
        TELogFactory.getNormalLogger().info("Begin to call jni that provided by U2000 server. JNI_GNL_ATTR_CHANGE_NOTIFY");
        long retCode = TECNEMgrService.dispatch(10, req, rsp);
        TELogFactory.getNormalLogger().info("U2000 Server has return the result. JNI_GNL_ATTR_CHANGE_NOTIFY");
        TEJniNoticeResult result = new TEJniNoticeResult(retCode);
        return result;
    }

    private static int convertAttrNameToAttrID(String attrName) {
        if (!TEInteMacroCodeConstant.getAttributeMap().containsValue(attrName)) {
            return -1;
        }
        Set<Map.Entry<Integer, String>> entrySet = TEInteMacroCodeConstant.getAttributeMap().entrySet();
        for (Map.Entry<Integer, String> entry : entrySet) {
            int key = entry.getKey();
            String val = entry.getValue();
            if (!val.equals(attrName)) continue;
            return key;
        }
        return -1;
    }
}

