/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.jni.nelist;

import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TEASN1CommMgr;
import com.huawei.nglct.core.neproxy.TEProcID;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.jni.nelist.TEJNIGetLogicNEIDReq;
import com.huawei.nglct.jni.nelist.TEJNIGetLogicNEIDRsp;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.f_interface.neexplorer.AsnGetNGLCTParaReq;
import com.huawei.nglct.nemgr.f_interface.neexplorer.AsnGetNGLCTParaRsp;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.commustru.fstru.FStruct;

public class TEGetLogicNEIDService {
    public static int getLogicNEID(int phyneid) {
        int logicNEID = -1;
        TEJNIGetLogicNEIDReq req = new TEJNIGetLogicNEIDReq(phyneid);
        TEJNIGetLogicNEIDRsp rsp = new TEJNIGetLogicNEIDRsp();
        TELogFactory.getNormalLogger().info("Begin to call jni that provided by U2000 server." + req.toString());
        long retCode = TEJNIFacadeUtil.sendJNIMessage(7, req, rsp);
        TELogFactory.getNormalLogger().info("U2000 Server has return the result:" + retCode + ", " + rsp.toString());
        if (retCode == 0L && rsp.getErrcode() == 0L) {
            logicNEID = rsp.getLogicNeID();
        }
        return logicNEID;
    }

    public static TENE getNE(int phyneid) {
        TENE ne = TENEListMgr.getInstance().getPhyNE(phyneid);
        if (ne == null && TESysManagerBean.getInstance().isIntegratedStatus()) {
            int logicNeId = TEGetLogicNEIDService.getLogicNEID(phyneid);
            return TENEListMgr.getInstance().getInterNE(logicNeId);
        }
        return ne;
    }

    public static String[] getProcInfo(int neID) {
        int destProcID = TEGetLogicNEIDService.getNEProccID(neID);
        if (destProcID == -1) {
            return null;
        }
        String[] procArr = null;
        AsnGetNGLCTParaReq req = new AsnGetNGLCTParaReq();
        req.userID = 386;
        req.neID = neID;
        TELogFactory.getNormalLogger().info(TEAsn1Util.getAsn1String(req));
        AsnGetNGLCTParaRsp rsp = new AsnGetNGLCTParaRsp();
        int cmdCode = 0x202211;
        TEProcID procID = new TEProcID();
        procID.setProcID((char)destProcID);
        int result = TEASN1CommMgr.sendCommand(procID, (FStruct)req, (FStruct)rsp, cmdCode);
        if (result != 0) {
            TELogFactory.getNormalLogger().error("Send query procinfo cmd fail! errorCode:" + result);
            return procArr;
        }
        String procReg = "[0-9]+/[0-9]+$";
        Matcher matcher = Pattern.compile("[0-9]+/[0-9]+$").matcher(new String(rsp.webServerConnStr));
        if (matcher.find()) {
            procArr = matcher.group(0).split("/");
        }
        return procArr;
    }

    public static int getNEProccID(int neID) {
        int procID = -1;
        TENE ne = TENEListMgr.getInstance().getInterNE(neID);
        if (ne == null) {
            return procID;
        }
        procID = 4025;
        return procID;
    }
}

