/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.jni.hfcp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.jni.TECNEMgrService;
import com.huawei.nglct.jni.hfcp.TEJNIHFCPFileReq;
import com.huawei.nglct.jni.hfcp.TEJNIHFCPFileRsp;
import com.huawei.nglct.jni.hfcp.TEJNIHFCPGetGuageReq;
import com.huawei.nglct.jni.hfcp.TEJNIHFCPGetGuageRsp;
import com.huawei.nglct.jni.hfcp.TEJNIHFCPGetResultReq;
import com.huawei.nglct.jni.hfcp.TEJNIHFCPGetResultRsp;
import com.huawei.nglct.neinterface.neadapter.hfcpadapter.TEHFCPHandler;
import com.huawei.nglct.util.hfcpfiledata.TEHFCPFileCopyHandler;
import com.huawei.nglct.util.xml.TERWCfgFile;
import com.huawei.nglct.util.xml.TEResourceManager;
import java.io.File;
import java.security.SecureRandom;
import org.slf4j.Logger;

public class TEHFCPFileService {
    private static int TIME_OUT = 60;
    private static String HFCP_FILE_PATH = "hfcp";
    private static Logger log = TELogFactory.getHFCPFileTransferLogger();
    private static SecureRandom random = new SecureRandom();

    private static String getLocalFilePath() {
        String cfgFileRootPath = TERWCfgFile.getBundleRWCfgFilePath(TEResourceManager.class, "");
        String result = cfgFileRootPath + HFCP_FILE_PATH;
        File filePath = new File(result);
        if (!filePath.exists()) {
            filePath.mkdir();
        }
        return result;
    }

    private static String getFileName(int neid, String fileName) {
        int index = fileName.lastIndexOf(".");
        String result = neid + "_" + random.nextInt(65535);
        result = index >= 0 ? fileName.substring(0, index) + "_" + result + fileName.substring(index) : fileName + "_" + result;
        return result;
    }

    public static byte[] getFileWait(String neFilePath, String fileName, int neid) {
        String localFilePath = TEHFCPFileService.getLocalFilePath();
        fileName = TEHFCPFileService.getFileName(neid, fileName);
        log.info("<HFCP> File JNI ---- HFCP file TEHFCPFileService get file " + fileName + " from NE begin!");
        byte[] fileData = null;
        TEJNIHFCPFileRsp rsp = TEHFCPFileService.uploadHFCPFile(neFilePath, localFilePath, fileName, neid);
        if (rsp.getErrCode() == 0L) {
            long result = TEHFCPFileService.getResult(rsp.getSerialID(), TIME_OUT);
            if (result == 0L) {
                String filepath = localFilePath + File.separator + fileName;
                File tmpFile = new File(filepath);
                if (tmpFile.exists()) {
                    fileData = TEHFCPFileCopyHandler.getFileBytes(filepath);
                    tmpFile.delete();
                } else {
                    log.info("<HFCP> File JNI ---- HFCP file " + filepath + " is not exist!");
                }
            }
        } else {
            log.info("<HFCP> File JNI ---- uploadHFCPFile is failed! The error code is " + rsp.getErrCode());
            TEHFCPHandler.instance().setRet((int)rsp.getErrCode());
        }
        log.info("<HFCP> File JNI ---- HFCP file TEHFCPFileService get file " + fileName + " from NE end!");
        return fileData;
    }

    public static long sendFileWait(byte[] fileData, String neFilePath, String fileName, int neid) {
        String localFilePath = TEHFCPFileService.getLocalFilePath();
        long result = TEHFCPFileCopyHandler.writeFile(localFilePath + File.separator + fileName, fileData);
        if (result == 0L) {
            result = TEHFCPFileService.sendFileWait(neFilePath, localFilePath, fileName, neid);
        }
        return result;
    }

    public static long sendFileWait(String neFilePath, String localFilePath, String fileName, int neid) {
        log.info("<HFCP> File JNI ---- HFCP file TEHFCPFileService send file " + fileName + " from NE begin!");
        long result = 0L;
        TEJNIHFCPFileRsp rsp = TEHFCPFileService.downloadHFCPFile(neFilePath, localFilePath, fileName, neid);
        if (rsp.getErrCode() == 0L) {
            String filepath = localFilePath + File.separator + fileName;
            File tmpFile = new File(filepath);
            if (tmpFile.exists()) {
                result = TEHFCPFileService.getResult(rsp.getSerialID(), TIME_OUT);
                tmpFile.delete();
            } else {
                log.info("<HFCP> File JNI ---- HFCP file " + filepath + " is not exist!");
            }
        } else {
            result = rsp.getErrCode();
        }
        log.info("<HFCP> File JNI ---- HFCP file TEHFCPFileService send file " + fileName + " from NE end!");
        return result;
    }

    public static long getResult(int serialID, int timeOut) {
        TEJNIHFCPGetResultReq req = new TEJNIHFCPGetResultReq(serialID, timeOut);
        TEJNIHFCPGetResultRsp rsp = new TEJNIHFCPGetResultRsp();
        log.info("Begin to call jni that provided by U2000 server.serialID=" + serialID);
        long retCode = TECNEMgrService.dispatch(804, req, rsp);
        log.info("U2000 Server has return the result=" + retCode + "serialID=" + serialID);
        if (retCode == 0L) {
            log.info("Successed to call JNI.serialID=" + serialID + "errorCode=" + rsp.getErrCode());
        } else {
            rsp.setErrCode(retCode);
        }
        return rsp.getErrCode();
    }

    public static TEJNIHFCPGetGuageRsp getGuage(int serialID) {
        TEJNIHFCPGetGuageReq req = new TEJNIHFCPGetGuageReq(serialID);
        TEJNIHFCPGetGuageRsp rsp = new TEJNIHFCPGetGuageRsp();
        log.info("Begin to call jni that provided by U2000 server.serialID=" + serialID);
        long retCode = TECNEMgrService.dispatch(803, req, rsp);
        log.info("U2000 Server has return the result=" + retCode + "serialID=" + serialID);
        if (retCode == 0L) {
            log.info("Successed to call JNI.serialID=" + serialID + "errorCode=" + rsp.getErrCode());
        } else {
            rsp.setErrCode(retCode);
        }
        return rsp;
    }

    public static TEJNIHFCPFileRsp uploadHFCPFile(String neFilePath, String localFilePath, String fileName, int neid) {
        TEJNIHFCPFileReq req = new TEJNIHFCPFileReq(neid, neFilePath, localFilePath, fileName);
        TEJNIHFCPFileRsp rsp = new TEJNIHFCPFileRsp();
        log.info("Begin to call jni that provided by U2000 server.neFilePath=" + neFilePath);
        long retCode = TECNEMgrService.dispatch(801, req, rsp);
        log.info("U2000 Server has return the result=" + retCode);
        if (retCode == 0L) {
            log.info("Successed to call JNI.serialID=" + rsp.getSerialID() + "errorCode=" + rsp.getErrCode());
        } else {
            rsp.setErrCode(retCode);
        }
        return rsp;
    }

    public static TEJNIHFCPFileRsp downloadHFCPFile(String neFilePath, String localFilePath, String fileName, int neid) {
        TEJNIHFCPFileReq req = new TEJNIHFCPFileReq(neid, neFilePath + "/" + fileName, localFilePath, fileName);
        TEJNIHFCPFileRsp rsp = new TEJNIHFCPFileRsp();
        log.info("Begin to call jni that provided by U2000 server.neFilePath=" + neFilePath);
        long retCode = TECNEMgrService.dispatch(802, req, rsp);
        log.info("U2000 Server has return the result=" + retCode);
        if (retCode == 0L) {
            log.info("Successed to call JNI.serialID=" + rsp.getSerialID() + "errorCode=" + rsp.getErrCode());
        } else {
            rsp.setErrCode(retCode);
        }
        return rsp;
    }
}

