/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.jni.db;

import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.jni.TEJNIFacadeUtil;
import com.huawei.nglct.nemgr.f_interface.asncommon.AsnNullReq;
import com.huawei.nglct.nemgr.f_interface.db.AsnJNIGetDBConnParamsRsp;
import java.util.Properties;
import net.commustru.fstru.FStruct;

public class TEJNIGetDBRefParamsSerivce {
    private static final String CONNECTION_DRIVER_CLASS_KEY = "hibernate.connection.driver_class";
    private static final String CONNECTION_URL_KEY = "hibernate.connection.url";
    private static final String CONNECTION_USERNAME_KEY = "hibernate.connection.username";
    private static final String CONNECTION_PASSWORD_KEY = "hibernate.connection.password";
    private static final String DIALECT_KEY = "hibernate.dialect";
    private static final String DEFAULT_SCHEMA = "hibernate.default_schema";
    private static final String SYBASE = "sybase";
    private static final String MSSQL = "sqlserver";
    private static final String ORACLE = "oracle";

    public static Properties getDBConnParams(int proID) {
        AsnNullReq aReq = new AsnNullReq();
        AsnJNIGetDBConnParamsRsp aRsp = new AsnJNIGetDBConnParamsRsp();
        TELogFactory.getNormalLogger().info(TEAsn1Util.getAsn1String(aReq));
        int retCode = (int)TEJNIFacadeUtil.sendJNIMessage_noRspLog(2180419, (FStruct)aReq, (FStruct)aRsp);
        if (0 != retCode) {
            TELogFactory.getNormalLogger().error("get db conn params failed!");
            return null;
        }
        Properties databasePro = new Properties();
        databasePro.put(DIALECT_KEY, TEJNIGetDBRefParamsSerivce.getDialect(new String(aRsp.dbType)));
        databasePro.put(CONNECTION_DRIVER_CLASS_KEY, TEJNIGetDBRefParamsSerivce.getDBDriver(new String(aRsp.dbType)));
        databasePro.put(CONNECTION_URL_KEY, TEJNIGetDBRefParamsSerivce.getDBConnURL(aRsp));
        databasePro.put(CONNECTION_USERNAME_KEY, new String(aRsp.dbUserName));
        databasePro.put(CONNECTION_PASSWORD_KEY, new String(aRsp.dbPassword));
        if (new String(aRsp.dbType).equals(ORACLE)) {
            databasePro.put(DEFAULT_SCHEMA, new String(aRsp.dbName));
        }
        return databasePro;
    }

    private static String getDialect(String dbType) {
        if (SYBASE.equals(dbType)) {
            return "org.hibernate.dialect.SybaseDialect";
        }
        if (MSSQL.equals(dbType)) {
            return "org.hibernate.dialect.SQLServerDialect";
        }
        if (ORACLE.equals(dbType)) {
            return "org.hibernate.dialect.Oracle10gDialect";
        }
        return "org.hibernate.dialect.HSQLDialect";
    }

    private static String getDBDriver(String dbType) {
        if (SYBASE.equals(dbType)) {
            return "com.sybase.jdbc3.jdbc.SybDriver";
        }
        if (MSSQL.equals(dbType)) {
            return "net.sourceforge.jtds.jdbc.Driver";
        }
        if (ORACLE.equals(dbType)) {
            return "oracle.jdbc.driver.OracleDriver";
        }
        return "org.hsqldb.jdbcDriver";
    }

    private static String getDBConnURL(AsnJNIGetDBConnParamsRsp rsp) {
        if (SYBASE.equals(new String(rsp.dbType))) {
            return "jdbc:sybase:Tds:" + new String(rsp.serverName) + ":" + new String(rsp.serverPort) + "/" + new String(rsp.dbName);
        }
        if (MSSQL.equals(new String(rsp.dbType))) {
            return "jdbc:jtds:sqlserver://" + new String(rsp.serverName) + ":" + new String(rsp.serverPort) + "/" + new String(rsp.dbName);
        }
        if (ORACLE.equals(new String(rsp.dbType))) {
            return "jdbc:oracle:thin:@//" + new String(rsp.serverName) + ":" + new String(rsp.serverPort) + "/" + new String(rsp.dbName);
        }
        return "jdbc:hsqldb:.";
    }
}

