/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.jni.checkright;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.jni.ITECNEMgrService;
import com.huawei.nglct.jni.TECNEMgrServiceImpl;
import com.huawei.nglct.jni.checkright.TEJNICheckRightReq;
import com.huawei.nglct.jni.checkright.TEJNICheckRightRsp;
import com.huawei.nglct.jni.checkright.TEJNIGetDwdmService;

public class TEJNICheckRightService {
    private ITECNEMgrService cNemgrService;
    public static TEJNICheckRightService instance;
    public static final int HASH_RESULT_FLAG = 1;
    public static final int NE_OSTID = 1;
    public static final int NE_OTID = 4;

    public static synchronized TEJNICheckRightService getInstance() {
        if (instance == null) {
            instance = new TEJNICheckRightService();
            TEJNICheckRightService.instance.cNemgrService = new TECNEMgrServiceImpl();
        }
        return instance;
    }

    public void setTECNEMgrServiceInterface(ITECNEMgrService cwnemgrService) {
        this.cNemgrService = cwnemgrService;
    }

    public boolean jniRightCheck(int userID, int cmdID, int otid, int ostid, int neid) {
        int dwdmid = TEJNIGetDwdmService.getInstance().jniGetDwdmID(neid);
        if (dwdmid != 0) {
            neid = dwdmid;
        }
        TEJNICheckRightReq req = new TEJNICheckRightReq();
        req.setOstid(ostid);
        req.setOtid(otid);
        req.setOid(neid);
        req.setUserID(userID);
        req.setCmdid(cmdID);
        TEJNICheckRightRsp rsp = new TEJNICheckRightRsp();
        TELogFactory.getNormalLogger().debug("Check right for req:\n" + req.toString());
        long retCode = this.cNemgrService.dispatch(6, req, rsp);
        TELogFactory.getNormalLogger().debug("Check right for rsp:\n" + rsp.toString());
        if (retCode == 0L) {
            return rsp.getResult() == 1;
        }
        TELogFactory.getNormalLogger().info("Failed to call JNI. Error codeis" + retCode);
        return true;
    }

    public boolean jniRightCheck(int userID, int cmdID, int neid) {
        return this.jniRightCheck(userID, cmdID, 4, 1, neid);
    }
}

