/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.jni.asncommu;

import com.huawei.commextend.taskmgr.Task;
import com.huawei.commextend.taskmgr.TaskDes;
import com.huawei.commextend.taskmgr.TaskDispatcherMgr;
import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.mdp.TECommUtil;
import com.huawei.nglct.core.startup.TEWNEMgrJniLogFactory;
import com.huawei.nglct.core.taskmgr.TETaskDes;
import com.huawei.nglct.core.taskmgr.TETaskInfo;
import com.huawei.nglct.core.taskmgr.TEWNEMgrTaskDescription;
import com.huawei.nglct.core.taskmgr.TEWNEMgrTaskMgr;
import com.huawei.nglct.jni.asncommu.JniAsnDataType;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEAsnMsgDispatcher {
    private static TEAsnMsgDispatcher instance = new TEAsnMsgDispatcher();
    private TEWNEMgrTaskMgr taskMgr = null;
    private static Logger log = TEWNEMgrJniLogFactory.getLogger(TEAsnMsgDispatcher.class.getName());
    private Map<Integer, TEWNEMgrTaskDescription> cmdTaskDesMap = new ConcurrentHashMap<Integer, TEWNEMgrTaskDescription>();

    public static TEAsnMsgDispatcher getInstance() {
        return instance;
    }

    private TEAsnMsgDispatcher() {
        this.init();
    }

    private void init() {
        this.taskMgr = new TEWNEMgrTaskMgr();
    }

    public int registerTask(Class taskClass) {
        log.info("register task->" + taskClass);
        int result = 0;
        result = TEAsnMsgDispatcher.checkIntStatus() ? this.registerTask_Jni(taskClass) : TaskDispatcherMgr.getInstance(null).registerTask(taskClass);
        return result;
    }

    private int registerTask_Jni(Class taskClass) {
        Method[] methodAry = taskClass.getMethods();
        Class<?> reqClass = null;
        Class<?> rspClass = null;
        for (Method method : methodAry) {
            int taskMsgFlag;
            int cmdCode;
            int taskID;
            int taskMgrID;
            TaskDes taskDes = method.getAnnotation(TaskDes.class);
            if (null != taskDes) {
                taskMgrID = taskDes.taskmgrID();
                taskID = taskDes.taskID();
                cmdCode = taskDes.cmdCode();
                taskMsgFlag = 0;
            } else {
                TETaskDes teTaskDes = method.getAnnotation(TETaskDes.class);
                if (null == teTaskDes) continue;
                taskMgrID = teTaskDes.taskmgrID();
                taskID = teTaskDes.taskID();
                cmdCode = teTaskDes.cmdCode();
                taskMsgFlag = teTaskDes.detailMsgFlag();
            }
            if (!this.isValidateMethod(method)) continue;
            try {
                Class<?>[] paramTypes = method.getParameterTypes();
                reqClass = paramTypes[0];
                rspClass = null;
                if (paramTypes.length >= 3) {
                    rspClass = paramTypes[1];
                }
                TEWNEMgrTaskDescription taskDesObj = new TEWNEMgrTaskDescription(taskClass, taskMgrID, taskID, cmdCode, reqClass, rspClass, method, taskMsgFlag);
                this.cmdTaskDesMap.put(cmdCode, taskDesObj);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEAsnMsgDispatcher.registerTask_Jni fail!", (Throwable)e);
            }
        }
        return 0;
    }

    public static boolean isStaticTask(int taskID) {
        return taskID >= 1 && taskID <= 20;
    }

    private boolean isValidateMethod(Method method) {
        boolean result = false;
        Class<?>[] paramTypes = method.getParameterTypes();
        switch (paramTypes.length) {
            case 2: {
                result = !FStruct.class.isAssignableFrom(paramTypes[0]) || !Task.class.isAssignableFrom(paramTypes[1]);
                break;
            }
            case 3: {
                result = !FStruct.class.isAssignableFrom(paramTypes[0]) || !FStruct.class.isAssignableFrom(paramTypes[1]) || !Task.class.isAssignableFrom(paramTypes[2]) || Task.class.isAssignableFrom(paramTypes[2]) && !TaskMgr.class.isAssignableFrom(paramTypes[2]);
                break;
            }
            case 4: {
                result = !FStruct.class.isAssignableFrom(paramTypes[0]) || !FStruct.class.isAssignableFrom(paramTypes[1]) || !Task.class.isAssignableFrom(paramTypes[2]) || !TETaskInfo.class.isAssignableFrom(paramTypes[3]);
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private static boolean checkIntStatus() {
        return true;
    }

    public void receiveMessage(JniAsnDataType asnDataType) {
        this.dispatchMsg(asnDataType);
    }

    private void dispatchMsg(JniAsnDataType asnDataType) {
        FStruct rsp = null;
        int cmd = asnDataType.getFuncID();
        log.info("taskdispatcher receive msg, funID->" + cmd);
        TEWNEMgrTaskDescription des = this.cmdTaskDesMap.get(cmd);
        if (null == des) {
            log.info("taskdispatcher, can't find task des, cmd->" + cmd);
            rsp = null;
        } else {
            log.info("taskdispatcher, des class ->" + des.getTaskClass());
            try {
                MSGHead mh = new MSGHead();
                mh.cmdCode = cmd;
                MSGPacketExt msg = new MSGPacketExt(mh, asnDataType.getDataReq());
                rsp = this.taskMgr.dispatchMsg(des, msg);
            }
            catch (Exception e) {
                TELogFactory.getNormalLogger().error("TEWNEMgrTaskDispatcher.dispatchMsg() fail!", (Throwable)e);
                rsp = null;
            }
        }
        if (null == rsp) {
            log.info("response is NULL");
        } else {
            asnDataType.setDataRsp(TECommUtil.encode(rsp));
            log.info("response is NOT NULL");
        }
    }

    public void close() {
        if (null != this.cmdTaskDesMap) {
            this.cmdTaskDesMap.clear();
        }
        this.taskMgr.close();
    }
}

