/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.jni;

import com.huawei.communicate.core.MSGHead;
import com.huawei.communicate.core.MSGPacketExt;
import com.huawei.communicate.util.asn.AsnCoder;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.startup.TEWNEMgrJniDllLoader;
import com.huawei.nglct.jni.TECNEMgrService;
import com.huawei.nglct.jni.TEJNICommonRsp;
import com.huawei.nglct.jni.TEJNIGnlReq;
import com.huawei.nglct.jni.TEJNIGnlRsp;
import com.huawei.nglct.jni.TEJNIService;
import com.huawei.nglct.jni.asncommu.JniAsnDataType;
import com.huawei.nglct.jni.struct.TEJNIDefaultRsp;
import com.huawei.nglct.jni.struct.TEJNIRegCmdReqData;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public final class TEJNIFacadeUtil {
    private static Logger embededWnemgrlog = TELogFactory.getembededWnemgrLogger();

    private TEJNIFacadeUtil() {
    }

    public static String getSBICommStr(int neID) {
        String commStr = null;
        TEJNICommonRsp rsp = new TEJNICommonRsp();
        try {
            TEJNIService.getSBICommStr(neID, rsp);
        }
        catch (Error e) {
            embededWnemgrlog.error("Get sbi info fail!", (Throwable)e);
            return commStr;
        }
        int result = rsp.getResult();
        if (0 == result) {
            commStr = (String)rsp.getData();
        } else if (0 != result) {
            embededWnemgrlog.error("Get sbi info fail. result->" + result);
        }
        return commStr;
    }

    public static long sendJNIMessage(int cMethodCmd, TEJNIGnlReq req, TEJNIGnlRsp rsp) {
        long retCode;
        try {
            retCode = (int)TECNEMgrService.dispatch(cMethodCmd, req, rsp);
        }
        catch (Error e) {
            embededWnemgrlog.error("Send message fail!", (Throwable)e);
            retCode = 2L;
        }
        return retCode;
    }

    public static long sendJNIMessage(int cMethodCmd, FStruct req, FStruct rsp) {
        long retCode;
        embededWnemgrlog.info("Send asn message. cMethodCmd->" + cMethodCmd);
        embededWnemgrlog.info("req->" + TEAsn1Util.getAsn1String(req));
        try {
            JniAsnDataType asnDataType = new JniAsnDataType();
            asnDataType.setFuncID(cMethodCmd);
            asnDataType.setDataReq(AsnCoder.serialize((FStruct)req));
            asnDataType.setDataRsp(AsnCoder.serialize((FStruct)rsp));
            retCode = (int)TECNEMgrService.dispatchAsn(asnDataType);
            MSGHead mh = new MSGHead();
            mh.cmdCode = cMethodCmd;
            MSGPacketExt msg = new MSGPacketExt(mh, asnDataType.getDataRsp());
            AsnCoder.deserialize((MSGPacketExt)msg, (FStruct)rsp);
        }
        catch (Throwable e) {
            embededWnemgrlog.error("Send asn message fail!", e);
            retCode = 2L;
        }
        embededWnemgrlog.info("rsp->" + TEAsn1Util.getAsn1String(rsp));
        embededWnemgrlog.info("retCode->" + retCode);
        return retCode;
    }

    public static long sendJNIMessage_noRspLog(int cMethodCmd, FStruct req, FStruct rsp) {
        long retCode;
        embededWnemgrlog.info("Send asn message. cMethodCmd->" + cMethodCmd);
        embededWnemgrlog.info("req->" + TEAsn1Util.getAsn1String(req));
        try {
            JniAsnDataType asnDataType = new JniAsnDataType();
            asnDataType.setFuncID(cMethodCmd);
            asnDataType.setDataReq(AsnCoder.serialize((FStruct)req));
            asnDataType.setDataRsp(AsnCoder.serialize((FStruct)rsp));
            retCode = (int)TECNEMgrService.dispatchAsn(asnDataType);
            MSGHead mh = new MSGHead();
            mh.cmdCode = cMethodCmd;
            MSGPacketExt msg = new MSGPacketExt(mh, asnDataType.getDataRsp());
            AsnCoder.deserialize((MSGPacketExt)msg, (FStruct)rsp);
        }
        catch (Throwable e) {
            embededWnemgrlog.error("Send asn message fail!", e);
            retCode = 2L;
        }
        embededWnemgrlog.info("retCode->" + retCode);
        return retCode;
    }

    public static long registerCmd(int[] cmdArr) {
        TEJNIRegCmdReqData req = new TEJNIRegCmdReqData(cmdArr);
        TEJNIDefaultRsp rsp = new TEJNIDefaultRsp();
        long retCode = TEJNIFacadeUtil.sendJNIMessage(1, req, rsp);
        return retCode;
    }

    static {
        TEWNEMgrJniDllLoader.loadWNEMgrDll();
    }
}

