/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgCmdFactory;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunCmd;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.ngwdm_pub.TESimpleModelUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TETL1GenCfgSetBean
extends TETL1NEExplorerBean {
    private static Logger log = TELogFactory.getNormalLogger();
    protected ArrayList logInfoList = new ArrayList();
    public TEResourceUtil res = null;
    protected TETL1GenCfgFunCmd funCmd = null;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.outputData = new Datainterface();
        ArrayList operationList = null;
        StringBuffer filePath = new StringBuffer(TEPathManager.RESOURCE_PROFILE_PATH).append("gencfg").append(File.separator).append("attribres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TETL1NE ne = (TETL1NE)TENEListUtils.getNEObj(neid);
        if (null == ne) {
            log.info("Get ne object fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090596385));
            return this.outputData;
        }
        this.neType = ne.getNEType();
        String hostVersion = ne.getHostVersion();
        String fileName = TEGetFilePath.getFilePath(this.neType, hostVersion, filePath.toString());
        this.res = TEResourceUtil.getInstance(fileName);
        if (this.bQueryAidAndType) {
            this.slotIDList = this.getSlotIDFromInputDdata(inputData);
            if (this.slotIDList.size() > 0) {
                this.aidAndTypeList = TETL1CommonUtil.queryPortType(neid, this.slotIDList, this.outputData);
                if (this.aidAndTypeList == null) {
                    return this.outputData;
                }
                if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                    this.addRTRVPORTError(neid, ne, this.outputData);
                    return this.outputData;
                }
            }
        }
        fileName = subFunc.getGenCfgAttrDesPath().getContent();
        fileName = TEGetFilePath.getFilePath(this.neType, hostVersion, "conf" + File.separator + fileName);
        this.funCmd = TETL1GenCfgCmdFactory.getInstance().getFunCmd(fileName);
        if (null == this.funCmd) {
            log.info("Parse atrribute To TL1 mapping file fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            return this.outputData;
        }
        TL1Definitions definitions = null;
        try {
            definitions = TECreateObjectFactory.parseTL1DesFile(neid);
        }
        catch (Exception e) {
            log.error("Get NE's Qx Description Fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
            return this.outputData;
        }
        operationList = this.getSetOperationList(definitions, this.funCmd, inputData);
        if (null == operationList || operationList.isEmpty()) {
            return this.handleOperationListError(operationList, this.outputData);
        }
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(neid, (List)operationList, this.getTimeOut());
        if (0 == result.retCode) {
            ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
            this.handleMessage(neid, subFunc, operationList, filterErrorCodeList);
        } else {
            log.debug("Send command fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result.retCode));
        }
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
        }
        return this.outputData;
    }

    public Datainterface handleOperationListError(ArrayList operationList, Datainterface outputData) {
        outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
        return outputData;
    }

    public ArrayList getSetOperationList(TL1Definitions definitions, TETL1GenCfgFunCmd funCmd, Datainterface inputData) {
        ArrayList operationList = new ArrayList();
        BussinessParams bussinessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        Param param = null;
        Datainterface tmp = new Datainterface();
        tmp.setBussinessParams(new BussinessParams());
        tmp.getBussinessParams().addRowParams(0, new RowParams());
        int len = bussinessparams.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            rowparams = bussinessparams.getRowParams(i);
            tmp.getBussinessParams().setRowParams(0, rowparams);
            int size = rowparams.getParamCount();
            for (int j = 0; j < size; ++j) {
                param = rowparams.getParam(j);
                if (!param.getModifyFlag()) continue;
                this.getSetAttrOperationList(definitions, funCmd, operationList, param.getName(), tmp);
            }
        }
        return operationList;
    }

    @Override
    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = true;
        DataBlock dataBlock = null;
        Part part = null;
        int num = 0;
        int len = msgBlock.getDataBlockCount();
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                if (this.convertPartValue(part, rowparams)) {
                    ++num;
                    continue;
                }
                if (null == part.getDefault() || part.getDefault().isEmpty()) continue;
                part.setValue(part.getDefault());
                ++num;
            }
        }
        if (num < 1) {
            flag = false;
        }
        return flag;
    }

    @Override
    protected boolean convertPartValue(Part part, RowParams rowparams) {
        String convertID;
        boolean flag = true;
        String attrid = part.getName();
        String convertIDold = part.getConvert();
        Param param = rowparams.getParam("isByFun");
        String byfun = "";
        if (param != null) {
            byfun = param.getValue();
        }
        if (byfun.equals("true") && convertIDold != null && convertIDold.equals("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK")) {
            convertIDold = "DWDMTL1_ATTRPORT_LOOPBACK";
        }
        if (byfun.equals("true") && convertIDold != null && convertIDold.equals("DWDMTL1_ATTRPORT_ADVANCED_SVTIMER")) {
            convertIDold = "DWDMTL1_ATTRPORT_SVTIMER";
        }
        if ((convertID = this.convertAttrID(convertIDold)) != null && !convertID.equals("")) {
            attrid = convertID;
        } else if (null != this.funCmd) {
            attrid = this.funCmd.getParamAttrID(part.getName());
        }
        Param tmpParam = rowparams.getParam(attrid);
        if (tmpParam != null && !tmpParam.getModifyFlag()) {
            return false;
        }
        if (null != tmpParam) {
            part.setValue(tmpParam.getValue());
        } else {
            flag = false;
        }
        return flag;
    }

    public String convertAttrID(String attrID) {
        return attrID;
    }

    public void getSetAttrOperationList(TL1Definitions definitions, TETL1GenCfgFunCmd funCmd, ArrayList operationList, String attrId, Datainterface inputData) {
        if (null == funCmd) {
            return;
        }
        TETL1GenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrId, "set");
        if (null == funAttr) {
            return;
        }
        ArrayList subOperationList = this.convertToTL1Operation(funAttr, inputData, definitions, this.aidAndTypeList);
        if (null != subOperationList && 0 != subOperationList.size()) {
            int size = subOperationList.size();
            for (int i = 0; i < size; ++i) {
                TL1Operation oper = (TL1Operation)subOperationList.get(i);
                TETL1CommonUtil.addOperList(operationList, oper);
            }
        }
        String groupAttr = "";
        Param param = null;
        int size = funAttr.getGroupAttrList().size();
        for (int i = 0; i < size; ++i) {
            groupAttr = (String)funAttr.getGroupAttrList().get(i);
            if (groupAttr.equalsIgnoreCase(attrId) || null == (param = Datainterface.getParam(inputData.getBussinessParams().getRowParams(0).getParam(), groupAttr))) continue;
            param.setModifyFlag(false);
        }
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList);
    }

    @Override
    public RowErrors handleErrorData(int neid, SubFunc subfunc, TL1Operation oper, OutMsg output) {
        MsgBlock outputBlock;
        int i;
        int len;
        ArrayList operObjct = this.getTL1OperationObject(subfunc);
        InMsg input = oper.getInMsg();
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(neid));
        rowError.addParam(errorparam);
        DataBlock dataBlock = null;
        if (null != input) {
            AID aid = input.getStagBlock().getAID();
            len = aid.getPartCount();
            for (i = 0; i < len; ++i) {
                if (aid.getPart(i).getName().equalsIgnoreCase("AID")) {
                    String aidValue = aid.getPart(i).getValue();
                    String mod2 = TETL1CommonUtil.getRealMod2(oper);
                    ArrayList<String> aidTempList = TESimpleModelUtil.handleTL1SimpleModelPath(aidValue, mod2, neid);
                    errorparam = new Param(aid.getPart(i).getName(), aidTempList.get(0));
                } else {
                    errorparam = new Param(aid.getPart(i).getName(), aid.getPart(i).getValue());
                }
                rowError.addParam(errorparam);
            }
            len = input.getMsgBlock().getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = input.getMsgBlock().getDataBlock(i);
                int size = dataBlock.getPartCount();
                for (int j = 0; j < size; ++j) {
                    String partName = dataBlock.getPart(j).getConvert();
                    if (partName == null || partName.equals("")) {
                        partName = this.funCmd.getParamAttrID(dataBlock.getPart(j).getName());
                    }
                    if ((errorparam = new Param(partName, dataBlock.getPart(j).getValue())).getValue() != null) {
                        rowError.addParam(errorparam);
                    }
                    if (operObjct.contains(errorparam.getName()) || errorparam.getValue() == null) continue;
                    if (rowError.getParam("attrId") != null) {
                        errorparam = rowError.getParam("attrId");
                        errorparam.setValue(rowError.getParam("attrId").getValue() + "," + partName);
                    } else {
                        errorparam = new Param("attrId", partName);
                    }
                    rowError.addParam(errorparam);
                }
            }
        }
        if ((outputBlock = output.getMsgBlock()) != null) {
            len = outputBlock.getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = output.getMsgBlock().getDataBlock(i);
                int size = dataBlock.getPartCount();
                for (int j = 0; j < size; ++j) {
                    errorparam = new Param("attrId", dataBlock.getPart(j).getName());
                    if (null != rowError.getParam(dataBlock.getPart(j).getName())) continue;
                    rowError.addParam(errorparam);
                }
            }
        }
        if (oper.getName().indexOf("RLS-LPBK") != -1) {
            errorparam = new Param("attrId", "DWDMTL1_ATTRPORT_LOOPBACK");
            rowError.addParam(errorparam);
        }
        this.addErrorParam(neid, rowError);
        return rowError;
    }

    @Override
    public ArrayList getFilterErrorCodeList() {
        return null;
    }

    @Override
    public boolean isNeedOperationlog() {
        return true;
    }
}

