/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.tl1;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgObject;
import com.huawei.nglct.gencfg.TEGenCfgObjectFactory;
import com.huawei.nglct.gencfg.TEObjTypeMgr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgCmdFactory;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunCmd;
import com.huawei.nglct.nelist.TENEListUtils;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgPortAttribute;
import com.huawei.nglct.ngwdm_pub.TESimpleModelUtil;
import com.huawei.nglct.ngwdm_pub.TETL1SimpleAID;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.tl1.TETL1NEExplorerBean;
import com.huawei.nglct.tl1.eventinterpret.prbs.TEPRBSSupportPortMgr;
import com.huawei.nglct.tl1.nemanager.TETL1NE;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.tl1.OperationResult;
import com.huawei.uflight.tl1.TETL1NECommMgr;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.Fault;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TETL1GenCfgQueryBean
extends TETL1NEExplorerBean {
    private static Logger log = TELogFactory.getNormalLogger();
    protected StringBuffer queryAttrListBuff = new StringBuffer();
    public TEResourceUtil res = null;
    protected ArrayList operationList = null;
    protected String extendAttr = "";
    protected TETL1GenCfgFunCmd funCmd = null;
    protected int nmCurrSlotID = -1;
    protected static final String filterErrDesc = "INVALID DATA PARAMETER, Command not supported";
    protected boolean isByFun = false;
    public static final int AP8MODE = 0;
    public static final int LQM2MODE = 1;
    public static final int REGMODEL = 2;
    public static final int NORMALMODEL = 3;
    public static final int NONCASCADING = 4;
    public static final int CASCADING = 5;
    public static final int ODU0 = 6;
    public static final int UNODU0 = 7;
    public static final String GFP_OTU = "GFP_OTU";
    public static final String SDH_OTU = "SDH_OTU";
    public static final int BANDPASSMODE = 10;
    public static final int OADMMODE = 11;
    protected String boardMode = "";
    protected HashMap<String, String> portModelMap = new HashMap();
    protected ArrayList supportAttrList = new ArrayList();
    protected int bdtype = -1;
    protected String neVersion = "";
    protected String neName = "";
    private static ArrayList needQueryPstListByfun = new ArrayList();
    private static ArrayList<Integer> needQueryBoardModeBoardType = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        log.info("Start query TL1 WDM Interface.");
        this.slotIDList = this.getSlotIDFromInputDdata(inputData);
        Object[] nmCurrSlotIDArr = this.slotIDList.toArray();
        ArrayList<Integer> bufferSlotIDList = new ArrayList<Integer>();
        int len2 = nmCurrSlotIDArr.length;
        for (int i = 0; i < len2; ++i) {
            bufferSlotIDList.add((Integer)nmCurrSlotIDArr[i]);
        }
        TEConfigurationDataMgr.getInstance().startMethodBuffer(neid, bufferSlotIDList);
        try {
            Param byFunParam;
            this.bQueryAidAndType = true;
            this.neid = neid;
            this.subfunc = subFunc;
            this.TIME_OUT = 20;
            TETL1NE neObj = (TETL1NE)TENEListUtils.getNEObj(neid);
            if (null == neObj) {
                log.info("Get ne object fail!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090596385));
                Datainterface len2 = this.outputData;
                return len2;
            }
            this.neVersion = neObj.getHostVersion();
            this.neType = neObj.getNEType();
            this.neName = neObj.getNEName();
            this.outputData = new Datainterface();
            String fileName = subFunc.getGenCfgAttrDesPath().getContent();
            String path = TEGetFilePath.getFilePath(this.neType, this.neVersion, "conf" + File.separator + fileName);
            this.funCmd = TETL1GenCfgCmdFactory.getInstance().getFunCmd(path);
            if (null == this.funCmd) {
                log.info("Parse atrribute To TL1 mapping file fail!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
                Datainterface datainterface = this.outputData;
                return datainterface;
            }
            TL1Definitions tl1definitions = null;
            try {
                tl1definitions = TECreateObjectFactory.parseTL1DesFile(neid);
            }
            catch (Exception e) {
                log.error("Parse Qx description file fail!", (Throwable)e);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(1090646019));
                Datainterface datainterface = this.outputData;
                TEConfigurationDataMgr.getInstance().stopMethodBuffer(neid, bufferSlotIDList);
                return datainterface;
            }
            StringBuffer filePath = new StringBuffer(TEPathManager.RESOURCE_PROFILE_PATH).append("gencfg").append(File.separator).append("attribres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
            path = TEGetFilePath.getFilePath(this.neType, this.neVersion, filePath.toString());
            this.res = TEResourceUtil.getInstance(path);
            if (this.bQueryAidAndType) {
                this.nmCurrSlotID = (Integer)nmCurrSlotIDArr[0];
                if (this.slotIDList.size() > 0) {
                    this.aidAndTypeList = TETL1CommonUtil.queryPortType(neid, this.slotIDList, this.outputData);
                    if (this.aidAndTypeList == null) {
                        Datainterface datainterface = this.outputData;
                        return datainterface;
                    }
                    if (this.aidAndTypeList.size() == 0 && this.aidAndTypeList.getErrorCount() > 0) {
                        this.addRTRVPORTError(neid, neObj, this.outputData);
                        Datainterface datainterface = this.outputData;
                        return datainterface;
                    }
                }
            }
            this.bdtype = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.nmCurrSlotID);
            if (needQueryBoardModeBoardType.contains(this.bdtype)) {
                this.boardMode = this.getBoardMode(this.nmCurrSlotID);
            }
            if (this.bdtype == 1573 || this.bdtype == 2280 || this.bdtype == 2279 || this.bdtype == 2315 || this.bdtype == 2297 || this.bdtype == 2296 || this.bdtype == 2481 || this.bdtype == 2482) {
                this.getBoardPortMode(this.nmCurrSlotID);
            }
            if ((byFunParam = this.getIsByFunInputDdata(inputData)) != null && byFunParam.getValue() != null && byFunParam.getValue().equals("true")) {
                this.isByFun = true;
            }
            this.operationList = this.getQueryOperationList(this.funCmd, tl1definitions, inputData);
            if (null == this.operationList || 0 == this.operationList.size()) {
                log.info("The operationlist is null!");
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
                Datainterface datainterface = this.outputData;
                return datainterface;
            }
            OperationResult result = this.sendBatCommand(neid, this.operationList);
            if (0 != result.retCode) {
                log.debug("send command fail!The errorCode is :" + result.retCode);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(result.retCode));
                Datainterface datainterface = this.outputData;
                return datainterface;
            }
            log.debug("send command success!");
            ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
            this.handleMessage(neid, subFunc, this.operationList, filterErrorCodeList);
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, user, ipAddress, this.cloneTL1OperationList);
            }
            log.info("End query TL1 WDM Interface.");
            Datainterface datainterface = this.outputData;
            return datainterface;
        }
        finally {
            TEConfigurationDataMgr.getInstance().stopMethodBuffer(neid, bufferSlotIDList);
        }
    }

    protected OperationResult sendBatCommand(int neID, List<Operation> allOperList) {
        OperationResult result = null;
        ArrayList<Operation> operList = null;
        int m = 50;
        int n = allOperList.size();
        for (int i = 0; i < n; i += m) {
            operList = new ArrayList<Operation>();
            if (i + m > n) {
                operList.addAll(allOperList.subList(i, n));
            } else {
                operList.addAll(allOperList.subList(i, i + m));
            }
            result = TETL1NECommMgr.getInstance().sendCommand(neID, operList, this.getTimeOut());
            if (0 != result.retCode) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("TEGenCfgQueryBean thread sleep error! ", (Throwable)e);
            }
        }
        return result;
    }

    protected void getBoardPortMode(int nmCurrSlotID2) {
    }

    private String getBoardMode(int slotID) {
        TL1Definitions tl1definitions = null;
        String boardMode = "";
        try {
            tl1definitions = TECreateObjectFactory.parseTL1DesFile(this.neid);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("RTRV-PORT getOperation fail!", (Throwable)e);
            return boardMode;
        }
        ArrayList<TL1Operation> tl1OperList = new ArrayList<TL1Operation>();
        TL1Operation tl1Operation = tl1definitions.getTL1Operation("RTRV-EQPT");
        String tmpAid = "SLOT-" + TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(this.neid, slotID);
        TL1Operation tmpTl1Operation = (TL1Operation)tl1Operation.clone();
        InMsg inputMsg = tmpTl1Operation.getInMsg();
        StagBlock stagBlock = inputMsg.getStagBlock();
        AID aid = stagBlock.getAID();
        Part part = aid.getPart(0);
        part.setValue(tmpAid);
        tl1OperList.add(tmpTl1Operation);
        OperationResult result = TETL1NECommMgr.getInstance().sendCommand(this.neid, tl1OperList, 60);
        if (result.retCode == 0) {
            TL1Operation tOper = (TL1Operation)tl1OperList.get(0);
            int size = tOper.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                HashMap partMap;
                String aidStr;
                OutMsg output = tOper.getOutMsg(row);
                if (output.getFault().getCompletionCode() != 0 || !(aidStr = ((Part)(partMap = TETL1CommonUtil.getOutMsgPart(output)).get("slotID")).getValue()).equals(tmpAid)) continue;
                Part phyPart = (Part)partMap.get("WORKMODE");
                if (phyPart != null) {
                    boardMode = TETL1CommonUtil.isNull(phyPart.getValue());
                    continue;
                }
                Part mapModePart = (Part)partMap.get("MAPMODE");
                if (mapModePart == null) continue;
                String mapModeStr = mapModePart.getValue();
                if (mapModeStr.indexOf("GFP") != -1) {
                    boardMode = GFP_OTU;
                    continue;
                }
                if (mapModeStr.indexOf("SDH") == -1) continue;
                boardMode = SDH_OTU;
            }
        }
        return boardMode;
    }

    protected Param getIsByFunInputDdata(Datainterface inputData) {
        BussinessParams businessparams = inputData.getBussinessParams();
        RowParams rowparams = null;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            Param tmpParam = rowparams.getParam("byFun");
            if (tmpParam == null) continue;
            return tmpParam;
        }
        return null;
    }

    public ArrayList getQueryOperationList(TETL1GenCfgFunCmd funCmd, TL1Definitions definitions, Datainterface inputData) {
        ArrayList operationList = new ArrayList();
        ArrayList<String> tempList = new ArrayList<String>();
        Datainterface tmpData = new Datainterface();
        for (int rowIndex = 0; rowIndex < inputData.getBussinessParams().getRowParamsCount(); ++rowIndex) {
            int i;
            tempList.clear();
            RowParams rowparams = inputData.getBussinessParams().getRowParams(rowIndex);
            this.supportAttrList = this.getQueryAttrList(rowparams);
            tmpData.setBussinessParams(new BussinessParams());
            tmpData.getBussinessParams().addRowParams(rowparams);
            ArrayList attrList = this.getQueryAttrList(rowparams);
            boolean isNeedQuerySST = false;
            if (this.isByFun) {
                isNeedQuerySST = this.checkisNeedQueryPST(attrList);
            }
            String attrId = "";
            for (i = attrList.size() - 1; i >= 0; --i) {
                attrId = (String)attrList.get(i);
                if (this.isByFun && attrId.indexOf("DWDMTL1_ATTRPORT_PST") != -1 || this.isByFun && (attrId.equals("DWDMTL1_ATTRPORT_ADVANCED_PST") || attrId.equals("DWDMTL1_ATTRPORT_ADVANCED_SST")) || (this.boardMode.equals("REG") || this.boardMode.equals("OREG")) && (attrId.equals("DWDMTL1_ATTRPORT_OTNNULL") || attrId.equals("DWDMTL1_ATTRPORT_LOOPBACK"))) continue;
                TETL1GenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrId, "query");
                if (!this.isByFun && attrId.equals("DWDMTL1_ATTRPORT_SVTIMER") || null == funAttr) continue;
                if (this.isByFun && isNeedQuerySST) {
                    tempList.add(attrId);
                }
                this.getQueryAttrOperationList(definitions, funAttr, operationList, attrId, tmpData);
            }
            int size = tempList.size();
            for (i = 0; i < size; ++i) {
                attrId = (String)tempList.get(i);
                TETL1GenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr("DWDMTL1_ATTRPORT_ADVANCED_PST", "query");
                this.getQueryAttrOperationList(definitions, funAttr, operationList, attrId, tmpData);
            }
        }
        return operationList;
    }

    private boolean checkisNeedQueryPST(ArrayList attrList) {
        for (int i = attrList.size() - 1; i >= 0; --i) {
            String attrId = (String)attrList.get(i);
            if (!needQueryPstListByfun.contains(attrId)) continue;
            return true;
        }
        return false;
    }

    public ArrayList getQueryAttrList(RowParams rowparams) {
        ArrayList<String> attrList = new ArrayList<String>();
        String paramName = "";
        for (int i = rowparams.getParamCount() - 1; i >= 0; --i) {
            paramName = rowparams.getParam(i).getName();
            if ("attrId".equalsIgnoreCase(paramName)) {
                attrList.add(rowparams.getParam(i).getValue());
                continue;
            }
            if (!"extendattr".equalsIgnoreCase(paramName)) continue;
            this.extendAttr = rowparams.getParam(i).getValue();
        }
        return attrList;
    }

    public void getQueryAttrOperationList(TL1Definitions definitions, TETL1GenCfgFunAttr funAttr, ArrayList operationList, String attrId, Datainterface inputData) {
        if (null == funAttr) {
            return;
        }
        Datainterface convertData = null;
        RowParams rowparams = inputData.getBussinessParams().getRowParams(0);
        convertData = null != rowparams.getParam("FACAID") ? this.performPortPathObj(attrId, inputData) : this.performExpandOperObj(attrId, funAttr, inputData);
        if (null == convertData) {
            return;
        }
        ArrayList subOperationList = this.convertToTL1Operation(funAttr, convertData, definitions, this.aidAndTypeList);
        if (null != subOperationList && 0 != subOperationList.size()) {
            int size = subOperationList.size();
            for (int i = 0; i < size; ++i) {
                TL1Operation operClone = (TL1Operation)subOperationList.get(i);
                this.addOperList(operationList, operClone);
            }
            if (!this.res.getString(attrId).equals("")) {
                this.queryAttrListBuff.append(",").append(this.res.getString(attrId));
            }
        }
    }

    private Datainterface performPortPathObj(String attrID, Datainterface inputData) {
        if (attrID.equals("DWDMTL1_ATTRPORT_LPTENABLE") || attrID.equals("DWDMTL1_ATTRPORT_LOOPBACK")) {
            return null;
        }
        int slotNM = -1;
        int portNM = -1;
        int path = -1;
        Datainterface operObj = new Datainterface();
        BussinessParams bussinessparams = new BussinessParams();
        RowParams rowparams = null;
        Param param = null;
        RowParams rowparam = inputData.getBussinessParams().getRowParams(0);
        if (attrID.equals("DWDMTL1_ATTRPORT_BOARD_PST")) {
            if (rowparam.getParamCount() > 0) {
                rowparams = new RowParams();
                rowparams.addParam("neid", String.valueOf(this.neid));
                rowparams.addParam("slotid", String.valueOf(this.nmCurrSlotID));
                rowparams.addParam("BOARD_PST", "");
                rowparams.addParam("SETMODE2", "EQPT");
                bussinessparams.addRowParams(rowparams);
            }
            operObj.setBussinessParams(bussinessparams);
            return operObj;
        }
        int len = rowparam.getParamCount();
        for (int i = 0; i < len; ++i) {
            param = rowparam.getParam(i);
            if (!param.getName().equals("FACAID")) continue;
            rowparams = new RowParams();
            String[] tempAttrArr = param.getValue().split(":");
            String value = tempAttrArr[0];
            String mod2Value = "";
            if (tempAttrArr.length > 1) {
                mod2Value = param.getValue().split(":")[1];
            }
            slotNM = TETL1CommonUtil.getNMSlotStr(value, this.neid);
            portNM = TETL1CommonUtil.getNMPortNOFromAidStruct(value, this.neid);
            if (portNM < 50 && attrID.equals("DWDMTL1_ATTRPORT_PLDTYPE")) {
                return null;
            }
            TETL1SimpleAID sAid = new TETL1SimpleAID(value, this.neid);
            String[] curMod2 = mod2Value.split("&&");
            path = curMod2.length > 1 ? sAid.getNmPath(curMod2[1]) : sAid.getNmPath(curMod2[0]);
            if (attrID.equals("DWDMTL1_ATTRPORT_GCCTRANS")) {
                TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode(this.bdtype);
                if (this.isSupportAttr(attrID, genCfgModel, portNM, -1)) {
                    RowParams rowparamsGCC = new RowParams();
                    rowparamsGCC.addParam("neid", String.valueOf(this.neid));
                    rowparamsGCC.addParam("slotid", String.valueOf(slotNM));
                    rowparamsGCC.addParam("port", String.valueOf(portNM));
                    rowparamsGCC.addParam("SETMODE2", "");
                    bussinessparams.addRowParams(rowparamsGCC);
                }
                if (path <= 0 || !this.isSupportAttr(attrID, genCfgModel, portNM, path)) continue;
                RowParams rowparamsGCCPath = new RowParams();
                rowparamsGCCPath.addParam("neid", String.valueOf(this.neid));
                rowparamsGCCPath.addParam("slotid", String.valueOf(slotNM));
                rowparamsGCCPath.addParam("port", String.valueOf(portNM));
                rowparamsGCCPath.addParam("path", String.valueOf(path));
                rowparamsGCCPath.addParam("SETMODE2", "");
                bussinessparams.addRowParams(rowparamsGCCPath);
                continue;
            }
            rowparams.addParam("neid", String.valueOf(this.neid));
            rowparams.addParam("slotid", String.valueOf(slotNM));
            rowparams.addParam("port", String.valueOf(portNM));
            if (path != -1) {
                rowparams.addParam("path", String.valueOf(path));
            }
            rowparams.addParam("SETMODE2", mod2Value);
            bussinessparams.addRowParams(rowparams);
        }
        operObj.setBussinessParams(bussinessparams);
        return operObj;
    }

    private void addOperList(ArrayList list, TL1Operation operClone) {
        boolean flag = false;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            TL1Operation oper = (TL1Operation)list.get(i);
            if (!oper.getName().equals(operClone.getName()) || !oper.getInMsg().getStagBlock().getAID().getPart(0).getValue().equals(operClone.getInMsg().getStagBlock().getAID().getPart(0).getValue())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            list.add(operClone);
        }
    }

    @Override
    protected boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        if (msgBlock.getDataBlockCount() == 0) {
            return true;
        }
        return super.fillMsgBlock(rowparams, msgBlock);
    }

    public Datainterface performExpandOperObj(String attrId, TETL1GenCfgFunAttr funAttr, Datainterface inputData) {
        String srcObjType = "ID_OBJECT_TYPE_NE";
        Param srcObjTypeParam = Datainterface.getParam(inputData.getBussinessParams().getRowParams(0).getParam(), "srcObjType");
        if (null != srcObjTypeParam) {
            srcObjType = srcObjTypeParam.getValue();
        }
        TEGenCfgObject srcObj = TEGenCfgObjectFactory.getInstance().getGencfgobj(srcObjType);
        String sinkobjType = funAttr.getObjectType();
        TEGenCfgObject sinkObj = TEGenCfgObjectFactory.getInstance().getGencfgobj(sinkobjType);
        if (null == srcObj || null == sinkObj) {
            return null;
        }
        if (!sinkobjType.equalsIgnoreCase(srcObjType) && srcObj.getLevel() <= sinkObj.getLevel()) {
            return this.expandOperObj(srcObjType, sinkobjType, attrId, inputData);
        }
        return inputData;
    }

    public Datainterface expandOperObj(String srcObjType, String sinkObjType, String attrId, Datainterface inputData) {
        log.debug("srcObjType = " + srcObjType + " sinkObjType = " + sinkObjType);
        TEObjTypeMgr objTypeMgr = TEObjTypeMgr.getInstance();
        String methodName = objTypeMgr.getConvertMethod(srcObjType, sinkObjType);
        Class[] type = new Class[]{String.class, Datainterface.class};
        Object[] value = new Object[]{attrId, inputData};
        Datainterface converInputData = null;
        try {
            converInputData = (Datainterface)TEObjTypeMgr.class.getMethod(methodName, type).invoke((Object)objTypeMgr, value);
        }
        catch (Exception e) {
            log.error("expand operation object fail!", (Throwable)e);
            return null;
        }
        return converInputData;
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        this.outputData = this.convertToDatainterface(neid, subfunc, operationList, filterErrorCodeList, this.aidAndTypeList);
    }

    public Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList, TEAIDAndTypeList aidTypeList) {
        int i;
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        if (null == tl1OperList) {
            return null;
        }
        int tl1OperSize = tl1OperList.size();
        ArrayList errorData = this.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
        TL1Operation tl1Operation = null;
        if (0 == tl1OperList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        OutMsg output = null;
        outputData.setBussinessParams(new BussinessParams());
        int len = tl1OperList.size();
        for (i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                output = tl1Operation.getOutMsg(row);
                Fault tempFault = output.getFault();
                if (!tempFault.getErrDesc().equals("") && tempFault.getErrDesc() != null && tempFault.getErrDesc().equals(filterErrDesc) || !this.handleRowData(neid, rowparams = new RowParams(), output, TETL1CommonUtil.getRealMod2(tl1Operation)) || this.isByFun && this.isNotSupport(rowparams, this.extendAttr)) continue;
                String curMod2 = tl1Operation.getMod2();
                if (curMod2 == null || curMod2.equals("")) {
                    curMod2 = tl1Operation.getMod1();
                }
                Param param = new Param("CurrentMOD2", curMod2);
                rowparams.addParam(param);
                if (0 == rowparams.getParamCount()) continue;
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            rowparams = new RowParams();
            int size = errorData.size();
            for (i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)errorData.get(i));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
        }
        return outputData;
    }

    private boolean isNotSupport(RowParams rowparam, String extendAttr2) {
        if (extendAttr2.equals("DWDMTL1_ATTRPORT_LOOPBACK")) {
            return rowparam.getParam("DWDMTL1_ATTRPORT_LOOPBACK") == null && rowparam.getParam("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK") == null;
        }
        if (extendAttr2.equals("DWDMTL1_ATTRPORT_SVTIMER")) {
            return rowparam.getParam("DWDMTL1_ATTRPORT_SVTIMER") == null && rowparam.getParam("DWDMTL1_ATTRPORT_ADVANCED_SVTIMER") == null;
        }
        if (extendAttr2.equals("DWDMTL1_ATTRPORT_OAWORKVALUE")) {
            return rowparam.getParam("DWDMTL1_ATTRPORT_OAWORKVALUE") == null && rowparam.getParam("DWDMTL1_ATTRPORT_OAWORKMODE") == null;
        }
        return rowparam.getParam(extendAttr2) == null;
    }

    protected boolean isFilterErrorCode(ArrayList filterErrorCodeList, String errorCode) {
        if (errorCode == null || errorCode.equals("")) {
            return false;
        }
        int size = filterErrorCodeList.size();
        for (int i = 0; i < size; ++i) {
            String filterErrorCode = (String)filterErrorCodeList.get(i);
            if (errorCode.indexOf(filterErrorCode) == -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList joinTL1Operation(int neid, SubFunc subfunc, ArrayList tl1OperationList, ArrayList filterErrorCodeList) {
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        ArrayList tl1OperObject = TETL1DataConverter.getTL1OperationObject(subfunc);
        ArrayList operObjPart = null;
        ArrayList tmpoperObjPart = null;
        TL1Operation tl1Oper = null;
        TL1Operation tmpTL1Oper = null;
        OutMsg curOutput = null;
        OutMsg tmpOutput = null;
        String errorCode = "OK";
        if (null == tl1OperationList || 0 == tl1OperationList.size()) {
            return errorDataList;
        }
        this.cloneTL1OperationList.clear();
        for (int i = tl1OperationList.size() - 1; i >= 0; --i) {
            tl1Oper = (TL1Operation)tl1OperationList.get(i);
            boolean flag = true;
            for (int index = tl1Oper.getOutMsgCount() - 1; index >= 0; --index) {
                curOutput = tl1Oper.getOutMsg(index);
                errorCode = String.valueOf(curOutput.getFault().getCompletionCode());
                if (!"0".equals(errorCode)) {
                    tl1Oper.addCmdFault(curOutput.getFault());
                }
                if (this.isFilterErrorCode(filterErrorCodeList, curOutput.getFault().getErrDesc())) {
                    tl1Oper.removeOutMsg(curOutput);
                    continue;
                }
                if ("0".equals(errorCode)) continue;
                String errorinfo = curOutput.getFault().getErrDesc();
                if (!this.containFilterErrorInfo(errorinfo)) {
                    errorDataList.add(0, this.handleErrorData(neid, subfunc, tl1Oper, curOutput));
                    continue;
                }
                flag = false;
            }
            if (!flag) continue;
            this.cloneTL1OperationList.add(tl1Oper.clone());
        }
        int operSize = tl1OperationList.size();
        if (0 == operSize) {
            return errorDataList;
        }
        if (null != tl1OperObject && 0 != tl1OperObject.size()) {
            for (int i = 0; i < operSize; ++i) {
                tl1Oper = (TL1Operation)tl1OperationList.get(i);
                TETL1DataConverter.copyInDataToOutData(tl1Oper);
                int ouputlen = tl1Oper.getOutMsgCount();
                for (int outputIndex = 0; outputIndex < ouputlen; ++outputIndex) {
                    curOutput = tl1Oper.getOutMsg(outputIndex);
                    operObjPart = TETL1DataConverter.getTL1OperObjData(tl1OperObject, tl1Oper, curOutput);
                    for (int j = i + 1; j < operSize; ++j) {
                        tmpTL1Oper = (TL1Operation)tl1OperationList.get(j);
                        TETL1DataConverter.copyInDataToOutData(tmpTL1Oper);
                        for (int tmpOutputIndex = tmpTL1Oper.getOutMsgCount() - 1; tmpOutputIndex >= 0; --tmpOutputIndex) {
                            tmpOutput = tmpTL1Oper.getOutMsg(tmpOutputIndex);
                            tmpoperObjPart = TETL1DataConverter.getTL1OperObjData(tl1OperObject, tmpTL1Oper, tmpOutput);
                            if (!this.compareMod2Equal(TETL1CommonUtil.getRealMod2(tl1Oper), TETL1CommonUtil.getRealMod2(tmpTL1Oper)) || !TETL1DataConverter.compareGencfgOperObj(operObjPart, tmpoperObjPart)) continue;
                            TETL1DataConverter.joinTL1OperationOutput(curOutput, tmpOutput);
                            tmpTL1Oper.removeOutMsg(tmpOutput);
                        }
                        if (0 != tmpTL1Oper.getOutMsgCount()) continue;
                        if (tl1Oper.getMod1().equalsIgnoreCase("LPT") || tl1Oper.getMod1().equalsIgnoreCase("CLNT")) {
                            tl1Oper.setMod1(TETL1CommonUtil.getRealMod2(tmpTL1Oper));
                        }
                        tl1OperationList.remove(tmpTL1Oper);
                        --operSize;
                        --j;
                    }
                }
            }
        }
        return errorDataList;
    }

    private boolean compareMod2Equal(String mod1, String mod2) {
        if (mod1.indexOf("ODU") == -1 || mod2.indexOf("ODU") == -1) {
            return true;
        }
        return mod1.equalsIgnoreCase(mod2);
    }

    @Override
    public RowErrors handleErrorData(int neid, SubFunc subfunc, TL1Operation oper, OutMsg output) {
        MsgBlock outputBlock;
        int i;
        int len;
        ArrayList operObjct = this.getTL1OperationObject(subfunc);
        InMsg input = oper.getInMsg();
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError1 = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam1 = null;
        Param errorparam2 = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError1.setErrorMessage(errorMessage);
        errorparam1 = new Param("neid", String.valueOf(neid));
        rowError1.addParam(errorparam1);
        DataBlock dataBlock = null;
        if (null != input) {
            AID aid = input.getStagBlock().getAID();
            len = aid.getPartCount();
            for (i = 0; i < len; ++i) {
                if (aid.getPart(i).getName().equalsIgnoreCase("AID")) {
                    String aidValue = aid.getPart(i).getValue();
                    String mod2 = TETL1CommonUtil.getRealMod2(oper);
                    ArrayList<String> aidTempList = TESimpleModelUtil.handleTL1SimpleModelPath(aidValue, mod2, neid);
                    errorparam1 = new Param(aid.getPart(i).getName(), aidTempList.get(0));
                } else {
                    errorparam1 = new Param(aid.getPart(i).getName(), aid.getPart(i).getValue());
                }
                errorparam2 = new Param("CurMod2", TETL1CommonUtil.getRealMod2(oper));
                rowError1.addParam(errorparam1);
                rowError1.addParam(errorparam2);
            }
            len = input.getMsgBlock().getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = input.getMsgBlock().getDataBlock(i);
                int size = dataBlock.getPartCount();
                for (int j = 0; j < size; ++j) {
                    String partName = dataBlock.getPart(j).getConvert();
                    if (partName == null || partName.equals("")) {
                        partName = dataBlock.getPart(j).getName();
                    }
                    if ((errorparam1 = new Param(partName, dataBlock.getPart(j).getValue())).getValue() != null) {
                        rowError1.addParam(errorparam1);
                    }
                    if (operObjct.contains(errorparam1.getName()) || errorparam1.getValue() == null) continue;
                    errorparam1 = new Param("attrId", partName);
                    rowError1.addParam(errorparam1);
                }
            }
        }
        if ((outputBlock = output.getMsgBlock()) != null) {
            len = outputBlock.getDataBlockCount();
            for (i = 0; i < len; ++i) {
                dataBlock = output.getMsgBlock().getDataBlock(i);
                int size = dataBlock.getPartCount();
                for (int j = 0; j < size; ++j) {
                    String paraName = dataBlock.getPart(j).getConvert();
                    if (paraName == null || paraName.equals("")) {
                        paraName = this.funCmd.getParamAttrID(dataBlock.getPart(j).getName());
                    }
                    if (!this.supportAttrList.contains(paraName)) continue;
                    errorparam1 = new Param("attrId", paraName);
                    if (null != rowError1.getParam(dataBlock.getPart(j).getName())) continue;
                    rowError1.addParam(errorparam1);
                }
            }
        }
        if (null != rowError1.getParam("neid")) {
            Param param = new Param("nename", this.neName);
            rowError1.addParam(param);
        }
        this.addErrorParam(neid, rowError1);
        return rowError1;
    }

    protected boolean handleRowData(int neid, RowParams rowparams, OutMsg output, String mode2) {
        String tmpValue = "";
        String tmpName = "";
        Param param = null;
        HashMap partmap = TETL1CommonUtil.getOutMsgPart(output);
        Part part = (Part)partmap.get("AID");
        int portNMID = -1;
        int slotNMID = -1;
        TEGenCfgModel genCfgModel = null;
        int pathID = -1;
        int brdType = -1;
        if (part != null && part.getValue() != null) {
            String aidStr = part.getValue();
            TETL1SimpleAID sAid = new TETL1SimpleAID(aidStr, neid);
            slotNMID = sAid.getNmSlotID();
            int portID = sAid.getPortID();
            portNMID = TETL1CommonUtil.getNMPortNOFromNEPort(sAid.getAidPre(), slotNMID, portID, neid);
            brdType = TEConfigurationDataMgr.getInstance().getBoardType(neid, slotNMID);
            pathID = sAid.getNmPath(mode2);
            genCfgModel = TEGenCfgDataMgr.getGenCfgMode(brdType);
        }
        rowparams.addParam("neid", String.valueOf(neid));
        DataBlock dataBlock = null;
        int size = output.getMsgBlock().getDataBlockCount();
        for (int tmpCol = 0; tmpCol < size; ++tmpCol) {
            dataBlock = output.getMsgBlock().getDataBlock(tmpCol);
            for (int index = dataBlock.getPartCount() - 1; index >= 0; --index) {
                Param par;
                tmpName = dataBlock.getPart(index).getName();
                tmpValue = dataBlock.getPart(index).getValue();
                String attrID = tmpName;
                String convertID = dataBlock.getPart(index).getConvert();
                if (convertID != null && !convertID.equals("")) {
                    attrID = dataBlock.getPart(index).getConvert();
                } else if (null != this.funCmd) {
                    attrID = this.funCmd.getParamAttrID(tmpName);
                }
                String newAttrID = this.convertAttrID(attrID);
                if (!this.isSupportAttr(newAttrID, genCfgModel, portNMID, pathID) || this.isNotSupport18PRBS(neid, newAttrID, mode2)) continue;
                rowparams = this.handleSepicalCol(newAttrID, tmpValue, rowparams, mode2);
                if (null == tmpValue) {
                    if (this.notSupportSpecialCol(newAttrID)) continue;
                    if (newAttrID.equals("DWDMTL1_ATTRPORT_PLDTYPE")) {
                        tmpValue = pathID != -1 ? this.aidAndTypeList.getPayLoadMod2(neid, slotNMID, portNMID, pathID) : this.aidAndTypeList.getPayLoadMod2(neid, slotNMID, portNMID);
                        if (tmpValue.equals("")) {
                            tmpValue = "/";
                        }
                    } else if (newAttrID.equals("DWDMTL1_ATTRPORT_OTNNULL")) {
                        if (brdType == 1186 && portNMID == 201 && mode2.equals("OTU1")) continue;
                        tmpValue = "STOP";
                    } else {
                        tmpValue = brdType == 1324 && (newAttrID.equals("DWDMTL1_ATTRPORT_ADBANDTYPE") || newAttrID.equals("DWDMTL1_ATTRPORT_ADWVNUM")) && this.boardMode.equals("BANDPASSMODE") ? "-" : "/";
                    }
                }
                if (null != rowparams.getParam(newAttrID) && rowparams.getParam(newAttrID).getValue().equals(tmpValue) && (-1 != newAttrID.indexOf("PST") || -1 != newAttrID.indexOf("SST") || newAttrID.equals("AID")) || (par = rowparams.getParam(newAttrID)) != null) continue;
                newAttrID = this.addbyFunAttrIDParam(rowparams, newAttrID, tmpValue);
                param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
            }
        }
        if (this.isSupportAttr("DWDMTL1_ATTRPORT_RMV", genCfgModel, portNMID, pathID)) {
            rowparams.addParam("DWDMTL1_ATTRPORT_RMV", "SUPPORTRMV");
        } else {
            rowparams.addParam("DWDMTL1_ATTRPORT_RMV", "NOSUPPROTRMV");
        }
        if (null != rowparams.getParam("neid")) {
            param = new Param("nename", this.neName);
            rowparams.addParam(param);
        }
        TETL1DataConverter.addReturnParam(neid, rowparams);
        return true;
    }

    private boolean isNotSupport18PRBS(int neid, String newAttrID, String mode2) {
        if (this.neType == 66 && newAttrID.equals("DWDMTL1_ATTRPORT_PRBS")) {
            ArrayList mod2 = TEPRBSSupportPortMgr.getInstance(neid).getBoardSupportMod2s(neid, String.valueOf(this.bdtype));
            return mod2 != null && !mod2.contains(mode2);
        }
        return false;
    }

    private String addbyFunAttrIDParam(RowParams rowparams, String newAttrID, String tmpValue) {
        if (this.extendAttr.equals("DWDMTL1_ATTRPORT_LOOPBACK") && this.isByFun) {
            if (newAttrID.equals("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_LOOPBACK";
            }
            if (newAttrID.equals("DWDMTL1_ATTRPORT_ADVANCED_PST")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_PST";
            }
            if (newAttrID.equals("DWDMTL1_ATTRPORT_ADVANCED_SST")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_SST";
            }
            if (newAttrID.equals("DWDMTL1_ATTRPORT_PST")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_ADVANCED_PST";
            }
            if (newAttrID.equals("DWDMTL1_ATTRPORT_SST")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_ADVANCED_SST";
            }
        }
        if (this.extendAttr.equals("DWDMTL1_ATTRPORT_SVTIMER") && this.isByFun) {
            if (newAttrID.equals("DWDMTL1_ATTRPORT_ADVANCED_SVTIMER")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_SVTIMER";
            }
            if (newAttrID.equals("DWDMTL1_ATTRPORT_ADVANCED_PST")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_PST";
            }
            if (newAttrID.equals("DWDMTL1_ATTRPORT_ADVANCED_SST")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_SST";
            }
            if (newAttrID.equals("DWDMTL1_ATTRPORT_PST")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_ADVANCED_PST";
            }
            if (newAttrID.equals("DWDMTL1_ATTRPORT_SST")) {
                Param param = new Param(newAttrID, tmpValue);
                rowparams.addParam(param);
                return "DWDMTL1_ATTRPORT_ADVANCED_SST";
            }
        }
        return newAttrID;
    }

    protected boolean notSupportSpecialCol(String newAttrID) {
        return false;
    }

    public boolean isSupportAttr(String attrID, TEGenCfgModel genCfgModel, int portNMID, int pathID) {
        if (!TETL1CommonUtil.isNewNeVersion(this.neType, this.neVersion) && this.bdtype == 1339) {
            return true;
        }
        if (genCfgModel == null) {
            return true;
        }
        if (attrID.equals("AID") || attrID.equals("level")) {
            return true;
        }
        TEGenCfgAttribute genCfgAttrObj = genCfgModel.getAttrFromId(attrID);
        if (genCfgAttrObj == null) {
            return false;
        }
        ArrayList portList = genCfgAttrObj.getPortList();
        if (portList == null) {
            return false;
        }
        TEGenCfgPortAttribute portAttr = null;
        int len = portList.size();
        for (int j = 0; j < len; ++j) {
            portAttr = (TEGenCfgPortAttribute)portList.get(j);
            int nmPathID = portAttr.getPath();
            if (nmPathID == 0) {
                nmPathID = -1;
            }
            if (portAttr.getPort() != portNMID || nmPathID != pathID || !portAttr.isSupportNE(this.neType, this.neVersion)) continue;
            return true;
        }
        return false;
    }

    public String convertAttrID(String attrID) {
        return attrID;
    }

    protected RowParams handleSepicalCol(String part, String partValue, RowParams rowparams, String _mod2) {
        Param tmpParam = null;
        String tmpMode2 = "";
        if (part.equals("AID")) {
            Param param = rowparams.getParam("mode2");
            if (param == null) {
                StringBuffer tmpPart = new StringBuffer(",");
                tmpPart.append(part).append(",").append(partValue);
                tmpParam = new Param("mode2", tmpPart.toString());
                rowparams.addParam("mode2", tmpParam.getValue());
            }
        } else {
            Param param = rowparams.getParam("mode2");
            if (null == param) {
                return rowparams;
            }
            String tmpValue = param.getValue();
            String tl1Mod2 = TETL1GenCfgCmdFactory.getInstance().getTL1DescMod2(_mod2);
            tmpMode2 = tl1Mod2 + "&&" + _mod2;
            tmpValue = tmpValue + "," + part + "," + tmpMode2;
            if (this.isByFun) {
                if (part.equals("DWDMTL1_ATTRPORT_ADVANCED_PST") && tmpValue.indexOf("DWDMTL1_ATTRPORT_PST") == -1) {
                    tmpValue = tmpValue + "," + "DWDMTL1_ATTRPORT_PST" + "," + tmpMode2;
                }
                if (part.equals("DWDMTL1_ATTRPORT_ADVANCED_SST") && tmpValue.indexOf("DWDMTL1_ATTRPORT_SST") == -1) {
                    tmpValue = tmpValue + "," + "DWDMTL1_ATTRPORT_SST" + "," + tmpMode2;
                }
                if (part.equals("DWDMTL1_ATTRPORT_PST") && tmpValue.indexOf("DWDMTL1_ATTRPORT_ADVANCED_PST") == -1) {
                    tmpValue = tmpValue + "," + "DWDMTL1_ATTRPORT_ADVANCED_PST" + "," + tmpMode2;
                }
                if (part.equals("DWDMTL1_ATTRPORT_SST") && tmpValue.indexOf("DWDMTL1_ATTRPORT_ADVANCED_SST") == -1) {
                    tmpValue = tmpValue + "," + "DWDMTL1_ATTRPORT_ADVANCED_SST" + "," + tmpMode2;
                }
            }
            param.setValue(tmpValue);
        }
        return rowparams;
    }

    protected String handleSpecialChar(String tmpMode2) {
        return tmpMode2;
    }

    @Override
    public ArrayList getFilterErrorCodeList() {
        return null;
    }

    public boolean containFilterErrorInfo(String errorInfo) {
        boolean isContain = false;
        String notSupport = "Command not supported";
        if (errorInfo.indexOf(notSupport) > 0) {
            isContain = true;
        }
        return isContain;
    }

    @Override
    public int getTimeOut() {
        return this.TIME_OUT * 2;
    }

    static {
        needQueryPstListByfun.add("DWDMTL1_ATTRPORT_LOOPBACK");
        needQueryPstListByfun.add("DWDMTL1_ATTRPORT_CLNTPLDTYPE");
        needQueryPstListByfun.add("DWDMTL1_ATTRPORT_CLIENTPRO");
        needQueryPstListByfun.add("DWDMTL1_ATTRPORT_ADVANCED_LOOPBACK");
        needQueryPstListByfun.add("DWDMTL1_ATTRPORT_OTNNULL");
        needQueryPstListByfun.add("DWDMTL1_ATTRPORT_CLNTRATE");
        needQueryBoardModeBoardType.add(1310);
        needQueryBoardModeBoardType.add(1541);
        needQueryBoardModeBoardType.add(1566);
        needQueryBoardModeBoardType.add(2209);
        needQueryBoardModeBoardType.add(1573);
        needQueryBoardModeBoardType.add(2211);
        needQueryBoardModeBoardType.add(1318);
        needQueryBoardModeBoardType.add(2093);
        needQueryBoardModeBoardType.add(1324);
        needQueryBoardModeBoardType.add(1279);
        needQueryBoardModeBoardType.add(60050);
        needQueryBoardModeBoardType.add(2293);
        needQueryBoardModeBoardType.add(2294);
        needQueryBoardModeBoardType.add(2424);
        needQueryBoardModeBoardType.add(2425);
        needQueryBoardModeBoardType.add(2309);
        needQueryBoardModeBoardType.add(2310);
        needQueryBoardModeBoardType.add(2281);
        needQueryBoardModeBoardType.add(2208);
        needQueryBoardModeBoardType.add(2311);
        needQueryBoardModeBoardType.add(2436);
        needQueryBoardModeBoardType.add(2552);
        needQueryBoardModeBoardType.add(2553);
        needQueryBoardModeBoardType.add(2511);
        needQueryBoardModeBoardType.add(2838);
        needQueryBoardModeBoardType.add(2835);
        needQueryBoardModeBoardType.add(2873);
        needQueryBoardModeBoardType.add(2874);
    }
}

