/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.gencfg.tl1;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.tl1.TETL1GenCfgFunAttr;
import com.huawei.nglct.tl1.TEAIDAndTypeList;
import com.huawei.nglct.tl1.TETL1CommonUtil;
import com.huawei.nglct.tl1.TETL1DataConverter;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.tl1.tl1operation.AID;
import com.huawei.uflight.tl1.tl1operation.DataBlock;
import com.huawei.uflight.tl1.tl1operation.InMsg;
import com.huawei.uflight.tl1.tl1operation.MsgBlock;
import com.huawei.uflight.tl1.tl1operation.OutMsg;
import com.huawei.uflight.tl1.tl1operation.Part;
import com.huawei.uflight.tl1.tl1operation.StagBlock;
import com.huawei.uflight.tl1.tl1operation.TL1Definitions;
import com.huawei.uflight.tl1.tl1operation.TL1Operation;
import java.util.ArrayList;

public class TETL1GenCfgDataConvertor {
    public static ArrayList convertToTL1Operation(TETL1GenCfgFunAttr funAttr, Datainterface inputData, TL1Definitions definitions, TEAIDAndTypeList aidAndTypeList) {
        BussinessParams businessparams = inputData.getBussinessParams();
        ArrayList<TL1Operation> operationList = new ArrayList<TL1Operation>();
        TL1Operation operation = null;
        InMsg inputMsg = null;
        RowParams rowparams = null;
        ArrayList<String> operationNameList = new ArrayList<String>();
        String operationName = funAttr.getTl1cmdcode();
        String modName = funAttr.getMod();
        if (!modName.equals("mod2")) {
            operationNameList.add(operationName + "-" + modName);
        } else {
            operationNameList.add(operationName + "-" + "mod2");
        }
        boolean fillComplete = false;
        int rowlen = businessparams.getRowParamsCount();
        for (int row = 0; row < rowlen; ++row) {
            rowparams = businessparams.getRowParams(row);
            int size = operationNameList.size();
            for (int i = 0; i < size; ++i) {
                int slotid = -1;
                int portid = -1;
                int neid = -1;
                String str = (String)operationNameList.get(i);
                if (null != rowparams.getParam("slotid")) {
                    slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
                    portid = Integer.parseInt(rowparams.getParam("port").getValue());
                    neid = Integer.parseInt(rowparams.getParam("neid").getValue());
                    str = operationName + "-" + aidAndTypeList.getMod2(neid, slotid, portid);
                }
                if (null != rowparams.getParam("AID")) {
                    str = operationName + "-" + rowparams.getParam("mode2").getValue();
                }
                if (null == (operation = definitions.getTL1Operation(str))) continue;
                inputMsg = operation.getInMsg();
                if (null == inputMsg) {
                    operationList.add(operation);
                    continue;
                }
                fillComplete = TETL1GenCfgDataConvertor.fillStagBlock(rowparams, inputMsg.getStagBlock(), aidAndTypeList);
                if (fillComplete) {
                    fillComplete = TETL1GenCfgDataConvertor.fillMsgBlock(rowparams, inputMsg.getMsgBlock());
                }
                if (!fillComplete) continue;
                operationList.add(operation);
            }
        }
        return operationList;
    }

    private static boolean fillStagBlock(RowParams rowparams, StagBlock stagBlock, TEAIDAndTypeList aidAndTypeList) {
        boolean flag = true;
        AID aidObj = stagBlock.getAID();
        Part part = null;
        int len = aidObj.getPartCount();
        for (int i = 0; i < len; ++i) {
            part = aidObj.getPart(i);
            int slotid = -1;
            int portid = -1;
            int neid = -1;
            String aid = "";
            if (null != rowparams.getParam("slotid")) {
                slotid = Integer.parseInt(rowparams.getParam("slotid").getValue());
                portid = Integer.parseInt(rowparams.getParam("port").getValue());
                neid = Integer.parseInt(rowparams.getParam("neid").getValue());
                aid = aidAndTypeList.getAID(neid, slotid, portid);
            }
            if (null != rowparams.getParam("AID")) {
                String[] tmpStr = rowparams.getParam("AID").getValue().split("-");
                int slotID = Integer.parseInt(tmpStr[1]);
                int portID = Integer.parseInt(tmpStr[3]);
                int neID = Integer.parseInt(rowparams.getParam("neid").getValue());
                String shelf_slot = TETL1CommonUtil.slotIDNMToNEShelfIDSlotID(neID, slotID);
                String aidPrefix = TETL1CommonUtil.getAIDFrefix(neID, slotID, portID);
                StringBuffer tmp = new StringBuffer();
                tmp.append(aidPrefix).append("-").append(shelf_slot).append("-").append(portID);
                if (rowparams.getParam("path") != null) {
                    tmp.append(rowparams.getParam("path").getValue());
                }
                aid = tmp.toString();
            }
            part.setValue(aid);
        }
        return flag;
    }

    private static boolean fillMsgBlock(RowParams rowparams, MsgBlock msgBlock) {
        boolean flag = false;
        DataBlock dataBlock = null;
        Part part = null;
        Param tmpParam = null;
        int len = msgBlock.getDataBlockCount();
        if (len == 0) {
            return true;
        }
        for (int i = 0; i < len; ++i) {
            dataBlock = msgBlock.getDataBlock(i);
            int size = dataBlock.getPartCount();
            for (int j = 0; j < size; ++j) {
                part = dataBlock.getPart(j);
                tmpParam = rowparams.getParam(part.getName());
                if (null == tmpParam || !tmpParam.getModifyFlag()) continue;
                part.setValue(tmpParam.getValue());
                flag = true;
            }
        }
        return flag;
    }

    public static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList) {
        int i;
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        if (tl1OperList == null) {
            return null;
        }
        int tl1OperSize = tl1OperList.size();
        ArrayList errorData = TETL1DataConverter.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
        TL1Operation tl1Operation = null;
        if (0 == tl1OperList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        OutMsg output = null;
        outputData.setBussinessParams(new BussinessParams());
        int len = tl1OperList.size();
        for (i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                output = tl1Operation.getOutMsg(row);
                rowparams = new RowParams();
                TETL1GenCfgDataConvertor.handleRowData(neid, rowparams, output);
                if (0 == rowparams.getParamCount()) continue;
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            rowparams = new RowParams();
            int size = errorData.size();
            for (i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)errorData.get(i));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
        }
        return outputData;
    }

    public static Datainterface convertToDatainterface(int neid, SubFunc subfunc, ArrayList tl1OperList, ArrayList filterErrorCodeList, TEAIDAndTypeList aidTypeList) {
        int i;
        if (null == filterErrorCodeList) {
            filterErrorCodeList = new ArrayList();
        }
        if (null == tl1OperList) {
            tl1OperList = new ArrayList();
        }
        int tl1OperSize = tl1OperList.size();
        ArrayList errorData = TETL1DataConverter.joinTL1Operation(neid, subfunc, tl1OperList, filterErrorCodeList);
        TL1Operation tl1Operation = null;
        if (0 == tl1OperList.size()) {
            return null;
        }
        RowParams rowparams = null;
        Datainterface outputData = new Datainterface();
        OutMsg output = null;
        outputData.setBussinessParams(new BussinessParams());
        int len = tl1OperList.size();
        for (i = 0; i < len; ++i) {
            tl1Operation = (TL1Operation)tl1OperList.get(i);
            int size = tl1Operation.getOutMsgCount();
            for (int row = 0; row < size; ++row) {
                output = tl1Operation.getOutMsg(row);
                rowparams = new RowParams();
                TETL1GenCfgDataConvertor.handleRowData(neid, rowparams, output, aidTypeList);
                if (0 == rowparams.getParamCount()) continue;
                outputData.getBussinessParams().addRowParams(rowparams);
            }
        }
        if (null != errorData && 0 != errorData.size()) {
            rowparams = new RowParams();
            int size = errorData.size();
            for (i = 0; i < size; ++i) {
                rowparams.addRowErrors((RowErrors)errorData.get(i));
            }
            outputData.getBussinessParams().addRowParams(rowparams);
        }
        outputData.setErrorMessage(new ErrorMessage());
        if (0 == errorData.size()) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 0));
        } else if (errorData.size() >= tl1OperSize) {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage(neid, 1));
        }
        return outputData;
    }

    public static RowErrors handleErrorData(int neid, SubFunc subfunc, InMsg input, OutMsg output) {
        int j;
        int size;
        int i;
        ArrayList operObjct = TETL1DataConverter.getTL1OperationObject(subfunc);
        String errorCode = output.getFault().getErrCode();
        String errorinfo = output.getFault().getErrDesc();
        RowErrors rowError = new RowErrors();
        ErrorMessage errorMessage = new ErrorMessage();
        Param errorparam = null;
        errorMessage.setErrorcode(errorCode);
        errorMessage.setErrorinfo(errorinfo);
        rowError.setErrorMessage(errorMessage);
        errorparam = new Param("neid", String.valueOf(neid));
        rowError.addParam(errorparam);
        AID aid = input.getStagBlock().getAID();
        int len = aid.getPartCount();
        for (int i2 = 0; i2 < len; ++i2) {
            errorparam = new Param(aid.getPart(i2).getName(), aid.getPart(i2).getValue());
            rowError.addParam(errorparam);
            if (operObjct.contains(errorparam.getName())) continue;
            errorparam = new Param("attrId", aid.getPart(i2).getName());
            rowError.addParam(errorparam);
        }
        DataBlock dataBlock = null;
        int len2 = input.getMsgBlock().getDataBlockCount();
        for (i = 0; i < len2; ++i) {
            dataBlock = input.getMsgBlock().getDataBlock(i);
            size = dataBlock.getPartCount();
            for (j = 0; j < size; ++j) {
                errorparam = new Param(dataBlock.getPart(i).getName(), dataBlock.getPart(i).getValue());
                rowError.addParam(errorparam);
                if (operObjct.contains(errorparam.getName())) continue;
                errorparam = new Param("attrId", dataBlock.getPart(i).getName());
                rowError.addParam(errorparam);
            }
        }
        len2 = output.getMsgBlock().getDataBlockCount();
        for (i = 0; i < len2; ++i) {
            dataBlock = output.getMsgBlock().getDataBlock(i);
            size = dataBlock.getPartCount();
            for (j = 0; j < size; ++j) {
                errorparam = new Param("attrId", dataBlock.getPart(i).getName());
                if (null != rowError.getParam(dataBlock.getPart(i).getName())) continue;
                rowError.addParam(errorparam);
            }
        }
        TETL1DataConverter.addErrorParam(neid, rowError);
        return rowError;
    }

    public static void handleRowData(int neid, RowParams rowparams, OutMsg output) {
        String tmpValue = "";
        String tmpName = "";
        Param param = null;
        rowparams.addParam("neid", String.valueOf(neid));
        DataBlock dataBlock = null;
        int size = output.getMsgBlock().getDataBlockCount();
        for (int tmpCol = 0; tmpCol < size; ++tmpCol) {
            dataBlock = output.getMsgBlock().getDataBlock(tmpCol);
            for (int index = dataBlock.getPartCount() - 1; index >= 0; --index) {
                tmpName = dataBlock.getPart(index).getName();
                tmpValue = dataBlock.getPart(index).getValue();
                if (null == tmpValue) {
                    tmpValue = "/";
                }
                if (null != rowparams.getParam(tmpName) && rowparams.getParam(tmpName).getValue().equals(tmpValue) && (tmpName.equals("PST") || tmpName.equals("AID"))) continue;
                param = new Param(tmpName, tmpValue);
                rowparams.addParam(param);
            }
        }
        TETL1DataConverter.addReturnParam(neid, rowparams);
    }

    public static void handleRowData(int neid, RowParams rowparams, OutMsg output, TEAIDAndTypeList aidAndTypeList) {
        String tmpValue = "";
        String tmpName = "";
        Param param = null;
        rowparams.addParam("neid", String.valueOf(neid));
        DataBlock dataBlock = null;
        int size = output.getMsgBlock().getDataBlockCount();
        for (int tmpCol = 0; tmpCol < size; ++tmpCol) {
            dataBlock = output.getMsgBlock().getDataBlock(tmpCol);
            for (int index = dataBlock.getPartCount() - 1; index >= 0; --index) {
                tmpName = dataBlock.getPart(index).getName();
                tmpValue = dataBlock.getPart(index).getValue();
                if (tmpName.equals("AID")) {
                    String[] tmpStr = tmpValue.split("-");
                    int shelfID = Integer.parseInt(tmpStr[1]);
                    int slotID = shelfID * 100 + Integer.parseInt(tmpStr[2]);
                    int portID = Integer.parseInt(tmpStr[3]);
                    Param tmpParam = new Param("mode2", aidAndTypeList.getMod2(neid, slotID, portID));
                    rowparams.addParam("mode2", tmpParam.getValue());
                }
                if (null == tmpValue) {
                    tmpValue = "/";
                }
                if (null != rowparams.getParam(tmpName) && rowparams.getParam(tmpName).getValue().equals(tmpValue) && (tmpName.equals("PST") || tmpName.equals("AID") || tmpName.endsWith("mode2"))) continue;
                param = new Param(tmpName, tmpValue);
                rowparams.addParam(param);
            }
        }
        TETL1DataConverter.addReturnParam(neid, rowparams);
    }
}

